//__lib__ lib_common
'use strict';

MANAGER.DistributorElementManager           = function () {
    this.elements        = {};
    this.mapping_by_name = {};
};
MANAGER.DistributorElementManager.prototype = {
    createElement                 : function ( data ) {
        var _to_return = new SHINKEN.OBJECT.ShinkenElement();
        _to_return.updateData( data );
        this.addElement( _to_return );
        return _to_return;
    },
    findElement                   : function ( uuid, data ) {
        if ( !uuid ) {
            return;
        }
        var _to_return = this.getElement( uuid );
        if ( !_to_return ) {
            _to_return = this.createElement( data );
        }
        else {
            _to_return.updateData( data );
        }
        return _to_return;
    },
    getElement                    : function ( uuid ) {
        return this.elements[ uuid ];
    },
    addElement                    : function ( element ) {
        this.elements[ element.getUUID() ]      = element;
        this.mapping_by_name[ element.getName() ] = element.getUUID();
    },
    getElementByName                    : function (name) {
        return this.elements[ this.mapping_by_name[ name ] ];
    },
};
MANAGER.__instance_element_distributor      = new MANAGER.DistributorElementManager();
