//__lib__ lib_shinken_V02_01
'use strict';

MANAGER.EventManagerV2 = {
    onChangeInput: function ( event, property_name ) {
        MANAGER.EventManagerV2.dispatch(event, "do", "onchange_in_input", property_name);
    },
    onClickInput: function ( event, property_name ) {
        MANAGER.EventManagerV2.dispatch(event, "do", "onclick_in_input", property_name);
    },
    clickRadioButton: function ( event, property_name, button_name ) {
        MANAGER.EventManagerV2.dispatch(event, "do", "click_on_radio_button", property_name, button_name);
    },
    clickSelector: function ( event, property_name, selector_name ) {
        MANAGER.EventManagerV2.dispatch(event, "do", "click_on_selector", property_name, selector_name);
    },
    clickItemSelector: function ( event, property_name, selector_name, item_name ) {
        MANAGER.EventManagerV2.dispatch(event, "do", "click_on_item_selector", property_name, selector_name, item_name);
    },
    clickButton : function ( event, param_1, param_2, param_3){
        MANAGER.EventManagerV2.dispatch(event, "do", "click_on_button", param_1, param_2, param_3);
    },
    dispatch: function ( event, type_dispatch, event_name, param_1, param_2, param_3 ) {
        var _controller = CONTROLLER.DistributorControllerManager.findControllerByEvent( event );
        switch ( type_dispatch ) {
            case "do":
                switch (event_name ) {
                    case "onchange_in_input":
                    case "onclick_in_input":
                    case "click_on_selector":
                    case "click_on_item_selector":
                    case "click_on_radio_button":
                    case "click_on_button":
                        event.stopPropagation();
                        _controller.doActionAfter(event_name, param_1, param_2, param_3);
                        break;
                }
                break;
        }
    },
};