//__lib__ lib_common
SHINKEN.OBJECT.ConfirmationPopup           = function () {
    this.dom_element       = null;
    this.dom_element_popup = null;
    this.init();
};
SHINKEN.OBJECT.ConfirmationPopup.prototype = {
    init: function () {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    show: function () {
        this.dom_element.classList.remove( "shinken-hidden" );
    },
    hide: function () {
        this.dom_element.classList.add( "shinken-hidden" );
        this.reset();
    },
    //********************************************  HTML  *****************************************************//
    computeHtmlDomElement: function () {
        this.dom_element = DOM.Service.createElement( "div", {
            "class"          : "shinken-parent-event-listener shinken-hidden",
            "id"             : "id-shinken-confirmation-popup-container",
            "data-controller": "ui_visualisation"
        } );
        this.computeHtmlPopup();
        DOM.Service.addElementTo( this.dom_element, document.body );
    },
    computeHtmlPopup     : function () {
        this.dom_element_popup = DOM.Service.createElement( "div", { "class": "shinken-confirmation-popup" } );
        this.computeHtmlHeader();
        this.computeHtmlContent();
        this.computeHtmlFooter();
        DOM.Service.addElementTo( this.dom_element_popup, this.dom_element );
    },
    computeHtmlHeader    : function () {
        var _container               = DOM.Service.createElement( "div", { "class": "shinken-header-confirmation-popup" } );
        var _table                   = DOM.Service.createElement( "table", { "class": "shinken-width-100" } );
        var _tr                      = DOM.Service.createElement( "tr", { "class": "shinken-header-confirmation-popup" } );
        this.dom_element_title       = DOM.Service.createElement( "td", { "class": "shinken-title-confirmation-popup" } );
        var _onclick_attribute_close = 'MANAGER.EventManager.clickOnButton(event, "click-on-cancel-confirmation-popup")';
        var _td_close                = DOM.Service.createElement( "td", { "class": "shinken-confirmation-popup-cell-close", "onclick": _onclick_attribute_close }, "<span class='shinkon-times'></span>" );
        DOM.Service.addElementTo( this.dom_element_title, _tr );
        DOM.Service.addElementTo( _td_close, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, _container );
        DOM.Service.addElementTo( _container, this.dom_element_popup );
    },
    computeHtmlContent   : function () {
        this.dom_element_content = DOM.Service.createElement( "div", { "class": "shinken-content-confirmation-popup" } );
        DOM.Service.addElementTo( this.content, this.dom_element_content );
        DOM.Service.addElementTo( this.dom_element_content, this.dom_element_popup );
    },
    computeHtmlFooter    : function () {
        var _container       = DOM.Service.createElement( "div", { "class": "shinken-footer-confirmation-popup" } );
        var _table           = DOM.Service.createElement( "table", { "class": "shinken-footer-table-confirmation-popup" } );
        var _tr              = DOM.Service.createElement( "tr", {} );
        var _td              = DOM.Service.createElement( "td", {} );
        var _table_buttons   = DOM.Service.createElement( "table", { "class": "shinken-action-button-table-confirmation-popup" } );
        var _tr_buttons      = DOM.Service.createElement( "tr", {} );
        var _td_validate     = DOM.Service.createElement( "td", {} );
        var _validate_button = DOM.Service.createElement( "div", {
            "class"  : "shinken-action-button-confirmation-popup shinken-validate-button",
            "onclick": "MANAGER.EventManager.clickOnButton(event, 'click-on-validate-confirmation-popup')"
        }, _( "confirmation_popup.validate_button", [DICTIONARY_COMMON_UI] ) );
        var _td_cancel       = DOM.Service.createElement( "td", {} );
        var _onclick_cancel  = 'MANAGER.EventManager.clickOnButton(event, "click-on-cancel-confirmation-popup")';
        var _cancel_button   = DOM.Service.createElement( "div", {
            "class"  : "shinken-action-button-confirmation-popup shinken-cancel-button",
            "onclick": _onclick_cancel
        }, _( "confirmation_popup.cancel_button", [DICTIONARY_COMMON_UI] ) );
        
        
        DOM.Service.addElementTo( _validate_button, _td_validate );
        DOM.Service.addElementTo( _td_validate, _tr_buttons );
        
        DOM.Service.addElementTo( _cancel_button, _td_cancel );
        DOM.Service.addElementTo( _td_cancel, _tr_buttons );
        
        DOM.Service.addElementTo( _tr_buttons, _table_buttons );
        DOM.Service.addElementTo( _table_buttons, _td );
        DOM.Service.addElementTo( _td, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, _container );
        DOM.Service.addElementTo( _container, this.dom_element_popup );
    },
    setContent           : function ( to_set ) {
        if ( !this.dom_element ) {
            this.computeHtmlDomElement();
        }
        DOM.Service.addElementTo( to_set, this.dom_element_content );
    },
    setTitle             : function ( to_set ) {
        if ( !this.dom_element ) {
            this.computeHtmlDomElement();
        }
        this.dom_element_title.innerHTML = to_set;
    },
    setController        : function ( to_set ) {
        if ( !this.dom_element ) {
            this.computeHtmlDomElement();
        }
        DOM.Service.setDataSet( this.dom_element, "controller", to_set );
    },
    reset                : function () {
        DOM.Service.empty( this.dom_element_content );
        DOM.Service.empty( this.dom_element_title );
        DOM.Service.setDataSet( this.dom_element, "controller", "ui_visualisation" );
    }
};
MANAGER.__instance_confirmation_popup      = new SHINKEN.OBJECT.ConfirmationPopup();