//__lib__ lib_common
//priority 12
'use strict';

SHINKEN.OBJECT.JsonEditor           = function ( dom_element, json, default_tag ) {
    this.__class_name__ = 'SHINKEN.OBJECT.JsonEditor';
    this.dom_element    = dom_element;
    this.json           = json;
    //delete this.json.users;
    //delete this.json.external_links;
    ////delete this.json.grids;
    ////    //delete this.json.external_links.default_link;
    //delete this.json.grids.json_list_content[ 0 ].grid_elements;
    ////    delete this.json.grids.json_list_content[ 0 ].grid_elements[ 1 ];
    ////    delete this.json.grids.json_list_content[ 0 ].grid_elements.json_list_content[ 0 ];
    //    delete this.json.grids.json_list_content[ 0 ].grid_elements.json_list_content[ 0 ].content.layout.information_to_display.title_area.font_zoom_percent;
    //    delete this.json.grids.json_list_content[ 0 ].grid_elements.json_list_content[ 0 ].content.layout.information_to_display.title_area.label;
    //    delete this.json.grids.json_list_content[ 0 ].grid_elements.json_list_content[ 0 ].content.layout.information_to_display.title_area.text_color;
    //    delete this.json.grids.json_list_content[ 0 ].grid_elements.json_list_content[ 0 ].content.type;
    //    delete this.json.grids.json_list_content[ 0 ].grid_elements.json_list_content[ 0 ].position_x;
    //    delete this.json.grids.json_list_content[ 0 ].grid_elements.json_list_content[ 0 ].position_y;
    //    delete this.json.grids.json_list_content[ 0 ].grid_elements.json_list_content[ 0 ].width;
    //    delete this.json.grids.json_list_content[ 0 ].grid_elements.json_list_content[ 0 ].height;
    //    delete this.json.grids.json_list_content[ 0 ].layouts.title_widget_layout;
    //    delete this.json.grids.json_list_content[ 0 ].layouts.weather_widget_layout;
    //    delete this.json.grids.json_list_content[ 0 ].layouts.separator_widget_layout.height;
    //    delete this.json.grids.json_list_content[ 0 ].layouts.separator_widget_layout.width;
    //    delete this.json.grids.json_list_content[ 0 ].layouts.separator_widget_layout.content.layout.information_to_display.right_area;
    //    delete this.json.grids.json_list_content[ 0 ].layouts.separator_widget_layout.content.layout.information_to_display.title_area;
    //    delete this.json.grids.json_list_content[ 0 ].type;
    //    delete this.json.grids.json_list_content[ 0 ].nb_tiles_in_width;
    //    delete this.json.grids.json_list_content[ 0 ].nb_tiles_in_height;
    //    delete this.json.grids.json_list_content[ 0 ].separation_grid_element_min;
    //    delete this.json.grids.json_list_content[ 0 ].separation_grid_element_max;
    //    delete this.json.grids.json_list_content[ 0 ].separation_grid_element_percent;
    //    //delete this.json.grids.json_list_content[ 0 ].grid_elements;
    this.content     = null;
    this.default_tag = default_tag;
    this.init();
};
SHINKEN.OBJECT.JsonEditor.prototype = {
    init: function () {
        this.content = DOM.Service.createElement( "span", {}, this.parseToHtml( this.json ) );
        this.computeErrorContent();
    },
    
    //********************************************  GET JSON  **************************************************//
    getCurrentContent: function () {
        return this.dom_element.innerText;
    },
    //********************************************  COMPUTE   **************************************************//
    computeErrorContent: function () {
        this.data_with_error = {};
        var _error_contents  = this.content.querySelectorAll( "." + SHINKEN.OBJECT.JsonEditor.CONST.CLASS_ERROR );
        for ( var i = 0, _size_i = _error_contents.length; i < _size_i; i++ ) {
            if ( _error_contents[ i ].dataset.jsonUuidPart ) {
                this.data_with_error[ _error_contents[ i ].dataset.jsonUuidPart ] = _error_contents[ i ].innerText;
            }
        }
    },
    //********************************************  COMPUTE HTML  **************************************************//
    parseToHtml                         : function ( to_parse ) {
        var _to_return = '';
        if ( to_parse.__class_name__  === "SHINKEN.OBJECT.Param" ) {
            var _value = to_parse.getUserValue() === undefined ? "" : to_parse.getUserValue();
            if ( typeof _value === 'string' ) {
                return this.parseStringToHtml( _value, to_parse );
            }
            else if ( typeof _value === 'number' ) {
                return this.parseNumberToHtml( _value, to_parse );
            }
            else if ( typeof _value === 'boolean' ) {
                return this.parseBooleanToHtml( _value, to_parse );
            }
            else if ( _value instanceof Array ) {
                return this.parseArrayToHtml( _value, to_parse );
            }
            return this.parseObjectToHtml( _value, to_parse );
        }
        else if ( to_parse instanceof Array ) {
            _to_return += this.parseArrayToHtml( to_parse );
        }
        else if ( typeof to_parse === 'object' ) {
            _to_return += this.parseObjectToHtml( to_parse );
        }
        else if ( typeof to_parse === 'string' ) {
            return this.parseStringToHtml( to_parse );
        }
        else if ( typeof to_parse === 'number' ) {
            return this.parseNumberToHtml( to_parse );
        }
        else if ( typeof to_parse === 'boolean' ) {
            return this.parseBooleanToHtml( to_parse );
        }
        else {
            _to_return += '{}';
        }
        return _to_return;
    },
    parseObjectToHtml                   : function ( to_parse, object_with_json_information ) {
        if ( to_parse.json_list_content ) {
            return this.parseArrayToHtml( to_parse.json_list_content, to_parse );
        }
        var _to_return = '<span class="' + this.parseJsonTagToClassCss( object_with_json_information ) + '" ' + this.parseJsonTagToAttribute( object_with_json_information ) + '>{';
        _to_return += this.buildAnchorsEntry( to_parse );
        var _keys      = Object.keys( to_parse );
        if ( _keys.length ) {
            _to_return += this.buildUlEntry( to_parse );
            var _current_key;
            _keys = Object.keys( to_parse ); //TO KEEP THERE BECAUSE THE KEYS CAN CHANGE
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                _to_return += this.buildLiEntry( to_parse );
                _to_return += this.buildKeyEntry( _current_key );
                _to_return += this.parseToHtml( to_parse[ _keys[ i ] ] );
                if ( i < _keys.length - 1 ) {
                    _to_return += ",";
                }
                _to_return += "</div></li>";
            }
            _to_return += "</ul>";
        }
        _to_return += "}</span>";
        return _to_return;
    },
    parseArrayToHtmlWithListKeys        : function ( to_parse, object_with_json_information ) {
        var _to_return = "";
        var _current_list_keys;
        for ( var i = 0, _size_i = object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key.length; i < _size_i; i++ ) {
            _to_return += "<div>";
            _to_return += this.buildDivEntry( object_with_json_information, i );
            _current_list_keys = object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents[ object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key[ i ] ].list_keys;
            if ( !_current_list_keys ) {
                continue;
            }
            for ( var j = 0, _size_j = _current_list_keys.length; j < _size_j; j++ ) {
                _to_return += this.parseArrayToHtmlWithListKeys_forKey( to_parse, _current_list_keys[ j ] );
            }
            _to_return += "</div></div>";
        }
        return _to_return;
    },
    parseArrayToHtmlWithListKeys_forKey : function ( to_parse, key ) {
        if ( to_parse[ key ][ SHINKEN.OBJECT.JsonEditor.CONST.JSON_INDEX_ALREADY_WRITE ] ) {
            return "";
        }
        var _to_return = this.buildLiEntry();
        _to_return += this.parseToHtml( to_parse[ key ] );
        if ( typeof to_parse[ key ] === "object" ) {
            to_parse[ key ][ SHINKEN.OBJECT.JsonEditor.CONST.JSON_INDEX_ALREADY_WRITE ] = true;
        }
        if ( !this.isLastIndexArrayDisplayed( to_parse ) ) {
            _to_return += ",";
        }
        _to_return += "</div></li>";
        return _to_return;
    },
    isLastIndexArrayDisplayed           : function ( array ) {
        for ( var i = 0, _size_i = array.length; i < _size_i; i++ ) {
            if ( !array[ i ][ SHINKEN.OBJECT.JsonEditor.CONST.JSON_INDEX_ALREADY_WRITE ] ) {
                return false;
            }
        }
        return true;
    },
    parseObjectToHtmlWithListKeys       : function ( to_parse ) {
        var _to_return = "";
        var _current_list_keys;
        for ( var i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key.length; i < _size_i; i++ ) {
            _to_return += "<div>";
            _to_return += this.buildDivEntry( to_parse, i );
            _current_list_keys = to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents[ to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key[ i ] ].list_keys;
            if ( !_current_list_keys ) {
                continue;
            }
            for ( var j = 0, _size_j = _current_list_keys.length; j < _size_j; j++ ) {
                _to_return += this.parseObjectToHtmlWithListKeys_forKey( to_parse, _current_list_keys[ j ] );
            }
            _to_return += "</div></div>";
        }
        return _to_return;
    },
    parseObjectToHtmlWithListKeys_forKey: function ( to_parse, key ) {
        if ( to_parse[ key ] === undefined ) {
            return ""; //PATCH if a key was already used, it is not anymore available (deleted)
        }
        var _to_return = this.buildLiEntry();
        _to_return += '<span class="k">"' + SHINKEN.TOOLS.STRING.cleanXss( key ) + '"</span> : ';
        _to_return += this.parseToHtml( to_parse[ key ] );
        delete to_parse[ key ];
        if ( Object.keys( to_parse ).length > 1 ) { // AT THIS MOMENT THERE IS AT LEAST THE PROPERTY JSON_FORMAT_INFORMATION
            _to_return += ",";
        }
        _to_return += "</div></li>";
        return _to_return;
    },
    parseArrayToHtml                    : function ( to_parse, object_with_json_information ) {
        var _to_return = '<span class="' + this.parseJsonTagToClassCss( to_parse ) + '" ' + this.parseJsonTagToAttribute( to_parse ) + '>[';
        if ( object_with_json_information && object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] ) {
            _to_return = '<span class="' + this.parseJsonTagToClassCss( object_with_json_information ) + '" ' + this.parseJsonTagToAttribute( object_with_json_information ) + '>[';
        }
        if ( to_parse.length ) {
            _to_return += "<ol class='A'>";
            if ( object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] && object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key.length ) {
                _to_return += this.parseArrayToHtmlWithListKeys( to_parse, object_with_json_information );
            }
            for ( var i = 0, _size_i = to_parse.length; i < _size_i; i++ ) {
                _to_return += this.parseArrayToHtmlWithListKeys_forKey( to_parse, i );
            }
            _to_return += "</ol>";
        }
        _to_return += ']</span>';
        return _to_return;
    },
    parseStringToHtml                   : function ( string, to_parse ) {
        if ( string === this.default_tag && !(to_parse && to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ]) ) {
            return '"<span class="X" data-default-value="' + this.default_tag + '">' + this.default_tag + '</span>"';
        }
        var string_escape = SHINKEN.TOOLS.STRING.cleanXss( string );
        return '<span class="' + this.parseJsonTagToClassCss( to_parse ) + '" ' + this.parseJsonTagToAttribute( to_parse ) + '>"' + string_escape + '"</span>';
    },
    parseBooleanToHtml                  : function ( boolean, to_parse ) {
        return this.parseNumberToHtml( boolean, to_parse );
    },
    parseNumberToHtml                   : function ( number, to_parse ) {
        return '<span class="' + this.parseJsonTagToClassCss( to_parse ) + '" ' + this.parseJsonTagToAttribute( to_parse ) + '>' + number + '</span>';
    },
    parseJsonTagToClassCss              : function ( to_parse, index ) {
        var _to_return = "";
        if ( to_parse && to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] ) {
            for ( var i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents.length; i < _size_i; i++ ) {
                if ( index !== undefined && index !== i ) {
                    continue;
                }
                _to_return += " " + (to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents[ i ].class || "");
            }
        }
        return _to_return;
    },
    parseJsonTagToAttribute             : function ( to_parse, index ) {
        var _to_return = "";
        if ( to_parse && to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] ) {
            var _tootip = "";
            for ( var i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents.length; i < _size_i; i++ ) {
                if ( index !== undefined && index !== i ) {
                    continue;
                }
                _to_return += ' data-json-uuid-part="' + to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents[ i ].uuid + '"';
                _tootip += to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents[ i ].tooltip;
            }
            if ( _tootip ) {
                _to_return += ' onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-type="shinken-warning" shi-tip-html="' + SHINKEN.TOOLS.STRING.cleanXssForTooltipWithUserData( _tootip)  + '"';
            }
        }
        return _to_return;
    },
    //********************************************  PART HTML  **************************************************//
    buildAnchorsEntry: function ( to_parse ) {
        var _to_return = "";
        if ( to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID_ANCHOR ] ) {
            for ( var i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID_ANCHOR ].length; i < _size_i; i++ ) {
                _to_return += '<span data-json-uuid-part="' + to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID_ANCHOR ][ i ] + '"></span>';
            }
            delete to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID_ANCHOR ];
        }
        return _to_return;
    },
    buildUlEntry     : function ( to_parse ) {
        var _to_return = "";
        if ( to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] ) {
            if ( to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key.length ) {
                _to_return += '<ul class="D">';
                _to_return += this.parseObjectToHtmlWithListKeys( to_parse );
            }
            else {
                _to_return += '<ul class="D ' + this.parseJsonTagToClassCss( to_parse ) + '" ' + this.parseJsonTagToAttribute( to_parse ) + '>';
            }
            delete to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ];
        }
        else {
            _to_return += '<ul class="D">';
        }
        return _to_return;
    },
    buildKeyEntry    : function ( key ) {
        return '<span class="k">"' + SHINKEN.TOOLS.STRING.cleanXss( key ) + '"</span> : ';
    },
    buildLiEntry     : function ( to_parse ) {
        return '<li><div class="' + this.parseJsonTagToClassCss( to_parse ) + '" ' + this.parseJsonTagToAttribute( to_parse ) + '>';
    },
    buildDivEntry    : function ( to_parse, index ) {
        return '<div class="z' + this.parseJsonTagToClassCss( to_parse, index ) + '" ' + this.parseJsonTagToAttribute( to_parse, index ) + '>';
    },
    //********************************************  VIEW   **************************************************//
    updateHtml            : function () {
        DOM.Service.addElementToAfterEmpty( this.content, this.dom_element );
        this.dom_element.classList.add( "shinken-json-editor-container" );
        this.dom_element.setAttribute( "contenteditable", "true" );
    },
    cleanHtmlAfterEdition : function () {
        this.updateDefaultValueHtml();
        this.removeErrorAfterUpdate();
    },
    updateDefaultValueHtml: function () {
        var _default_value_doms = this.dom_element.querySelectorAll( ".X" );
        for ( var i = 0, _size_i = _default_value_doms.length; i < _size_i; i++ ) {
            if ( _default_value_doms[ i ].innerText !== _default_value_doms[ i ].dataset.defaultValue ) {
                _default_value_doms[ i ].classList.remove( "X" );
            }
        }
    },
    removeErrorAfterUpdate: function () {
        var _keys = Object.keys( this.data_with_error );
        var _current_key;
        var _current_dom;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _current_dom = this.dom_element.querySelector( '.' + SHINKEN.OBJECT.JsonEditor.CONST.CLASS_ERROR + '[data-json-uuid-part="' + _current_key + '"]' );
            if ( _current_dom && !this._is_same_text( _current_dom.innerText, this.data_with_error[ _current_key ] ) ) {
                _current_dom.classList.remove( SHINKEN.OBJECT.JsonEditor.CONST.CLASS_ERROR );
                DOM.Service.removeTooltip( _current_dom );
                delete this.data_with_error[ _current_key ];
            }
        }
        
    },
    _is_same_text         : function ( text_1, text_2 ) {
        return SHINKEN.TOOLS.STRING.replaceAll( text_1, "\n", "" ) === SHINKEN.TOOLS.STRING.replaceAll( text_2, "\n", "" );
    }
};

SHINKEN.OBJECT.JsonEditor.CONST = {
    SHINKEN_JSON_UUID_ANCHOR         : "__SHINKEN_JSON_UUID_ANCHOR_ANCHOR__",
    JSON_UNKNOWN_PROPERTY            : "__JSON_UNKNOWN_PROPERTY__",
    JSON_BAD_FORMAT_IS_NOT_AN_OBJECT : "__JSON_BAD_FORMAT_IS_NOT_AN_OBJECT__",
    JSON_INVALID_VALUE               : "__JSON_INVALID_VALUE__",
    JSON_MODIFIED_VALUE_TO_FIT_FORMAT: "__JSON_MODIFIED_VALUE_TO_FIT_FORMAT__",
    JSON_DEFAULT_VALUE_IS_OK         : "__JSON_DEFAULT_VALUE_IS_OK__",
    JSON_FORMAT_INFORMATION          : "__JSON_FORMAT_INFORMATION__",
    JSON_INDEX_ALREADY_WRITE         : "__JSON_INDEX_ALREADY_WRITE__",
    CLASS_ERROR                      : "shinken-json-error"
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.JsonEditor, SHINKEN.OBJECT.ShinkenObject );

SHINKEN.OBJECT.JsonEditorService = (function ( self ) {
    "use strict";
    var __LINE_TAG__       = "__SHINKEN_LINE_TAG__";
    self.computeValidation = function ( dom_element ) {
        var _text_parsed = _parseJsonDomElementToText( dom_element );
        _text_parsed     = SHINKEN.TOOLS.STRING.replaceAll( _text_parsed, __LINE_TAG__, "\n" );
        return [_text_parsed, SHINKEN.TOOLS.STRING.JSON.isFormatJsonInvalid( _text_parsed )];
    };
    self.computeLineNumber = function ( dom_element, error_line ) {
        var _computed_style = DOM.Service.getComputedStyles( dom_element, ["padding-bottom", "padding-top", "line-height", "height"] );
        var number_line     = (dom_element.scrollHeight - _computed_style[ "padding-bottom" ] - _computed_style[ "padding-top" ]) / _computed_style[ "line-height" ];
        var _html           = '';
        for ( var i = 1, _size = number_line; i <= _size; i++ ) {
            if ( i === error_line ) {
                _html += '<div class="shinken-line-number shinken-weather-json-form-line-error" data-number="' + i + '">' + i + '</div>';
            }
            else {
                _html += '<div class="shinken-line-number" data-number="' + i + '">' + i + '</div>';
            }
        }
        var _container       = document.querySelector( '.shinken-textarea-line-nums' );
        _container.innerHTML = _html;
        if ( error_line ) {
            self.scrollToError( dom_element, error_line );
        }
        _container.style.transform = "translateY(-" + dom_element.scrollTop + "px)";
    };
    self.scrollToError     = function ( dom_element, error_line ) {
        var _computed_style = DOM.Service.getComputedStyles( dom_element, ["padding-bottom", "padding-top", "line-height", "height"] );
        dom_element.scrollTo( 0, (error_line) * _computed_style[ "line-height" ] - _computed_style[ "height" ] / 2 );
    };
    
    var _parseJsonDomElementToText = function ( dom_element ) {
        var clone    = DOM.Service.cloneElement( dom_element );
        var _text    = clone.innerHTML;
        _text        = SHINKEN.TOOLS.STRING.replaceAll( _text, "<li", __LINE_TAG__ + "<li" );
        _text        = SHINKEN.TOOLS.STRING.replaceAll( _text, "</ol>", __LINE_TAG__ + "</ol>" );
        _text        = SHINKEN.TOOLS.STRING.replaceAll( _text, "</ul>", __LINE_TAG__ + "</ul>" );
        var _new_dom = DOM.Service.createElement( "div", {}, _text );
        var _text_2  = _new_dom.innerText;
        return SHINKEN.TOOLS.STRING.replaceAll( _text_2, __LINE_TAG__, "\n" );
    };
    
    return self;
})( SHINKEN.OBJECT.JsonEditorService || {} );

SHINKEN.OBJECT.JsonForm           = function ( dom_element ) {
    this.__class_name__ = 'SHINKEN.OBJECT.JsonForm';
    this.init( dom_element );
};
SHINKEN.OBJECT.JsonForm.prototype = {
    init         : function ( dom_element ) {
        this.dom_element                     = dom_element;
        this.message_invalid                 = "";
        this.timeout_computeEditorLineNumber = null;
        this.line_invalid                    = 0;
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "focus-on-anchor-json":
                var _to_return = this.dom_element.querySelector( "[data-json-uuid-part='" + param + "']" );
                DOM.Service.focusOnAnchor_withDom( _to_return, this.dom_element, new DOM.Service.Animation( "shinken-pulsate", 1600 ), 5 );
                return _to_return;
        }
    },
    
    //********************************************  GETTER SETTER  **************************************************//
    isValid: function () {
        return !this.error_syntax;
    },
    
    getMessageInValid: function () {
        return this.message_invalid;
    },
    getText          : function () {
        return this.text;
    },
    //********************************************  COMPUTE  **************************************************//
    askComputeLineNumber: function ( timeout ) {
        timeout  = timeout || 0;
        var self = this;
        if ( self.timeout_computeEditorLineNumber ) {
            clearTimeout( self.timeout_computeEditorLineNumber );
        }
        self.timeout_computeEditorLineNumber = setTimeout( function () {
            var _interval_done = setInterval( function () {
                if ( self.dom_element.scrollHeight ) {
                    SHINKEN.OBJECT.JsonEditorService.computeLineNumber( self.dom_element, self.line_invalid );
                    clearInterval( _interval_done );
                }
            }, 100 );
        }, timeout );
    },
    scrollToError       : function () {
        SHINKEN.OBJECT.JsonEditorService.scrollToError( this.dom_element, this.line_invalid );
    },
    _computeWhenInvalid : function () {
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            this.message_invalid = _( "json_editor.invalid_json_ie", [DICTIONARY_COMMON_UI] );
            return;
        }
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isFireFox' ) ) {
            this.line_invalid = parseInt( SHINKEN.TOOLS.STRING.extractBetween( this.error_syntax.toString(), 'at line ', ' column' ) );
        }
        else {
            var _error_position = parseInt( this.error_syntax.message.replace( /[^\d.]/g, '' ) );
            var _json_error     = this.text.substring( 0, _error_position );
            this.line_invalid   = _json_error.split( "\n" ).length;
        }
        this.message_invalid = SHINKEN.TOOLS.STRING.format( _( "json_editor.invalid_json", [DICTIONARY_COMMON_UI] ), this.line_invalid );
    },
    computeIsValid      : function () {
        this.line_invalid = 0;
        var _analyze      = SHINKEN.OBJECT.JsonEditorService.computeValidation( this.dom_element );
        this.text         = _analyze[ 0 ];
        this.error_syntax = _analyze[ 1 ];
        if ( !this.isValid() ) {
            this._computeWhenInvalid();
        }
    }
};



SHINKEN.OBJECT.ShinkenObjectJson           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.ShinkenObjectJson';
};
SHINKEN.OBJECT.ShinkenObjectJson.prototype = {
    parseToJson       : function () {
        var _to_return = this.getObjectToJson();
        
        var _components = this.getChildrenObjectDict();
        
        
        if ( Array.isArray( _components ) ) {
            _to_return.json_list_content = [];
            for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
                _to_return.json_list_content.push( _components[ i ].parseToJson() );
            }
        }
        else {
            var _keys = Object.keys( _components );
            var _current_key;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                if ( Array.isArray( _components[ _current_key ] ) ) {
                    _to_return[ _current_key ] = [];
                    for ( var j = 0, _size_j = _components[ _current_key ].length; j < _size_j; j++ ) {
                        _to_return[ _current_key ].push( _components[ _current_key ][ j ].parseToJson() );
                    }
                }
                else if ( _components[ _current_key ].__class_name__  === "SHINKEN.OBJECT.Param" ) {
                    _to_return[ _current_key ] = _components[ _current_key ].user_value;
                }
                else if ( _components[ _current_key ] ) {
                    _to_return[ _current_key ] = _components[ _current_key ].parseToJson();
                }
            }
        }
        return _to_return;
    },
    getObjectToJson   : function () {
        var _to_return = this._getObjectToJson() || {};
        var _keys;
        var i;
        var _size;
        if ( this.unknown_property ) {
            _keys = Object.keys( this.unknown_property );
            for ( i = 0, _size = _keys.length; i < _size; i++ ) {
                _to_return[ _keys[ i ] ] = this[ _keys[ i ] ].getObjectToJson();
            }
        }
        if ( this.__class_name__  !== "SHINKEN.OBJECT.Param" ) {
            var _valid_own_property = this.getValidOwnProperty().getContent();
            for ( i = 0, _size = _valid_own_property.length; i < _size; i++ ) {
                if ( _valid_own_property[ i ].is_mandatory && typeof this[ _valid_own_property[ i ].key ] === 'undefined' ) {
                    _to_return[ _valid_own_property[ i ].key ] = "";
                }
            }
        }
        
        if ( this._json_anchor ) {
            _to_return[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID_ANCHOR ] = this._json_anchor;
        }
        var _information = this.addJSONInformation();
        if ( _information ) {
            _to_return[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] = _information;
        }
        return _to_return;
    },
    addJSONInformation: function () {
        var _to_return = null;
        if ( this.messages && this.messages.hasStatus() ) {
            _to_return = this.messages._getObjectToJson();
        }
        return _to_return;
    },
    _getObjectToJson  : function () {
        return {};
    },
    //********************************************  ADD ANCHOR   **************************************************//.
    addJsonAnchor: function ( uuid_anchor ) {
        this._json_anchor = this._json_anchor || [];
        this._json_anchor.push( uuid_anchor );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectJson, SHINKEN.OBJECT.ShinkenObject );