//__lib__ lib_common
'use strict';
OBJECT.MESSAGE  = {
    ICON       : {
        ERROR  : '<span class="shinken-icon-error shinkon-warning"></span>',
        WARNING: '<span class="shinken-icon-warning shinkon-warning"></span>',
        BEWARE : '<span class="shinken-icon-warning shinkon-warning-light"></span>'
    },
    MAX_ERROR  : 5,
    MAX_WARNING: 5
};
OBJECT.Messages = function ( footer ) {
    this.init( footer );
};


OBJECT.Messages.prototype = {
    init                : function ( footer ) {
        this.messages_error   = [];
        this.messages_warning = [];
        this.messages_beware  = [];
        this.messages_info    = [];
        this.is_dfe           = false;
        this.is_dfe_protected = false;
        this.footer           = footer;
        this.no_duplicate     = false;
    },
    addMessage          : function ( type_message, text ) {
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.messages_error.push( new OBJECT.Message( type_message, text ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.messages_warning.push( new OBJECT.Message( type_message, text ) );
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.messages_beware.push( new OBJECT.Message( type_message, text ) );
                break;
            default:
                this.messages_info.push( new OBJECT.Message( type_message, text ) );
                break;
        }
    },
    addMessages         : function ( messages ) {
        if ( !messages ) {
            return;
        }
        var _size = messages.length;
        var _current_message;
        for ( var i = 0; i < _size; i++ ) {
            _current_message = messages[ i ];
            this.addMessage( _current_message._type, _current_message._text );
        }
    },
    hasMessage          : function () {
        return this.hasError() || this.hasWarning() || this.hasBeware() || this.hasInfo();
    },
    getNumberErrors     : function () {
        return this.messages_error.length;
    },
    getNumberWarnings   : function () {
        return this.messages_warning.length;
    },
    hasError            : function () {
        return this.getNumberErrors() > 0;
    },
    hasWarning          : function () {
        return this.getNumberWarnings() > 0;
    },
    hasBeware           : function () {
        return this.messages_beware.length > 0;
    },
    hasInfo             : function () {
        return this.messages_info.length > 0;
    },
    getStatus           : function () {
        if ( this.hasError() ) {
            return COMPONENT.CONST.STATUS.ERROR;
        }
        if ( this.hasWarning() ) {
            return COMPONENT.CONST.STATUS.WARNING;
        }
        if ( this.hasBeware() ) {
            return COMPONENT.CONST.STATUS.BEWARE;
        }
        return COMPONENT.CONST.STATUS.NONE;
    },
    hasStatus           : function () {
        return this.getStatus() !== COMPONENT.CONST.STATUS.NONE;
    },
    buildMessage        : function ( is_default, template_name, has_no_max, skip_invalid_syntax ) {
        
        var _status = this.getStatus();
        if ( _status === COMPONENT.CONST.STATUS.NONE ) {
            return '';
        }
        var _to_return          = '<div class="shinken-tooltip-message text-left shinken-drag-exclude">';
        var _show_extra_message = false;
        if ( this.hasError() ) {
            _show_extra_message = true;
            if ( !skip_invalid_syntax ) {
                _to_return += '<span class="text-underline">' + _( 'messages.invalid_syntax', [DICTIONARY_COMMON_UI] ) + '</span><br>';
            }
            _to_return += OBJECT.MESSAGE.ICON.ERROR + _( 'messages.tag_error', [DICTIONARY_COMMON_UI] ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_error, has_no_max ? '' : OBJECT.MESSAGE.MAX_ERROR );
            _to_return += '</ol>';
        }
        if ( this.hasWarning() ) {
            _show_extra_message = true;
            _to_return += OBJECT.MESSAGE.ICON.WARNING + _( 'messages.tag_warning', [DICTIONARY_COMMON_UI] ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_warning, has_no_max ? '' : OBJECT.MESSAGE.MAX_WARNING );
            _to_return += '</ol>';
        }
        if ( !this.is_dfe_protected && _show_extra_message && this.is_dfe ) {
            var _format_to_follow        = is_default ? _( 'messages.tooltip_dfe_common_default_value' ) : _( 'element.tooltip_dfe_common' );
            var _note_to_update_template = template_name ? '<div class=\'container-legend \'>' + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_common_go_tpl' ), template_name ) + '</div>' : "";
            _to_return                   = _to_return +
                                           '<div class=\'container-legend\'>' + _format_to_follow + '</div>' +
                                           _note_to_update_template;
            
        }
        if ( this.hasBeware() && this.is_dfe ) {
            if ( !this.is_dfe_protected && _show_extra_message ) {
                _to_return += '<hr>';
            }
            _to_return += '<ol>' + OBJECT.MESSAGE.ICON.BEWARE + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_deleted_part_1' ), this.property_name );
            _to_return += this.buildMessageForList( this.messages_beware, 999 );
            _to_return += '</ol>';
        }
        else if ( this.hasBeware() ) {
            _to_return += OBJECT.MESSAGE.ICON.BEWARE + _( 'messages.tag_warning', [DICTIONARY_COMMON_UI] ) + '<br>';
            _to_return += this.buildMessageForList( this.messages_beware, 999 );
        }
        if ( this.footer ) {
            _to_return += this.footer;
        }
        
        _to_return += '</div>';
        return _to_return;
    },
    buildMessageGeneric : function () {
        var _status = this.getStatus();
        if ( _status === COMPONENT.CONST.STATUS.NONE ) {
            return '';
        }
        var _to_return = '<div class="shinken-message-container">';
        if ( this.hasError() ) {
            _to_return += OBJECT.MESSAGE.ICON.ERROR + _( 'messages.tag_error', [DICTIONARY_COMMON_UI] ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_error );
            _to_return += '</ol>';
        }
        if ( this.hasWarning() ) {
            _to_return += OBJECT.MESSAGE.ICON.ERROR + _( 'messages.tag_warning', [DICTIONARY_COMMON_UI] ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_warning );
            _to_return += '</ol>';
        }
        _to_return += '</div>';
        return _to_return;
    },
    buildMessageForList : function ( list, max ) {
        var _to_return = '';
        var _size      = list.length;
        if ( max ) {
            _size = Math.min( list.length, _size );
        }
        var _to_add;
        var _duplicate = {};
        for ( var i = 0; i < _size; i++ ) {
            _to_add = list[ i ].buildHtml();
            if ( this.no_duplicate ) {
                var _md5 = SHINKEN.TOOLS.MD5.MD5( _to_add );
                if ( _duplicate[ _md5 ] ) {
                    continue;
                }
                _duplicate[ _md5 ] = true;
            }
            _to_return += _to_add;
        }
        return _to_return;
    },
    getAllMessages      : function () {
        var to_return = [];
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_error );
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_warning );
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_info );
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_beware );
        return to_return;
    },
    _getObjectToJson    : function () {
        return {};
    },
    countMessageWithText: function ( type_message, text ) {
        var messages   = null;
        var _to_return = 0;
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                messages = this.messages_error;
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                messages = this.messages_warning;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                messages = this.messages_beware;
                break;
            default:
                messages = this.messages_info;
                break;
        }
        var messages_length = messages.length;
        
        for ( var i = 0; i < messages_length; i++ ) {
            if ( SHINKEN.TOOLS.STRING.contains( messages[ i ]._text, text ) ) {
                _to_return++;
            }
        }
        return _to_return;
    }
};

OBJECT.MessagesConfig = function () {
    this.init();
};


OBJECT.MessagesConfig.prototype = {
    getUUID         : function () {
        if ( !this.uuid ) {
            this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        }
        return this.uuid;
    },
    addMessage      : function ( type_message, object_message ) {
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.messages_error.push( new OBJECT.MessageConfig( type_message, object_message, this.getUUID() ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.messages_warning.push( new OBJECT.MessageConfig( type_message, object_message, this.getUUID() ) );
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.messages_beware.push( new OBJECT.MessageConfig( type_message, object_message, this.getUUID() ) );
                break;
            default:
                this.messages_info.push( new OBJECT.MessageConfig( type_message, object_message, this.uuid ) );
                break;
        }
    },
    _getObjectToJson: function () {
        var _to_return           = {};
        _to_return.contents      = [];
        _to_return.with_list_key = [];
        var _messages            = this.getAllMessages();
        var _current;
        for ( var i = 0, _size_i = _messages.length; i < _size_i; i++ ) {
            _current = _messages[ i ]._getObjectToJson();
            if ( _current.list_keys ) {
                _to_return.with_list_key.push( _to_return.contents.push( _current ) - 1 );
            }
            else {
                _to_return.contents.push( _current );
            }
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.MessagesConfig, OBJECT.Messages );

OBJECT.Message = function ( type, text, line_index ) {
    this._type = type;
    this._text = text;
};

OBJECT.Message.prototype = {
    buildHtml: function () {
        return '<li class=\'' + this._type + '\'>' + this._text + '</li>';
    }
};

OBJECT.MessageConfig = function ( type, object_message, uuid ) {
    this._type       = type;
    this._text       = object_message.text;
    this._list_keys  = object_message.list_keys;
    this.parent_uuid = uuid;
};

OBJECT.MessageConfig.prototype = {
    buildHtml       : function () {
        var _to_return = DOM.Service.createElement( "li", { class: this._type } );
        var _table     = DOM.Service.createElement( "table", { class: "shinken-table" } );
        var _tr        = DOM.Service.createElement( "tr" );
        var _td_1      = DOM.Service.createElement( "td", { class: "shinken-text-cell" }, "<div>" + this._text + "</div>" );
        DOM.Service.addElementTo( _table, _to_return );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _td_1, _tr );
        
        if ( this._list_keys !== "__SHINKEN_NONE__" ) {
            var _td_2 = DOM.Service.createElement( "td", { class: "shinken-json-link-cell" } );
            var _link = DOM.Service.createElement( "span", { class: "shinken-data-user shinken-json-link", onclick: "MANAGER.EventManager.clickOnButton(event, 'focus-on-anchor-json', '" + this.parent_uuid + "')" }, 'JSON' );
            DOM.Service.addElementTo( _td_2, _tr );
            DOM.Service.addElementTo( _link, _td_2 );
        }
        return _to_return.outerHTML;
    },
    getCategory     : function () {
        return this._category;
    },
    _getObjectToJson: function () {
        var _to_return     = {};
        _to_return.uuid    = this.parent_uuid;
        _to_return.tooltip = this._text;
        switch ( this._type ) {
            case COMPONENT.CONST.STATUS.ERROR:
            case COMPONENT.CONST.STATUS.WARNING:
                _to_return.class = SHINKEN.OBJECT.JsonEditor.CONST.CLASS_ERROR;
                break;
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.MessagesConfig, OBJECT.Messages );

OBJECT.MessageService = (function ( self ) {
    "use strict";
    self.parseBackendStatus = function ( status ) {
        switch ( status ) {
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.WARNINGS:
                return COMPONENT.CONST.STATUS.WARNING;
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.CRITICAL:
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.ERRORS:
                return COMPONENT.CONST.STATUS.ERROR;
        }
    };
    return self;
})( OBJECT.MessageService || {} );