//__lib__ lib_common
'use strict';

SHINKEN.OBJECT.NOTIFICATION.Container           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.NOTIFICATION.CONTAINER';
    this.dom_element    = null;
    this.notifications  = null;
};
SHINKEN.OBJECT.NOTIFICATION.Container.prototype = {
    init: function () {
        this.notifications = [];
    },
    
    addNotification            : function ( message, status, element_to_bind_with, notification_placement, time_before_remove, skip_close ) {
        if ( !this.dom_element ) {
            this.createNotificationContainer( skip_close );
        }
        
        var _user_notification = new SHINKEN.OBJECT.NOTIFICATION.User();
        
        this.cleanAllNotification();
        _user_notification.init();
        _user_notification.createNotification( message, status, skip_close );
        _user_notification.setTimerToCloseNotification( this.dom_element, time_before_remove );
        if ( element_to_bind_with ) {
            _user_notification.bindToElement( element_to_bind_with, notification_placement );
        }
        
        this.notifications.push( _user_notification );
        DOM.Service.addElementTo( _user_notification.dom_element, this.dom_element );
        return _user_notification;
    },
    addNotificationStyled      : function ( message, status, styles, time_before_remove ) {
        var _user_notification = this.addNotification( message, status );
        
        if ( styles ) {
            _user_notification.addStyles( styles );
        }
    },
    createNotificationContainer: function ( skip_close ) {
        if ( !skip_close ) {
            this.dom_element = DOM.Service.createElement( "div", { id: "id-shinken-notification-popup-container" });
            DOM.BodyService.addChild( this.dom_element );
        }
        else {
            this.dom_element = DOM.Service.createElement( "div", { id: "id-shinken-notification-popup-container", "onclick": "this.firstChild.classList.add('shinken-removed');event.stopPropagation();" } );
            DOM.BodyService.addChild( this.dom_element );
        }
        
    },
    cleanAllNotification       : function () {
        DOM.Service.empty( this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NOTIFICATION.Container, SHINKEN.OBJECT.ShinkenObject );