//priority 19
//__lib__ lib_shinken_V02_01
'use strict';

PROPERTY.InterfaceSelectAbstract           = function () {
};
PROPERTY.InterfaceSelectAbstract.prototype = {
    //********************************************  GETTER SETTER  **************************************************//
    ___unset   : function () {
        this.setValueFromUser( '', '' );
    },
    getSelector: function ( selector_name ) {
        if ( !selector_name || selector_name === COMPONENT.CONST.SELECT.NAME_MAIN_SELECTOR ) {
            return this.component_selector;
        }
        console.log("[InterfaceSelectAbstract - getSelector]", "[TO BE DEV]" );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    ___hidePopup          : function ( exception ) {
        if ( exception !== this.getSelector() ) {
            this.getSelector().hidePopup();
        }
    },
    ___clickOnItemSelector: function ( _target_component, key_name ) {
        this.setLastItemSelected( key_name );
        this.getSelector().clickOnItemSelector( this.name, key_name );
        this.updateView();
        return true;
    },
    //********************************************  VIEW  **************************************************//
    ___updateView      : function () {
        this._computeState();
    },
    _computeLabelSelect: function () {
    },
    //********************************************  VALIDATION   *********************************************************//
    
    //********************************************  FILTER   *********************************************************//
    doFilter: function ( dom_element, filter ) {
        var _target_component = this.getSelectViaDomElement( dom_element );
        _target_component.doFilter( filter );
    },
    //********************************************  KEY EVENT   ******************************************************//
    keydown: function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.getSelectViaDomElement( event.target ).moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.getSelectViaDomElement( event.target ).moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                this.getSelectViaDomElement( event.target ).validAutoSelect();
                event.preventDefault();
                break;
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceSelectAbstract, PROPERTY.InterfaceCommon );

PROPERTY.InterfaceSelectFromHtml           = function ( dom_element ) {
};
PROPERTY.InterfaceSelectFromHtml.prototype = {
    initMainSelector: function () {
        this.component_selector = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.SELECTOR.MAIN + '"]' ), this.type, false, this );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceSelectFromHtml, PROPERTY.InterfaceSelectAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceSelectFromHtml, PROPERTY.InterfaceSelectFromHtml );

PROPERTY.InterfaceSelectFromData           = function () {
};
PROPERTY.InterfaceSelectFromData.prototype = {};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceSelectFromData, PROPERTY.InterfaceSelectAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceSelectFromData, PROPERTY.InterfaceCommonFromData );