//__lib__ lib_shinken_V02_01
'use strict';

PROPERTY.SingleSelectAbstract           = function () {
};
PROPERTY.SingleSelectAbstract.prototype = {
    init: function () {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnSelector    : function ( selector_name ) {
        if ( this.is_disabled ) {
            return false;
        }
        this.getSelector( selector_name ).clickOnSelector();
    },
    clickOnItemSelector: function ( selector_name, item_name ) {
        if ( this.is_disabled ) {
            return false;
        }
        this.getSelector( selector_name ).clickOnItemSelector( item_name, this );
    },
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_item_selector_done":
                DOM.Service.setDataSet( this.getDomElement(), "currentValue", param_1.getValue() );
                break;
        }
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeState: function () {
        this._computeLabelSelect();
    },
    //********************************************  GET / SET    **********************************************************//
    setValueFromUser          : function ( value ) {
        this.clickOnItemSelector( null, value );
    },
    getValue                  : function ( value ) {
        return this.getSelector().getValue();
    },
    setStatus                 : function ( _to_set ) {
        this.status = _to_set;
        this.component_selector.setStatus( _to_set );
    },
    setDefaultLabelForSelector: function ( selector_name, to_set ) {
        this.getSelector( selector_name ).setDefaultLabelForSelector( to_set );
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSave: function () {
        return this.getSelector().getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectAbstract, PROPERTY.InterfaceSelectAbstract );

PROPERTY.SingleSelectFromData           = function ( property_name, options ) {
    this.initSpecific( property_name, options );
};
PROPERTY.SingleSelectFromData.prototype = {
    initSpecific    : function ( property_name, data_option_array ) {
        this.name = property_name;
        this.init();
        this.initMainSelector( data_option_array );
    },
    initMainSelector: function ( data_option_array ) {
        this.component_selector = new COMPONENT.SingleSelectFromData( this.getName() );
        this.component_selector.setOptionsFromArray( data_option_array );
    },
    //********************************************  OTHER    **********************************************************//
    changeOptionsFromArray: function ( data_option_array ) {
        this.component_selector.changeOptionsFromArray( data_option_array );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY.CONST.COMMON.TYPES.SINGLE_SELECT;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_selector.computeHtml();
        DOM.Service.addElementTo( this.component_selector.getDomElement(), this.dom_cell_action );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData, PROPERTY.SingleSelectAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData, PROPERTY.InterfaceSelectFromData );