//__lib__ lib_common
//priority 10
DOM.BodyService = (function ( self ) {
    "use strict";
    
    var __body_element;
    var __list_to_remove = {};
    var __time_out_add;
    var __bouding_rect;
    
    self.load            = function () {
        if ( !__body_element ) {
            __body_element = document.querySelector( 'body' );
        }
    };
    self.hasChildWithID  = function ( id ) {
        var _child = self.getDomElement().querySelector( "#" + id );
        return _child;
    };
    self.askAddClass     = function ( to_add, time_out ) {
        self.getDomElement().classList.add( to_add );
        if ( time_out ) {
            __list_to_remove[ to_add ] = true;
            clearTimeout( __time_out_add );
            __time_out_add = setTimeout( function () {
                var _keys = Object.keys( __list_to_remove );
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    self.getDomElement().classList.remove( _keys[ i ] );
                }
                __list_to_remove = {};
            }, time_out );
        }
    };
    self.removeClass     = function ( to_remove ) {
        self.getDomElement().classList.remove( to_remove );
        __list_to_remove[ to_remove ] = false;
    };
    self.addChild        = function ( dom_element ) {
        DOM.Service.addElementTo( dom_element, self.getDomElement() );
    };
    self.getDomElement   = function () {
        if ( !__body_element ) {
            self.load();
        }
        return __body_element;
    };
    self.cleanDomElement = function () {
        __body_element = null;
    };
    self.getWidth = function () {
        if ( !__bouding_rect ){
            __bouding_rect = DOM.Service.getBoundingClientRect(this.getDomElement());
        }
        return __bouding_rect[DOM.CONST.STYLE.WIDTH] ;
    };
    self.reset = function () {
        __bouding_rect = undefined;
    };
    return self;
})( DOM.BodyService || {} );

window.addEventListener( "resize", function () {
    DOM.BodyService.reset()
} );