//__lib__ lib_common
'use strict';

WINDOW.ElementGroupFromHtml           = function ( name ) {
    //dom_element
    //size
    this.name = name;
    this.list = {};
    this.init();
};
WINDOW.ElementGroupFromHtml.prototype = {
    init                     : function () {
        this.dom_element = document.querySelector( '.' + WINDOW.CONST.CLASS.WINDOW_GROUP + '[data-name="' + this.name + '"]' );
        this.initWindows();
    },
    initWindows              : function () {
        var _dom_elements = this.dom_element.querySelectorAll( '.' + WINDOW.CONST.CLASS.WINDOW_TAB + '[data-group-name="' + this.name + '"]' );
        this.size         = _dom_elements.length;
        var _current;
        var _current_name;
        var _has_properties;
        for ( var i = 0; i < this.size; i++ ) {
            _current                   = _dom_elements[ i ];
            _current_name              = _current.dataset.name;
            _has_properties            = _current.dataset.hasProperties;
            this.list[ _current_name ] = _has_properties ? new WINDOW.ElementWithProperties( _current_name, _current ) : new WINDOW.Element( _current_name, _current );
            MANAGER.__instance_object_distributor.addObject( this.list[ _current_name ].getUUID(), this.list[ _current_name ] );
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
    
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroupFromHtml, WINDOW.ElementGroup );