#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.


class DataHubException(Exception):
    def __init__(self, message):
        self.message = message
    
    
    def __str__(self):
        return self.message


class DataHubNotReady(DataHubException):
    def __init__(self, message='Data Hub not ready'):
        super(DataHubNotReady, self).__init__(message)


class DataHubItemNotFound(DataHubException):
    def __init__(self, data_type='', data_id='', message=''):
        if not message:
            message = 'The %s [ %s ] was not found in Data Hub' % (data_type, data_id)
        super(DataHubItemNotFound, self).__init__(message)


class DataHubCorruptedData(DataHubException):
    def __init__(self, message='Corrupted data'):
        super(DataHubCorruptedData, self).__init__(message)


class DataHubFatalException(DataHubException):
    def __init__(self, message='Fatal exception'):
        super(DataHubFatalException, self).__init__(message)


class DataHubDriverException(DataHubException):
    """Base class for DataHubDriver errors"""
    pass


class DataHubReadError(DataHubDriverException):
    def __init__(self, message='Error occurred when reading data'):
        super(DataHubReadError, self).__init__(message=message)


class DataHubWriteError(DataHubDriverException):
    def __init__(self, message='Error occurred when writing data'):
        super(DataHubWriteError, self).__init__(message=message)
