#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.filters.abstract_filter import AbstractFilter, FilteredObject

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, Dict, List
    from shinkensolutions.filters.list.items.abstract_list_filter_item import AbstractListFilterItem


class ListFilter(AbstractFilter):
    if TYPE_CHECKING:
        # The override is made only to specify the filter item type
        # Otherwise we don't need to really override the methods
        # It is only for static type checking
        
        def add_filter_item_to_apply(self, filter_item):
            # type: (AbstractListFilterItem) -> None
            return super(ListFilter, self).add_filter_item_to_apply(filter_item)
        
        
        def get_registered_filter_items(self):
            # type: () -> List[AbstractListFilterItem]
            return super(ListFilter, self).get_registered_filter_items()
    
    
    def get_filtered_object(self, object_to_filter):
        # type: (List[Any]) -> FilteredObject
        
        additional_info = {}  # type: Dict[str, Any]
        filter_items_to_apply = self.get_registered_filter_items()
        
        if filter_items_to_apply:
            
            for filter_item in filter_items_to_apply:
                additional_info = filter_item.get_additional_information_from_non_filtered_list(object_to_filter, info_dict=additional_info)
            
            for filter_item in filter_items_to_apply:
                object_to_filter = filter_item.apply_on(object_to_filter)
            
            for filter_item in filter_items_to_apply:
                additional_info = filter_item.get_additional_information_from_filtered_list(object_to_filter, info_dict=additional_info)
        
        return FilteredObject(object_to_filter, additional_info)
