#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.


class MassActionsException(Exception):
    def __init__(self, message):
        # type: (str) -> None
        super(MassActionsException, self).__init__(message)
        self.message = message


class ActionAlreadyRegistered(MassActionsException):
    def __init__(self, action, message=''):
        # type: (str, str) -> None
        if not message:
            message = 'Action [ %s ] already registered' % action
        super(ActionAlreadyRegistered, self).__init__(message)
        self.action = action
