#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import Dict, TYPE_CHECKING, IN_TESTING

SourceConfItem = Dict[str, str]  # Type of item send to source (return by get_objects). For type hint.

try:
    from shinken.synchronizer.dao.def_items import METADATA, NAGIOS_TABLE_KEYS, ITEM_TYPE, ItemType, DEF_ITEMS, NOT_TO_LOOK, ITEM_STATE, PERSISTENT_SYNCHRONIZER_DATA
    from shinken.synchronizer.dao.dataprovider.dataprovider_mongo import DataProviderMongo
    from shinken.synchronizer.dao.datamanagerV2 import get_type_item_from_class, get_class_from_type, get_name_from_type
    from shinken.synchronizer.dao.helpers import get_item_property
    from shinken.synchronizer.component.component_manager_syncui import ComponentManagerSyncui
    from shinken.synchronizer.component.component_manager_synchronizer import ComponentManagerSynchronizer
    from shinken.synchronizer.component.generic_component.translate_component import SourceTranslatePart, TranslatePart
    from shinken.synchronizer.component.generic_component.configuration_component import ConfigurationComponent
    from shinken.synchronizer.dao.validators.rules import RulesComponent
    from shinken.synchronizer.business.source.item_source_info_property import ItemSourceInfoProperty
    from shinken.synchronizer.business.source.item_source_info import ItemSourceInfo
    from shinken.synchronizer.business.source.source import Source
    from shinken.synchronizer.business.source.proxy_source_info import ProxySourceInfo
    from shinken.synchronizer.front_end.object.messages import MESSAGE
    from shinken.synchronizer.front_end.property.property_constante import PROPERTY_TYPE
    from shinken.synchronizer.front_end.property.abstract_property import AbstractProperty
    from shinken.synchronizer.front_end.object.html.tooltip import TOOLTIP_PLACEMENT
    from shinken.synchronizer.front_end.source.front_end_property_source import FrontEndPropertySource
    from shinken.synchronizer.business.source.source_configuration import SourceConfiguration, SourcePropertyDefinition, SourcePropertyDefinitionBind, PYTHON_TYPE, PROPERTY_TYPE, HTML_CATEGORY, COMPUTE_ELEMENT_DIFFERENCE, COMPUTE_NEW_ELEMENT
    from shinken.synchronizer.business.source.source_configuration import COMPUTE_DELETED_ELEMENT_NOT_IN_SOURCE, PUT_IN, PROPERTIES_USED_AS, SourcePropertyMetadata
    from shinken.synchronizer.business.source.source_configuration_constant import SOURCE_PROPERTY_NAME
    from shinken.synchronizer.business.item_controller.exceptions import BusinessException, HTTPSyncUIBusinessError, DaemonIsRequestedToStopException
    from shinken.synchronizer.business.source.validation.validation_state import ValidationState
    from shinkensolutions.toolbox.box_tools_string import ToolsBoxString

except ImportError as e:
    if TYPE_CHECKING or IN_TESTING:
        from synchronizer.dao.def_items import METADATA, NAGIOS_TABLE_KEYS, ITEM_TYPE, ItemType, DEF_ITEMS, NOT_TO_LOOK, ITEM_STATE, PERSISTENT_SYNCHRONIZER_DATA
        from synchronizer.dao.dataprovider.dataprovider_mongo import DataProviderMongo
        from synchronizer.dao.datamanagerV2 import get_type_item_from_class, get_class_from_type, get_name_from_type
        from synchronizer.dao.helpers import get_item_property
        from synchronizer.component.component_manager_syncui import ComponentManagerSyncui
        from synchronizer.component.component_manager_synchronizer import ComponentManagerSynchronizer
        from synchronizer.component.generic_component.translate_component import SourceTranslatePart, TranslatePart
        from synchronizer.component.generic_component.configuration_component import ConfigurationComponent
        from synchronizer.dao.validators.rules import RulesComponent
        from synchronizer.business.source.item_source_info_property import ItemSourceInfoProperty
        from synchronizer.business.source.item_source_info import ItemSourceInfo
        from synchronizer.business.source.source import Source
        from synchronizer.business.source.proxy_source_info import ProxySourceInfo
        from synchronizer.front_end.object.messages import MESSAGE
        from synchronizer.front_end.property.property_constante import PROPERTY_TYPE
        from synchronizer.front_end.property.abstract_property import AbstractProperty
        from synchronizer.front_end.object.html.tooltip import TOOLTIP_PLACEMENT
        from synchronizer.front_end.source.front_end_property_source import FrontEndPropertySource
        from synchronizer.business.source.source_configuration import SourceConfiguration, SourcePropertyDefinition, SourcePropertyDefinitionBind, PYTHON_TYPE, PROPERTY_TYPE, HTML_CATEGORY, COMPUTE_ELEMENT_DIFFERENCE, COMPUTE_NEW_ELEMENT
        from synchronizer.business.source.source_configuration import COMPUTE_DELETED_ELEMENT_NOT_IN_SOURCE, PUT_IN, PROPERTIES_USED_AS, SourcePropertyMetadata
        from synchronizer.business.source.source_configuration_constant import SOURCE_PROPERTY_NAME
        from synchronizer.business.item_controller.exceptions import BusinessException, HTTPSyncUIBusinessError, DaemonIsRequestedToStopException
        from synchronizer.business.source.validation.validation_state import ValidationState
        from shinkensolutions.toolbox.box_tools_string import ToolsBoxString

    if not IN_TESTING:
        raise e
