#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.


from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.api.synchronizer.source.abstract_module.listener_module import ListenerModule

if TYPE_CHECKING:
    from shinken.objects.module import Module as ShinkenModuleDefinition
    from collections import OrderedDict


class AnalyzerModule(ListenerModule):
    
    def __init__(self, module_configuration):
        # type: (ShinkenModuleDefinition) -> None
        super(AnalyzerModule, self).__init__(module_configuration)
    
    
    def init_analyzer(self):
        return
    
    
    def analyze_host(self, job, host):
        raise NotImplementedError()
    
    
    def get_analyzer_host_templates(self) -> 'OrderedDict':
        raise NotImplementedError()
    
    
    # If the user disable the analysis, we must kill all running ones
    def stop_all_analyzes(self):
        raise NotImplementedError()
