"use strict";
SHINKEN.TOOLS.TEST_AUTO_CHECK_TAB = (function ( self ) {
    self.DOM                                         = {};
    self.DOM.TRY_CHECK                               = {};
    self.TEST                                        = {};
    self.TEST.TRY_CHECK                              = {};
    self.ACTION                                      = {};
    self.CONST                                       = {};
    self.getModeCheck                                = function () {
        return document.getElementById( "id-shinken-window-checks-target" ).dataset.tabSelected;
    };
    self.getCheckExcludeStatus                       = function ( id_host, id_check, dfe, name_host, name_check ) {
        return self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check ).dataset.excludeStatus;
    };
    self._buildCheckID                               = function ( id_host, id_check, dfe, name_host, name_check ) {
        id_host        = id_host || MANAGER.__instance_element_distributor.getElementByName( name_host ).uuid;
        id_check       = id_check || MANAGER.__instance_element_distributor.getElementByName( name_check ).uuid;
        var _to_return = id_host + "-" + id_check;
        if ( typeof dfe === "string" ) {
            _to_return = _to_return + "-" + dfe;
        }
        return _to_return;
    };
    self.buildOverridePropertyName                   = function ( property_name, id_host, id_check, dfe, name_host, name_check ) {
        return "override-" + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) + "-" + property_name;
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getOverrideTitle                        = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _ui = self.getCheckOverrideInterface( id_host, id_check, dfe, name_host, name_check );
        return _ui.querySelector( ".shinken-override-title" );
    };
    self.getHostInPageHostDomElement                 = function ( id ) {
        return document.getElementById( "id-host-in-page-host-" + id );
    };
    self.getDeleteInvalidOverrideButtonDomElement    = function ( id_check, dfe ) {
        return document.getElementById( "id-shinken-unvalid-oeverride-delete-button-" + id_check + "-" + dfe );
    };
    self.DOM.hostInPageHost_Name                     = function ( id ) {
        return self.getHostInPageHostDomElement( id ).querySelector( ".shinken-template" );
    };
    self.DOM.checkOverrideContainer                  = function ( id_host, id_check ) {
        return document.querySelector( "#tr-check-override-" + id_host + "-" + id_check );
    };
    self.DOM.checkOverrideProperty                   = function ( property, id_host, id_check ) {
        return self.DOM.checkOverrideContainer( id_host, id_check ).querySelector( ".shinken-element-property-line[data-override-prop-name=" + property + "]" );
    };
    self.DOM.checkOverridePropertyDuplicateError     = function ( property, id_host, id_check ) {
        return self.DOM.checkOverrideProperty( property, id_host, id_check ).querySelector( ".shinken-override-duplicate-error-table" );
    };
    self.getAllCheckInPageHost                       = function () {
        return document.querySelectorAll( ".shinken-check-line:not(.shinken-override-unvalid)" );
    };
    self.getAllCheckOverrideUnvalidInPageHost        = function () {
        return document.querySelectorAll( ".shinken-container-host-in-page-host.shinken-container-unvalid-override" );
    };
    self.getAllPropertyOverrideUnvalidInPageHost     = function () {
        return document.querySelectorAll( ".shinken-check-line.shinken-override-unvalid" );
    };
    self.getCheckInPageHostDomElement                = function ( id_host, id_check, dfe, name_host, name_check ) {
        return document.getElementById( "id-shinken-check-line-" + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
    };
    self.getCheckOverrideInterface                   = function ( id_host, id_check, dfe, name_host, name_check ) {
        return document.getElementById( "tr-check-override-" + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
    };
    self.getTryCheckRun                              = function ( id_host, id_check, dfe, name_host, name_check ) {
        return document.getElementById( "tr-check-run-" + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
    };
    self.getCheckInPageHostCountersDomElement        = function ( id_host, id_check, dfe, name_host, name_check ) {
        return self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check ).querySelectorAll( ".shinken-tab-check-col-name .shinken-counter" );
    };
    self._getTagModulation                           = function ( id_host, id_check, dfe, name_host, name_check ) {
        return self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-tag-modulation" );
    };
    self.getCheckInPageHostOverrideStatus            = function ( id_host, id_check, dfe, name_host, name_check ) {
        return self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check ).dataset.overrideStatus;
    };
    self.getCfgOverrideText                          = function () {
        return document.querySelector( ".shinken-override-cfg-format-value .shinken-override-cfg-format-text" );
    };
    self.getButtonOverride                           = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-button-container" );
    };
    self.getButtonExcludeByID                        = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-check-exclude-tag.shinken-exclude-by-id" );
    };
    self.getButtonExcludeByIDClean                   = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _dom = self.getButtonExcludeByID( id_host, id_check, dfe, name_host, name_check );
        return _dom.querySelector( ".shinken-btn-clean" );
    };
    self.getButtonExcludeByName                      = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-check-exclude-tag.shinken-exclude-by-name" );
    };
    self.getButtonExcludeNot                         = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-check-exclude-tag.shinken-not-exclude" );
    };
    self.getButtonExcludeDFE                         = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-check-exclude-tag.shinken-not-exclude-dfe" );
    };
    self.getHiddenTag                                = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-tab-check-col-name .shinken-check-hidden" );
    };
    self.getDuplicatedTag                            = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-tab-check-col-name .shinken-check-duplicate" );
    };
    self.getTagInformation                           = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-information-tag" );
    };
    self.getTagError                                 = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-tab-check-col-dfe .tag-error" );
    };
    self.getDFESeparator                             = function ( dfe_key ) {
        return document.querySelector( '[data-dfe-key=\"' + dfe_key + '\"]' );
    };
    self.getTryCheckButtons                          = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-buttons-try-check-container" );
    };
    self.getTryCheckButtonClose                      = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getTryCheckButtons( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-hide-eval" );
    };
    self.getCommand                                  = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-macro-container" );
    };
    self.getMacrosInCommand                          = function ( class_to_find, id_host, id_check, dfe, name_host, name_check ) {
        return self.getCommand( id_host, id_check, dfe, name_host, name_check ).querySelectorAll( "." + class_to_find );
    };
    self.getWindowTabCounter                         = function () {
        return document.querySelector( "#id-shinken-window-checks .shinken-window-total-counter" );
    };
    self.getCleanAllButton                           = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _button_override = self.getButtonOverride( id_host, id_check, dfe, name_host, name_check );
        return _button_override.querySelector( ".shinken-btn-clean" );
    };
    self.getTryCheckCommandLine                      = function ( id_host, id_check, dfe, name_host, name_check ) {
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".result-check-content .shinken-try-check-command-container .content .code" );
    };
    self.getTryCheckEvaluationLine                   = function ( id_host, id_check, dfe, name_host, name_check ) {
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".result-check-content .shinken-try-check-evaluation-container .content .code" );
    };
    self.getTryCheckStatus                           = function ( id_host, id_check, dfe, name_host, name_check ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-execution-table:not(.shinken-matching-modulation) tbody .col-result" );
        }
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-try-check-execution-container:not(.shinken-matching-modulation) .shinken-cell-status .shinken-label" );
    };
    self.getTryCheckShinkenContainerResult           = function ( id_host, id_check, dfe, name_host, name_check ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-execution-table:not(.shinken-matching-modulation) .shinken-container" );
        }
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-try-check-execution-container:not(.shinken-matching-modulation) .shinken-container" );
    };
    self.getTryCheckResult                           = function ( id_host, id_check, dfe, name_host, name_check ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-execution-table:not(.shinken-matching-modulation) .shinken-output-short .shinken-content-try-check" );
        }
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-try-check-execution-container:not(.shinken-matching-modulation) .shinken-output-short .shinken-content-try-check" );
    };
    self.getTryCheckLongOutput                       = function ( id_host, id_check, dfe, name_host, name_check ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-execution-table:not(.shinken-matching-modulation) .shinken-output-long .shinken-content-try-check" );
        }
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-try-check-execution-container:not(.shinken-matching-modulation) .shinken-output-long .shinken-content-try-check" );
    };
    self.getTryCheckFlatPerformanceData              = function ( id_host, id_check, dfe, name_host, name_check ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-execution-table .shinken-output-frame.shinken-metric-flat .shinken-content-try-check" );
        }
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-try-check-execution-container .shinken-output-frame.shinken-metric-flat .shinken-div-inline-block" );
    };
    self.getTryCheckTablePerformanceData             = function ( id_host, id_check, dfe, name_host, name_check ) {
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-metrics-table" );
    };
    self.getTryCheckMessagePerformanceData           = function ( id_host, id_check, dfe, name_host, name_check ) {
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-tooltip-message" );
    };
    self.getTryCheckStatusModulate                   = function ( id_host, id_check, dfe, name_host, name_check ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-execution-table.shinken-matching-modulation tbody .col-result" );
        }
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-execute-content.shinken-matching-modulation .shinken-result-summary .shinken-cell-status-container .shinken-label" );
    };
    self.getTryCheckModulateResult                   = function ( id_host, id_check, dfe, name_host, name_check ) {
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelectorAll( ".shinken-table-rule-cell.col-status" );
    };
    self.getCheckNameTagLabel                        = function ( id_host, id_check, dfe, name_host, name_check ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
        return _check.querySelector( ".shinken-tab-check-col-name .shinken-label .shinken-link" );
    };
    self.DOM.getQuickFilterContainer                 = function () {
        return SHINKEN.TOOLS.TEST_AUTO_PAGE_EDIT.DOM.getRightColumn().querySelector( ".shinken-container-filter-name " );
    };
    self.DOM.getQuickFilterInput                     = function () {
        return self.DOM.getQuickFilterContainer().querySelector( ".shinken-input" );
    };
    self.DOM.getQuickFilterCleanButton               = function () {
        return self.DOM.getQuickFilterContainer().querySelector( ".shinken-clean-button-container" ).querySelector( ".shinken-button" );
    };
    self.DOM.getQuickFilterActivateSwitchButton      = function () {
        return self.DOM.getQuickFilterContainer().querySelector( ".switch-button" );
    };
    self.DOM.getFocusOnCheckButton                   = function ( id_host, id_check, dfe, name_host, name_check ) {
        return self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-button-focus-container" );
    };
    self.DOM.getNoElementAfterFilterText             = function () {
        return SHINKEN.TOOLS.TEST_AUTO_PAGE_EDIT.DOM.getRightColumn().querySelector( ".shinken-no-element-after-filter" );
    };
    self.DOM.TRY_CHECK.timeExecuteUnit               = function ( id_host, id_check, dfe, name_host, name_check ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-execution-table:not(.shinken-matching-modulation) th.col-time .shinken-extra-label" );
        }
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check )
                   .querySelector( ".shinken-try-check-execution-container:not(.shinken-matching-modulation) .shinken-cell-execute-time-result .shinken-label-header .shinken-extra-label" );
    };
    self.DOM.TRY_CHECK.argLineEvaluate               = function ( line_name, id_host, id_check, dfe, name_host, name_check ) {
        return self.getTryCheckRun( id_host, id_check, dfe, name_host, name_check ).querySelector( '.result-check-content .shinken-try-check-evaluation-container .table-try-check-data-eval tr[data-name="' + line_name + '"]' );
    };
    self.DOM.TRY_CHECK.fromCellArgLineEvaluate       = function ( line_name, id_host, id_check, dfe, name_host, name_check ) {
        return self.DOM.TRY_CHECK.argLineEvaluate( line_name, id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-macro-eval-table-from" );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.navigateInTabOverride                = function ( timeout, tab_name, id_host, id_check, dfe, name_host, name_check ) {
        
        id_host  = id_host || MANAGER.__instance_element_distributor.getElementByName( name_host ).uuid;
        id_check = id_check || MANAGER.__instance_element_distributor.getElementByName( name_check ).uuid;
        
        var _value = tab_name + "-override-" + self._buildCheckID( id_host, id_check, dfe, name_host, name_check );
        return SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_EDITION.ACTION.navigateInTab( timeout, _value );
    };
    self.ACTION.cleanAllOverridesByButton            = function ( timeout, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _dom = self.getCleanAllButton( id_host, id_check, dfe, name_host, name_check );
            //SHINKEN.TOOLS.TEST_AUTO_DOM.click(0, _dom);
            //SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( 100, document.activeElement, SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT.getEnterEvent() );
            
            //J AI PAS REUSSI A PASSER LA POPUP DONC JE FAIS UN RACCOOURCI...
            var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( _dom.getAttribute( "onclick" ).split( "'" )[ 1 ] );
            _check_in_page_host.cleanOverride();
            App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
        }, timeout );
        return 1000;
    };
    self.ACTION.runTryCheck                          = function ( timeout, type_try_check, id_host, id_check, dfe, name_host, name_check, timeout_to_return ) {
        setTimeout( function () {
            var _dom    = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
            var _button = _dom.querySelector( "." + type_try_check );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _button );
        }, timeout );
        return timeout_to_return || 4000;
    };
    self.ACTION.closeTryCheckPanel                   = function ( timeout, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _button = self.getTryCheckButtonClose( id_host, id_check, dfe, name_host, name_check );
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button, "button close try check " + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _button );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 200, _button, "button close try check " + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
        }, timeout );
        return 1000;
    };
    self.ACTION.goToMode                             = function ( tab_id, timeout, window ) {
        var _document = window ? window.document : document;
        setTimeout( function () {
            _document.querySelector( ".shinken-check-mode-menu-tab[data-value='" + tab_id + "']" ).click();
        }, timeout );
        return 150;
    };
    self.ACTION.openOrCloseOverrideInterface         = function ( timeout, id_host, id_check, dfe, name_host, name_check ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "openOrCloseOverrideInterface", id_host, id_check, dfe, name_host, name_check );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            id_check = id_check || MANAGER.__instance_element_distributor.getElementByName( name_check ).uuid;
            id_host  = id_host || MANAGER.__instance_element_distributor.getElementByName( name_host ).uuid;
            var _need_pulsate = self.getModeCheck() !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE;
            var _status       = self.getCheckInPageHostOverrideStatus( id_host, id_check, dfe, name_host, name_check );
            var _button       = self.getButtonOverride( id_host, id_check, dfe, name_host, name_check );
            switch ( _status ) {
                case OBJECT.CONST.OVERRIDE_STATUS.OFF:
                    _button.querySelector( ".shinken-not-override" ).click();
                    break;
                case OBJECT.CONST.OVERRIDE_STATUS.ON:
                    _button.querySelector( ".shinken-overridden" ).click();
                    break;
            }
            if ( _need_pulsate ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasPulsate( document.querySelector( '.shinken-check-mode-menu-tab[data-value="1"]' ), "Clignotement du bouton surcharge", 2000 );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnButtonExclude                 = function ( timeout, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _mode_check     = self.getModeCheck();
            var _status_exclude = self.getCheckExcludeStatus( id_host, id_check, dfe, name_host, name_check );
            var _dom;
            switch ( _mode_check ) {
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                    switch ( _status_exclude ) {
                        case OBJECT.CONST.EXCLUDE_STATUS.OFF:
                            return;
                        case OBJECT.CONST.EXCLUDE_STATUS.BY_NAME:
                            _dom = self.getButtonExcludeByName( id_host, id_check, dfe, name_host, name_check );
                            break;
                        case OBJECT.CONST.EXCLUDE_STATUS.BY_ID:
                            _dom = self.getButtonExcludeByID( id_host, id_check, dfe, name_host, name_check );
                            break;
                    }
                    var _current_timeout = SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
                    setTimeout( function () {
                        SHINKEN.TOOLS.TEST_AUTO.__hasPulsate( document.querySelector( '.shinken-check-mode-menu-tab[data-value="2"]' ), "Clignotement du bouton exclude", 2000 );
                    }, _current_timeout );
                    break;
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                    _dom = self.getButtonExcludeNot( id_host, id_check, dfe, name_host, name_check );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
                    break;
            }
        }, timeout );
        return 2000;
    };
    self.ACTION.clickOnButtonRemoveExclude           = function ( timeout, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _mode_check = self.getModeCheck();
            switch ( _mode_check ) {
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                    break;
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                    var _dom = self.getButtonExcludeByIDClean( id_host, id_check, dfe, name_host, name_check );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
                    break;
            }
        }, timeout );
        return 2000;
    };
    self.ACTION.clickOnDeleteInvalidOverride         = function ( timeout, id_check, dfe ) {
        setTimeout( function () {
            var _dom_button = self.getDeleteInvalidOverrideButtonDomElement( id_check, dfe );
            _dom_button.click();
        }, timeout );
        return 2000;
    };
    self.ACTION.setValueOverride                     = function ( timeout, to_set, property_name, id_host, id_check, dfe, name_check, name_host ) {
        
        id_check = id_check || MANAGER.__instance_element_distributor.getElementByName( name_check ).uuid;
        id_host  = id_host || MANAGER.__instance_element_distributor.getElementByName( name_host ).uuid;
        
        var _property_name_override = self.buildOverridePropertyName( property_name, id_host, id_check, dfe, name_host, name_check );
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.ACTION.setValue( timeout, _property_name_override, to_set );
    };
    self.ACTION.addValueOverrideError                = function ( timeout, to_add ) {
        setTimeout( function () {
            MANAGER.__instance_element_distributor.current_element.override.addOverrideWithErrorsArray( to_add );
            fire_element_is_modifie();
        }, timeout );
        return 200;
    };
    self.ACTION.setValueOverrideError                = function ( timeout, to_set ) {
        setTimeout( function () {
            MANAGER.__instance_element_distributor.current_element.override.setOverrideWithErrorsArray( to_set );
            fire_element_is_modifie();
        }, timeout );
        return 200;
    };
    self.ACTION.filterChecks                         = function ( timeout, value ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setQuickFilterValue', value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = self.DOM.getQuickFilterInput();
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, _dom, value );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.cleanCheckFilter                     = function ( timeout ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.cleanCheckFilter' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = self.DOM.getQuickFilterCleanButton();
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.togglActivityFilter                  = function ( timeout ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.togglActivityFilter' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = self.DOM.getQuickFilterActivateSwitchButton();
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnFocusOnCheckButton            = function ( timeout, id_host, id_check, dfe, name_host, name_check ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.togglActivityFilter' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = self.DOM.getFocusOnCheckButton( id_host, id_check, dfe, name_host, name_check );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.nbHostInPageHost                       = function ( timeout, nb_expected ) {
        setTimeout( function () {
            var _number_present = App.Elements.ChecksTab.getListHostInPageHost().getContents().length;
            if ( _number_present !== nb_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "le nombre d'host_in_page_host n'est pas égale à " + nb_expected + " ==> [" + _number_present + "]" );
            }
        }, timeout );
        return 10;
    };
    self.TEST.nbCheckInPageHost                      = function ( timeout, nb_counter, nb_visible, nb_hidden, nb_filtered ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_WINDOW.TEST.counter( 0, "id-shinken-window-checks", undefined, undefined, nb_counter );
            let _checks_dom_line = self.getAllCheckInPageHost();
            let _hidden          = 0;
            let _visible         = 0;
            let _filtered        = 0;
            for ( var i = 0, _size_i = _checks_dom_line.length; i < _size_i; i++ ) {
                if ( _checks_dom_line[ i ].classList.contains( "shinken-check-hidden-container" ) ) {
                    _hidden++;
                }
                else {
                    _visible++;
                }
                if ( nb_filtered && DOM.Service.isVisible( _checks_dom_line[ i ] ) ) {
                    _filtered++;
                }
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _hidden, nb_hidden, "check caché" );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _visible, nb_visible, "check visible" );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _visible, nb_visible, "check visible après le filtre" );
        }, timeout );
        return 10;
    };
    self.TEST.counterCheck                           = function ( timeout, nb_error, nb_warning, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _counters = self.getCheckInPageHostCountersDomElement( id_host, id_check, dfe, name_host, name_check );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _counters[ 0 ], nb_error );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _counters[ 1 ], nb_warning );
        }, timeout );
        return 10;
    };
    self.TEST.inactiveOverrideCheckReason            = function ( timeout, text_array ) {
        setTimeout( function () {
            var _checks_dom_line = self.getAllCheckOverrideUnvalidInPageHost();
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _checks_dom_line.length, text_array.length, "NB CHECK OVERRIDE INACTIVE" );
            for ( var i = 0, _size_i = _checks_dom_line.length; i < _size_i; i++ ) {
                var _current = _checks_dom_line[ i ].querySelector( ".shinken-title" );
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _current, text_array[ i ], "Inactivity text for check" );
            }
        }, timeout );
        return 10;
    };
    self.TEST.nbInactiveOverrideCheck                = function ( timeout, nb_expected_check, nb_expected_property ) {
        setTimeout( function () {
            var _checks_dom_line = self.getAllCheckOverrideUnvalidInPageHost();
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _checks_dom_line.length, nb_expected_check, "NB CHECK OVERRIDE INACTIVE" );
            var _checks_dom_line_property = self.getAllPropertyOverrideUnvalidInPageHost();
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _checks_dom_line_property.length, nb_expected_property, "NB PROPERTY OVERRIDE INACTIVE" );
        }, timeout );
        return 10;
    };
    self.TEST.overrideInterface                      = function ( timeout, status, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _row_override = self.getCheckOverrideInterface( id_host, id_check, dfe, name_host, name_check );
            switch ( status ) {
                case OBJECT.CONST.OVERRIDE_STATUS.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _row_override, "override interface for " + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
                    break;
                case OBJECT.CONST.OVERRIDE_STATUS.ON:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _row_override, "override interface for " + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
                    break;
            }
        }, timeout );
        return 50;
    };
    self.TEST.hasOverrideButtonStatus                = function ( timeout, status, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _button     = self.getButtonOverride( id_host, id_check, dfe, name_host, name_check );
            var _mode_check = self.getModeCheck();
            switch ( status ) {
                case OBJECT.CONST.OVERRIDE_STATUS.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check ).dataset, "overrideStatus", status );
                    switch ( _mode_check ) {
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button.querySelector( ".shinken-not-override" ) );
                            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button.querySelector( ".shinken-overridden" ) );
                            break;
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button.querySelector( ".shinken-not-override" ) );
                            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "color", "rgb(0, 0, 0)" );
                            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "cursor", "pointer" );
                            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button.querySelector( ".shinken-overridden" ) );
                            break;
                    }
                    break;
                case OBJECT.CONST.OVERRIDE_STATUS.ON:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check ).dataset, "overrideStatus", status );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button.querySelector( ".shinken-not-override" ) );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button.querySelector( ".shinken-overridden" ) );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "cursor", "pointer" );
                    switch ( _mode_check ) {
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "backgroundColor", "rgb(0, 0, 0)" );
                            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "color", "rgb(255, 255, 255)" );
                            break;
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                            if ( DOM.Service.isVisible( self.getCheckOverrideInterface( id_host, id_check, dfe, name_host, name_check ) ) ) {
                                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "backgroundColor", "rgb(147, 213, 243)" );
                                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "color", "rgb(0, 0, 0)" );
                            }
                            else {
                                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "backgroundColor", "rgb(0, 0, 0)" );
                                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "color", "rgb(255, 255, 255)" );
                            }
                            break;
                    }
                    break;
                case OBJECT.CONST.OVERRIDE_STATUS.DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check ).dataset, "overrideStatus", "0" );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button.querySelector( ".shinken-not-override" ) );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button.querySelector( ".shinken-overridden" ) );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "cursor", "pointer" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "backgroundColor", "rgba(0, 0, 0, 0)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "color", "rgb(0, 0, 0)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "opacity", "0.2" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "pointer-events", "none" );
                    break;
            }
        }, timeout );
        return 50;
    };
    self.TEST.hasExcludeButtonStatus                 = function ( timeout, status, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _button_by_id          = self.getButtonExcludeByID( id_host, id_check, dfe, name_host, name_check );
            var _button_by_name        = self.getButtonExcludeByName( id_host, id_check, dfe, name_host, name_check );
            var _button_by_not_exclude = self.getButtonExcludeNot( id_host, id_check, dfe, name_host, name_check );
            var _button_dfe            = self.getButtonExcludeDFE( id_host, id_check, dfe, name_host, name_check );
            
            
            var _mode_check = self.getModeCheck();
            switch ( status ) {
                case OBJECT.CONST.EXCLUDE_STATUS.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_id );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_name );
                    switch ( _mode_check ) {
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_not_exclude );
                            break;
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                            if ( dfe ) {
                                SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_not_exclude );
                                SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button_dfe );
                                SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _button_dfe, "Exclusionspécifiquenondisponible" );
                                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button_dfe, "cursor", "not-allowed" );
                                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button_dfe.querySelector( ".shinken-label-exclude" ), "opacity", "0.8" );
                                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button_dfe.querySelector( ".shinken-label" ), "font-style", "italic" );
                            }
                            else {
                                SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button_by_not_exclude );
                            }
                            break;
                    }
                    break;
                case OBJECT.CONST.EXCLUDE_STATUS.BY_ID:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button_by_id );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_name );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_not_exclude );
                    break;
                case OBJECT.CONST.EXCLUDE_STATUS.BY_NAME:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button_by_name );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_id );
                    switch ( _mode_check ) {
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_not_exclude );
                            break;
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button_by_not_exclude );
                            break;
                    }
                    break;
            }
        }, timeout );
        return 50;
    };
    self.TEST.validOverridenButton                   = function ( timeout, nb_error, nb_warning, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            self.TEST.hasOverrideButtonStatus( 0, OBJECT.CONST.OVERRIDE_STATUS.ON, id_host, id_check, dfe, name_host, name_check );
            var _button = self.getButtonOverride( id_host, id_check, dfe, name_host, name_check ).querySelector( ".shinken-overridden" );
            var _error  = _button.querySelector( ".shinken-counter.shinken-error-counter" );
            if ( nb_error ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _error, nb_error );
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _error, "tag error" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _error, "tag error" );
            }
            var _warning = _button.querySelector( ".shinken-counter.shinken-warning-counter" );
            if ( nb_warning ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _warning, nb_warning );
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _warning, "tag warning" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _warning, "tag warning" );
            }
        }, timeout );
        return 50;
    };
    self.TEST.tagInformationDisplay                  = function ( timeout, state_expected, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _dom_tag_info = self.getTagInformation( id_host, id_check, dfe, name_host, name_check );
            switch ( state_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "tag information" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_info, "tag information" );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.TEST.validCleanAllButton                    = function ( timeout, state_expected, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _dom = self.getCleanAllButton( id_host, id_check, dfe, name_host, name_check );
            switch ( state_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, "button delete all" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, "button delete all" );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.TEST.tagError                               = function ( timeout, state_expected, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _timeout       = 0;
            var _dom_tag_error = self.getTagError( id_host, id_check, dfe, name_host, name_check );
            switch ( state_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_error, "tag Error DFE" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom_tag_error, "background-color", "rgb(217, 83, 79)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom_tag_error, "color", "rgb(255, 255, 255)" );
                    switch ( __shinken_test_type + "-" + __phase ) {
                        case "00020-1":
                            _timeout += SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( _timeout, _dom_tag_error, "mouseenter" );
                            _timeout += SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _( "element.tooltip_dfe_link_on_data" ).substring( 0, 25 ) );
                            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.click( _timeout, _dom_tag_error );
                            _timeout += SHINKEN.TOOLS.TEST_AUTO_WINDOW.TEST.isSelected( _timeout, "id-shinken-window-datas" );
                            _timeout += SHINKEN.TOOLS.TEST_AUTO_WINDOW.TEST.isSelected( _timeout, "id-shinken-window-checks", true );
                            break;
                    }
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_error, "tag Error DFE" );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.TEST.hostInPageHost_Name                    = function ( timeout, name_expected, id_host ) {
        setTimeout( function () {
            var _dom = self.DOM.hostInPageHost_Name( id_host );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom, name_expected, "name of host in page host" );
        }, timeout );
        return 100;
    };
    self.TEST.hasValueOverride                       = function ( timeout, to_test, property_name, id_host, id_check, dfe, name_host, name_check ) {
        var _property_name_override = self.buildOverridePropertyName( property_name, id_host, id_check, dfe, name_host, name_check );
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.TEST.hasValue( timeout, _property_name_override, to_test );
    };
    self.TEST.tryCheckResultContainerStatus          = function ( timeout, status_expected, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            let _dom = self.getTryCheckShinkenContainerResult( id_host, id_check, dfe, name_host, name_check );
            switch ( status_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _dom );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom );
                    break;
            }
        }, timeout );
        return 500;
    };
    self.TEST.tryCheckResultContainerHaveAllChildren = function ( timeout, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _dom_shinken_container = self.getTryCheckShinkenContainerResult( id_host, id_check, dfe, name_host, name_check );
            if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
                SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom_shinken_container.childElementCount, 4 );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom_shinken_container.childElementCount, 1 );
            }
        }, timeout );
        return 500;
    };
    self.TEST.propertyIsLockedOverride               = function ( timeout, property_name, id_host, id_check, dfe, name_host, name_check, revert ) {
        
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.propertyIsLockedOverride', property_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            id_check = id_check || MANAGER.__instance_element_distributor.getElementByName( name_check ).uuid;
            id_host  = id_host || MANAGER.__instance_element_distributor.getElementByName( name_host ).uuid;
            
            var dom_property = self.DOM.checkOverrideProperty( property_name, id_host, id_check );
            if ( !revert && !dom_property.classList.contains( "shinken-disabled" ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( property_name + " is not protected" );
            }
            if ( revert && dom_property.classList.contains( "shinken-disabled" ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( property_name + " is protected" );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST TRY CHECK   **************************************************//
    self.TEST.tryCheckButtonDisplay                  = function ( timeout, state_expected, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _dom_tag_info = self.getTryCheckButtons( id_host, id_check, dfe, name_host, name_check );
            switch ( state_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "try check button" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_info, "try check button" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "try check button" );
                    var _timeout = SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( 0, _dom_tag_info, "mouseenter" );
                    SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _( "element.no_run_bp_rule" ) );
                    break;
            }
        }, timeout );
        return 200;
    };
    self.TEST.statusTryCheckAfterRun                 = function ( timeout, status_expected_array, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            id_host  = id_host || MANAGER.__instance_element_distributor.getElementByName( name_host ).uuid;
            id_check = id_check || MANAGER.__instance_element_distributor.getElementByName( name_check ).uuid;
            SHINKEN.TOOLS.TEST_AUTO_DOM.isTextInArray( 0, self.getTryCheckStatus( id_host, id_check, dfe, name_host, name_check ), status_expected_array, "Status du try check run" );
        }, timeout );
        return 300;
    };
    self.TEST.statusTryCheckAfterRunModulate         = function ( timeout, status_expected, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _dom_tag_status = self.getTryCheckStatusModulate( id_host, id_check, dfe, name_host, name_check );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_tag_status, status_expected, "Status du try check run après modulation" );
        }, timeout );
        return 200;
    };
    self.TEST.statusFoundAfterRunModulate            = function ( timeout, status_expected, id_host, id_check, dfe, name_host, name_check ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.ALPHA ) {
            return 0;
        }
        setTimeout( function () {
            var _dom_tag_status = self.getTryCheckModulateResult( id_host, id_check, dfe, name_host, name_check );
            _dom_tag_status.forEach( ( dom_tag_status, index ) => {
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( dom_tag_status, status_expected[ index ], "Status du try check run après modulation" );
            } );
        }, timeout );
        return 200;
    };
    self.TEST.statusNoElementAfterFilterText         = function ( timeout, status_expected ) {
        setTimeout( function () {
            let _dom = self.DOM.getNoElementAfterFilterText();
            switch ( status_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _dom );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom );
                    break;
                
            }
        }, timeout );
        return 200;
    };
    self.TEST.statusDFESeparator                     = function ( timeout, status_expected, dfe_name ) {
        setTimeout( function () {
            let _dom = self.getDFESeparator( dfe_name );
            switch ( status_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _dom );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom );
                    break;
                
            }
        }, timeout );
        return 200;
    };
    self.TEST.statusCheckLine                        = function ( timeout, status_expected, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            let _dom = self.getCheckInPageHostDomElement( id_host, id_check, dfe, name_host, name_check );
            switch ( status_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _dom );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.FILTERED_NOT_FOCUSED:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "background-color", "rgb(213, 234, 255)" );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _dom.querySelector( ".shinken-button-focus-container" ) );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.FILTERED:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "background-color", "rgb(213, 234, 255)" );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom.querySelector( ".shinken-button-focus-container .shinken-focus-on" ) );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.FOCUSED:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "background-color", "rgb(213, 234, 255)" );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom.querySelector( ".shinken-button-focus-container .shinken-focus-off" ) );
                    break;
                
            }
        }, timeout );
        return 200;
    };
    self.TEST.resultTryCheckAfterRun                 = function ( timeout, id_host, id_check, dfe, name_host, name_check, extra_step ) {
        var _text_expected = "__NOT_DEFINED__";
        var _switch_value  = __shinken_test_type + "-" + __phase;
        if ( extra_step ) {
            _switch_value = _switch_value + "-" + extra_step;
        }
        switch ( _switch_value ) {
            case "00018-1":
                _text_expected = "[valA] []";
                break;
            case "00122-4":
            case "00122-6":
                _text_expected = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL._00122.RESULT;
                break;
            case "00212-1":
                _text_expected = "Name or service not known";
                break;
            case "00218-1":
                _text_expected = "UNKNOWN";
                break;
            case "00280-1-1":
                _text_expected = "Connection took";
                break;
            case "00280-1-2":
            case "00282-1-2":
            case "00282-1-4":
            case "00283-1-2":
            case "00284-1-2":
            case "00284-1-3":
                _text_expected = "Mongo 3 is not in MMapV1 mode but in wiredTiger (new format) or in a cluster mode. This indicator is not available.";
                break;
            case "00280-1-3":
            case "00282-1-6":
            case "00283-1-3":
            case "00284-1-4":
                _text_expected = "percent";
                break;
            case "00280-1-4":
            case "00280-1-5":
            case "00280-1-6":
                _text_expected = "Connection to Mongo server on localhost:27017 has failed";
                break;
            case "00281-1-1":
            case "00291-1-1":
                _text_expected = "Graphite service as cache (where data is stored) is working fine.";
                break;
            case "00281-1-2":
            case "00291-1-2":
                _text_expected = "Process carbon-cache status : Not running";
                break;
            case "00282-1-1":
            case "00283-1-1":
            case "00284-1-1":
                _text_expected = "Connection took";
                break;
            case "00282-1-3":
                _text_expected = "MongoDB says: not supported on this platform";
                break;
            case "00282-1-5":
                _text_expected = "Mongo 3 is free of global locks. This check is not useful anymore. Please disable it or apply the Shinken Enterprise pack differences.";
                break;
            case "00282-1-7":
            case "00282-1-8":
            case "00282-1-9":
            case "00282-1-10":
            case "00284-1-5":
            case "00284-1-6":
            case "00284-1-7":
            case "00284-1-8":
                _text_expected = "Queries / Sec";
                break;
            case "00282-1-11":
            case "00282-1-12":
            case "00284-1-9":
            case "00284-1-10":
                _text_expected = "Not running with replSet";
                break;
            case "00282-1-13":
            case "00282-1-14":
            case "00282-1-15":
            case "00282-1-16":
            case "00282-1-17":
            case "00282-1-18":
            case "00282-1-19":
            case "00282-1-20":
            case "00282-1-21":
            case "00282-1-22":
            case "00282-1-23":
            case "00282-1-24":
            case "00283-1-4":
            case "00283-1-5":
            case "00283-1-6":
            case "00284-1-11":
            case "00284-1-12":
            case "00284-1-13":
            case "00284-1-14":
            case "00284-1-15":
            case "00284-1-16":
            case "00284-1-17":
            case "00284-1-18":
            case "00284-1-19":
            case "00284-1-20":
                _text_expected = "has failed";
                break;
            case "00285-1-1":
                _text_expected = "All graphite backends are available.";
                break;
            case "00285-1-2":
                _text_expected = "Module WebUI is working as intended.";
                break;
            case "00285-1-3":
            case "00285-1-4":
            case "00287-1-2":
            case "00288-1-2":
            case "00289-1-4":
            case "00289-1-5":
            case "00289-1-6":
                _text_expected = "The broker is performing a shutdown";
                break;
            case "00286-1-1":
                _text_expected = "Your arbiter is running well";
                break;
            case "00286-1-2":
                _text_expected = "Arbiter answered in";
                break;
            case "00286-1-3":
            case "00286-1-4":
                _text_expected = "Cannot connect to localhost:7770/ping with exception";
                break;
            case "00287-1-1":
                _text_expected = "Module on webui : WebUI is working as intended";
                break;
            case "00288-1-1":
                _text_expected = "Module is working as intended.";
                break;
            case "00289-1-1":
                _text_expected = "The daemon is running well";
                break;
            case "00289-1-2":
                _text_expected = "API Connection is in the good range";
                break;
            case "00289-1-3":
                _text_expected = "Modules performance is going well";
                break;
            case "00292-1-1":
            case "00292-1-2":
            case "00292-1-3":
            case "00292-1-4":
            case "00292-1-5":
            case "00292-1-6":
            case "00292-1-7":
            case "00292-1-8":
            case "00292-1-9":
            case "00292-1-10":
            case "00292-1-11":
            case "00292-1-12":
            case "00292-1-13":
                _text_expected = "Authentication failed";
                break;
            case "00292-1-14":
                _text_expected = "CPU is";
                break;
            case "00292-1-15":
                _text_expected = "all disks are in the limits";
                break;
            case "00292-1-16":
            case "00292-1-17":
            case "00292-1-20":
            case "00292-1-21":
                _text_expected = "OK";
                break;
            case "00292-1-18":
                _text_expected = "load average is";
                break;
            case "00292-1-19":
                _text_expected = "memory consumption is";
                break;
            case "00292-1-22":
                _text_expected = "ntp delay is";
                break;
            case "00292-1-23":
                _text_expected = "no read only file system";
                break;
            case "00292-1-24":
                _text_expected = "uptime is";
                break;
            case "00292-1-25":
                _text_expected = "connexion is";
                break;
            case "00292-1-26":
                _text_expected = "OK";
                break;
            case "00293-1-1":
                _text_expected = "Module is working as intended.";
                break;
            case "00294-1-1":
                _text_expected = "Module is working as intended";
                break;
            case "00295-1-1":
                _text_expected = "Your poller is running well";
                break;
            case "00295-1-2":
                _text_expected = "Poller statistics";
                break;
            case "00295-1-3":
            case "00295-1-4":
                _text_expected = "Cannot connect to localhost:7771/ping with exception";
                break;
            case "00296-1-1":
                _text_expected = "Your reactionner is running well";
                break;
            case "00296-1-2":
                _text_expected = "Reactionner statistics";
                break;
            case "00296-1-3":
            case "00296-1-4":
                _text_expected = "Cannot connect to localhost:7769/ping with exception";
                break;
            case "00297-1-1":
                _text_expected = "The daemon is running well";
                break;
            case "00297-1-2":
                _text_expected = "API Connection is in the good range";
                break;
            case "00297-1-3":
            case "00297-1-4":
                _text_expected = "Cannot connect to localhost:7773/ping with exception";
                break;
            case "00298-1-1":
                _text_expected = "Your scheduler is running well";
                break;
            case "00298-1-2":
                _text_expected = "The scheduler is running well";
                break;
            case "00298-1-3":
            case "00298-1-4":
                _text_expected = "Cannot connect to localhost:7768/ping with exception";
                break;
            case "00299-1-1":
                _text_expected = "The synchronizer is running well";
                break;
            case "00299-1-2":
                _text_expected = "API Connection is in the good range";
                break;
            case "00301-3":
                _text_expected = "Ok: all processes are in the limits";
                break;
            case "00301-6":
                _text_expected = "Warning: some processes are not good";
                break;
            case "00301-9":
                _text_expected = "Critical: some processes are not good";
                break;
            case "00292-1":
                _text_expected = "";
                break;
        }
        setTimeout( function () {
            id_host  = id_host || MANAGER.__instance_element_distributor.getElementByName( name_host ).uuid;
            id_check = id_check || MANAGER.__instance_element_distributor.getElementByName( name_check ).uuid;
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( self.getTryCheckResult( id_host, id_check, dfe, name_host, name_check ), _text_expected, "Result" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( self.getTryCheckResult( id_host, id_check, dfe, name_host, name_check ), "Traceback", "Result", null, true );
        }, timeout );
        return 300;
    };
    self.TEST.commandLineTryCheckAfterRun            = function ( timeout, id_host, id_check, dfe, name_host, name_check ) {
        var _text_expected = "";
        var _switch_value  = __shinken_test_type + "-" + __phase;
        
        switch ( _switch_value ) {
            case "00122-4":
            case "00122-6":
                _text_expected = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL._00122.COMMAND_LINE;
                break;
            case "00122-8":
                _text_expected = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL._00122.COMMAND_LINE_7;
                break;
            default:
                _text_expected = "echo [$ARG1$] [$ARG2$]";
                break;
        }
        setTimeout( function () {
            id_host  = id_host || MANAGER.__instance_element_distributor.getElementByName( name_host ).uuid;
            id_check = id_check || MANAGER.__instance_element_distributor.getElementByName( name_check ).uuid;
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.getTryCheckCommandLine( id_host, id_check, dfe, name_host, name_check ), _text_expected, "Ligne de commande" );
        }, timeout );
        return 100;
    };
    self.TEST.evaluationLineTryCheckAfterRun         = function ( timeout, id_host, id_check, dfe, name_host, name_check ) {
        var _text_expected = "";
        var _switch_value  = __shinken_test_type + "-" + __phase;
        
        switch ( _switch_value ) {
            case "00122-4":
                _text_expected = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL._00122.COMMAND_LINE_INTERPRETED.PHASE_4;
                break;
            case "00122-6":
                _text_expected = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL._00122.COMMAND_LINE_INTERPRETED.PHASE_6;
                break;
            case "00178-1":
                _text_expected = "echo ['aaaa'] []";
                break;
            case "00270-1":
                _text_expected = '/var/lib/shinken/libexec/check_ntp_sync_by_ssh.py -H "localhost" -u "Ce champ est protégé" -i "~/.ssh/id_rsa" -P "Ce champ est protégé" -C -w "100,10" -c "200,30"';
                break;
            default:
                SHINKEN.TOOLS.TEST_AUTO.addError( "Missing switch case : " + _switch_value + " in TEST.evaluationLineTryCheckAfterRun" );
                break;
        }
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.getTryCheckEvaluationLine( id_host, id_check, dfe, name_host, name_check ), _text_expected, "Ligne de commande avec les données interprétées" );
        }, timeout );
        return 100;
    };
    self.TEST.TRY_CHECK.fromCellArgEvaluationLine    = function ( timeout, line_name, value_expected, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.TRY_CHECK.fromCellArgLineEvaluate( line_name, id_host, id_check, dfe, name_host, name_check ), value_expected, 'contenu de la cellule "FROM" pour évaluation arguments' );
        }, timeout );
        return 100;
    };
    self.TEST.dataPerformanceTryCheckAfterRun        = function ( timeout, id_host, id_check, dfe, name_check, name_host ) {
        
        id_check = id_check || MANAGER.__instance_element_distributor.getElementByName( name_check ).uuid;
        id_host  = id_host || MANAGER.__instance_element_distributor.getElementByName( name_host ).uuid;
        
        var _text_expected_flat  = "";
        var _text_expected_table = "";
        
        var _is_perf_data_valid = true;
        var _has_perf_data      = true;
        var _has_table_data     = true;
        
        var _nb_table_data_row = 3;
        var _nb_table_data_col = 4;
        
        var _switch_value = __shinken_test_type + "-" + __phase;
        switch ( _switch_value ) {
            case "00028-2":
                _text_expected_flat  = "time=0.216080s size=1124B";
                _text_expected_table = "MétriqueValeurSeuild'avertissementSeuilcritiquetime0.216080ssize1124B";
                break;
            case "00028-3":
                _text_expected_flat  = "time=0.216080s";
                _text_expected_table = "MétriqueValeurSeuild'avertissementSeuilcritiquetime0.216080s";
                _nb_table_data_row   = 2;
                break;
            case "00028-4":
                _text_expected_flat = "time blabla=0.216080s";
                _has_table_data     = false;
                _is_perf_data_valid = false;
                break;
            case "00028-5":
                _text_expected_flat = "time=0.216080s,";
                _has_table_data     = false;
                _is_perf_data_valid = false;
                break;
            case "00028-6":
                _text_expected_flat = "time=0,216080s";
                _has_table_data     = false;
                _is_perf_data_valid = false;
                break;
            case "00028-7":
                _text_expected_flat  = "'john''s disk'=83%";
                _text_expected_table = "MétriqueValeurSeuild'avertissementSeuilcritiquejohn''sdisk83%";
                _has_table_data      = true;
                _nb_table_data_row   = 2;
                _nb_table_data_col   = 4;
                break;
            case "00028-8":
                _text_expected_flat = "'disk usage'=78%;80;90;;;";
                _has_table_data     = false;
                _is_perf_data_valid = false;
                break;
            case "00028-9":
                _text_expected_flat  = "'disk usage'=78%;80;90";
                _text_expected_table = "MétriqueValeurSeuild'avertissementSeuilcritiquediskusage78%8090";
                _has_table_data      = true;
                _nb_table_data_row   = 2;
                _nb_table_data_col   = 4;
                break;
            case "00028-10":
                _text_expected_flat  = "'data packets'=11345234c";
                _text_expected_table = "MétriqueValeurSeuild'avertissementSeuilcritiquedatapackets11345234c";
                _has_table_data      = true;
                _nb_table_data_row   = 2;
                _nb_table_data_col   = 4;
                break;
            case "00028-11":
                _text_expected_flat = "temperature=23;;;20;30";
                _has_table_data     = true;
                _nb_table_data_row  = 2;
                _nb_table_data_col  = 4;
                break;
            case "00028-12":
                _has_table_data = false;
                _has_perf_data  = false;
                break;
            case "00147-1":
                _has_table_data = false;
                _has_perf_data  = false;
                break;
            case "00242-1":
                _text_expected_flat  = "'Vlan201_errors_in'=0%;5;15;0;100 'Vlan201_errors_out'=0%;5;15;0;100";
                _text_expected_table = "MétriqueValeurSeuild'avertissementSeuilcritiqueVlan201_errors_in0%515Vlan201_errors_out0%515";
                _nb_table_data_col   = 4;
                _nb_table_data_row   = 3;
                break;
            case "00242-2":
                _text_expected_flat  = "'Vlan201_errors_in'=0%;5;15;0;100 'Vlan201_errors_out'=0%;5;15;0;100";
                _text_expected_table = "MétriqueValeurSeuild'avertissementSeuilcritiqueVlan201_errors_in0%515Vlan201_errors_out0%515";
                _nb_table_data_col   = 4;
                _nb_table_data_row   = 3;
                break;
            case "00242-3":
                _text_expected_flat  = "'Vlan201_errors_in'=0%;5;15;0;100 'Vlan201_errors_out'=0%;5;15;0;100";
                _text_expected_table = "MétriqueValeurSeuild'avertissementSeuilcritiqueVlan201_errors_in0%515Vlan201_errors_out0%515";
                _nb_table_data_col   = 4;
                _nb_table_data_row   = 3;
                break;
            case "00242-4":
                _text_expected_flat  = "'Vlan201_errors_in'=0%;5;15;0;100 'Vlan201_errors_out'=0%;5;15;0;100";
                _text_expected_table = "MétriqueValeurSeuild'avertissementSeuilcritiqueVlan201_errors_in0%515Vlan201_errors_out0%515";
                _nb_table_data_col   = 4;
                _nb_table_data_row   = 3;
                break;
        }
        setTimeout( function () {
            var _dom_flat  = self.getTryCheckFlatPerformanceData( id_host, id_check, dfe, name_host, name_check );
            var _dom_table = self.getTryCheckTablePerformanceData( id_host, id_check, dfe, name_host, name_check );
            var _dom_error = self.getTryCheckMessagePerformanceData( id_host, id_check, dfe, name_host, name_check );
            if ( _has_perf_data ) {
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_flat, _text_expected_flat, "La data performance flat" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, _dom_flat );
            }
            if ( _has_table_data ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isTable( 0, _dom_table, _nb_table_data_row, _nb_table_data_col, _text_expected_table );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, _dom_table );
            }
            if ( _is_perf_data_valid ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, _dom_error );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_error );
            }
        }, timeout );
        return 10;
    };
    self.TEST.tryCheckExecuteTimeUnit                = function ( timeout, id_host, id_check, dfe, name_check, name_host ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.TRY_CHECK.timeExecuteUnit( id_host, id_check, dfe, name_host, name_check ), "secondes" );
        }, timeout );
        return 10;
    };
    //********************************************  TEST TAGS  **************************************************//
    self.TEST.hasHiddenTagState                      = function ( timeout, state_expected, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _tag = self.getHiddenTag( id_host, id_check, dfe, name_host, name_check );
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tag, "TAG HIDDEN " + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _tag, "TAG HIDDEN " + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.TEST.isNoElementAfterFilterTextVisible      = function ( timeout, state_expected ) {
        setTimeout( function () {
            let _dom = self.DOM.getNoElementAfterFilterText();
            switch ( state_expected ) {
                case false:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _dom );
                    break;
                case true:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.TEST.hasDuplicateTagState                   = function ( timeout, state_expected, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _tag = self.getDuplicatedTag( id_host, id_check, dfe, name_host, name_check );
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tag, "TAG Duplicate " + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _tag, "TAG Duplicate " + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
                    self.TEST.hasHiddenTagState( 0, state_expected, id_host, id_check, dfe, name_host, name_check );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.TEST.tagModulation                          = function ( timeout, state, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _dom_tag_info = self._getTagModulation( id_host, id_check, dfe, name_host, name_check );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "tag modulation" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_info, "tag modulation" );
                    break;
            }
        }, timeout );
        return 10;
    };
    //********************************************  TEST OVERRIDE  **************************************************//
    self.TEST.hasOverrideUI                          = function ( timeout, id_host, id_check, dfe, name_host, name_check ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "hasOverrideUI", self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.getOverrideTitle( id_host, id_check, dfe, name_host, name_check );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, "hasOverrideUI" + self._buildCheckID( id_host, id_check, dfe, name_host, name_check ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.overridePropertyHasDuplicateError      = function ( timeout, property, id_host, id_check ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "overridePropertyHasDuplicateError" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = SHINKEN.TOOLS.TEST_AUTO_CHECK_TAB.DOM.checkOverridePropertyDuplicateError( property, id_host, id_check );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST MISC  **************************************************//
    self.TEST.cfgOverrideText                        = function ( timeout, text_expected ) {
        setTimeout( function () {
            var _text = self.getCfgOverrideText();
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _text, text_expected, "Syntaxe des surcharges de check" );
        }, timeout );
        return 2000;
    };
    self.TEST.isTextCommand                          = function ( timeout, value, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _command = self.getCommand( id_host, id_check, dfe, name_host, name_check );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _command, value );
        }, timeout );
        return 100;
    };
    self.TEST.commandErrorAndWarning                 = function ( timeout, nb_error, nb_warning, id_host, id_check, dfe, name_host, name_check ) {
        setTimeout( function () {
            var _errors = self.getMacrosInCommand( "shinken-macro-error", id_host, id_check, dfe, name_host, name_check );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _errors, nb_error, "nb errors in macro" );
            for ( var i = 0, _size_i = _errors.length; i < _size_i; i++ ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.isMacroError( 0, _errors[ i ] );
            }
            var _warning = self.getMacrosInCommand( "shinken-macro-warning", id_host, id_check, dfe, name_host, name_check );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _warning, nb_warning, "nb warnings in macro" );
            for ( var j = 0, _size_j = _warning.length; j < _size_j; j++ ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.isMacroWarning( 0, _warning[ j ] );
            }
        }, timeout );
        return 200;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_CHECK_TAB || {} );


SHINKEN.TOOLS.TEST_AUTO_CHECK_TAB.CONST.ERRORS = {
    "00260": {
        "links_with_errors": [
            {
                "check_link": {
                    "item_type": "serviceshosttpls",
                    "_id"      : "20000000000000000000000000000008",
                    "name"     : "00008_test_auto_1",
                    "exists"   : true
                },
                "dfe_key"   : "1",
                "value"     : "2",
                "key"       : "business_impact",
                "error_type": "duplicate"
            },
            {
                "check_link": {
                    "item_type": "serviceshosttpls",
                    "_id"      : "20000000000000000000000000000008",
                    "name"     : "00008_test_auto_1",
                    "exists"   : true
                },
                "dfe_key"   : "1",
                "value"     : "3",
                "key"       : "business_impact",
                "error_type": "duplicate"
            },
            {
                "check_link"             : {
                    "item_type": "serviceshosttpls",
                    "_id"      : "20000000000000000000000000000008",
                    "name"     : "00008_test_auto_1",
                    "exists"   : true
                },
                "dfe_key"                : "1",
                "value"                  : "1",
                "key"                    : "active_checks_enabled",
                "error_type"             : "duplicate"
            },
            {
                "check_link"             : {
                    "item_type": "serviceshosttpls",
                    "_id"      : "20000000000000000000000000000008",
                    "name"     : "00008_test_auto_1",
                    "exists"   : true
                },
                "dfe_key"                : "1",
                "value"                  : "https://www.google.fr",
                "key"                    : "notes_url",
                "error_type"             : "duplicate"
            }
        ]
    }
};
