SHINKEN.TOOLS.TEST_AUTO_SOURCE_CONFIGURATION_TAB = (function ( self ) {
    self.DOM                        = {};
    self.TEST                       = {};
    self.ACTION                     = {};
    //********************************************  DOM   **************************************************//
    self.DOM.getTab                 = function () {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return document.querySelector( "#tab-pane-configuration-target" );
        }
        return document.querySelector( "#id-shinken-window-tab-configuration-target" );
    };
    self.DOM.getTabMenu             = function () {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return document.querySelector( "#tab-pane-configuration" );
        }
        return document.querySelector( "#id-shinken-window-tab-configuration" );
    };
    self.DOM.authenticationCheckBox = function ( type_source ) {
        switch ( type_source ) {
            case SOURCE.CONST.TYPES.LISTENER:
                return self.DOM.getTab().querySelector( '#configuration__authentication' );
        }
    };
    self.DOM.loginInput             = function ( type_source ) {
        switch ( type_source ) {
            case SOURCE.CONST.TYPES.LISTENER:
                return self.DOM.getTab().querySelector( '#configuration__login' );
        }
    };
    self.DOM.passwordInput          = function ( type_source ) {
        switch ( type_source ) {
            case SOURCE.CONST.TYPES.LISTENER:
                return self.DOM.getTab().querySelector( '#configuration__password' );
        }
    };
    self.DOM.buttonSubmit           = function ( type_source ) {
        return self.DOM.getTab().querySelector( '#shinken-form-source-conf .button .shinken-button' );
        
    };
    //********************************************  TEST   **************************************************//
    //********************************************  ACTION   **************************************************//
    self.ACTION.addConfiguration = function ( timeout, type_source, login, password, eval_to_do ) {
        var _to_return = 2000 + 400;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.addConfiguration', login + " - " + password );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( type_source ) {
                case SOURCE.CONST.TYPES.LISTENER:
                    var _dom = self.DOM.authenticationCheckBox( type_source );
                    if ( self.DOM.authenticationCheckBox( type_source ).checked !== true ) {
                        SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
                    }
                    self.ACTION.setInputValue( 500, self.DOM.loginInput( type_source ), login );
                    self.ACTION.setInputValue( 1000, self.DOM.passwordInput( type_source ), password );
                    self.ACTION.submitForm( 2000, eval_to_do );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.submitForm       = function ( timeout, eval_to_do ) {
        var _to_return = 400;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.submitForm' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( eval_to_do ) {
                eval( eval_to_do );
            }
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 2000, self.DOM.buttonSubmit() );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            if ( __test_auto_continue_if_error || !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextLink( __shinken_test_type, __phase + 1 ) );
            }
        }, timeout );
        return _to_return;
    };
    self.ACTION.setInputValue    = function ( timeout, dom_element, to_set ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___dispatchMouseEvent( dom_element, 'keydown' );
            DOM.Service.setInputValue( dom_element, to_set );
            SHINKEN.TOOLS.TEST_AUTO.___dispatchMouseEvent( dom_element, 'keyup' );
        }, timeout );
        return 100;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SOURCE_CONFIGURATION_TAB || {} );
