'use strict';

SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE = (function ( self ) {
    self.ACTION          = {};
    self.ACTION.DATABASE = {};
    self.TEST            = {};
    self.TEST.API        = {};
    self.COMMON          = {};
    var _INTERNAL        = {};
    
    //********************************************  INTERNAL   **************************************************//
    _INTERNAL.dropAllDatabases                          = function () {
        self.ACTION.dropDatabase( 0, "shinken" );
        self.ACTION.dropDatabase( 0, "synchronizer" );
        self.ACTION.dropDatabase( 0, "event_container" );
        self.ACTION.dropDatabase( 0, "webui" );
    };
    _INTERNAL.executeFlaskCommand                       = function ( timeout, command, success, error, request, function_name ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, function_name, command );
        setTimeout( function () {
            console.log( function_name, "[ - ]", command );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            request( "http://" + SHINKEN.HIGHWAY.getHostName() + ":5000/push_commands", JSON.stringify( { "commands": command } ), success, error );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.resetTime                               = function ( timeout ) {
        var _command = 'service ntpd restart';
        
        var _success = function ( _status, data ) {
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.replaceInFile                           = function ( timeout, original_text, new_text, file ) {
        var _command = "sed -i 's/" + original_text + "/" + new_text + "/g' " + file;
        
        var _success = function ( _status, data ) {
            if ( data.rc !== 0 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Error while replacing [ " + data.stderr + " ]" );
            }
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 500;
    };
    self.ACTION.createFileAndSetShinkenOwner            = function ( timeout, file, to_write ) {
        var _command = "sudo -u shinken echo " + to_write + " >> " + file;
        
        var _success = function ( _status, data ) {
            if ( data.rc !== 0 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Error while creating [ " + data.stdout + " ]" );
            }
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 500;
    };
    self.ACTION.copyFile                                = function ( timeout, source, destination ) {
        let _command = "cp -r " + source + " " + destination;
        
        let _success = function ( _status, data ) {
            if ( data.rc !== 0 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Error while copying [ " + data.stdout + " ]" );
            }
        };
        let _error   = function ( err ) {
            self.COMMON.errorExecuteCommand( err );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 500;
    };
    self.ACTION.removeFile                              = function ( timeout, file ) {
        let _command = "rm " + file;
        
        let _success = function ( _status, data ) {
            if ( data.rc !== 0 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Error while deleting [ " + data.stdout + " ]" );
            }
        };
        let _error   = function ( err ) {
            self.COMMON.errorExecuteCommand( err );
            
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 500;
    };
    self.ACTION.copyFolder                              = function ( timeout, source, destination ) {
        let _command = "cp " + source + " " + destination;
        
        self.ACTION.copyFile( timeout, "-r " + source, destination );
        return 500;
    };
    self.ACTION.removeFolder                            = function ( timeout, folder_path ) {
        var _command = "rm -fr " + folder_path;
        
        var _success = function ( _status, data ) {
            if ( data.rc !== 0 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Error while deleting [ " + data.stdout + " ]" );
            }
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, self.COMMON.errorExecuteCommand );
        return 3000;
    };
    self.ACTION.cleanFolder                             = function ( timeout, folder_path ) {
        return SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.removeFolder( timeout, folder_path + "*" );
    };
    self.ACTION.addMinutes                              = function ( timeout, minutes ) {
        var _command = 'date $(date +%m%d%H%M%Y.%S -d \'' + minutes + ' minutes\')';
        
        var _success = function ( _status, data ) {
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.setTime                                 = function ( timeout, time ) {
        var _command = 'timedatectl set-time \'' + time + '\'';
        var _success = function ( _status, data ) {
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.setServerTimeSynchronisation            = function ( timeout, boolean ) {
        let _command = "";
        if ( boolean ) {
            _command = 'timedatectl set-ntp yes';
        }
        else {
            _command = 'timedatectl set-ntp no';
        }
        var _success = function ( _status, data ) {
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.executeCurlCommand                      = function ( timeout, user, password, type, url, content_type, data, success, error ) {
        let _command = "curl ";
        if ( user && password ) {
            _command += "-u " + user + ":" + password + " ";
        }
        _command += "-X " + type + " ";
        if ( content_type ) {
            _command += '-H "Content-Type: ' + content_type + '" ';
        }
        if ( data ) {
            _command += "-d '" + data + "' ";
        }
        _command += url;
        return self.ACTION.executePostCommand( timeout, _command, success, error );
    };
    self.ACTION.executePostCommand                      = function ( timeout, command, success, error ) {
        return _INTERNAL.executeFlaskCommand(
            timeout,
            command,
            success || self.COMMON.successExecuteCommand,
            error || self.COMMON.errorExecuteCommand,
            SHINKEN.COMUNICATION.requestPost,
            "ACTION.executePostCommand"
        );
    };
    self.ACTION.executeGetCommand                       = function ( timeout, command, success, error ) {
        return _INTERNAL.executeFlaskCommand(
            timeout,
            command,
            success || self.COMMON.successExecuteCommand,
            error || self.COMMON.errorExecuteCommand,
            SHINKEN.COMUNICATION.requestGet,
            "ACTION.executeGetCommand"
        );
    };
    self.ACTION.getPythonPath                           = function ( timeout, success, error ) {
        var _success = function ( _status, data ) {
            // delete \n of the python_path
            var python_path = data.stdout.slice( 0, -1 );
            success( _status, python_path );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, "python3-shinken -c \"import shinken;import os;print(os.path.dirname(shinken.__file__))\"", _success, error );
    };
    self.ACTION.clearWeatherFromPersistantDataAndDevShm = function ( timeout ) {
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout,
            "rm -rf /var/lib/shinken/persistent_data/service_weather ; rm -rf /dev/shm/shinken/service_weather",
            function ( _status, data ) {
            },
            function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.COMMON.errorExecuteCommand( "rm -rf /var/lib/shinken/persistent_data/service_weather ; rm -rf /dev/shm/shinken/service_weather" );
            } );
        return 2000;
    };
    self.ACTION.executeCommand                          = function ( timeout, command, timeout_to_return ) {
        self.ACTION.executePostCommand( timeout, command, self.COMMON.successExecuteCommand, self.COMMON.errorExecuteCommand );
        return timeout_to_return || 3000;
    };
    self.ACTION.doActionRecheckNow                      = function ( timeout, is_host, uuid_element ) {
        var _to_return = 20000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.doActionRecheckNow ', uuid_element );
        var success    = function ( _status, data ) {
        };
        var error      = function ( err ) {
        };
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let url  = "http://" + SHINKEN.HIGHWAY.getHostName() + ":7767/action";
            let data = {
                args            : ["$NOW$"],
                configuration_id: CONTROLLER.UiVisualisation.current_user.configuration_id,
                element_id      : uuid_element,
                type_action     : is_host ? 'SCHEDULE_FORCED_HOST_CHECK' : 'SCHEDULE_FORCED_SVC_CHECK'
            };
            SHINKEN.COMUNICATION.requestPost( url, JSON.stringify( data ), success, error );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.addCfgDir                               = function ( timeout, file_path ) {
        var _command = "echo cfg_dir=" + file_path + " >> /etc/shinken/shinken.cfg";
        var _success = function () {
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 500;
    };
    self.ACTION.sendElementToListenerRest               = function ( timeout, element, element_type ) {
        self.ACTION.executeCurlCommand(
            timeout,
            null,
            null,
            "PUT",
            "http://" + SHINKEN.HIGHWAY.getHostName() + ":" + SOURCE__PORT__LISTENER_REST + "/shinken/listener-rest/v1/" + element_type + "/",
            "application/json",
            JSON.stringify( element )
        );
        return 7000;
    };
    //********************************************  GRAPHITE   **************************************************//
    self.ACTION.startCarbonCache                        = function ( timeout ) {
        return self.ACTION.executeCommand( timeout, "service carbon-cache start" );
    };
    self.ACTION.stopCarbonCache                         = function ( timeout ) {
        return self.ACTION.executeCommand( timeout, "service carbon-cache stop" );
    };
    //********************************************  DATABASE   **************************************************//
    self.ACTION.DATABASE.update                         = function ( timeout, database, collection, document_id ) {
        let to_return     = 3000;
        let _switch_value = __shinken_test_type + "-" + __phase;
        let data          = "";
        switch ( _switch_value ) {
            case "00274-10":
                data = {
                    "service_overrides": {
                        "raw_value"           : "",
                        "links"               : [
                            {
                                "key"       : "business_impact",
                                "value"     : "1",
                                "check_link": {
                                    "check_name": "00274_test_auto",
                                    "item_type" : "serviceshosts",
                                    "_id"       : "20000000000000000000000000000274",
                                    "exists"    : true
                                }
                            }
                        ],
                        "links_with_errors"   : [
                            {
                                "check_link": {
                                    "check_name": "00274_test_auto",
                                    "item_type" : "serviceshosts",
                                    "_id"       : "20000000000000000000000000000274",
                                    "exists"    : true
                                },
                                "error_type": "duplicate",
                                "value"     : "0",
                                "key"       : "business_impact"
                            }
                        ],
                        "link_error_raw_value": "Two services override with a different value were set on same check [ 00274_test_auto ] on the property [ business_impact ]. We removed value [ 1 ] and kept [ 0 ], as 1 was the value currently used by Shinken. You need to confirm this choice in the host page by checking the value and then removing the message on the overload.",
                        "all_linked_types"    : [
                            "serviceshosts"
                        ]
                        
                    }
                };
                break;
        }
        self.ACTION.updateDocumentToMongo( timeout, database, collection, document_id, data );
        return to_return;
        
    };
    self.ACTION.DATABASE.start                          = function ( timeout ) {
        let _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.DATABASE.start' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, "service mongod start", function ( _status, data ) {
            }, function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.COMMON.errorExecuteCommand( "service mongod start" );
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.DATABASE.stop                           = function ( timeout ) {
        let _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.DATABASE.stop' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, "service mongod stop", function ( _status, data ) {
            }, function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.COMMON.errorExecuteCommand( "service mongod stop" );
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.dropDatabase                            = function ( timeout, database ) {
        var _command = "mongo " + database + " --eval " + "'db.dropDatabase()'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            self.COMMON.errorExecuteCommand( err );
        };
        
        self.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.dropAllDatabases                        = function ( timeout ) {
        __do_next = false;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DAEMON.COMMON.ACTION.stopAll( 0, function () {
                _INTERNAL.dropAllDatabases();
                SHINKEN.TOOLS.TEST_AUTO_DAEMON.COMMON.ACTION.startAll( 4000,
                    function () {
                        SHINKEN.HIGHWAY.goTo( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                    } );
            } );
        }, timeout );
    };
    self.ACTION.deleteManyMongo                         = function ( timeout, database, collection, query ) {
        var _command = "mongo " + database + " --eval " + "'db.getCollection(\"" + collection + "\").remove(" + JSON.stringify( query ) + ")'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.upsertDocumentToMongo                   = function ( timeout, database, collection, document_id, document ) {
        return SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.upsertStringDocumentToMongo( timeout, database, collection, document_id, JSON.stringify( document ) );
    };
    self.ACTION.updateDocumentToMongo                   = function ( timeout, database, collection, document_id, document ) {
        return SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.updateStringDocumentToMongo( timeout, database, collection, document_id, '{ $set :' + JSON.stringify( document ) + '}' );
    };
    self.ACTION.upsertStringDocumentToMongo             = function ( timeout, database, collection, document_id, document_string ) {
        var _key_to_find = { "_id": document_id };
        var _command     = "mongo " + database + " --eval " + "'db.getCollection(\"" + collection + "\").update(" + JSON.stringify( _key_to_find ) + ", " + document_string + ", upsert=true)'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.updateStringDocumentToMongo             = function ( timeout, database, collection, document_id, document_string ) {
        var _key_to_find = { "_id": document_id };
        var _command     = "mongo " + database + " --eval " + "'db.getCollection(\"" + collection + "\").update(" + JSON.stringify( _key_to_find ) + ", " + document_string + ")'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.API.trustedSource                         = function ( timeout, status, content_text ) {
        var _to_return = 30000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.API.trustedSource', "command" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout,
                'curl "http://localhost:7765/trusted-source/v1/put-in-production?password=dGVzdF9hdXRvX3VzZXJfZXhlY3V0b3I%3D&filter=sources:test_auto&item_type=hosts&login=test_auto_user_executor"',
                function ( _status, data ) {
                    SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _status, status );
                    SHINKEN.TOOLS.TEST_AUTO.__containsText( data.stdout, content_text );
                },
                function ( err ) {
                    self.COMMON.errorExecuteCommand( err );
                } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.jsonContent                               = function ( timeout, command, key, value_expected ) {
        var _success = function ( _status, data ) {
            var _data = JSON.parse( data.stdout.substring( data.stdout.indexOf( "{" ), data.stdout.indexOf( "}" ) + 1 ) );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _data[ key ], value_expected, "jsonContent" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, command, _success, self.COMMON.errorExecuteCommand );
        return 3000;
    };
    //self.TEST.grepInLog                                 = function ( timeout, command, key, value_expected ) {
    //    var _success = function ( _status, data ) {
    //        var _data = JSON.parse( data.stdout.substring( data.stdout.indexOf( "{" ), data.stdout.indexOf( "}" ) + 1 ) );
    //        SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _data[ key ], value_expected, "jsonContent" );
    //    };
    //    SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, command, _success, self.COMMON.errorExecuteCommand );
    //    return 3000;
    //};
    //********************************************  COMMON   **************************************************//
    self.TEST.isFolderExisting            = function ( timeout, folder_path, reverse ) {
        var _command = 'if test -d ' + folder_path + '; then echo "__shinken_found__"; else echo "__shinken_not_found__"; fi';
        
        var _success = function ( _status, data ) {
            if ( reverse && !SHINKEN.TOOLS.STRING.contains( data.stdout, "__shinken_not_found__" ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "FOLDER FOUND => [" + folder_path + "]" );
            }
            else if ( !reverse && !SHINKEN.TOOLS.STRING.contains( data.stdout, "__shinken_found__" ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "FOLDER NOT FOUND => [" + folder_path + "]" );
            }
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, self.COMMON.errorExecuteCommand );
        return 500;
    };
    self.TEST.grep                        = function ( timeout, to_grep, path, reverse, pattern_to_search = " " ) {
        let _command = "grep " + to_grep + " " + path;
        let _success = function ( _status, data ) {
            if ( pattern_to_search !== " " ) {
                SHINKEN.TOOLS.TEST_AUTO.__containsText( data.stdout, pattern_to_search, "", "", reverse );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.__containsText( data.stdout, to_grep, "", "", reverse );
            }
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, self.COMMON.errorExecuteCommand );
        return 500;
    };
    self.TEST.grepCommandResult           = function ( timeout, command, to_grep, pattern_to_search, reverse ) {
        let _command = command + "| grep " + to_grep + " ";
        let _success = function ( _status, data ) {
            if ( pattern_to_search !== " " ) {
                SHINKEN.TOOLS.TEST_AUTO.__containsText( data.stdout, pattern_to_search, "", "", reverse );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.__containsText( data.stdout, to_grep, "", "", reverse );
            }
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, self.COMMON.errorExecuteCommand );
        return 500;
    };
    self.TEST.verifyConfiguration        = function ( timeout, to_grep, reverse ) {
        let _command = "shinken-arbiter -v -c /etc/shinken/shinken.cfg | grep" + " " + to_grep;
        let _success = function ( _status, data ) {
            SHINKEN.TOOLS.TEST_AUTO.__containsText( data.stdout, to_grep, "", "", reverse );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, self.COMMON.errorExecuteCommand );
        return 500;
    };
    self.TEST.isKeyLoadedByModuleHasValue = function ( timeout, module_name, key, value, invert ) {
        
        var _uuid   = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.isKeyLoadedByModuleHasValue' );
        var success = function ( _status, data ) {
            var _modules           = data.module;
            let current_module;
            let current_key;
            let is_module_existing = false;
            for ( let i = 0, size = _modules.length; i < size; i++ ) {
                current_module = _modules[ i ];
                if ( SHINKEN.TOOLS.ARRAY.contains( current_module[ 'module_name' ], module_name ) ) {
                    is_module_existing = true;
                    current_key        = current_module[ key ];
                    if ( !current_key ) {
                        SHINKEN.TOOLS.TEST_AUTO.addError( key + " doesn't seems to exist or to be loaded =>", current_module );
                    }
                    else if ( invert && !SHINKEN.TOOLS.ARRAY.contains( current_key, value ) ) {
                        return 3000;
                    }
                    else if ( SHINKEN.TOOLS.ARRAY.contains( current_key, value ) ) {
                        return 3000;
                    }
                    else {
                        SHINKEN.TOOLS.TEST_AUTO.addError( key + " doesn't have value " + value + "  =>", current_key );
                    }
                }
            }
            if ( !is_module_existing ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( module_name + " doesn't seems to exist or to be loaded =>", _modules );
            }
        };
        var error   = function ( _status, err ) {
            if ( _status === 403 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "-- Synchronizer not in debug mode --" );
            }
        };
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _url = "http://" + SHINKEN.HIGHWAY.getHostName() + ":7766/internal/private_shinken_test/load_conf_as_arbiter?password=private_shinken_test";
            SHINKEN.COMUNICATION.requestGet( _url, success, error );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", 5000 );
        }, timeout );
    };
    //********************************************  COMMON   **************************************************//
    self.COMMON.successExecuteCommand     = function ( status, data ) {
    };
    self.COMMON.errorExecuteCommand       = function ( err ) {
        SHINKEN.TOOLS.TEST_AUTO.addError( err );
        SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE || {} );
