SHINKEN.TOOLS.TEST_AUTO_UI_VISU_ELEMENT_DETAIL = (function ( self ) {
    self.DOM                              = {};
    self.TEST                             = {};
    self.ACTION                           = {};
    self.CONST                            = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe                    = function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).window.onerror = function () {
            _has_script_error++;
        };
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.buttonRefresh                = function () {
        return self.DOM.getIframe().querySelector( "#refresh-detail-btn" );
    };
    self.DOM.actionCommandButton          = function ( action_class ) {
        return self.DOM.getIframe().querySelector( "." + action_class ).querySelector( ".shinken-action-command" );
    };
    self.DOM.actionCommandButtonLabel     = function ( action_class ) {
        return self.DOM.actionCommandButton( action_class ).querySelector( ".ssssss" );
    };
    self.DOM.actionCommandButtonUserLabel = function ( action_class ) {
        return self.DOM.actionCommandButtonLabel( action_class ).querySelector( ".shinken-property-data-user" );
    };
    self.DOM.checkList                    = function () {
        return self.DOM.getIframe().querySelector( ".shinken-grid-datas-container" );
    };
    self.DOM.check                        = function ( check_uuid ) {
        return self.DOM.checkList().querySelector( ".row-data[data-uuid='" + check_uuid + "']" );
    };
    self.DOM.status                       = function ( check_uuid ) {
        return self.DOM.check( check_uuid ).querySelector( ".shinken-cell-data[data-header-field='statusName']" );
    };
    self.DOM.context                      = function ( check_uuid ) {
        return self.DOM.check( check_uuid ).querySelector( ".shinken-cell-data[data-header-field='context']" );
    };
    //********************************************  GETTER   **************************************************//
    //********************************************  TEST   **************************************************//
    self.TEST.labelCommandButton = function ( timeout, action_class, label ) {
        var _to_return = 300;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.labelCommandButton', label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.actionCommandButtonLabel( action_class ), label );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.status               = function ( timeout, status_to_test, check_uuid, reverse ) {
        const _to_return = 500;
        const _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.status' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasAttribute( 0, self.DOM.status( check_uuid ), "data-filter", status_to_test.toLowerCase(), null, reverse );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.context              = function ( timeout, context_to_test, check_uuid, reverse ) {
        const _to_return = 500;
        const _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.context' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasAttribute( 0, self.DOM.context( check_uuid ), "data-filter", context_to_test.toLowerCase(), null, reverse );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.disableRefreshAuto = function ( timeout ) {
        const _to_return = 500;
        const _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.disableRefreshAuto', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.getAngularService( "App" ).isNavigatorHidden = function () {
                return true;
            };
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnRefresh     = function ( timeout ) {
        const _to_return = 2000;
        const _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnRefresh', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonRefresh() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_ELEMENT_DETAIL || {} );

