//__lib__ lib_common
"use strict";

SHINKEN.OBJECT.LastModifications           = function () {
    this.init();
};
SHINKEN.OBJECT.LastModifications.prototype = {
    init: function () {
        this.initContents();
        this.current_step = -1;
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "add_last_modification":
                return this.addSpecific( param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ] );
            case "reset_all__20240909":
                this.init();
                break;
            case "on_key_up":
                let current_key_code = param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].keyCode;
                switch ( current_key_code ) {
                    case SHINKEN.CONST.KEY_CODE.Z:
                        if ( this.getCurrentStep() >= 0 ) {
                            this.gotoStep( this.getCurrentStep() - 1, param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.PARENT_OBJECT ] );
                        }
                        break;
                    case SHINKEN.CONST.KEY_CODE.Y:
                        if ( this.getCurrentStep() + 1 < this.getSize() ) {
                            this.gotoStep( this.getCurrentStep() + 1, param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.PARENT_OBJECT ] );
                        }
                        break;
                }
                break;
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    getCurrentStep: function () {
        return this.current_step;
    },
    //********************************************  ACTIONS   **************************************************//
    addSpecific: function ( last_modification ) {
        if ( !last_modification || !last_modification.isValid() ) {
            return false;
        }
        last_modification.setIndex( ++this.current_step );
        last_modification.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        //last_modification.updateHighestElementOfModification();
        this.add( last_modification );
        if ( this.current_step < this.getSize() ) { //REMOVE EXISTING MODIFICATIONS OVER THE STEP
            this.removeAllContentFromIndex( this.current_step + 1 );
        }
        return true;
    },
    gotoStep   : function ( target_step, object_parent ) {
        let action_event = target_step < this.current_step ? "undo_last_modification" : "redo_last_modification";
        while ( this.getCurrentStep() !== target_step ) {
            if ( action_event === "undo_last_modification" ) {
                object_parent.doActionAfter( action_event, { [ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ]: this.getContent( this.current_step-- ) } );
            }
            else {
                object_parent.doActionAfter( action_event, { [ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ]: this.getContent( ++this.current_step ) } );
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LastModifications, SHINKEN.OBJECT.ShinkenObjectContainerHtml );

SHINKEN.OBJECT.LastModificationsInterface           = function () {
};
SHINKEN.OBJECT.LastModificationsInterface.prototype = {
    initLastModifications: function () {
        this.last_modifications = new SHINKEN.OBJECT.LastModifications();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LastModificationsInterface, SHINKEN.OBJECT.ShinkenObject );