//__lib__ lib_common
"use strict";
SHINKEN_LIST.LinesFromData           = function () {
    this.init();
};
SHINKEN_LIST.LinesFromData.prototype = {
    init                  : function () {
        this.initCommon();
        this.initTextNoElement();
    },
    initTextNoElement     : function () {
        try {
            this.addTextForNoElement( _( "shinken_list.no_elements.text_no_elements", [DICTIONARY_COMMON_UI] ),
                _( "shinken_list.no_elements.text_no_elements_after_filter", [DICTIONARY_COMMON_UI] ) );
        }
        catch ( e ) {
        
        }
    },
    computeContentWithData: function ( data, headers_object ) {
        var to_add;
        for ( var i = 0, _size = data.length; i < _size; i++ ) {
            to_add = this.getChildConstructor( data[ i ], headers_object );
            this.addSpecific( to_add );
            to_add.setIndexOriginal( i );
        }
        this.doActionAfter( "compute_content_with_data_done" );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getChildConstructor: function ( data, headers ) {
        return new SHINKEN_LIST.LineFromData( data, headers );
    },
    //********************************************  UPDATE   *****************************************************//
    addLineWithData: function ( data, headers, index ) {
        var _to_add = this.getChildConstructor( data, headers );
        if ( index !== undefined ) {
            this.insertAtIndex( _to_add, index );
        }
        else {
            this.add( _to_add );
        }
    },
    //********************************************  COLLAPSE  *****************************************************//
    
    //********************************************  FILTERS  *****************************************************//
    
    //********************************************  SAVE  *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    computeHtml          : function () {
        this.setDomElement( DOM.Service.createElement( "tbody", { class: "shinken-list-tbody" } ) );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
            this.addDomElement( this.getContent( i ).getDomElementBind() );
        }
        this.computeTextNoElements();
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING ) && this.dom_element_loading ) {
            this.addDomElement( this.dom_element_loading );
        }
        this.addCountersTargetDomElement( this.getDomElement() );
    },
    computeTextNoElements: function () {
        if ( this.text_no_element ) {
            this.dom_element_text_no_elements = DOM.Service.createElement( "tbody", { class: "shinken-text-no-element-container" } );
            const _tr                         = DOM.Service.addElementTo( DOM.Service.createElement( "tr", { class: "shinken-list-text-line" } ), this.dom_element_text_no_elements );
            const _td                         = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-list-text-cell", colspan: 99 } ), _tr );
            const _list_text_container        = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-list-text-container shinken-layout-center-h-v" } ), _td );

            DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-no-element" }, this.text_no_element ), _list_text_container );

            if ( this.text_no_element_after_filter ) {
                DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-no-element-after-filter" }, this.text_no_element_after_filter ), _list_text_container );
            }
            this.setPhaseDomElement( this.dom_element_text_no_elements );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesFromData, SHINKEN_LIST.Lines );