//__lib__ lib_common
"use strict";

SHINKEN_LIST.PaginationNavigation_V3 = function ( type ) {
    this.__class_name__ = "SHINKEN_LIST.PaginationNavigation_V3";
    this.init( type );
};

SHINKEN_LIST.PaginationNavigation_V3.prototype = {
    init: function ( type ) {
        this.type        = type;
        this.is_disabled = false;
        this.computeLabel();
        this.button = new COMPONENT.ButtonFromData_V3( this.type, this.getLabel() );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    addParamForEvents: function ( key, value ) {
        this.button.addParamForEvents( key, value );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getType    : function () {
        return this.type;
    },
    getUUID    : function () {
        return this.getType();
    },
    setDisabled: function ( to_set ) {
        this.is_disabled = to_set;
        if ( this.getDomElement() ) {
            DOM.Service.addOrRemoveClasses( this.getDomElement(), this.is_disabled, "shinken-disabled" );
        }
    },
    //********************************************  COMPUTE  *****************************************************//
    computeLabel: function () {
        var dom_class;
        switch ( this.type ) {
            case COMPONENT.CONST.PAGINATION_NAVIGATION.FIRST :
                dom_class = "shinken-double-arrows shinkon-double-chevron-left";
                break;
            case COMPONENT.CONST.PAGINATION_NAVIGATION.PREVIOUS :
                dom_class = "shinken-simple-arrow shinken-2023-left";
                break;
            case COMPONENT.CONST.PAGINATION_NAVIGATION.NEXT :
                dom_class = "shinken-simple-arrow shinken-2023-right";
                break;
            case COMPONENT.CONST.PAGINATION_NAVIGATION.LAST :
                dom_class = "shinken-double-arrows shinkon-double-chevron-right";
                break;
        }
        this.label = "<span class='" + dom_class + "'></span>";
    },
    computeClass: function () {
        this.class = "shinken-pagination-navigation";
        switch ( this.type ) {
            case COMPONENT.CONST.PAGINATION_NAVIGATION.FIRST :
            case COMPONENT.CONST.PAGINATION_NAVIGATION.PREVIOUS :
                this.class += " shinken-type-first-pagination";
                break;
            case COMPONENT.CONST.PAGINATION_NAVIGATION.NEXT :
            case COMPONENT.CONST.PAGINATION_NAVIGATION.LAST :
                this.class += " shinken-type-last-pagination";
                break;
        }
        
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        if ( this.getDomElement() ) {
            return;
        }
        
        this.computeClass();
        this.button.addClass( "shinken-pagination-arrow-content" );
        this.button.computeHtml();
        
        this.setDomElement( DOM.Service.createElement( "div", { class: this.getClass() } ) );
        this.addDomElement( this.button.getDomElement() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.PaginationNavigation_V3, SHINKEN.OBJECT.ShinkenObjectHtml );