//__lib__ lib_common
"use strict";

MANAGER.DistributorResourcesManager           = function () {
    this.contents = {};
};
MANAGER.DistributorResourcesManager.prototype = {
    createResource: function ( uuid, data ) {
        var _to_return = new SHINKEN.OBJECT.Resource();
        _to_return.updateData( data );
        this.addResource( _to_return );
        return _to_return;
    },
    findResource  : function ( uuid, data ) {
        if ( !uuid ) {
            return;
        }
        var _to_return = this.getResource( uuid );
        if ( !_to_return ) {
            _to_return = this.createResource( uuid, data );
        }
        else {
            _to_return.updateData( data );
        }
        return _to_return;
    },
    getResource   : function ( uuid ) {
        return this.contents[ uuid ];
    },
    addResource   : function ( resource ) {
        this.contents[ resource.getUUID() ] = resource;
    }
};
MANAGER.__instance_resources_distributor      = new MANAGER.DistributorResourcesManager();

MANAGER.DistributorResourcesManager.factory = function ( key, data ) {
    switch ( key ) {
        case "resources":
            var _keys = Object.keys( data );
            var _size = _keys.length;
            var _currentKey;
            for ( var i = 0; i < _size; i++ ) {
                _currentKey = _keys[ i ];
                MANAGER.DistributorResourcesManager.factory( _currentKey, data[ _currentKey ] );
            }
            break;
        case "audio":
            var _keys = Object.keys( data );
            var _size = _keys.length;
            var _currentKey;
            for ( var i = 0; i < _size; i++ ) {
                _currentKey                          = _keys[ i ];
                data[ _currentKey ][ "resource_id" ] = _currentKey;
                data[ _currentKey ][ "type" ]        = "audio/mpeg";
                MANAGER.__instance_resources_distributor.findResource( _currentKey, data[ _currentKey ] );
            }
            break;
    }
};

MANAGER.DistributorResourcesManager.getInstance = function () {
    try {
        if ( window.parent.MANAGER.__instance_resources_distributor ) {
            return window.parent.MANAGER.DistributorResourcesManager.getInstance();
        }
    }
    catch ( e ) {
    }
    return MANAGER.__instance_resources_distributor;
};