//__lib__ lib_common
"use strict";
MANAGER.DragNDropManager = (function ( self ) {
    self.last_element_hovered          = null;
    self.current_parent_name           = null;
    self.type_drag_start               = null;
    self.list_element                  = null;
    self.single_element_drag           = null;
    self.options                       = null;
    self._name_origin_controller       = null;
    self.parent_element_relative_pos_X = null;
    self.parent_element_relative_pos_Y = null;
    
    //********************************************  SINGLE DRAG  *****************************************************//
    self.initDragNDropSingle = function ( event ) {
        self.single_element_drag = DOM.Service.findParentElementByClassWithClassExcluded( event.target, "shinken-draggable", 'shinken-drag-exclude', 50 );
        if ( !self.single_element_drag ) {
            return;
        }
        self._bounding_origin = self.single_element_drag.getBoundingClientRect();
        self._mouse_x_origin  = parseInt( event.clientX );
        self._mouse_y_origin  = parseInt( event.clientY );
        event.stopPropagation();
        self.options = null;
    };
    self.activeDragNDropSingle      = function () {
        if ( self.options ) {
            return;
        }
        self.single_element_drag.classList.add( "shinken-drag-active" );
        let _body             = document.querySelector( 'body' );
        _body.classList.add( "shinken-has-drag-in-progress" );
        _body.addEventListener( 'mouseleave', self.dragEndSingle, false );
        document.documentElement.addEventListener( 'mousemove', self.dragSingle, false );
        document.documentElement.addEventListener( 'mouseup', self.dragEndSingle, false );
        self._initParametersIsInParentDiv();
        self._callbackDragStart();
        event.stopPropagation();
        window.getSelection().removeAllRanges();
        self.parent_element_relative_pos_X     = 0;
        self.parent_element_relative_pos_Y     = 0;
        let dom_element_with_position_relative = DOM.Service.findParentElementWithClass( self.single_element_drag, "shinken-css-relative-position", 50 );
        if ( dom_element_with_position_relative ) {
            let _rect                          = DOM.Service.getBoundingClientRect( dom_element_with_position_relative );
            self.parent_element_relative_pos_X = _rect[ "left" ];
            self.parent_element_relative_pos_Y = _rect[ "top" ];
        }
    };
    
    
    //********************************************  SINGLE DRAG  *****************************************************//
    self.dragStartSingle = function ( event ) {
        self.single_element_drag = DOM.Service.findParentElementByClassWithClassExcluded( event.target, "shinken-draggable", 'shinken-drag-exclude', 50 );
        if ( !self.single_element_drag ) {
            return;
        }
        self.single_element_drag.classList.add( "shinken-drag-active" );
        self._bounding_origin = self.single_element_drag.getBoundingClientRect();
        self._mouse_x_origin  = parseInt( event.clientX );
        self._mouse_y_origin  = parseInt( event.clientY );
        let _body             = document.querySelector( 'body' );
        _body.classList.add( "shinken-has-drag-in-progress" );
        _body.addEventListener( 'mouseleave', self.dragEndSingle, false );
        document.documentElement.addEventListener( 'mousemove', self.dragSingle, false );
        document.documentElement.addEventListener( 'mouseup', self.dragEndSingle, false );
        self._initParametersIsInParentDiv();
        self._callbackDragStart();
        event.stopPropagation();
        window.getSelection().removeAllRanges();
        self.parent_element_relative_pos_X     = 0;
        self.parent_element_relative_pos_Y     = 0;
        let dom_element_with_position_relative = DOM.Service.findParentElementWithClass( self.single_element_drag, "shinken-css-relative-position", 50 );
        if ( dom_element_with_position_relative ) {
            let _rect                          = DOM.Service.getBoundingClientRect( dom_element_with_position_relative );
            self.parent_element_relative_pos_X = _rect[ "left" ];
            self.parent_element_relative_pos_Y = _rect[ "top" ];
        }
    };
    self.dragSingle      = function ( event ) {
        let _position_x = parseInt( event.clientX ) - self._mouse_x_origin + self._bounding_origin.left - self.parent_element_relative_pos_X;
        let _position_y = parseInt( event.clientY ) - self._mouse_y_origin + self._bounding_origin.top - self.parent_element_relative_pos_Y;
        
        if ( self.options._is_in_screen ) {
            let _result = self._computeIsInParentDiv( _position_x, _position_y );
            _position_x = _result.x;
            _position_y = _result.y;
        }
        DOM.Service.setStyles( self.single_element_drag, { "top": _position_y + 'px', "left": _position_x + 'px' } );
        self._callbackDragMove( parseInt( event.clientX ) - self._mouse_x_origin, parseInt( event.clientY ) - self._mouse_y_origin );
    };
    self.dragEndSingle   = function () {
        document.documentElement.removeEventListener( 'mousemove', self.dragSingle, false );
        document.documentElement.removeEventListener( 'mouseup', self.dragEndSingle, false );
        let _body = document.querySelector( 'body' );
        _body.removeEventListener( 'mouseleave', self.dragEndSingle, false );
        document.querySelector( 'body' ).classList.remove( "shinken-has-drag-in-progress" );
        self.single_element_drag.classList.remove( "shinken-drag-active" );
        self._callbackDragStop();
        self.single_element_drag     = null;
        self._name_origin_controller = null;
    };
    
    //********************************************  PRIVATE  *****************************************************//
    self._computeIsInParentDiv        = function ( _delta_x, _delta_y ) {
        let _to_return = { x: _delta_x, y: _delta_y };
        if ( _delta_x < 0 ) {
            _to_return.x = 0;
        }
        else if ( (_delta_x + self._bounding_origin.width) > self.options._is_in_screen.parameters.window_width ) {
            _to_return.x = self.options._is_in_screen.parameters.window_width - self._bounding_origin.width - self.options._is_in_screen.parameters.scrollbar_x_width;
        }
        
        if ( _delta_y < 0 ) {
            _to_return.y = 0;
        }
        else if ( (_delta_y + self._bounding_origin.height) > self.options._is_in_screen.parameters.window_height ) {
            _to_return.y = self.options._is_in_screen.parameters.window_height - self._bounding_origin.height - self.options._is_in_screen.parameters.scrollbar_y_height;
        }
        return _to_return;
    };
    self._initParametersIsInParentDiv = function () {
        self.options = {
            _is_in_screen: {
                is_active : false,
                parameters: {}
            }
        };
        if ( !self.single_element_drag ) {
            return;
        }
        if ( !DOM.Service.hasKeyInDataSet( self.single_element_drag, 'dragIsInScreen' ) ) {
            return;
        }
        self.options._is_in_screen.is_active = true;
        let css_selector                     = "body";
        if ( DOM.Service.hasKeyInDataSet( self.single_element_drag, "dragIsInScreenId" ) ) {
            css_selector = self.single_element_drag.dataset[ "dragIsInScreenId" ];
        }
        let dom_element                       = document.querySelector( css_selector );
        let rect                              = DOM.Service.getBoundingClientRect( dom_element );
        self.options._is_in_screen.parameters = {
            window_width      : rect.width,
            window_height     : rect.height,
            scrollbar_x_width : DOM.Service.scrollbarIsVisible( dom_element, 'width' ) ? 8 : 0,
            scrollbar_y_height: DOM.Service.scrollbarIsVisible( dom_element, 'height' ) ? 8 : 0
        };
    };
    self._getDragNameForCallback      = function () {
        let _name = self.single_element_drag.dataset[ 'dragResizeElementName' ];
        if ( _name ) {
            return _name;
        }
    };
    self._callbackDragStart           = function () {
        if ( CONTROLLER && CONTROLLER.DistributorControllerManager ) {
            self._name_origin_controller = CONTROLLER.DistributorControllerManager.findControllerName( "", self.single_element_drag );
        }
        if ( MANAGER && MANAGER.EventManager && self._name_origin_controller ) {
            MANAGER.EventManager.onDragStart( self._name_origin_controller, self._getDragNameForCallback(), self._mouse_x_origin, self._mouse_y_origin );
        }
    };
    self._callbackDragMove            = function ( delta_x, delta_y ) {
        if ( MANAGER && MANAGER.EventManager && self._name_origin_controller ) {
            MANAGER.EventManager.onDragMove( self._name_origin_controller, self._getDragNameForCallback(), delta_x, delta_y );
        }
    };
    self._callbackDragStop            = function () {
        if ( MANAGER && MANAGER.EventManager && self._name_origin_controller ) {
            MANAGER.EventManager.onDragStop( self._name_origin_controller, self._getDragNameForCallback() );
        }
    };
    
    //********************************************  DRAG OBSOLETE   *****************************************************//
    self.dragStartShinken = function ( e, type, parent_name, key_name ) {
        let _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        if ( _object.is_disabled ) {
            return false;
        }
        // Fix pour firefox
        e.dataTransfer.setData( 'text', 'anything' );
        // end Fix
        self.type_drag_start      = type;
        self.current_parent_name  = parent_name;
        self.list_element         = _object.dragStartShinken( type, key_name );
        self.last_element_hovered = self.list_element.getDragged().getDomElement().parentNode;
        self.last_index           = self.last_element_hovered.dataset.index;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        
        let _list_droppable = _object.dom_element.querySelectorAll( '.droppable' );
        for ( let i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = _list_droppable[ i ].getBoundingClientRect().width + 'px';
        }
    };
    self.dragOverShinken  = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
        if ( self.current_parent_name !== parent_name ) {
            return false;
        }
        if ( self.type_drag_start !== type ) {
            return false;
        }
        let _current_index_hovered = dom_element.dataset.index;
        if ( _current_index_hovered === self.last_index ) {
            return false;
        }
        
        self.list_element.changeElementPosition( self.last_index, _current_index_hovered );
        self.last_index = _current_index_hovered;
        self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        self.last_element_hovered = dom_element;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
    };
    self.dragEndShinken   = function ( e, type ) {
        let _list_droppable = MANAGER.__instance_property_distributor.last_element_focus.dom_element.querySelectorAll( '.droppable' );
        for ( let i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = '';
        }
        
        if ( MANAGER.__instance_property_distributor.last_element_focus.is_disabled ) {
            return false;
        }
        e.preventDefault();
        self._reset();
    };
    self.dropShinken      = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
    };
    self._reset           = function () {
        MANAGER.__instance_property_distributor.last_element_focus.resetDragging();
        if ( self.last_element_hovered ) {
            self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        }
        self.last_element_hovered = null;
        self.current_parent_name  = null;
        self.type_drag_start      = null;
        self.list_element         = null;
        self.pause_timeout        = null;
    };
    
    return self;
})
( MANAGER.DragNDropManager || {} );
