//__lib__ lib_common_V02_01
"use strict";
MANAGER.EVENT_MANAGER_V2 = {
    PARAM: {
        EVENT           : 'event',
        EVENT_NAME      : 'event_name',
        STOP_PROPAGATION: 'stop_propagation'
    }
};

MANAGER.EventManagerV2 = {
    onKeyUp                : function ( event, controller_name ) {
        let param                                       = {};
        param[ CONTROLLER.CONST.CONTROLLER_NAME_LABEL ] = controller_name;
        param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]   = event;
        MANAGER.EventManagerV2.dispatch( event, "do", "on_key_up", param );
    },
    onKeyDown              : function ( event, controller_name ) {
        let param                                       = {};
        param[ CONTROLLER.CONST.CONTROLLER_NAME_LABEL ] = controller_name;
        param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]   = event;
        MANAGER.EventManagerV2.dispatch( event, "do", "on_key_down", param );
    },
    onMouseDown            : function ( event, controller_name ) {
        let param                                       = {};
        param[ CONTROLLER.CONST.CONTROLLER_NAME_LABEL ] = controller_name;
        param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]   = event;
        MANAGER.EventManagerV2.dispatch( event, "do", "mouse_down", param );
    },
    mouseMove              : function ( event, controller_name ) {
        let param                                       = {};
        param[ CONTROLLER.CONST.CONTROLLER_NAME_LABEL ] = controller_name;
        param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]   = event;
        MANAGER.EventManagerV2.dispatch( event, "do", "mouse_move", param );
    },
    onMouseEnter           : function ( event, controller_name ) {
        let param                                       = {};
        param[ CONTROLLER.CONST.CONTROLLER_NAME_LABEL ] = controller_name;
        param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]   = event;
        MANAGER.EventManagerV2.dispatch( event, "do", "mouse_enter", param );
    },
    onChangeInput          : function ( event, property_name, args ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "onchange_in_input", property_name, args );
    },
    onChangeInput_V3       : function ( event, param ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "onchange_in_input_V3", param );
    },
    onClickInput           : function ( event, property_name ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "onclick_in_input", property_name );
    },
    onClickInput_V3        : function ( event, param ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "onclick_in_input_V3", param );
    },
    clickRadioButton       : function ( event, property_name, button_name ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_radio_button", property_name, button_name );
    },
    clickRadioButton_V3    : function ( event, param ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_radio_button_V3", param );
    },
    clickSelector          : function ( event, property_name, selector_name ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_selector", property_name, selector_name );
    },
    clickSelector_V3       : function ( event, param ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_selector_V3", param );
    },
    clickSelectorV2        : function ( event, property_name, selector_name ) {
        let param                                    = {};
        param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] = property_name;
        param[ PROPERTY.SELECT.PARAM.SELECTOR_NAME ] = selector_name;
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_selector", param );
    },
    clickItemSelector      : function ( event, property_name, selector_name, item_name ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_item_selector", property_name, selector_name, item_name );
    },
    clickItemSelector_V3   : function ( event, param ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_item_selector_V3", param );
    },
    clickOnWindowNavigation: function ( event, param ) {
        if ( !param[ WINDOW_V2.CONST.PARAM.WINDOW_NAME ] ) {
            var _nav_tab = DOM.Service.findParentElementWithClass( event.target, WINDOW_V2.CONST.CLASS.WINDOW_TAB, 10 );
            if ( !_nav_tab ) {
                return;
            }
            param[ WINDOW_V2.CONST.PARAM.WINDOW_NAME ] = _nav_tab.dataset.name;
        }
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( param[ WINDOW_V2.CONST.PARAM.WINDOW_GROUP_NAME ] );
        
        var _click_done = _parent_window.clickOnWindow( param[ WINDOW_V2.CONST.PARAM.WINDOW_NAME ] );
        if ( !_click_done ) {
            return;
        }
        if ( param[ WINDOW_V2.CONST.PARAM.UPDATE_URL ] ) {
            SHINKEN.HIGHWAY.goToElementTab( param[ WINDOW_V2.CONST.PARAM.WINDOW_NAME ] );
        }
        param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT_NAME ] = "click_on__window_navigation__done";
        MANAGER.EventManagerV2.dispatch( event, "do", "do_action_after", param );
    },
    clickItemSelectorV2    : function ( event, property_name, selector_name, item_name ) {
        let param                                    = {};
        param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] = property_name;
        param[ PROPERTY.SELECT.PARAM.SELECTOR_NAME ] = selector_name;
        param[ PROPERTY.SELECT.PARAM.OPTION_NAME ]   = item_name;
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_item_selector", param );
    },
    clickButton            : function ( event, param_1, param_2, param_3 ) {
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_button", param_1, param_2, param_3 );
    },
    clickButtonV2          : function ( event, param_1, param_2, param_3 ) {
        let param                                   = {};
        param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] = param_1;
        param[ "item_uuid" ]                        = param_2;
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_button", param );
    },
    clickButton_V3         : function ( event, param ) {
        param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] = event;
        if ( DOM.Service.findParentElementWithClass( event.srcElement, "shinken-button-V3" ) && DOM.Service.findParentElementWithClass( event.srcElement, "shinken-button-V3" ).classList.contains( "shinken-disabled" ) ) {
            return;
        }
        MANAGER.EventManagerV2.dispatch( event, "do", "click_on_button_V3", param );
    },
    doActionAfter          : function ( event, event_name, param, param_2, param_3 ) {
        param                                              = param || {};
        param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT_NAME ] = event_name;
        param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]      = event;
        event.stopPropagation();
        MANAGER.EventManagerV2.dispatch( event, "do", "do_action_after", param, param_2, param_3 );
    },
    dispatch               : function ( event, type_dispatch, event_name, param, param_2, param_3 ) {
        const RIGHT_CLICK = 2;
        if ( event.button === RIGHT_CLICK ) {
            return;
        }
        if ( param[ MANAGER.EVENT_MANAGER_V2.PARAM.STOP_PROPAGATION ] ) {
            event.stopPropagation();
        }
        let controller_name = param[ CONTROLLER.CONST.CONTROLLER_NAME_LABEL ];
        var _controller     = CONTROLLER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        switch ( type_dispatch ) {
            case "do":
                switch ( event_name ) {
                    case "onchange_in_input":
                    case "onchange_in_input_V3":
                    case "onclick_in_input":
                    case "onclick_in_input_V3":
                    case "click_on_selector":
                    case "click_on_selector_V3":
                    case "click_on_item_selector":
                    case "click_on_item_selector_V3":
                    case "click_on_radio_button":
                    case "click_on_radio_button_V3":
                    case "click_on_button":
                    case "click_on_button_V3":
                        event.stopPropagation();
                        _controller.doActionAfter( event_name, param, param_2, param_3 );
                        break;
                    case "on_key_down":
                    case "on_key_up":
                    case "mouse_down":
                    case "mouse_move":
                    case "mouse_enter":
                        _controller.doActionAfter( event_name, param, param_2, param_3 );
                        break;
                    case "do_action_after":
                        _controller.doActionAfter( param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT_NAME ], param, param_2, param_3 );
                        break;
                    default:
                        console.log( "[EventManagerV2 - dispatch]", "[UNKNOW EVENT]", event_name );
                }
                break;
        }
    }
};