//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.VolumeNotificationOfChange = function ( data ) {
    this.init( data );
};

SHINKEN.OBJECT.VolumeNotificationOfChange.prototype = {
    init: function ( data ) {
        if ( data ) {
            this.updateData( data );
        }
    },
    //**************************************    EVENT LISTENER     **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "notification-configuration-set-dom-element-with-data":
                this.updateHtmlWithData();
                break;
            case "change_value_notification_of_change_sound":
                this.setData( SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VOLUME, param );
                break;
        }
    },
    //**************************************    GETTER SETTER         **************************************************//
    getValue: function () {
        if ( this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VOLUME ] === undefined ) {
            return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
        }
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VOLUME ];
    },
    //**************************************    DATAS         **************************************************//
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VOLUME:
                this[ key ] = value;
                break;
        }
    },
    //********************************************  PHASE  *****************************************************//
    //**************************************    SAVE         **************************************************//
    getDataToSave: function () {
        var _to_return                                                         = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VOLUME ] = this.getValue();
        return _to_return;
    },
    //**************************************    HTML         **************************************************//
    updateHtmlWithData: function () {
        var _dom     = document.querySelector( "#shinken-modal-container #sound-" + this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] );
        _dom.checked = true;
    },
    isEnabled         : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === true;
    }
};