//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.NotificationsOfChangeDefaultValues           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.NotificationsOfChangeDefaultValues.prototype = {
    //********************************************  EVENT LISTENER  *****************************************************//
    init: function ( data ) {
        this.users  = new SHINKEN.OBJECT.NotificationsOfChangeUser();
        this.hives  = new SHINKEN.OBJECT.NotificationsOfChangeView();
        this.lists  = new SHINKEN.OBJECT.NotificationsOfChangeView();
        this.events = new SHINKEN.OBJECT.NotificationsOfChangeView();
        if ( data ) {
            this.updateData( data );
        }
    },
    //**************************************    DATAS         **************************************************//
    updateData               : function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData                  : function ( key, value ) {
        switch ( key ) {
            case "default_notifications_settings__event_container__visual__blink__enabled":
                this.events.doActionAfter( "change_value_notification_of_change_visual_blink", value );
                break;
            case "default_notifications_settings__event_container__sound__enabled":
                this.events.doActionAfter( "change_value_notification_of_change_sound", value );
                break;
            case "default_notifications_settings__hives__visual__blink__enabled":
                this.hives.doActionAfter( "change_value_notification_of_change_visual_blink", value );
                break;
            case "default_notifications_settings__hives__sound__enabled":
                this.hives.doActionAfter( "change_value_notification_of_change_sound", value );
                break;
            case "default_notifications_settings__lists__visual__blink__enabled":
                this.lists.doActionAfter( "change_value_notification_of_change_visual_blink", value );
                break;
            case "default_notifications_settings__lists__sound__enabled":
                this.lists.doActionAfter( "change_value_notification_of_change_sound", value );
                break;
            case "default_notifications_settings__users__sound__volume_percent":
                this.users.doActionAfter( "change_value_notification_of_change_sound", value );
                break;
            case "default_notifications_settings__users__visual__blink__enabled":
                this.users.doActionAfter( "change_value_notification_of_change_visual_blink", value );
                break;
            default:
                break;
        }
    },
    computeViewSettings      : function ( shinken_view ) {
        this.computeViewSettingsVisual( shinken_view );
        shinken_view.sound_notification_of_change_enabled = this.computeViewSettingsSound( shinken_view );
    },
    computeViewSettingsVisual: function ( shinken_view ) {
        shinken_view.visual_notification_of_change_enabled = this.computeViewSettingsBlink( shinken_view );
    },
    computeViewSettingsBlink : function ( shinken_view ) {
        if ( shinken_view.notifications_of_change.getBlinkValue() !== SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT ) {
            return shinken_view.notifications_of_change.getBlinkValue();
        }
        switch ( shinken_view.type ) {
            case "hive":
                return this.hives.getBlinkValue();
            case "list":
                return this.lists.getBlinkValue();
            case "event-tub":
                return this.events.getBlinkValue();
            default:
                console.warn( "[NotificationsOfChangeDefaultValues - computeViewSettingsBlink]", shinken_view.type, "NOT MANAGED" );
                break;
            
        }
    },
    computeViewSettingsSound : function ( shinken_view ) {
        if ( shinken_view.notifications_of_change.getSoundValue() !== SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT ) {
            return shinken_view.notifications_of_change.getSoundValue();
        }
        switch ( shinken_view.type ) {
            case "hive":
                return this.hives.getSoundValue();
            case "list":
                return this.lists.getSoundValue();
            case "event-tub":
                return this.events.getSoundValue();
            default:
                console.warn( "[NotificationsOfChangeDefaultValues - computeViewSettingsBlink]", shinken_view.type, "NOT MANAGED" );
                break;
        }
    },
    getFlatUserVolume        : function ( notification_of_change_from_user ) {
        var _to_return = notification_of_change_from_user.getVolumeValue();
        if ( _to_return === SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT ) {
            _to_return = this.getUserVolumeValue();
        }
        return _to_return;
    },
    getFlatUserBlink         : function ( notification_of_change_from_user ) {
        var _to_return = notification_of_change_from_user.getBlinkValue();
        if ( _to_return === SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT ) {
            _to_return = this.getUserBlinkValue();
        }
        return _to_return;
    },
    getUserVolumeValue       : function () {
        return this.users.getVolumeValue();
    },
    getUserBlinkValue        : function () {
        return this.users.getBlinkValue();
    }
};