//__lib__ lib_common
"use strict";


SHINKEN.OBJECT.OverlayFrame           = function () {
    this.__class_name__ = "SHINKEN.OBJECT.OverlayFrame";
};
SHINKEN.OBJECT.OverlayFrame.prototype = {
    init: function ( start_x, start_y, dom_relative_position_container ) {
        this.dom_element        = null;
        this.dom_element_parent = dom_relative_position_container;
        this.start_x            = start_x;
        this.start_y            = start_y;
        this.end_x              = start_x;
        this.end_y              = start_y;
        this.initial_scroll_top = 0;
        this.offset_x           = 0;
        this.offset_y           = 0;
        if ( dom_relative_position_container ) {
            this.offset_x           = DOM.Service.getBoundingClientRect( dom_relative_position_container, DOM.CONST.STYLE.LEFT );
            this.offset_y           = DOM.Service.getBoundingClientRect( dom_relative_position_container, DOM.CONST.STYLE.TOP );
            this.initial_scroll_top = dom_relative_position_container.scrollTop;
        }
        this.current_scroll_top = this.initial_scroll_top;
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter      : function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "mouse_down":
                if ( !param ) {
                    return;
                }
                this.end_x = param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].clientX;
                this.end_y = param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].clientY;
                this.updateSize();
                break;
            case "on_scroll":
                this.current_scroll_top = this.dom_element_parent.scrollTop;
                this.updateSize();
                this.updateContent( param );
                break;
            case "mouse_move":
                this.addOrRemoveDragInProgress( true );
                this.end_x = param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].clientX;
                this.end_y = param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].clientY;
                this.makeMouseMoveAction( param );
                break;
            case "mouse_up":
                this.addOrRemoveDragInProgress( false );
                if ( !param ) {
                    return;
                }
                return this.getImpactedElement( param, param_2, param_3 );
            case "make_mouse_up_action":
                return this.makeMouseUpAction( param, param_2, param_3 );
        }
    },
    makeMouseMoveAction: function ( param ) {
        this.updateSize();
        this.updateContent( param );
    },
    getImpactedElement : function () {
    },
    makeMouseUpAction  : function () {
    },
    //********************************************  OTHERS  *****************************************************//
    remove                   : function () {
        this.resetHTML();
    },
    computeFrameDisplayStyle : function () {
        return {
            top   : Math.min( this.getComputedStartY(), this.getComputedEndY() ) - this.offset_y,
            left  : Math.min( this.start_x, this.end_x ) - this.offset_x,
            width : Math.abs( this.start_x - this.end_x ),
            height: Math.abs( this.getComputedStartY() - this.getComputedEndY() )
        };
    },
    addOrRemoveDragInProgress: function ( add_or_remove ) {
        if ( add_or_remove && this.drag_in_progress ) {
            return;
        }
        DOM.BodyService.addOrRemoveClasses( add_or_remove, "shinken-has-drag-in-progress-overlay-frame-move" );
        DOM.BodyService.addOrRemoveClasses( add_or_remove, "shinken-has-drag-in-progress-overlay-frame" );
        this.drag_in_progress = add_or_remove;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getDelta_x       : function ( pos_pixel ) {
        return this.end_x - this.start_x;
    },
    getDelta_y       : function ( pos_pixel ) {
        return this.getComputedEndY() - this.getComputedStartY();
    },
    getComputedStartY: function () {
        return this.start_y + this.initial_scroll_top;
    },
    getComputedEndY  : function () {
        return this.end_y + this.current_scroll_top;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml      : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-selection-frame" } ) );
        DOM.Service.setStyles( this.getDomElement(), this.getInitStyle() );
    },
    getInitStyle     : function () {
        return {
            top   : this.getComputedStartY() - this.offset_y,
            left  : this.start_x - this.offset_x,
            width : 0,
            height: 0
        };
    },
    updateSize       : function () {
        if ( !this.getDomElement() ) {
            this.computeHtml();
        }
        DOM.Service.setStyles( this.getDomElement(), this.computeFrameDisplayStyle() );
    },
    updateContent    : function () {
    },
    resetZoneToRemove: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.OverlayFrame, SHINKEN.OBJECT.ShinkenObjectHtml );

SHINKEN.OBJECT.OverlayFrameForGrid           = function ( tile_pixel_size ) {
    this.__class_name__  = "SHINKEN.OBJECT.OverlayFrameForGrid";
    this.tile_pixel_size = tile_pixel_size;
};
SHINKEN.OBJECT.OverlayFrameForGrid.prototype = {
    //********************************************  EVENT LISTENER  *****************************************************//
    getImpactedElement: function ( shinken_grid_cells ) {
        let bounding_zone = this.getBoundingZone();
        return this.findCellMatchingZone( shinken_grid_cells, bounding_zone );
    },
    
    makeMouseUpAction: function ( shinken_grid_cells ) {
        let _has_unselected_cell = false;
        for ( let i = 0, _size_i = shinken_grid_cells.length; i < _size_i; i++ ) {
            if ( !shinken_grid_cells[ i ].isPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ) {
                _has_unselected_cell = true;
            }
        }
        for ( let i = 0, _size_i = shinken_grid_cells.length; i < _size_i; i++ ) {
            let next_phase = shinken_grid_cells[ i ].isPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ? SHINKEN.OBJECT.CONST.PHASE.EDITING : SHINKEN.OBJECT.CONST.PHASE.SELECTED;
            shinken_grid_cells[ i ].setPhase( next_phase );
        }
        return shinken_grid_cells;
    },
    //********************************************  OTHERS  *****************************************************//
    findCellMatchingZone     : function ( shinken_grid_cells, bounding_zone ) {
        let cell_in_frame        = [];
        let _has_unselected_cell = false;
        let bottom_left_point    = new SHINKEN.OBJECT.Point( bounding_zone.left, bounding_zone.bottom, "bottom_left" );
        let top_right_point      = new SHINKEN.OBJECT.Point( bounding_zone.right, bounding_zone.top, "top_right" );
        let selection_square     = new SHINKEN.OBJECT.Square( bottom_left_point, top_right_point );
        for ( let cell of shinken_grid_cells.contents ) {
            cell.computeSquare();
            if ( selection_square.isOverlapping( cell.square ) ) {
                cell_in_frame.push( cell );
            }
        }
        return cell_in_frame;
    },
    addOrRemoveDragInProgress: function ( add_or_remove ) {
        DOM.BodyService.addOrRemoveClasses( add_or_remove, "shinken-has-drag-in-progress-overlay-frame" );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getBoundingZone   : function () {
        return {
            left  : Math.min( this.parsePixelToGrid_x( this.start_x ), this.parsePixelToGrid_x( this.end_x ) ),
            right : Math.max( this.parsePixelToGrid_x( this.start_x ), this.parsePixelToGrid_x( this.end_x ) ),
            top   : Math.min( this.parsePixelToGrid_y( this.getComputedStartY() ), this.parsePixelToGrid_y( this.getComputedEndY() ) ),
            bottom: Math.max( this.parsePixelToGrid_y( this.getComputedStartY() ), this.parsePixelToGrid_y( this.getComputedEndY() ) )
        };
    },
    parsePixelToGrid_x: function ( pos_pixel ) {
        return Math.round( (pos_pixel - this.offset_x) / this.tile_pixel_size );
    },
    parsePixelToGrid_y: function ( pos_pixel ) {
        return Math.round( (pos_pixel - this.offset_y) / this.tile_pixel_size );
    },
    parseGridToPixel_y: function ( pos_grid ) {
        return pos_grid * this.tile_pixel_size;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.OverlayFrameForGrid, SHINKEN.OBJECT.OverlayFrame );

SHINKEN.OBJECT.OverlayFrameZoneSelection           = function ( tile_pixel_size ) {
    this.__class_name__  = "SHINKEN.OBJECT.OverlayFrameZoneSelection";
    this.tile_pixel_size = tile_pixel_size;
};
SHINKEN.OBJECT.OverlayFrameZoneSelection.prototype = {
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.OverlayFrameZoneSelection, SHINKEN.OBJECT.OverlayFrameForGrid );

SHINKEN.OBJECT.OverlayFrameMove           = function () {
    this.__class_name__  = "SHINKEN.OBJECT.OverlayFrameMove";
};
SHINKEN.OBJECT.OverlayFrameMove.prototype = {
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.OverlayFrameMove, SHINKEN.OBJECT.OverlayFrame );
