//__lib__ lib_common
"use strict";

//***************************    GenericResizer    ***************************//
SHINKEN.OBJECT.GenericResizer           = function ( type_resize, shinken_object ) {
    this.__class_name__ = "SHINKEN.OBJECT.GenericResizer";
    this.type_resize    = type_resize;
    this.shinken_object = shinken_object;
    this.dom_element    = this.shinken_object.getDomElement();
};
SHINKEN.OBJECT.GenericResizer.prototype = {
    init          : function ( pos_x, pos_y, dom_scrollable_container ) {
        this.initial_scroll_top = 0;
        this.offset_x           = 0;
        this.offset_y           = 0;
        this.dom_element_parent = dom_scrollable_container;
        if ( dom_scrollable_container ) {
            this.offset_x           = DOM.Service.getBoundingClientRect( dom_scrollable_container, DOM.CONST.STYLE.LEFT );
            this.offset_y           = DOM.Service.getBoundingClientRect( dom_scrollable_container, DOM.CONST.STYLE.TOP );
            this.initial_scroll_top = dom_scrollable_container.scrollTop;
        }
        let rect                = DOM.Service.getBoundingClientRect( this.getDomElement() );
        this.start_x            = this.isCursorOnLeft() ? rect.right : rect.left;
        this.start_y            = this.isCursorOnTop() ? rect.bottom : rect.top;
        this.end_x              = pos_x;
        this.end_y              = pos_y;
        this.current_scroll_top = this.initial_scroll_top;
    },
    isCursorOnTop : function () {
        return this.type_resize.includes( "top" );
    },
    isCursorOnLeft: function () {
        return this.type_resize.includes( "left" );
    },
    //********************************************  OTHERS  *****************************************************//
    remove: function () {
    }
    //********************************************  HTML  *****************************************************//
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GenericResizer, SHINKEN.OBJECT.OverlayFrame );

//***************************    GridCellResizer    ***************************//
SHINKEN.OBJECT.GridCellResizer           = function ( type_resize, grid_cell, tile_pixel_size ) {
    this.__class_name__  = "SHINKEN.OBJECT.GridCellResizer";
    this.type_resize     = type_resize;
    this.shinken_object  = grid_cell;
    this.dom_element     = this.shinken_object.getDomElement();
    this.tile_pixel_size = tile_pixel_size;
};
SHINKEN.OBJECT.GridCellResizer.prototype = {
    updateContent             : function () {
        if ( !this.shinken_object.starting_clone ) {
            this.shinken_object.initStartingZone();
            this.shinken_object.initEndingZone();
        }
        
        const position_in_tile = this.getComputedPositionInTile();
        this.shinken_object.ending_clone.applyResize( position_in_tile.start_x, position_in_tile.start_y, position_in_tile.end_x, position_in_tile.end_y );
    },
    getImpactedElement        : function () {
        if ( this.shinken_object.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING ) ) {
            this.shinken_object.rollbackResize();
            this.shinken_object.resetMoveObject();
            this.shinken_object.resetCounterByType( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING );
            return;
        }
        return [this.shinken_object];
    },
    getComputedPositionInTile : function () {
        const position_in_pixel = this.getComputedPositionInPixel();
        return {
            start_x: this.parsePixelToGrid_x( position_in_pixel.left + this.offset_x ),
            start_y: this.parsePixelToGrid_y( position_in_pixel.top + this.offset_y ),
            end_x  : this.parsePixelToGrid_x( position_in_pixel.left + position_in_pixel.width + this.offset_x ),
            end_y  : this.parsePixelToGrid_y( position_in_pixel.top + position_in_pixel.height + this.offset_y )
        };
    },
    getComputedPositionInPixel: function () {
        let top;
        let left;
        let width;
        let height;
        if ( this.isCursorOnLeft() ) {
            left  = Math.min( this.start_x - this.tile_pixel_size * SHINKEN_GRID.CONST.PARAM.GRID_CELL.MIN_WIDTH, this.end_x ) - this.offset_x;
            width = Math.max( this.start_x - this.end_x, this.tile_pixel_size * SHINKEN_GRID.CONST.PARAM.GRID_CELL.MIN_WIDTH );
        }
        else {
            left  = this.start_x - this.offset_x;
            width = Math.max( this.end_x - this.start_x, this.tile_pixel_size * SHINKEN_GRID.CONST.PARAM.GRID_CELL.MIN_WIDTH );
        }
        
        if ( this.isCursorOnTop() ) {
            top    = Math.min( this.getComputedStartY() - this.tile_pixel_size, this.getComputedEndY() ) - this.offset_y;
            height = Math.max( this.getComputedStartY() - this.getComputedEndY(), this.tile_pixel_size * SHINKEN_GRID.CONST.PARAM.GRID_CELL.MIN_HEIGHT );
        }
        else {
            top    = this.getComputedStartY() - this.offset_y;
            height = Math.max( this.getComputedEndY() - this.getComputedStartY(), this.tile_pixel_size * SHINKEN_GRID.CONST.PARAM.GRID_CELL.MIN_HEIGHT );
        }
        
        return {
            top   : top,
            left  : left,
            width : width,
            height: height
        };
    },
    computeFrameDisplayStyle  : function () {
        return this.getComputedPositionInPixel();
    },
    makeMouseUpAction         : function () {
        const position_in_tile = this.getComputedPositionInTile();
        this.shinken_object.applyResize( position_in_tile.start_x, position_in_tile.start_y, position_in_tile.end_x, position_in_tile.end_y );
        this.shinken_object.computeLastModificationData__fromStartingClone();
        this.shinken_object.resetMoveObject();
        return [this.shinken_object];
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridCellResizer, SHINKEN.OBJECT.GenericResizer );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridCellResizer, SHINKEN.OBJECT.OverlayFrameForGrid );
