//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.CONST.PARAM     = {
    VALUE       : "value",
    CFG_VALUE   : "cfg_value",
    SOURCE_VALUE: "source_value"
};
SHINKEN.OBJECT.Param           = function ( key, value_object, parameter, default_value ) {
    this.init( key, value_object, parameter, default_value );
};
SHINKEN.OBJECT.Param.prototype = {
    __class_name__          : 'SHINKEN.OBJECT.Param',
    init                    : function ( key, value_object, parameter, default_value ) {
        this.initCounterCommon();
        if ( !value_object ) {
            console.warn( "[Param - init FAILED]", key, value_object, parameter, default_value );
            return;
        }
        this.key           = key;
        this.default_value = default_value;
        this.initValueObject( value_object );
        if ( parameter && this.user_value === "" && !parameter.is_mandatory ) {
            this.user_value = default_value;
        }
    },
    initValueObject         : function ( value_object ) {
        if ( value_object.validation_messages ) {
            this.setMessagesSpecific( value_object.validation_messages );
        }
        this.setValue( value_object[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] );
        this._initial_value = this.getValue();
        this.cfg_value      = value_object[ SHINKEN.OBJECT.CONST.PARAM.CFG_VALUE ];
        this.setUserValue( value_object[ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ] === undefined ? "" : value_object[ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ] );
    },
    setMessagesSpecific     : function ( message ) {
        this.setMessages( message );
    },
    doActionAfterAddMessages: function () {
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, this.getObjectClassName(), this.messages.getNumberWarnings() );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.getObjectClassName(), this.messages.getNumberErrors() );
    },
    _getObjectToJson        : function ( format_data__20241115 ) {
        switch ( format_data__20241115 ) {
            case SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_ONLY:
                return this.getValue();
            case SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT:
                return { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this.getValue(), [ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ]: this.getUserValue() };
            case SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_FORCE_DEFAULT:
                return { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this.getValue(), [ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ]: this.default_value };
        }
        return this;
    },
    changeUserValueByValue  : function () {
        this.user_value = this.value;
    },
    setUserValue            : function ( to_set ) {
        this.user_value = to_set;
    },
    setUserValueAndValue    : function ( to_set ) {
        this.user_value = to_set;
        this.value      = to_set;
    },
    getInitialValue         : function () {
        return this._initial_value;
    },
    getUserValue            : function () {
        return this.user_value;
    },
    setValue                : function ( to_set ) {
        this.value = to_set;
    },
    getValue                : function () {
        return this.value;
    },
    getCfgValue             : function () {
        return this.cfg_value;
    },
    getUUID                 : function () {
        return this.uuid;
    },
    clone                   : function () {
        return new SHINKEN.OBJECT.Param( this.key, { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this.value, [ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ]: this.user_value } );
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave             : function () {
        return this.getValue();
    },
    getDataForLastModification: function () {
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Param, SHINKEN.OBJECT.CounterInterfaceValidation );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Param, SHINKEN.OBJECT.ShinkenObjectJson );
