//__lib__ lib_common
"use strict";

SHINKEN.OBJECT.PROGRESS_BAR_CONST = {
    SAVING_DEFAULT                  : {
        PREPARATION_CALL        : 1,
        CALL_IN_PROGRESS        : 2,
        BACKEND_RETURN_TREATMENT: 3,
        END                     : 4
    },
    SAVING_WITH_TREATMENT_AFTER_CALL: {
        PREPARATION_CALL        : 1,
        CALL_IN_PROGRESS        : 2,
        BACKEND_RETURN_ANALYSE  : 3,
        BACKEND_RETURN_TREATMENT: 4,
        END                     : 5
    }
};

SHINKEN.OBJECT.Progressbar           = function ( parent, nb_steps, min_timeout, dom_element_parent ) {
    this.__class_name__ = "SHINKEN.OBJECT.Progressbar";
    this._parent        = parent;
    this._nb_steps      = nb_steps;
    this._min_timeout   = min_timeout;
    this.setDomElementParent( dom_element_parent );
    this.init();
};
SHINKEN.OBJECT.Progressbar.prototype = {
    //********************************  INIT    ******************************************************************//
    init     : function () {
        this.dom_element_parent.innerHTML = __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__.replace( "$$$$__COLLAPSE__TITLE__$$$$", _( "progress_bar.toggle_display_message_label", [DICTIONARY_COMMON_UI] ) );
        this.setDomElement( this.dom_element_parent.firstChild );
        this._dom_progress_bar = this.getDomElement().querySelector( ".shinken-progress-bar" );
        this._dom_title        = this.getDomElement().querySelector( ".shinken-popup-title" );
        this._dom_message      = this.getDomElement().querySelector( ".shinken-progress-bar-message" );
        this.starting_time     = null;
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN, this.getDomElement() );
    },
    reset    : function () {
        this._timeout_run  = null;
        this._current_step = 0;
        this.setMessagesDisplayed( false );
        this.initSteps();
    },
    initSteps: function () {
        this._steps = [];
        for ( var i = 0; i <= this._nb_steps; i++ ) {
            this._steps.push( new SHINKEN.OBJECT.ProgressbarStep( i ) );
        }
    },
    //********************************  GETTER SETTER    ******************************************************************//
    setMessagesDisplayed: function ( to_set ) {
        DOM.Service.setDataSet( this.getDomElement(), 'messageDisplayed', !!to_set ? "1" : "0" );
    },
    getCurrentStep      : function () {
        return this._steps[ this._current_step ];
    },
    getStep             : function ( step ) {
        return this._steps[ step ];
    },
    setParamStep        : function ( step, to_set ) {
        this._steps[ step ].setParam( to_set );
    },
    setMessageStep      : function ( step, to_set ) {
        this._steps[ step ].setMessage( to_set );
    },
    setDomElementParent : function ( to_set ) {
        this.dom_element_parent = to_set;
        if ( this.getDomElement() ) {
            DOM.Service.addElementTo( this.getDomElement(), this.dom_element_parent );
        }
    },
    setTitleStep        : function ( step, to_set ) {
        this._steps[ step ].setTitle( to_set );
    },
    callbackForPhase    : function () {
        var _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                this.reset();
                break;
        }
    },
    //********************************  OTHERS    ******************************************************************//
    kill: function () {
        DOM.Service.removeElement( this.getDomElement() );
    },
    //********************************  PROGRESS    ******************************************************************//
    doProgress: function ( expected_step, phase, param, message, title ) {
        if ( expected_step === 1 ) {
            this.reset();
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        }
        var _step = this._steps[ expected_step ];
        _step.setPhase( phase );
        _step.setParam( param );
        _step.setMessage( message );
        _step.setTitle( title );
        _step.askForRun();
        this._run();
    },
    _run      : function () {
        if ( this._timeout_run ) {
            return;
        }
        if ( !this._steps[ this._current_step + 1 ].needToBeRun() ) {
            return;
        }
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK ) ) {
            return;
        }
        this._current_step++;
        var _current_step = this.getCurrentStep();
        this._parent.doActionWhenProgressStart( this._current_step, _current_step.getParam(), this );
        this._updateHtml( _current_step );
        if ( this._timeout_run ) {
            return;
        }
        var self = this;
        
        this._timeout_run = setTimeout( function () {
            self._parent.doActionWhenProgressEnd( self._current_step, _current_step.getParam(), self );
            self._timeout_run = null;
            if ( self._current_step < self._nb_steps ) {
                self._run();
            }
        }, this._min_timeout );
    },
    //********************************  UPDATE HTML    ******************************************************************//
    _updateHtml    : function ( current_step ) {
        if ( current_step.getPhase() ) {
            this.setPhase( current_step.getPhase() );
        }
        if ( current_step.getTitle() ) {
            this.updateTitleHtml( current_step.getTitle() );
        }
        if ( current_step.getMessage() ) {
            this._dom_message.innerHTML = current_step.getMessage();
        }
        this._updateBarHtml();
    },
    _updateBarHtml : function () {
        DOM.Service.setStyle( this._dom_progress_bar, DOM.CONST.STYLE.WIDTH, (this._current_step / this._nb_steps * 100) + "%" );
        DOM.Service.setDataSet( this.getDomElement(), "isComplete", (this._current_step === this._nb_steps) ? "1" : "0" );
    },
    updateTitleHtml: function ( to_set ) {
        this._dom_title.innerHTML = to_set;
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Progressbar, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Progressbar, SHINKEN.OBJECT.ShinkenObjectHtml );

SHINKEN.OBJECT.ProgressbarStep           = function ( index ) {
    this._index        = index;
    this._phase        = null;
    this._title        = null;
    this._message      = null;
    this._param        = null;
    this._run_expected = false;
};
SHINKEN.OBJECT.ProgressbarStep.prototype = {
    //********************************  GETTER SETTER    ******************************************************************//
    setPhase   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._phase = to_set;
        }
    },
    setMessage : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._message = to_set;
        }
    },
    getTitle   : function ( to_set ) {
        return this._title;
    },
    setTitle   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._title = to_set;
        }
    },
    getMessage : function ( to_set ) {
        return this._message;
    },
    setParam   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._param = to_set;
        }
    },
    askForRun  : function () {
        this._run_expected = true;
    },
    needToBeRun: function () {
        return this._run_expected;
    },
    getParam   : function () {
        return this._param;
    },
    getPhase   : function () {
        return this._phase;
    },
    isPhase    : function ( to_test ) {
        return this._phase === to_test;
    }
};

SHINKEN.OBJECT.ProgressbarInterface           = function () {
};
SHINKEN.OBJECT.ProgressbarInterface.prototype = {
    doActionWhenProgressStart        : function ( current_step, param, progress_bar_object ) {
        if ( current_step === progress_bar_object._nb_steps ) {
            this.doActionWhenProgressionIsComplete( progress_bar_object );
        }
        this._doActionWhenProgressStart( current_step, param );
    },
    doActionWhenProgressEnd          : function ( current_step, param, progress_bar_object ) {
        if ( (current_step === progress_bar_object._nb_steps - 1) && progress_bar_object.getCurrentStep().isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK ) ) {
            progress_bar_object.doProgress( progress_bar_object._nb_steps );
        }
        this._doActionWhenProgressEnd( current_step, param );
    },
    _doActionWhenProgressStart       : function ( current_step, param ) {
    },
    _doActionWhenProgressEnd         : function ( current_step, param ) {
    },
    doActionWhenProgressionIsComplete: function ( progress_bar_object ) {
        if ( progress_bar_object.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK ) ) {
            progress_bar_object.setPhaseWithTimeOut( SHINKEN.OBJECT.CONST.PHASE.HIDDEN, 2000 );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ProgressbarInterface, SHINKEN.OBJECT.ShinkenObject );

var __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__ = '<div class="shinken-popup-progress-bar-container shinken-parent-event-listener" data-controller="common_ui" data-message-displayed="0">\n' +
                                             '    <div class="shinken-popup-title"></div>\n' +
                                             '    <div class="shinken-progress-bar-container">\n' +
                                             '        <div class="shinken-progress-bar"></div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-collapse-button-container">\n' +
                                             '    <div class="shinken-collapse-button-container">\n' +
                                             '        <div class="shinken-button-container">\n' +
                                             '            <div class="shinken-button shinken-popup-message-detail-collapse" onclick="MANAGER.EventManager.clickOnButton(event)" data-name="toggle_display_popup_progress_bar_message">\n' +
                                             '                <div class="shinken-display-table">\n' +
                                             '                    <div class="shinken-display-table-cell">\n' +
                                             '                        <span class="">$$$$__COLLAPSE__TITLE__$$$$</span>\n' +
                                             '                    </div>\n' +
                                             '                </div>\n' +
                                             '            </div>\n' +
                                             '        </div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-popup-close">\n' +
                                             '        <div class="shinken-button-container">\n' +
                                             '            <div class="shinken-button" onclick="MANAGER.EventManager.clickOnButton(event)" data-name="close_popup_progress_bar">\n' +
                                             '                <div class="shinken-display-table">\n' +
                                             '                    <div class="shinken-display-table-cell"><span class=""><span class="shinkon shinkon-times"></span></span></div>\n' +
                                             '                </div>\n' +
                                             '            </div>\n' +
                                             '        </div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-progress-bar-message"></div>\n' +
                                             '</div>';
