//__lib__ lib_common
"use strict";

SHINKEN.STATUS = {
    OK                        : {
        CODE    : 0,
        NAME    : 'ok',
        KEY     : 'OK',
        PRIORITY: 0,
        ORDER   : 0,
        TYPE    : 'status',
        PATH    : 'assets/images/status/ok.svg'
    },
    WARNING                   : {
        CODE    : 1,
        NAME    : 'warning',
        KEY     : 'WARNING',
        PRIORITY: 2,
        ORDER   : 1,
        TYPE    : 'status',
        PATH    : 'assets/images/status/warning.svg'
    },
    CRITICAL                  : {
        CODE    : 2,
        NAME    : 'critical',
        KEY     : 'CRITICAL',
        PRIORITY: 3,
        ORDER   : 2,
        TYPE    : 'status',
        PATH    : 'assets/images/status/critical.svg'
    },
    UNKNOWN                   : {
        CODE    : 3,
        NAME    : 'unknown',
        KEY     : 'UNKNOWN',
        PRIORITY: 1,
        ORDER   : 3,
        TYPE    : 'status',
        PATH    : 'assets/images/status/unknown.svg'
    },
    MISSING_DATA              : {
        CODE    : 4,
        NAME    : 'missing-data',
        KEY     : 'MISSING_DATA',
        PRIORITY: 0,
        ORDER   : 4,
        TYPE    : 'status'
    },
    PENDING                   : {
        CODE    : 4,
        NAME    : 'missing-data',
        KEY     : 'MISSING_DATA',
        PRIORITY: 0,
        ORDER   : 4,
        TYPE    : 'status'
    },
    SHINKEN_INACTIVE          : {
        CODE    : 5,
        NAME    : 'shinken-inactive',
        KEY     : 'SHINKEN_INACTIVE',
        PRIORITY: 0,
        ORDER   : 5,
        TYPE    : 'status'
    },
    NOTHING                   : {
        CODE    : 'NOTHING',
        NAME    : 'nothing',
        PRIORITY: 0,
        ORDER   : 0,
        TYPE    : 'context'
    },
    ACKNOWLEDGED              : {
        CODE    : 'ACKNOWLEDGED',
        NAME    : 'acknowledged',
        PRIORITY: 15,
        ORDER   : 1,
        TYPE    : 'context'
    },
    PARTIAL_ACKNOWLEDGED      : {
        CODE    : 'PARTIAL-ACKNOWLEDGED',
        NAME    : 'partial-acknowledged',
        PRIORITY: 19,
        ORDER   : 2,
        TYPE    : 'context'
    },
    INHERITED_ACKNOWLEDGED    : {
        CODE    : 'INHERITED-ACKNOWLEDGED',
        NAME    : 'inherited-acknowledged',
        PRIORITY: 10,
        ORDER   : 2,
        TYPE    : 'context'
    },
    DOWNTIME                  : {
        CODE    : 'DOWNTIME',
        NAME    : 'downtime',
        PRIORITY: 35,
        ORDER   : 3,
        TYPE    : 'context',
        PATH    : 'assets/images/status/downtime.svg'
    },
    PARTIAL_DOWNTIME          : {
        CODE    : 'PARTIAL-DOWNTIME',
        NAME    : 'partial-downtime',
        PRIORITY: 39,
        ORDER   : 3,
        TYPE    : 'context'
    },
    INHERITED_DOWNTIME        : {
        CODE    : 'INHERITED-DOWNTIME',
        NAME    : 'inherited-downtime',
        PRIORITY: 30,
        ORDER   : 3,
        TYPE    : 'context'
    },
    FLAPPING                  : {
        CODE    : 'FLAPPING',
        NAME    : 'flapping',
        PRIORITY: 25,
        ORDER   : 4,
        TYPE    : 'context'
    },
    PARTIAL_FLAPPING          : {
        CODE    : 'PARTIAL-FLAPPING',
        NAME    : 'partial-flapping',
        PRIORITY: 29,
        ORDER   : 5,
        TYPE    : 'context'
    },
    DISABLED                  : {
        CODE    : 'DISABLED',
        NAME    : 'disabled',
        PRIORITY: 404,
        ORDER   : 6,
        TYPE    : 'context'
    },
    STATUS_COUNT              : 6,
    CODE_TO_KEY               : {
        0                       : 'OK',
        1                       : 'WARNING',
        2                       : 'CRITICAL',
        3                       : 'UNKNOWN',
        4                       : 'MISSING_DATA',
        5                       : 'SHINKEN_INACTIVE',
        NOTHING                 : 'NOTHING',
        ACKNOWLEDGED            : 'ACKNOWLEDGED',
        'PARTIAL-ACKNOWLEDGED'  : 'PARTIAL_ACKNOWLEDGED',
        'INHERITED-ACKNOWLEDGED': 'INHERITED_ACKNOWLEDGED',
        DOWNTIME                : 'DOWNTIME',
        'PARTIAL-DOWNTIME'      : 'PARTIAL_DOWNTIME',
        'INHERITED-DOWNTIME'    : 'INHERITED_DOWNTIME',
        FLAPPING                : 'FLAPPING',
        'PARTIAL-FLAPPING'      : 'PARTIAL_FLAPPING',
        DISABLED                : 'DISABLED'
    },
    NAME_TO_CODE              : {
        ok      : 0,
        warning : 1,
        critical: 2,
        unknown : 3
    },
    LIST_CONTEXT_WIDGET_DETAIL: {
        0: 'NOTHING',
        1: 'ACKNOWLEDGED',
        2: 'FLAPPING',
        3: 'DOWNTIME'
    },
    TYPE                      : {
        STATUS : 'status',
        CONTEXT: 'context'
    }
    
};
