//__lib__ lib_common_V02_01
"use strict";

SHINKEN_GRID.Cell           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cell.prototype = {
    init             : function ( data ) {
        this.initInternal();
        this.initPhase();
        this.class = "shinken-grid-cell shinken-no-opacity";
        this.updateData( data );
        this.setUUID();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED );
    },
    //********************************************  EVENT LISTENER  *********************************************//
    doActionAfter      : function ( event_name, param, param_2, param_3 ) {
        return this.doActionAfterCommon( event_name, param, param_2, param_3 );
    },
    doActionAfterCommon: function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "toggle_remove_grid_cell_from_delete_list":
                        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED, this.getUUID(), this.getCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED ) ? 0 : 1 );
                        break;
                }
                break;
            case "focus_on_dom_element":
                if ( this.getDomElement() ) {
                    this.askAddClass( "shinken-pulsate", 1600 );
                    DOM.Service.scrollIntoElementIfNotVisible( this.getDomElement() );
                }
                break;
            case "mouse_down_on_grid_cell":
                if ( !param[ SHINKEN_PAGE.CONST.EVENTS.PARAM.WIDGET_MODE__PHASE__OBJECT ].isPhase( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT ) ) {
                    break;
                }
                if ( param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].ctrlKey ) {
                    break;
                }
                switch ( this.getCurrentPhase() ) {
                    case SHINKEN.OBJECT.CONST.PHASE.SELECTED:
                        this.selection_event_in_progress = true;
                        break;
                    default:
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED );
                        break;
                }
                break;
            case "mouse_up_on_grid_cell":
                if ( this.selection_event_in_progress ) {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                    this.selection_event_in_progress = false;
                    this.updateSize();
                }
                break;
            case "mouse_scroll_selected_grid_cell":
            case "mouse_move_selected_grid_cell":
                this.selection_event_in_progress = false;
                this.move__delta_x               = param;
                this.move__delta_y               = param_2;
                if ( !this.starting_clone ) {
                    this.initStartingZone();
                    this.initEndingZone();
                }
                this.applyCurrentMove();
                break;
            case "grid_cell_action_after_mouse_up_reset":
                this.move__delta_x = 0;
                this.move__delta_y = 0;
                this.applyMove();
                this.rollbackResize();
                this.resetMoveObject();
                break;
            case "grid_cell_action_after_mouse_up":
                if ( !this.starting_clone ) { // USEFUL FOR TAKING INTO ACCOUNT ONLY ACTIONS THAT CAN LEAD TO A MOVE
                    return;
                }
                this.applyMove();
                this.resetMoveObject();
                if ( this.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ) ) {
                    let index_impacted = this.getCellIndexInPositionErrorMessage();
                    this.getController().doActionAfter( "remove_position_errors_of_cells", { index_of_cells: index_impacted } );
                }
                param.last_modification.addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MOVE ) );
                break;
            case "apply_change_in_json":
            case "drag_n_drop_widget_stop_update_json":
                this.applyMoveInJson();
                this.applyResizeInJson();
                break;
            case "on_scroll":
                if ( this.isInPhase( [SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.EDITING] ) && param_2.isInPhase( [SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.EDITING] ) ) {
                    this.computeHtml( param_2, "", true );
                }
                return;
            case "adding_new_widget_manually":
                this.content.doActionAfter( event_name, param );
                this.resetHTML();
                this.computeHtml( param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ], param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ].dom_parent_with_scroll, param[ SHINKEN_GRID.CONST.PARAM.EVENT.ADD_DIRECTLY_TO_GRID ] );
                break;
            case "mouseover_on_deleting_pop_up":
                if ( this.uuid === param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ] ) {
                    this.askAddClass( "shinken-pulsate", 1600 );
                    DOM.Service.scrollIntoElementIfNotVisible( this.dom_element );
                }
                else {
                    this.dom_element.classList.remove( "shinken-pulsate" );
                }
                break;
            case "change__shinken_element__from_form":
                var to_return = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE );
                this.changeWidget__fully( param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_DATA ][ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ], param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ], param[ WIDGET.CONST.PARAM_EVENT.WIDGET_DATA_FROM_FORM ] );
                to_return.setNext( this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].getDataForLastModification() );
                return to_return;
            case "widgets__have_been_configured__from_form":
                return this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].doActionAfter( event_name, param );
            case "undo_last_modification":
            case "redo_last_modification":
                const modification_element         = param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_ELEMENT ];
                const correct_modification_element = event_name === "undo_last_modification" ? modification_element.getPrevious() : modification_element.getNext();
                switch ( param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_TYPE ] ) {
                    case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE:
                        this.changeWidget__fully( param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_ELEMENT ].getNextOrPrevious( event_name ), param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ] );
                        CONTROLLER.PageController.doActionAfter( "update_grid_element_in_json", {
                            [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ]: this,
                            [ SHINKEN_GRID.CONST.PARAM.GRID_CELL.INDEX ]       : param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ].grid_elements.getMappingIndex( this.getUUID() )
                        } );
                        break;
                    case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.EDIT:
                        if ( param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_ELEMENT ].getModifiedObjectParam( WIDGET.CONST.PARAM_EVENT.WIDGET_CONTAINER_KEY ) ) {
                            CONTROLLER.PageController.doActionAfter( "update_grid_element_in_json", {
                                [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ]: this,
                                [ SHINKEN_GRID.CONST.PARAM.GRID_CELL.INDEX ]       : param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ].grid_elements.getMappingIndex( this.getUUID() )
                            } );
                            return this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].doActionAfter( event_name, param );
                        }
                        //this.doActionAfter( "widgets__have_been_configured__from_form", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_DATA ]: correct_modification_element } );
                        break;
                    default:
                        this.updatePositionWithLastModification( correct_modification_element );
                        this.doActionAfter( "drag_n_drop_widget_stop_update_json" );
                        if ( correct_modification_element.list_default_values.length ) {
                            this.getController().doActionAfter( "change_value_to_default_in_json", { cell_uuid: this.getUUID(), list_property_to_change: correct_modification_element.list_default_values } );
                        }
                        break;
                }
                break;
            case "remove_error_of_widget__from_form_widget":
            case "remove_position_errors_of_cells":
                this.removeErrorsAndWarningIfNeeded();
                break;
            case "remove_position_errors_of_cells_with_uuid":
                if ( this.hasCounter[ SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ] ) {
                    let index_impacted = this.getCellIndexInPositionErrorMessage();
                    this.getController().doActionAfter( "remove_position_errors_of_cells", { index_of_cells: Object.values( index_impacted ) } );
                }
                break;
            case "update_nb_tiles_in_height":
                this.nb_tiles_in_height = param.new_nb_tiles_in_height;
                break;
            case "compute_square":
                this.computeSquare();
                break;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setUUID                       : function ( to_set ) {
        if ( !to_set && !this.uuid ) {
            to_set = SHINKEN.TOOLS.STRING.buildUUID();
        }
        this.uuid = to_set || this.uuid;
        this.addParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID, this.getUUID() );
    },
    addParamForEvents             : function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        if ( this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ] ) {
            this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].addParamForEvents( key, value );
        }
    },
    getUUID                       : function () {
        return this.uuid;
    },
    getContentNameForDeletePopup  : function () {
        return this.content.getNameToDisplay();
    },
    getContentType                : function () {
        return this.content.getType();
    },
    getContentUUID                : function () {
        if ( this.content ) {
            return this.content.getUUID();
        }
    },
    setIsOutsideOfWeatherDisplay  : function () {
        if ( this.getSquare().isOutsideOfDisplay( this.nb_tiles_in_width ) ) {
            this.addClass( "shinken-outside" );
            SHINKEN.TOOLS.NOTIFICATION.addNotification( _( "common.cant_drag_drop_out_of_window" ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR, this.dom_parent_with_scroll );
        }
        else {
            this.removeClass( "shinken-outside" );
        }
        if ( this.getDomElement() ) {
            this.getDomElement().className = this.class;
        }
    },
    getPositionCell               : function ( cell ) {
        let element               = cell || this;
        const list_default_values = [];
        if ( element[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ].getUserValue() === WEATHER.CONST.DEFAULT_VALUE ) {
            list_default_values.push( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH );
        }
        if ( element[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].getUserValue() === WEATHER.CONST.DEFAULT_VALUE ) {
            list_default_values.push( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT );
        }
        const computed_width = element.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ) === SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL
                               ? this.nb_tiles_in_width : element.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH );
        return {
            top_left_x         : element.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ),
            top_left_y         : element.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ),
            bottom_right_x     : element.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ) + computed_width,
            bottom_right_y     : element.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ) + element.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ),
            list_default_values: list_default_values
        };
    },
    getShinkenElement             : function () {
        if ( this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].getShinkenElement ) {
            return this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].getShinkenElement();
        }
    },
    getController                 : function () {
        console.shinken.debug( "TO BE OVERRIDE" );
        return null;
    },
    getWidgetType                 : function () {
        return this.content.type.getValue();
    },
    setIndexLabel                 : function ( index_value ) {
        this.index_label = "<span class='shinken-cell-label-index'>Widget " + index_value + "</span>";
    },
    setIndexLabelForced           : function ( index_label ) {
        this.index_label = index_label;
    },
    getParameterToValidateProperty: function ( current_property ) {
        let _composed_key = SHINKEN.TOOLS.STRING.splitAndJoinExceptLastOne( current_property.getName(), "." );
        let _key          = SHINKEN.TOOLS.STRING.splitForGetLastOne( current_property.getName(), "." );
        return SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this.content, _composed_key ).getValidOwnProperty( _key );
    },
    isConfigured__20241209        : function () {
        return this.getShinkenElement() && this.getShinkenElement().isConfigured();
    },
    getNameToDisplay              : function () {
        return this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].getNameToDisplay();
    },
    //********************************************  JSON  *****************************************************//
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT, "SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty"]
        ] );
    },
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE, undefined, true],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE, undefined, true],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH, SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE, [SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL, this.getDefaultValueLabel()]],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE]
        ] );
    },
    
    //********************************************  OTHERS  *****************************************************//
    isVisible   : function () {
        let _box      = this.getDisplayBox();
        let _rect     = DOM.Service.getBoundingClientRect( this.dom_parent_with_scroll );
        let _box_cell = { top: _box.top + _rect.top, bottom: _box.top + _box.height + _rect.top };
        let _box_grid = { top: _rect.top + this.dom_parent_with_scroll.scrollTop, bottom: _rect.bottom + this.dom_parent_with_scroll.scrollTop };
        
        return DOM.Service.isPartiallyVisibleIntoScrollingVerticalParent_Box( _box_cell, _box_grid );
    },
    remove      : function ( avoid_do_action, avoid_reset_counter ) {
        if ( !avoid_reset_counter ) {
            this.resetCounters();
        }
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.DELETED );
        this.resetHTML();
        if ( !avoid_do_action ) {
            this.getController().doActionAfter( "grid_cell_has_been_deleted", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]: this.getUUID() } );
        }
    },
    canBeDeleted: function () {
        return this.content.canBeDeleted();
    },
    //********************************************  COMPUTE  *****************************************************//
    computeMapping          : function ( mapping ) {
        if ( this.content && this.content.computeMapping ) {
            this.content.computeMapping( mapping );
        }
    },
    computeSizes            : function ( shinken_grid ) {
        this.updateSize( shinken_grid );
    },
    updateSize              : function ( shinken_grid ) {
        if ( !this.dom_element ) {
            return;
        }
        if ( shinken_grid ) {
            this.tile_pixel_size = shinken_grid.tile_pixel_size;
            this.font_size       = shinken_grid.font_size;
        }
        DOM.Service.setStyles( this.dom_element, this.getStyle() );
        DOM.Service.setStyle( this.dom_element_border_select_parent, DOM.CONST.STYLE.PADDING, this.padding_value );
        this._updateSize();
        if ( this.content ) {
            if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.ADDING ) ) {
                this.content.updateSize();
            }
        }
        this.removeClass( "shinken-no-opacity" );
    },
    _updateSize             : function () {
    },
    computeContentWithChange: function () {
        let _to_return = 0;
        if ( this.content ) {
            _to_return = this.content.computeContentWithChange();
        }
        return _to_return;
    },
    computeOverlapping      : function ( grid_cell ) {
        if ( this.getUUID() === grid_cell.getUUID() ) {
            return;
        }
        grid_cell.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING, this.getUUID(), this.getSquare().isOverlapping( grid_cell.getSquare() ) ? 1 : 0 );
    },
    confirmDoComputeHtml    : function () {
        return true;
    },
    
    changeWidget__fully: function ( data_widget, grid_object, data_form ) {
        this.resetCounters();
        this.resetHTML();
        this.setData( SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT, data_widget );
        if ( data_form ) {
            let data_shinken_element = {
                "item_uuid"                                   : SHINKEN.TOOLS.DICT.getValueWithComposedKey( data_form, WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY )[ SHINKEN.OBJECT.CONST.PARAM.VALUE ],
                "item_type"                                   : SHINKEN.TOOLS.DICT.getValueWithComposedKey( data_form, WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY )[ SHINKEN.OBJECT.CONST.PARAM.VALUE ],
                "context"                                     : "NOTHING",
                "item_name"                                   : SHINKEN.TOOLS.DICT.getValueWithComposedKey( data_form, WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY )[ SHINKEN.OBJECT.CONST.PARAM.VALUE ],
                "visualisation_name"                          : SHINKEN.TOOLS.DICT.getValueWithComposedKey( data_form, WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY )[ SHINKEN.OBJECT.CONST.PARAM.VALUE ],
                "sla"                                         : {
                    "value"             : "100.00",
                    "warning_threshold" : 99,
                    "critical_threshold": 97,
                    "tendency"          : "arrow-up-ok"
                },
                "status"                                      : 0,
                "exists"                                      : true,
                "element_visibility_on_not_authenticated_view": false,
                "is_not_authorized_for_user"                  : false
            };
            this.content.updateShinkenElementData( data_shinken_element );
        }
        this.computeHtml( grid_object, null, true );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
    },
    //********************************************  DRAG N DROP  *****************************************************//
    getPointBottomLeft       : function () {
        const current_grid_cell = this.ending_clone || this;
        return new SHINKEN.OBJECT.Point(
            current_grid_cell.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ),
            current_grid_cell.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ) + current_grid_cell.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ),
            "bottom_left",
            current_grid_cell.nb_tiles_in_width - current_grid_cell.getComputedWidth()
        );
    },
    getPointTopRight         : function () {
        const current_grid_cell = this.ending_clone || this;
        return new SHINKEN.OBJECT.Point(
            current_grid_cell.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ) + current_grid_cell.getComputedWidth(),
            current_grid_cell.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ),
            "top_right",
            current_grid_cell.nb_tiles_in_width
        );
    },
    getPositionsDragNDrop_X  : function () {
        let _pos_x = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].value + Math.round( this.move__delta_x / this.tile_pixel_size );
        _pos_x     = Math.max( 0, _pos_x );
        return Math.min( this.nb_tiles_in_width - this.getComputedWidth(), _pos_x );
    },
    getPositionsDragNDrop_Y  : function () {
        let _pos_y = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].value + Math.round( this.move__delta_y / this.tile_pixel_size );
        _pos_y     = Math.max( 0, _pos_y );
        return Math.min( this.nb_tiles_in_height - this.getComputedHeight(), _pos_y );
    },
    getSquare                : function () {
        if ( !this.square ) {
            this.computeSquare();
        }
        return this.square;
    },
    resetSquare              : function () {
        this.square = null;
    },
    computeSquare            : function () {
        const bottom_left_point = this.getPointBottomLeft();
        const top_right_point   = this.getPointTopRight();
        this.square             = new SHINKEN.OBJECT.Square( bottom_left_point, top_right_point, this.getUUID() );
    },
    initStartingZone         : function () {
        this.starting_clone = this.clone();
        this.starting_clone.addClass( "shinken-drag-origin-position-cell" );
        this.starting_clone.computeHtml();
        DOM.Service.insertElementBefore( this.getDomElement(), this.starting_clone.getDomElement() );
        this.starting_clone.computeSizes();
    },
    initEndingZone           : function () {
        this.ending_clone = this.clone();
        this.ending_clone.addClass( "shinken-drag-shadow-position-cell" );
        this.ending_clone.computeHtml();
        DOM.Service.insertElementBefore( this.getDomElement(), this.ending_clone.getDomElement() );
        this.ending_clone.computeSizes();
        this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING, this.ending_clone.getDomElement() );
    },
    resetMoveObject          : function () {
        if ( this.starting_clone ) {
            this.starting_clone.remove( true );
            this.starting_clone = null;
        }
        if ( this.ending_clone ) {
            this.ending_clone.remove( true );
            this.ending_clone = null;
        }
        this.computeSquare();
    },
    applyCurrentMove         : function () {
        this.setDomElementStyle( "left", this.tile_pixel_size * this.starting_clone.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ) + this.move__delta_x );
        this.setDomElementStyle( "top", this.tile_pixel_size * this.starting_clone.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ) + this.move__delta_y );
        
        this.ending_clone.position_x.setValue( this.getPositionsDragNDrop_X() );
        this.ending_clone.position_y.setValue( this.getPositionsDragNDrop_Y() );
        this.ending_clone.computeSizes();
        this.computeSquare();
    },
    rollbackResize           : function () {
        const start_position = this.getPositionCell( this.starting_clone );
        this.applyResize( start_position.top_left_x, start_position.top_left_y, start_position.bottom_right_x, start_position.bottom_right_y );
        this.applyResizeInJson( this.starting_clone );
        this.applyMoveInJson( this.starting_clone );
    },
    applyResize              : function ( parsed_to_grid_start_x, parsed_to_grid_start_y, parsed_to_grid_end_x, parsed_to_grid_end_y ) {
        let height       = Math.max( Math.abs( parsed_to_grid_start_y - parsed_to_grid_end_y ), SHINKEN_GRID.CONST.PARAM.GRID_CELL.MIN_HEIGHT );
        let width        = Math.max( Math.abs( parsed_to_grid_start_x - parsed_to_grid_end_x ), SHINKEN_GRID.CONST.PARAM.GRID_CELL.MIN_WIDTH );
        const position_x = Math.min( parsed_to_grid_start_x, parsed_to_grid_end_x );
        const position_y = Math.min( parsed_to_grid_start_y, parsed_to_grid_end_y );
        if ( position_x + width > this.nb_tiles_in_width ) {
            width = this.nb_tiles_in_width - position_x;
        }
        if ( position_y + height > this.nb_tiles_in_height ) {
            height = this.nb_tiles_in_height - position_y;
        }
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].setUserValueAndValue( position_x );
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].setUserValueAndValue( position_y );
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ].setUserValueAndValue( width );
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].setUserValueAndValue( height );
        this.updateSize();
    },
    applyMove                : function () {
        this.computeLastModificationData__fromStartingClone();
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].setValue( this.getPositionsDragNDrop_X() );
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].setValue( this.getPositionsDragNDrop_Y() );
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].setUserValue( this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].value );
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].setUserValue( this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].value );
        this.updateSize();
    },
    getNewJsonDomElementValue: function ( property_name, start_value ) {
        if ( start_value ) {
            return start_value.getValue( property_name );
        }
        else if ( this.ending_clone ) {
            return this.ending_clone.getValue( property_name );
        }
        else {
            return this.getValue( property_name );
        }
    },
    setJsonDomElementValue   : function ( property_name, start_value ) {
        const new_json_value = this.getNewJsonDomElementValue( property_name, start_value );
        this[ property_name ].setJsonDomElementValue( new_json_value );
        return new_json_value;
    },
    applyMoveInJson          : function ( start_value ) {
        if ( !this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].getJsonDomElement() ) {
            const _dom_json = document.querySelector( "#id-shinken-output-json [data-json-uuid-part='" + this.getUUID() + "']" );
            if ( _dom_json ) {
                const _dom_json_pos_x = _dom_json.parentElement.querySelector( '.shinken-value[data-key="' + SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X + '"]' );
                const _dom_json_pos_y = _dom_json.parentElement.querySelector( '.shinken-value[data-key="' + SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y + '"]' );
                this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].setJsonDomElement( _dom_json_pos_x );
                this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].setJsonDomElement( _dom_json_pos_y );
            }
        }
        
        this.setJsonDomElementValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X, start_value );
        this.setJsonDomElementValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y, start_value );
    },
    applyResizeInJson        : function ( start_value ) {
        let _dom_json = document.querySelector( "#id-shinken-output-json [data-json-uuid-part='" + this.getUUID() + "']" );
        if ( !_dom_json ) {
            return;
        }
        
        const _dom_json_width  = _dom_json.parentElement.querySelector( '.shinken-value[data-key="' + SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH + '"]' );
        const _dom_json_height = _dom_json.parentElement.querySelector( '.shinken-value[data-key="' + SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT + '"]' );
        
        if ( _dom_json_width && _dom_json_height ) {
            this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ].setJsonDomElement( _dom_json_width );
            this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].setJsonDomElement( _dom_json_height );
        }
        else {
            this.applyDefaultValues( _dom_json, start_value );
        }
        
        this.setJsonDomElementValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH, start_value );
        this.setJsonDomElementValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, start_value );
    },
    
    applyDefaultValues: function ( _dom_json, start_value ) {
        const data_to_change_default_value = [];
        
        _dom_json.querySelectorAll( 'span' ).forEach( span_element => {
            let property_name = span_element.textContent.replaceAll( '"', '' );
            if ( [SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH].includes( property_name ) ) {
                if ( span_element.parentElement.querySelector( "[data-default-value]" ) ) {
                    data_to_change_default_value.push( {
                        property_name     : property_name,
                        property_data     : this[ property_name ],
                        property_new_value: this.getNewJsonDomElementValue( property_name, start_value ),
                        dom_element       : span_element.parentElement
                    } );
                }
            }
        } );
        
        this.getController().doActionAfter( "change_default_value_to_value_in_json", {
            data_to_change_default_value: data_to_change_default_value,
            widget_type                 : this.content.type.getValue()
        } );
        
        if ( this.ending_clone ) {
            this.updateEndingCloneValues();
        }
    },
    
    updateEndingCloneValues: function () {
        this.ending_clone[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].setUserValueAndValue( this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].getValue() );
        this.ending_clone[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ].setUserValueAndValue( this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ].getValue() );
    },
    //********************************************  UPDATE DATA   **************************************************//
    setData            : function ( key, value ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT:
                this.setDataKey( key, value );
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT:
                this[ key ] = this.getChildConstructor( value );
                this[ key ].setCountersParent( this );
                this[ key ].addParamsForEvents( this.getParamForEvents() );
                this.own_children_keys.push( key );
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.UUID:
                this.setUUID( value );
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    getChildConstructor: function ( data ) {
        return new SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty( data );
    },
    //********************************************  FORM  *****************************************************//
    clone              : function () {
        const to_return                                                            = this.getCloneConstructor();
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ]                 = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].clone();
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ]                 = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].clone();
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ]                      = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ].clone();
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ]                     = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].clone();
        to_return.tile_pixel_size                                                  = this.tile_pixel_size;
        to_return.font_size                                                        = this.font_size;
        to_return.dom_parent_with_scroll                                           = this.dom_parent_with_scroll;
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]                     = this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ]                     = this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ]     = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ]     = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ];
        return to_return;
    },
    cloneFull          : function () {
        const to_return                                         = this.clone();
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ] = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].clone();
        return to_return;
    },
    getCloneConstructor: function ( data ) {
        return new SHINKEN_GRID.Cell( data );
    },
    //********************************************  HTML   **************************************************//
    computeHtml           : function ( shinken_grid, dom_parent_with_scroll, add_directly_to_grid ) {
        this.dom_parent_with_scroll = dom_parent_with_scroll || this.dom_parent_with_scroll;
        if ( this.getDomElement() ) {
            return false;
        }
        if ( !__has_edit_mode__ && this.hasIssues() ) {
            return false;
        }
        if ( shinken_grid ) {
            this.tile_pixel_size                                                  = shinken_grid.tile_pixel_size;
            this.font_size                                                        = shinken_grid.font_size;
            this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]                     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X );
            this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ]                     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y );
            this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ]     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN );
            this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ]     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX );
            this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT );
        }
        if ( !this.confirmDoComputeHtml( shinken_grid ) ) {
            return false;
        }
        if ( !add_directly_to_grid && !this.isVisible() ) {
            return false;
        }
        this.setDomElement( DOM.Service.createElement( "div", this.getAttribute() ) );
        this.content_container = DOM.Service.createElement( "div", { class: "shinken-grid-cell-container shinken-height-100" } );
        this.addDomElement( this.wrapHtmlContainer( this.content_container ) );
        if ( this.content ) {
            this.content.setDomElementParent( this.content_container );
            this.content.computeHtml( this.tile_pixel_size * this.getComputedWidth(), this.tile_pixel_size * this.height );
        }
        this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING, this.getDomElement() );
        this.setPhaseDomElement( this.getDomElement() );
        if ( add_directly_to_grid ) {
            DOM.Service.addElementTo( this.getDomElement(), shinken_grid.getDomElement() );
            this.updateSize();
        }
        return true;
    },
    computeCellMask       : function () {
        if ( this.dom_element_edition_mask ) {
            return;
        }
        this.dom_element_edition_mask               = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-grid-cell-mask-container" } ) );
        this.dom_element_border_select_parent       = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-grid-cell-border-container" } ), this.dom_element_edition_mask );
        this.dom_element_edition_mask_cursor_parent = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-grid-cell-resize-container shinken-layout-justify-between" } ), this.dom_element_edition_mask );
        DOM.Service.addResizeCursorsTo( this.dom_element_edition_mask_cursor_parent );
        
        let _delete_button_container   = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-layout-center-h-v shinken-button-container" } ), this.dom_element_edition_mask_cursor_parent );
        let _config_button_container   = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-layout-center-h-v shinken-button-container" } ), this.dom_element_edition_mask_cursor_parent );
        let _dom_element_border_select = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-grid-cell-border" } ), this.dom_element_border_select_parent );
        
        let container_bin = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-bin-container" } ), _delete_button_container );
        let bin_icon_svg  = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-bin-svg" ) );
        bin_icon_svg.classList.add( "shinken-delete-button" );
        DOM.Service.addElementTo( bin_icon_svg, container_bin );
        
        let container_cog = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-cog-container" } ), _config_button_container );
        let cog_icon_svg  = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-cog-svg" ) );
        cog_icon_svg.classList.add( "shinken-config-button" );
        DOM.Service.addElementTo( cog_icon_svg, container_cog );
    },
    wrapHtmlContainer     : function ( container ) {
        let _cell_content = DOM.Service.createElement( "div", { class: "shinken-grid-cell-content" } );
        DOM.Service.addElementTo( container, _cell_content );
        return _cell_content;
    },
    computeHtmlDeletePopup: function () {
        this.dom_element_delete_popup = DOM.Service.createElement( "div", {
            "onmouseover": "MANAGER.EventManagerV2.doActionAfter( event, 'mouseover_on_deleting_pop_up', " + this.parseParamForEventsToHtml() + ")",
            "class"      : "shinken-deleting shinken-layout-justify-between"
        } );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED );
        this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED, this.dom_element_delete_popup, "deletedActive" );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED, this.getUUID(), 1 );
        
        let type_element_to_delete = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-type-cell shinken-layout-center-v" } ), this.dom_element_delete_popup );
        DOM.Service.addElementTo( this.content.getIconTypeDom(), type_element_to_delete );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", {}, this.content.getTypeLabel() ), type_element_to_delete );
        
        let title_cell_label = this.getContentNameForDeletePopup();
        if ( !this.canBeDeleted() ) {
            title_cell_label += _( 'edit_mode.windows.tooltips.not_deletable_title' );
            this.dom_element_delete_popup.classList.add( "shinken-not-deletable-title" );
            this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED, this.getUUID(), 0 );
        }
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-title-cell shinken-layout-expand-1" }, title_cell_label ), this.dom_element_delete_popup );
        
        let shinken_action_cell = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-action-cell" } ), this.dom_element_delete_popup );
        
        let button_toggle_delete = new COMPONENT.ButtonFromData_V3( "toggle_remove_grid_cell_from_delete_list", "<span class='shinken-view-button-delete shinken-2023-broom'></span><span class='shinken-view-button-delete shinken-2023-back'></span>" );
        button_toggle_delete.addParamsForEvents( this.getParamForEvents() );
        button_toggle_delete.computeHtml();
        DOM.Service.addElementTo( button_toggle_delete.getDomElement(), shinken_action_cell );
        
        return this.dom_element_delete_popup;
    },
    getAttribute          : function () {
        const _to_return = {
            class: this.getClass(),
            style: DOM.Service.styleToHtml( this.getStyle() )
        };
        this.getUserInteraction( _to_return );
        return _to_return;
    },
    getUserInteraction    : function ( attributes ) {
        const param                 = "{'" + SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID + "' : '" + this.getUUID() + "','" + MANAGER.EVENT_MANAGER_V2.PARAM.EVENT + "' :  event}";
        attributes[ "onmousedown" ] = "MANAGER.EventManagerV2.doActionAfter(event, 'mouse_down_on_grid_cell'," + param + ")";
        attributes[ "onmouseup" ]   = "MANAGER.EventManagerV2.doActionAfter(event, 'mouse_up_on_grid_cell'," + param + ")";
    },
    getComputedWidth      : function () {
        return this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ) === SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL ? this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ] : this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH );
    },
    getComputedHeight     : function () {
        return this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ) === SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL ? this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ] : this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT );
    },
    getStyle              : function () {
        const _to_return = this.getDisplayBox();
        let _padding     = parseInt( DOM.BodyService.getWidth() * this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] / 100 );
        if ( !_to_return[ DOM.CONST.STYLE.WIDTH ] || !_to_return[ DOM.CONST.STYLE.HEIGHT ] ) {
            _padding = 0;
        }
        else {
            if ( this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] !== SHINKEN_GRID.CONST.SPECIAL_VALUE.SEPARATION_GRID_ELEMENT_MAX_UNLIMITED ) {
                _padding = Math.min( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] );
            }
            _padding = Math.max( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ] );
            
        }
        this.padding_value                    = _padding / 2;
        _to_return[ DOM.CONST.STYLE.PADDING ] = this.padding_value;
        return _to_return;
    },
    getDisplayBox         : function () {
        const _to_return                     = {};
        _to_return[ DOM.CONST.STYLE.WIDTH ]  = this.tile_pixel_size * this.getComputedWidth();
        _to_return[ DOM.CONST.STYLE.HEIGHT ] = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT );
        _to_return[ DOM.CONST.STYLE.TOP ]    = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y );
        _to_return[ DOM.CONST.STYLE.LEFT ]   = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X );
        return _to_return;
    },
    resetHTML             : function () {
        this.dom_element_edition_mask = null;
        this.resetHTMLCommon();
    },
    //********************************************  PHASE   **************************************************//
    callbackForPhase: function () {
        let current_phase = this.getCurrentPhase();
        switch ( current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.EDITING:
                this.computeCellMask();
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED, this.getUUID(), this.isPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ? 1 : 0 );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.SELECTED:
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED, this.getUUID(), this.isPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ? 1 : 0 );
                break;
        }
        this.updateSize();
    },
    //*****************************************  LAST MODIFICATION  *********************************************//
    updatePositionWithLastModification            : function ( last_modification_element ) {
        this.applyResize( last_modification_element.top_left_x, last_modification_element.top_left_y, last_modification_element.bottom_right_x, last_modification_element.bottom_right_y );
        this.computeDefaultValueInUserValue( last_modification_element.list_default_values );
        this.computeSquare();
    },
    computeDefaultValueInUserValue                : function ( list_property ) {
        list_property.forEach( property => {
            this[ property ].setUserValue( WEATHER.CONST.DEFAULT_VALUE );
            this[ property ].setJsonDomElement();
        } );
    },
    getLastModificationElement                    : function ( type_modification ) {
        let to_return;
        let data_last_modification;
        let element_modified = this;
        let previous         = null;
        let next             = null;
        switch ( type_modification ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE:
                previous = this.getDataForLastModification();
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.EDIT:
                data_last_modification                                            = this.getDataForLastModification();
                data_last_modification[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.UUID ] = this.getUUID();
                
                previous = this.last_modication_data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ];
                next     = data_last_modification[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ];
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.DELETE:
                data_last_modification                                            = this.getDataForLastModification();
                data_last_modification[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.UUID ] = this.getUUID();
                previous                                                          = data_last_modification;
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CREATE:
                data_last_modification                                            = this.getDataForLastModification();
                data_last_modification[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.UUID ] = this.getUUID();
                next                                                              = data_last_modification;
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MOVE:
                previous = this.last_modication_data;
                next     = this.getPositionCell();
                break;
            default:
                console.error( "[Cell - getLastModificationElement]", "[NOT MANAGED]", type_modification );
                break;
        }
        to_return                 = new SHINKEN.OBJECT.LastModificationElement( element_modified, previous, next );
        this.last_modication_data = null;
        return to_return;
    },
    computeLastModificationData__fromStartingClone: function () {
        this.last_modication_data = this.getPositionCell( this.starting_clone );
    },
    //********************************************  ERRORS   **************************************************//
    getCellIndexInPositionErrorMessage: function () {
        let index_of_widget_impacted = [];
        this.messages.getErrorMessages().forEach( error_msg => {
            if ( error_msg.getText().includes( _( "validation.business.grid.widget_overlapping" ).substring( 0, 30 ) ) ) {
                index_of_widget_impacted = SHINKEN.TOOLS.ARRAY.concat( index_of_widget_impacted, error_msg.getImpactedIndex() );
            }
        } );
        if ( index_of_widget_impacted ) {
            this.getController().doActionAfter( "position_errors_have_been_modified" );
        }
        return SHINKEN.TOOLS.ARRAY.removeDuplicate( index_of_widget_impacted );
    },
    removeErrorsAndWarningIfNeeded    : function () {
        if ( !this.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ) && !this.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS ) ) {
            return;
        }
        this.resetCountersByType( [SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS] );
        DOM.Service.addElementAtIndex( this.content_container, this.getDomElement(), 0 );
        DOM.Service.removeElement( this.getDomElement().querySelector( ".shinken-grid-cell-container-error" ) );
        DOM.Service.removeStyle( this.content_container, DOM.CONST.STYLE.HEIGHT );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN_GRID.BelongGridCell );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.EditableElementInterface );
