//__lib__ lib_common_V02_01
"use strict";
SHINKEN.OBJECT.AddRadioModes           = function ( name ) {
    this.init( name );
};
SHINKEN.OBJECT.AddRadioModes.prototype = {
    init: SHINKEN.OBJECT.RadioModes.init,
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "change_radio_mode_to_next":
                let _next_index = this.getNextLoopingIndex( this.getMappingIndex( this.getCurrentPhase() ) );
                this.doActionAfter( "change_radio_mode", {
                    [ SHINKEN.OBJECT.RADIOMODE.PARAM.PARENT_OBJECT ]: this.getName(),
                    [ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ]         : this.getContent( _next_index ).getUUID()
                } );
                return;
            case "mouse_move_on_grid":
                for ( let i = 0, size = this.getSize(); i < size; i++ ) {
                    this.getContent( i ).doActionAfter( event_name, param, param_2, param_3 );
                }
                return;
            case "compute_html_done":
                this.doActionAfter( "change_radio_mode_if_not_set" );
                return;
        }
        this.doActionAfterCommon( event_name, param, param_2, param_3 );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getClass: function ( to_add ) {
        return "shinken-radio-modes-content shinken-layout-wrap";
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.AddRadioModes, SHINKEN.OBJECT.RadioModes );