//__lib__ lib_common_V02_01
'use strict';

SHINKEN.OBJECT.WindowJsonEditPart           = function ( window_name, parent_name ) {
    this.__class_name__ = 'SHINKEN.OBJECT.WindowJsonEditPart';
    this.initSpecific( window_name, parent_name );
};
SHINKEN.OBJECT.WindowJsonEditPart.prototype = {
    initSpecific : function ( window_name, parent_name ) {
        this.init( window_name, parent_name );
        this.dom_element__json_preview_action = document.querySelector( ".shinken-form-action-bar-container" );
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "set_active_window":
            case "slide_panel__size__has_changed":
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING ) ) {
                    DOM.Service.addOrRemoveClasses( this.dom_element__json_preview_action.querySelector( ".shinken-action-bar-label-cell" ), true, "shinken-hidden" );
                    DOM.Service.addOrRemoveClasses( this.dom_element__json_preview_action.querySelector( ".shinken-note" ), true, "shinken-hidden" );
                    //NEEDED FOR THE COMPUTE SIZE PARENT WAS NOT IMPACTED BY CHILD ELEMENT
                    let _size = DOM.Service.getBoundingClientRect( this.dom_element__json_preview_action, DOM.CONST.STYLE.WIDTH );
                    DOM.Service.addOrRemoveClasses( this.dom_element__json_preview_action.querySelector( ".shinken-action-bar-label-cell" ), _size < 560, "shinken-hidden" );
                    DOM.Service.addOrRemoveClasses( this.dom_element__json_preview_action.querySelector( ".shinken-note" ), _size < 350, "shinken-hidden" );
                }
                return;
        }
        this.doActionAfterSpecificComma( event_name, param );
        this.doActionAfterCommon( event_name, param );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.WindowJsonEditPart, SHINKEN.OBJECT.WindowEditPartAbstract );
