//priority 25
//__lib__ lib_common_V02_01
"use strict";

WINDOW_V2.ElementFromData           = function ( window_name, parent_name ) {
    this.__class_name__ = 'WINDOW_V2.ElementFromData';
    this.initSpecific( window_name, parent_name );
    
};
WINDOW_V2.ElementFromData.prototype = {
    init        : WINDOW_V2.Element.prototype.init,
    initSpecific: function ( window_name, parent_name ) {
        this.init( window_name, parent_name );
        this.label = new COMPONENT.LabelFromData( this.getName() );
    },
    //********************************************  HTML  *****************************************************//
    getMainClass     : function () {
        return WINDOW_V2.CONST.CLASS.WINDOW_TAB + " shinken-layout-inline-center-h-v shinken-user-select-none";
    },
    computeHtml      : function () {
        this.setDomElement( DOM.Service.createElement( "div", {
            "class"                : this.getMainClass(),
            "id"                   : this.getUUID(),
            "data-group-name"      : this.getParentName(),
            "data-name"            : this.getName(),
            "data-visibility-state": this.getVisibilityState()
        } ) );
        this.main_div_dom_element = this.addDomElement( DOM.Service.createElement( "div", { "class": "shinken-div-tab shinken-layout-center-h-v" } ) );
        DOM.Service.addElementTo( this.getLabelCellHtml(), this.main_div_dom_element );
        this.doActionAfter( "compute_html_done" );
        this.computeHtml_tooltip();
        this.computeHtmlTarget();
    },
    getLabelCellHtml : function () {
        this.label.computeHtml();
        var _to_return = this.label.getDomElement();
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL, _to_return );
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, _to_return );
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, _to_return );
        return _to_return;
    },
    computeHtmlTarget: function () {
        if ( this.dom_element_target ) {
            return;
        }
        var _class = "shinken-tab-pane property-tab-pane shinken-prop-table shinken-parent-tab-id-parent";
        if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING ) ) {
            _class += " shinken-hidden";
        }
        this.dom_element_target = DOM.Service.createElement( "div", { "class": _class, "id": this.getUUID() + "-target", "data-name": this.getName() } );
        if ( this.content_dom_element_target ) {
            DOM.Service.addElementTo( this.content_dom_element_target, this.dom_element_target );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementFromData, WINDOW_V2.Element );

WINDOW_V2.ElementFromDataWithComma           = function ( window_name, parent_name ) {
    this.__class_name__ = 'WINDOW_V2.ElementFromDataWithComma';
    this.init( window_name, parent_name );
};
WINDOW_V2.ElementFromDataWithComma.prototype = {
    init         : WINDOW_V2.ElementFromData.prototype.init,
    doActionAfter: WINDOW_V2.ElementWithComma.prototype.doActionAfter
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementFromDataWithComma, WINDOW_V2.ElementFromData );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementFromDataWithComma, WINDOW_V2.ElementWithComma );
