#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from abc import abstractmethod

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.component.abstract_component import AbstractComponent

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any
    from shinkensolutions.translate.translate import TranslatePart
    
    TranslateKey = str


class AbstractTranslateComponent(AbstractComponent):
    @abstractmethod
    def init(self):
        # type: () -> None
        raise NotImplementedError()
    
    
    @abstractmethod
    def translator(self):
        # type:  () -> TranslatePart
        raise NotImplementedError()
    
    
    @abstractmethod
    def translate(self, translate_key, *args):
        # type: (TranslateKey, Any) -> str
        raise NotImplementedError()
