#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

from copy import copy
from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Optional, Any, Text


def append_to_filter(filters, to_append):
    # type: (Optional[Dict[Text,Any]], Optional[Dict[Text,Any]]) -> Optional[Dict[Text,Any]]
    if not to_append:
        return filters
    if not filters:
        return to_append

    if '$and' in to_append:
        if '$and' in filters:
            filters = copy(filters)
            filters['$and'].extend(to_append['$and'])
        else:
            if u'$or' in filters:
                filters = [filters]
            else:
                filters = [{k: v} for k, v in filters.items()]
            filters = {'$and': filters + to_append['$and']}
    else:
        if u'$and' in filters:
            filters = copy(filters)
            filters[u'$and'].append(to_append)
        elif u'$or' in filters:
            filters = {u'$and': [filters, to_append]}
        elif any(k in filters for k in to_append):
            filters = {u'$and': [{k: v} for k, v in filters.items()] + [{k: v} for k, v in to_append.items()]}
        else:
            filters = copy(filters)
            filters.update(to_append)
    return filters
