#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.

import json


class ShinkenEncoder(json.JSONEncoder):
    def default(self, obj):
        f = getattr(obj, 'to_json', None)
        if callable(f):
            return f()
        elif isinstance(obj, property):
            return obj.fget()
        return json.JSONEncoder.default(self, obj)


class JSONDecodeError(ValueError):
    pass


class ShinkenDecoder(json.JSONDecoder):
    def decode(self, s, *args, **kwargs):
        try:
            return json.JSONDecoder.decode(self, s, *args, **kwargs)
        except JSONDecodeError:
            raise
        except ValueError as e:
            raise JSONDecodeError(*e.args)
    
    
    def raw_decode(self, s, *args, **kwargs):
        try:
            return json.JSONDecoder.raw_decode(self, s, *args, **kwargs)
        except ValueError as e:
            raise JSONDecodeError(*e.args)


def dumps(obj, **kw):
    if 'cls' in kw:
        raise RuntimeError('Please do not specify cls for this json.dumps')
    return json.dumps(obj, cls=ShinkenEncoder, **kw)


def loads(obj, **kw):
    if 'cls' in kw:
        raise RuntimeError('Please do not specify cls for this json.loads')
    return json.loads(obj, cls=ShinkenDecoder, **kw)
