# !/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.
import os


class PidChangedBetweenRequest(Exception):
    pass


def raise_if_pid_changed(func):
    def wrapper(self, *args, **kwargs):
        actual_pid = os.getpid()
        if self.pid_used_to_start_connection and actual_pid != self.pid_used_to_start_connection:
            raise PidChangedBetweenRequest('pid_used_to_start = [ %s ] --- pid_used_now = [ %s ]' % (self.pid_used_to_start_connection, actual_pid))
        return func(self, *args, **kwargs)
    
    
    return wrapper
