#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#    Thibault Cohen, thibault.cohen@savoirfairelinux.com
#    Francois Mikus, fmikus@acktomic.com
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

from shinken.misc.type_hint import TYPE_CHECKING
from shinken.objects.broker.broker_item import BrokerItem
from shinken.objects.host import Host

if TYPE_CHECKING:
    from shinken.misc.type_hint import Tuple


class BrokerHost(Host, BrokerItem):
    def get_context(self):
        if not self.got_business_rule and 'disabled' in self.tags:
            return 'DISABLED', 'DISABLED'
        return super(BrokerHost, self).get_context()
    
    
    def get_ui_status(self):
        # If I'm a cluster, I will give my status
        if self.got_business_rule:
            return self.bp_state
        else:
            return super(BrokerHost, self).get_ui_status()
    
    
    def get_names(self):
        # type: () -> Tuple[str,str]
        return self.host_name, ''
