#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

ServiceMode = str  # Type for SERVICE_MODE. For type hint.


class SERVICE_MODE:
    ON = 'ON'
    NOT_OVERLOAD_BY_USER = 'NOT_OVERLOAD_BY_USER'
    OFF = 'OFF'
    
    SERVICE_MODE_VALUES = (ON, NOT_OVERLOAD_BY_USER, OFF)
    
    
    @staticmethod
    def is_enable(value):
        return value == SERVICE_MODE.ON or value == SERVICE_MODE.NOT_OVERLOAD_BY_USER
