#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any

BOOLEAN_STATES_TRUE = (True, 'true', '1')
BOOLEAN_STATES_FALSE = (False, 'false', '0')


class ToolsBoxBoolean:
    @staticmethod
    def try_parse_to_boolean(value):
        # type: (Any) -> Any
        if value == 1 or value == 0:
            return value
        if value in BOOLEAN_STATES_FALSE:
            return False
        if value in BOOLEAN_STATES_TRUE:
            return True
        
        return value
