"use strict";
SHINKEN_LIST.HeaderUIView           = function ( name, label ) {
    this.initSpecific( name, label );
};
SHINKEN_LIST.HeaderUIView.prototype = {
    initSpecific           : SHINKEN_LIST.HeaderFromDataWithSort.prototype.initSpecific,
    initSortingAvailability: function () {
        switch ( this.name ) {
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.ACTION._KEY:
                this.makeSortingUnavailable();
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderUIView, SHINKEN_LIST.HeaderFromDataWithSort );
CONTROLLER.UiPanels = (function ( self ) {
    self.controller_name    = CONTROLLER.CONST.UI_PANELS.NAME;
    self.timeout_resize     = null;
    self.current_user       = null;
    self.window_group_saver = null;
    
    self.clickOnButton        = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-apply-button":
            case "click-on-cancel-button":
            case "click-on-close-button":
            case "click-on-validate-confirmation-popup":
            case "click-on-cancel-confirmation-popup":
                self.window_group_saver.clickOnButton( event, event_name, param );
                break;
        }
    };
    self.computeSizes         = function ( event, event_name, param ) {
    };
    self.onClick              = function ( event ) {
    };
    self.doActionAfter        = function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "ask-for-pop-up-close-event":
                self.window_group_saver.doActionAfter( event_name );
                break;
            default:
                this.window_group.doActionAfter( event_name, param_1, param_2, param_3 );
                break;
        }
    };
    self.init                 = function () {
        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "controller-start-init", self.controller_name );
        self.current_view = SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.getFromParent( "current_view" ) || {};
        self.current_user = self.current_user || SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.getFromParent( "current_user" );
        if ( !self.current_user && __shinken_is_dev__ ) {
            var _success      = function ( _status, data ) {
                switch ( _status ) {
                    case COMMUNICATION.CODE.SUCCESS:
                        self.current_user.updateData( data );
                        CONTROLLER.UiPanels.init();
                        break;
                }
            };
            self.current_user = new SHINKEN.ELEMENT.UiCurrentUser();
            SHINKEN.COMUNICATION.requestGet( SHINKEN.COMUNICATION.CONST.QUERY.GET.USER.KEY, _success, null, null, null );
            return;
        }
        self._dom_container               = document.getElementById( "id-shinken-container-panels" );
        self._dom_container_loading_frame = document.getElementById( "id-shinken-container-for-loading-frame" );
        DOM.Service.addElementToAfterEmpty( SHINKEN.TOOLS.LOADING_FRAME.getDomElement( "id-shinken-loading-ui-panels" ), self._dom_container_loading_frame );
        
        self.window_group       = new WINDOW.ElementGroupUiPanel( "ui_panels_group" );
        self.window_group_saver = new SHINKEN.OBJECT.SaveUiPanels();
        self.window_group_saver.init( this );
        this.computeHtml_20240426();
        self.window_group.doActionAfter( "init_controller" );
    };
    self.getDataToSave        = function () {
        return self.window_group.getDataToSave();
    };
    self.getUrlToSave         = function () {
        return self.window_group.getUrlToSave();
    };
    self.findSetListWithData  = function ( key, data ) {
        return self.window_group.findSetListWithData( key, data );
    };
    self.computeHtml_20240426 = function () {
        self.window_group.computeHtml();
        DOM.Service.addElementTo( self.window_group.getDomElement(), self._dom_container );
        DOM.Service.addElementTo( self.window_group.getDomElementTargets(), self._dom_container );
        if ( __current_user_has_editable_right_service_weather__ ) {
            self.window_group_saver.computeHtml();
            DOM.Service.addElementTo( self.window_group_saver.dom_element, self._dom_container );
        }
        self._dom_container_loading_frame.classList.add( "shinken-hidden" );
    };
    return self;
})( CONTROLLER.UiPanels || {} );
document.addEventListener( "DOMContentLoaded", function ( e ) {
    doActionWhenDomReady();
} );
var doActionWhenDomReady = function ( e ) {
    CONTROLLER.UiPanels.init();
    window.addEventListener( "click", function ( event ) {
        if ( CONTROLLER.UiViewWeatherManager ) {
            CONTROLLER.UiViewWeatherManager.onClick( event );
        }
    } );
    document.onkeydown = function ( e ) {
        var _code = e.keyCode;
        switch ( _code ) {
            case SHINKEN.CONST.KEY_CODE.F1:
                e.preventDefault();
                break;
        }
    };
};
CONTROLLER.UiPanelsView = (function ( self ) {
    self.controller_name = CONTROLLER.CONST.UI_PANELS_VIEW.NAME;
    self._dom_container  = null;
    self.window_group    = null;
    
    self.computeSizes           = function ( event, event_name, param ) {
    };
    self.onClick                = function ( event ) {
        self.window_group.onClick( event );
    };
    self.doActionAfter           = function ( event_name, param, param_2, param_3 ) {
        this.window_group.doActionAfter( event_name, param, param_2, param_3 );
    };
    self.init                   = function () {
        self.window_group = new WINDOW.ElementGroupUiPanelView("ui_panels_view_group");
        self.computeHtml_20240427();
        self.window_group.doActionAfter( "init_controller" );
    };
    self.setParentCounter       = function ( to_set ) {
        self.window_group.setParentCounter( to_set );
    };
    self.resizeDone        = function () {
        self.window_group.resizeDone();
    };
    self.getDataToSave          = function () {
        return self.window_group.getDataToSave();
    };
    self.getUrlToSave          = function () {
        return self.window_group.getUrlToSave();
    };
    self.findSetListWithData     = function ( data ) {
        return self.window_group.findSetListWithData( data );
    };
    self.computeHtml_20240427   = function () {
        self._dom_container = document.querySelector(".shinken-parent-tab-id-parent[data-name='" + SHINKEN.UI.VIEW.WINDOWS_PANEL_TABS[0].name + "']");
        self._dom_container.classList.add("shinken-parent-event-listener");
        self._dom_container.dataset.controller = self.controller_name;
        self.window_group.computeHtml();
        DOM.Service.addElementTo( self.window_group.getDomElement(), self._dom_container );
        DOM.Service.addElementTo( self.window_group.getDomElementTargets(), self._dom_container );
    };
    return self;
})( CONTROLLER.UiPanelsView || {} );
CONTROLLER.UiViewWeatherManager = (function ( self ) {
    self.controller_name      = CONTROLLER.CONST.UI_VIEW_WEATHER_MANAGER.NAME;
    self.timeout_resize       = null;
    self.init                 = function ( parent ) {
        self.window_group = new WINDOW.ElementGroupUiPanelViewWeather( SHINKEN.UI.VIEW.TYPE.WEATHER );
        self.initSetUiViews();
        self.getDataFromBackend();
        self.computeHtml_20240428();
        self.linkCounter_20240430();
    };
    self.navigateTo           = function ( event, screen_uuid, screen_type ) {
        window.parent.CONTROLLER.UiVisualisation.navigateTo( event, screen_uuid, screen_type );
    };
    self.clickOnButton        = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-open-view-external-urls-popup":
            case "click-on-option-header-popup":
            case "click-on-header-popup":
            case "click-on-header":
            case "open_external_link":
            case "copy_external_link":
            case "click_on_pagination_btn":
            case "click-on-open-change-view-owner-popup":
            case "click-on-confirm-change-popup":
                self.set_ui_view[ this.window_group.getActiveWindow().getName() ].clickOnButton( event, event_name, param );
                break;
            case "clone-existing-view":
                self.set_ui_view[ this.window_group.getActiveWindow().getName() ].doActionAfter( event_name, param );
                break;
            default:
                console.warn( "NOT MANAGED", "[UiView - clickOnButton]", event, event_name, param );
                break;
        }
    };
    self.onClick              = function ( event ) {
        if ( self.set_ui_view ) {
            self.set_ui_view[ this.window_group.getActiveWindow().getName() ].onClick( event );
        }
        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.clickDone( event );
    };
    self.clickOnSelector      = function ( event, parent_name ) {
        self.set_ui_view[ this.window_group.getActiveWindow().getName() ].clickOnSelector( event );
        self.onClick( event );
    };
    self.clickOnInput         = function ( event ) {
        self.set_ui_view[ this.window_group.getActiveWindow().getName() ].clickOnInput( event );
    };
    self.onChangeOnInput      = function ( event ) {
        var _key_code = event.keyCode || "";
        switch ( _key_code ) {
            case SHINKEN.CONST.KEY_CODE.ENTER:
            case SHINKEN.CONST.KEY_CODE.UP:
            case SHINKEN.CONST.KEY_CODE.DOWN:
                self.doActionAfter( "on-key-down", event );
                break;
            default:
                self.set_ui_view[ this.window_group.getActiveWindow().getName() ].askComputeAfterChange( event.target );
                break;
        }
    };
    self.clickOnItemSelector  = function ( event, parent_name, element ) {
        self.set_ui_view[ this.window_group.getActiveWindow().getName() ].clickOnItemSelector( event, parent_name, element );
    };
    self.doActionAfter        = function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "onchange_in_input_V3":
            case "click_on_selector_V3":
            case "click_on_item_selector_V3":
            case "click_on_button_V3":
            case "onchange_in_input":
            case "click_on_selector":
            case "click_on_item_selector":
            case "click_on_button":
                self.set_ui_view[ this.window_group.getActiveWindow().getName() ].doActionAfter( event_name, param, param_2, param_3 );
                break;
            case "on-key-down":
                var _code = param.keyCode;
                switch ( _code ) {
                    case SHINKEN.CONST.KEY_CODE.ENTER:
                    case SHINKEN.CONST.KEY_CODE.UP:
                    case SHINKEN.CONST.KEY_CODE.DOWN:
                        self.set_ui_view[ this.window_group.getActiveWindow().getName() ].doActionAfter( "on-key-down-specific", param );
                        break;
                }
                break;
            case "click_on__window_navigation__done":
                self.set_ui_view[ this.window_group.getActiveWindow().getName() ].computeHasScrollVertical();
                break;
            case "ask-reload-data-for-current-panel":
                self.getDataFromBackend( true );
                self.doActionAfter( "ui_panel_stop_saving" );
                break;
            case "increment_original_index_from":
            case "decrement_original_index_from":
                self.set_ui_view[ this.window_group.getActiveWindow().getName() ].doActionAfter( event_name, param, param_2, param_3 );
                break;
            case "create-view-clone-in-administration":
                self.window_group.setActiveWindow( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY );
                self.set_ui_view[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY ].doActionAfter( event_name, param, param_2, param_3 );
                break;
            case "ui_panel_start_saving":
                var _keys2 = Object.keys( self.set_ui_view );
                for ( let i = 0, _size = _keys2.length; i < _size; i++ ) {
                    self.set_ui_view[ _keys2[ i ] ].setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING );
                }
                break;
            case "current_screen_has_changed":
            case "cancel_user_orders":
                var _keys = Object.keys( self.set_ui_view );
                for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
                    self.set_ui_view[ _keys[ i ] ].doActionAfter( event_name, param );
                }
                break;
            case "ui_panel_stop_saving":
                var _keys = Object.keys( self.set_ui_view );
                for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
                    self.set_ui_view[ _keys[ i ] ].setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                }
                break;
        }
    };
    self.findSetListWithData  = function ( data ) {
        var _to_return = [];
        var _keys      = Object.keys( this.set_ui_view );
        var _current_key;
        var _is_existing;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _is_existing = self.set_ui_view[ _current_key ].getLineByUUID( data.uuid );
            if ( _is_existing ) {
                _to_return.push( self.set_ui_view[ _current_key ] );
            }
        }
        return _to_return;
    };
    self.linkCounter_20240430 = function () {
        var _keys = Object.keys( self.set_ui_view );
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            switch ( _keys[ i ] ) {
                case SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY :
                    break;
                default:
                    self.window_group.getWindowByName( _keys[ i ] )
                        .setCounterParent( CONTROLLER.UiPanelsView.window_group.getWindowByName( SHINKEN.UI.VIEW.WINDOWS_VIEW_MANAGER_TABS[ 0 ].name ), SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
                    break;
            }
        }
    };
    self.getBackendDataUrl    = function () {
        return SHINKEN.HIGHWAY.getOrigin() + "/service-weather/api/V1/get-essential";
    };
    self.initSetUiViews       = function () {
        self.set_ui_view = {};
        var _name;
        var _keys        = self.window_group.getExpectedTabsFull();
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _name = _keys[ i ]._KEY;
            switch ( _name ) {
                case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY:
                    self.set_ui_view[ _name ] = new SHINKEN.UI.VIEW.SetUIViewWeatherAdministration( _name );
                    break;
                case SHINKEN.UI.VIEW.WEATHER.TABS.RUNNING._KEY:
                    self.set_ui_view[ _name ] = new SHINKEN.UI.VIEW.SetUIViewWeatherRunning( _name );
                    break;
                case SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY:
                    self.set_ui_view[ _name ] = new SHINKEN.UI.VIEW.SetUIViewWeatherDeleting( _name );
                    break;
            }
            self.set_ui_view[ _name ].setCountersParent( self.window_group.getWindowByName( _name ) );
            self.set_ui_view[ _name ].setHeaders( new SHINKEN_LIST.HeadersUIView( _keys[ i ].HEADERS, SHINKEN.UI.VIEW.WEATHER.TRAD_CONTAINER ) );
            self.set_ui_view[ _name ].setFilters( new SHINKEN_LIST.FiltersUIView( _keys[ i ].HEADERS, SHINKEN.UI.VIEW.WEATHER.TRAD_CONTAINER ) );
            self.set_ui_view[ _name ].initLines();
            self.set_ui_view[ _name ].lines.addLoadingFrame();
        }
    };
    self.setLinesWithData     = function ( data, is_update ) {
        data          = SHINKEN.TOOLS.ARRAY.sortArray( data, "name" );
        self.view_set = new SHINKEN.OBJECT.Views( data );
        self.view_set.setDelayBeforeDeletion( self.delay_before_view_deletion );
        var _keys = Object.keys( self.set_ui_view );
        var _current;
        var _lines;
        for ( var i = 0, _size_i = _keys.length; i < _size_i; i++ ) {
            _current = self.set_ui_view[ _keys[ i ] ];
            _current.computeLinesSpecific( self.view_set );
        }
    };
    self.getDataFromBackend   = function ( is_update ) {
        self.doActionAfter( "ui_panel_start_saving" );
        const _success            = ( _status, data ) => {
            switch ( data.rc ) {
                case COMMUNICATION.CODE.SUCCESS:
                    self.delay_before_view_deletion = data[ "output" ][ "views_trash" ][ "delay_before_deletion" ];
                    self.setLinesWithData( data[ "output" ][ "weathers" ], is_update );
                    break;
                default:
                    var _to_display       = DOM.Service.createElement( "div" );
                    var _complete_message = DOM.Service.addElementTo( DOM.Service.createElement( "p", {}, _( "views.manager.service_weather.backend_errors.cannot_get_weather_list" ) ), _to_display );
                    DOM.Service.addElementTo( DOM.Service.createElement( "pre", { class: "shinken-error-message-frame" }, data.output ), _complete_message );
                    self.window_group.getActiveWindow().setContentDomElementTarget( _to_display );
                    break;
            }
            self.doActionAfter( "ui_panel_stop_saving" );
        };
        var _error                = function ( _error ) {
            console.log( _( "service_weather.weathers.errors.cannot_get_weathers", [DICTIONARY_COMMON_UI] ) );
        };
        var unauthorized_callback = function ( _error ) {
            SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "raise-error-401" );
        };
        var url                   = self.getBackendDataUrl();
        SHINKEN.COMUNICATION.requestGet( url, _success, _error, null, unauthorized_callback );
    };
    self.getDataToSave        = function () {
        var _to_return = [];
        var _keys      = Object.keys( self.set_ui_view );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _to_return = SHINKEN.TOOLS.ARRAY.concat( _to_return, self.set_ui_view[ _keys[ i ] ].getDataToSave() );
        }
        return _to_return;
    };
    self.getUrlToSave         = function () {
        return "/" + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.SAVE_MANY_WEATHER;
    };
    self.resizeDone           = function () {
        self.set_ui_view[ this.window_group.getActiveWindow().getName() ].computeHasScrollVertical();
        SHINKEN_TOOLTIP.hideTooltip();
    };
    self.computeHtml_20240428 = function () {
        self.window_group.computeHtml();
        
        self._dom_container = document.querySelector( ".shinken-parent-tab-id-parent[data-name='" + SHINKEN.UI.VIEW.WINDOWS_VIEW_MANAGER_TABS[ 0 ].name + "']" );
        self._dom_container.classList.add( "shinken-parent-event-listener" );
        self._dom_container.dataset.controller = self.controller_name;
        DOM.Service.addElementToAfterEmpty( self.window_group.getDomElement(), self._dom_container );
        DOM.Service.addElementTo( self.window_group.getDomElementTargets(), self._dom_container );
        
        var _current;
        var _keys = Object.keys( self.set_ui_view );
        for ( var i = 0, _size_i = _keys.length; i < _size_i; i++ ) {
            _current = self.set_ui_view[ _keys[ i ] ];
            _current.computeHtml();
            self.window_group.setContentDomElementTarget( _current.name, _current.getDomElement() );
            switch ( _keys[ i ] ) {
                case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY:
                    DOM.Service.addElementTo( self.set_ui_view[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY ].getDomElement(), document.getElementById( "id-shinken-window-V2-window-ui-panel-weather-administration-service_weather-target" ) );
                    break;
            }
        }
    };
    return self;
})( CONTROLLER.UiViewWeatherManager || {} );
WINDOW.ElementGroupUiPanelViewWeather           = function ( group_name ) {
    this.__class_name__ = 'WINDOW.ElementGroupUiPanelViewWeather';
    this.initSpecific( group_name );
};
WINDOW.ElementGroupUiPanelViewWeather.prototype = {
    initSpecific: function ( group_name ) {
        this.init( group_name );
        this.initWithData( this.getExpectedTabs() );
        this.computeHtmlTargets( document.querySelector( ".shinken-parent-tab-id-parent[data-name='" + SHINKEN.UI.VIEW.WINDOWS_VIEW_MANAGER_TABS[ 0 ].name + "']" ) );
    },
    getExpectedTabsFull: function () {
        let to_return = [];
        if ( __current_user_has_editable_right_service_weather__ ) {
            to_return.push( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION );
            to_return.push( SHINKEN.UI.VIEW.WEATHER.TABS.DELETING );
        }
        else {
            to_return.push( SHINKEN.UI.VIEW.WEATHER.TABS.RUNNING );
        }
        return to_return;
    },
    getExpectedTabs    : function () {
        let to_return     = [];
        var expected_full = this.getExpectedTabsFull();
        for ( let i = 0, _size_i = expected_full.length; i < _size_i; i++ ) {
            to_return.push( this.getExpectedTab( expected_full[ i ], i ) );
        }
        return to_return;
    },
    getExpectedTab     : function ( data, index ) {
        let to_return                  = {};
        to_return[ "name" ]            = data._KEY;
        to_return[ "label" ]           = _( data.LABEL_TRAD_CONTAINER );
        to_return[ "controller_name" ] = CONTROLLER.CONST.UI_VIEW_WEATHER_MANAGER.NAME;
        if ( index === 0 ) {
            to_return[ "is_active" ] = true;
        }
        return to_return;
    },
    getChildConstructor: function ( window_name, parent_name ) {
        return new WINDOW_V2.ElementUIViewWeatherGeneric( window_name, parent_name );
    },
    getMainClass: function () {
        return "shinken-view-manager-navigation " + this.getClass();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroupUiPanelViewWeather, WINDOW_V2.ElementGroupFromDataWithComma );
WINDOW.ElementGroupUiPanelView           = function ( window_name ) {
    this.initSpecific( window_name );
};
WINDOW.ElementGroupUiPanelView.prototype = {
    initSpecific       : function ( window_name ) {
        this.init( window_name );
        this.initWithData( SHINKEN.UI.VIEW.WINDOWS_VIEW_MANAGER_TABS );
        this.computeHtmlTargets( document.querySelector( ".shinken-parent-tab-id-parent[data-name='" + SHINKEN.UI.VIEW.WINDOWS_PANEL_TABS[0].name + "']" ) );
    },
    getChildConstructor: function ( window_name, parent_name ) {
        switch ( window_name ) {
            case SHINKEN.UI.VIEW.WINDOWS_VIEW_MANAGER_TABS[0].name:
                return new WINDOW_V2.ElementUIViewWeather( window_name, parent_name );
            }
    },
    findSetListWithData: function ( data ) {
        if ( data.type === SHINKEN.UI.VIEW.TYPE.WEATHER ) {
            return this.getWindowByName( "weather_service" ).findSetListWithData( data );
        }
        else {
            return this.getWindowByName( data.type ).findSetListWithData( data );
        }
    },
    getDataToSave: function () {
        return { views: this.getActiveWindow().getDataToSave() };
    },
    getUrlToSave          : function () {
        return this.getActiveWindow().getUrlToSave();
    },
    getMainClass: function () {
        return "shinken-view-manager-navigation" + this.getClass();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroupUiPanelView, WINDOW_V2.ElementGroupFromDataWithComma );
WINDOW.ElementGroupUiPanel           = function ( group_name ) {
    this.initSpecific( group_name );
};
WINDOW.ElementGroupUiPanel.prototype = {
    initSpecific       : function ( group_name ) {
        this.init( group_name );
        this.initWithData( SHINKEN.UI.VIEW.WINDOWS_PANEL_TABS );
        this.computeHtmlTargets( document.getElementById( "id-shinken-container-panels" ) );
    },
    getChildConstructor: function ( window_name, parent_name ) {
        return new WINDOW.ElementUIViews( window_name, parent_name );
    },
    findSetListWithData: function ( key, data ) {
        return this.getWindowByName( key ).findSetListWithData( data );
    },
    getMainClass: function () {
        return "shinken-view-manager-navigation";
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroupUiPanel, WINDOW_V2.ElementGroupFromDataWithComma );
WINDOW_V2.ElementUIViewWeatherGeneric           = function ( name, parent_name ) {
    this.initSpecific( name, parent_name );
    
};
WINDOW_V2.ElementUIViewWeatherGeneric.prototype = {
    initSpecific             : WINDOW_V2.ElementFromDataWithComma.prototype.initSpecific,
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).setShowIfNull( true );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementUIViewWeatherGeneric, WINDOW_V2.ElementFromDataWithComma );
WINDOW_V2.ElementUIViewWeather           = function ( name, parent_name ) {
    this.__class_name__ = "WINDOW_V2.ElementUIViewWeather";
    this.init( name, parent_name );
};
WINDOW_V2.ElementUIViewWeather.prototype = {
    init             : function ( window_name, parent_name ) {
        this.initCommon( window_name, parent_name );
        this.label = new COMPONENT.LabelFromData( this.getLabel() );
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).setShowIfNull( true );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).addClass( "shinken-between-bracket" );
    },
    onClick      : function ( event ) {
        this.getController_20240426().onClick( event );
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "ask-reload-data-for-current-panel":
            case "cancel_user_orders":
            case "ui_panel_start_saving":
            case "current_screen_has_changed":
                this.getController_20240426().doActionAfter( event_name, param );
                return;
        }
        this.doActionAfterCommon( event_name, param );
    },
    getController_20240426: function () {
        return CONTROLLER.UiViewWeatherManager;
    },
    findSetListWithData   : function ( data ) {
        return this.getController_20240426().findSetListWithData( data );
    },
    getLabel: function () {
        var _img_path  = "/static/" + __static_time__ + "/ui_visualisation/img/service_weather.svg";
        var _to_return = DOM.Service.createElement( "div", {} );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-icon-container" }, '<img class="shinken-window-element-icon" src="' + _img_path + '" alt="shinken-window-weather-icon">' ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "" }, _( "views.manager.service_weather.window.name" ) ), _to_return );
        return _to_return.innerHTML;
    },
    getDataToSave: function () {
        return this.getController_20240426().getDataToSave();
    },
    getUrlToSave : function () {
        return this.getController_20240426().getUrlToSave();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW_V2.ElementUIViewWeather, WINDOW_V2.ElementFromDataWithComma );
WINDOW.ElementUIViews           = function ( window_name, parent_name ) {
    this.__class_name__ = 'WINDOW.ElementUIViews';
    this.init(window_name, parent_name);
};
WINDOW.ElementUIViews.prototype = {
    init                     : function (window_name, parent_name) {
        this.initCommon( window_name, parent_name );
        this.label = new COMPONENT.LabelFromData( _( 'views.panel.views.window.name' ));
        this.initDomViewPanelContainer();
    },
    initDomViewPanelContainer: function () {
        this.setContentDomElementTarget( DOM.Service.createElement( "div", {
            "class"          : "shinken-parent-event-listener",
            "id"             : "id-shinken-container-panels-view",
            "data-controller": CONTROLLER.CONST.UI_PANELS_VIEW.NAME
        }));
    },
    getController_20240426     : function () {
        return CONTROLLER.UiPanelsView;
    },
    findSetListWithData: function ( data ) {
        return this.getController_20240426().findSetListWithData( data );
    },
    onClick: function ( event ) {
        this.getController_20240426().onClick( event );
    },
    doActionAfter      : function ( event_name, param ) {
        
        switch ( event_name ) {
            case "cancel_user_orders":
            case "ask-reload-data-for-current-panel":
            case "ui_panel_start_saving":
            case "current_screen_has_changed":
                this.getController_20240426().doActionAfter( event_name, param  );
                return;
        }
        this.doActionAfterCommon( event_name, param );
    },
    computeLabelContainer: function () {
        var _table   = DOM.Service.createElement( "table", { "class": "shinken-width-100" } );
        var _tr      = DOM.Service.createElement( "tr", {} );
        var _td_icon = DOM.Service.createElement( "td", { "class": "shinken-window-element-icon" }, "<span class='shinicon shinicon-manage'></span>" );
        var _td_name = DOM.Service.createElement( "td", { "class": "shinken-window-element-name" }, "<span class='shinken-window-label'>" + this.getLabel() + "</span>" );
        DOM.Service.addElementTo( _td_icon, _tr );
        DOM.Service.addElementTo( _td_name, _tr );
        DOM.Service.addElementTo( _tr, _table );
        return _table;
    },
    getDataToSave: function () {
        return this.getController_20240426().getDataToSave();
    },
    getUrlToSave: function () {
        return this.getController_20240426().getUrlToSave();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementUIViews, WINDOW_V2.ElementFromDataWithComma );
SHINKEN.OBJECT.SaveUiPanels           = function () {
    this.__class_name__ = "SHINKEN.OBJECT.SaveUiPanels";
};
SHINKEN.OBJECT.SaveUiPanels.prototype = {
    init: function ( controller ) {
        this._controller = controller;
        this.initCounterCommon();
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER, "counter_user_save_ui_panels" );
        this.initPhase();
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    buildHtmlTitleConfirmationPopup  : function () {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_SAVING:
                return _( "views.panel.confirmation_popup.title_apply" );
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL:
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CLOSE:
                return _( "views.panel.confirmation_popup.title_cancel" );
        }
    },
    buildHtmlContentConfirmationPopup: function () {
        var _content       = DOM.Service.createElement( "div", {} );
        var _table         = DOM.Service.createElement( "table", { "class": "shinken-width-100" } );
        var _tr_icon       = DOM.Service.createElement( "tr", {} );
        var _td_icon       = DOM.Service.createElement( "td", {
            "class": "shinken-icon-view-cell-confirmation-popup"
        }, '<span class="shinkon shinkon-warning"></span>' );
        var _tr_text       = DOM.Service.createElement( "tr", {} );
        var _td_text       = DOM.Service.createElement( "td", { "class": "shinken-text-cell-view-confirmation-popup" } );
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_SAVING:
                _td_text.innerHTML = _( "views.panel.confirmation_popup.apply_text" );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL:
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CLOSE:
                _td_text.innerHTML = _( "views.panel.confirmation_popup.cancel_text" );
                break;
        }
        DOM.Service.addElementTo( _td_icon, _tr_icon );
        DOM.Service.addElementTo( _td_text, _tr_text );
        DOM.Service.addElementTo( _tr_icon, _table );
        DOM.Service.addElementTo( _tr_text, _table );
        DOM.Service.addElementTo( _table, _content );
        return _content;
    },
    
    _askForSave         : function () {
        this.getController_20240426().doActionAfter( "ui_panel_start_saving" );
        var _data    = this.getController_20240426().getDataToSave();
        var path     = this.getController_20240426().getUrlToSave();
        var _success = ( status, data ) => {
            this.saving_progress_bar.setParamStep( SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.BACKEND_RETURN_ANALYSE, data[ 'output' ] );
            this.saving_progress_bar.doProgress( SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.BACKEND_RETURN_ANALYSE );
        };
        var _error   = ( status, data ) => {
            this.saving_progress_bar.doProgress( SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.BACKEND_RETURN_ANALYSE, SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK, "", _( "views.manager.service_weather.backend_errors.broker_unreachable" ), _( "progress_bar.saving_failed", [DICTIONARY_COMMON_UI] ) );
        };
        SHINKEN.COMUNICATION.requestPost( path, JSON.stringify( _data ), _success, _error );
    },
    doTreatment         : function ( data ) {
        this.setMessages();
        this.computeTreatmentData( data );
        if ( this.getMessages().hasError() ) {
            var _size = Object.keys( data ).length;
            this.saving_progress_bar.doProgress(
                SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.BACKEND_RETURN_TREATMENT,
                SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK,
                "",
                this.getMessages().buildMessageGeneric(),
                SHINKEN.TOOLS.STRING.format( _( "views.panel.save.save_done_with_error" ), _size - this.getMessages().messages_error.length, _size ) );
        }
        else if ( this.getMessages().hasWarning() ) {
            this.saving_progress_bar.doProgress( SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.BACKEND_RETURN_TREATMENT );
            this.saving_progress_bar.doProgress( SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.END, SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK_WITH_WARNING, "", this.getMessages().buildMessageGeneric() );
        }
        else {
            this.saving_progress_bar.doProgress( SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.BACKEND_RETURN_TREATMENT, SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK );
        }
    },
    computeTreatmentData: function ( data ) {
        var data_action;
        var current_key;
        var current_sets;
        var _keys = Object.keys( data );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            current_key = _keys[ i ]; //ONLY "views" for the moment
            for ( var j = 0, _size_j = data[ current_key ].length; j < _size_j; j++ ) {
                data_action  = data[ current_key ][ j ];
                current_sets = this.getController_20240426().findSetListWithData( current_key, data_action );
                for ( var k = 0, _size_k = current_sets.length; k < _size_k; k++ ) {
                    if ( current_sets[ k ].updateAfterActionsDone( data_action ) ) {
                        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "action_on_view_done", data_action );
                    }
                    this.addMessages( current_sets[ k ].getMessages() );
                }
            }
        }
    },
    _doActionWhenSaveEnd: function () {
        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "ask_for_refresh_after_save" );
        this.getController_20240426().doActionAfter( "ask-reload-data-for-current-panel" );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SaveUiPanels, SHINKEN.OBJECT.ElementWindowGroupSaveObject );
SHINKEN_LIST.LineCellUIViewAction           = function ( name, value, uuid_parent, share_groups ) {
    this.name        = name;
    this.value       = value;
    this.uuid_parent = uuid_parent;
    this.share_groups = share_groups;
    this.init();
};
SHINKEN_LIST.LineCellUIViewAction.prototype = {
    init: SHINKEN_LIST.LineCellFromData.prototype.init,
    computeContentHtml__20241107: function () {
        this.dom_element_content = DOM.Service.createElement( "div", { class: "shinken-list-cell-content" }, this.label );
        var _table            = DOM.Service.addElementTo( DOM.Service.createElement( "table", { "class": "shinken-view-action-table shinken-table" } ), this.dom_element_content );
        var _tr            = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table );
        DOM.Service.addElementTo( DOM.Service.createElement( "td", {
            class    : "shinken-ui-panel-icon shinkon shinkon-undo",
            "onclick": "MANAGER.EventManagerV2.clickButton(event, 'restore-deleting-view', '" + this.uuid_parent + "')"
        } ), _tr );
    
        DOM.Service.addElementTo( DOM.Service.createElement( "td", {
            class    : "shinken-ui-panel-icon shinken-icon shinicon shinicon-copy",
            "onclick": "MANAGER.EventManagerV2.clickButton(event, 'clone-existing-view', '" + this.uuid_parent + "')"
        } ), _tr );
        DOM.Service.addElementTo( DOM.Service.createElement( "td", {
            class    : "shinken-ui-panel-icon shinken-bin-icon shinken-2023-bin",
            "onclick": "MANAGER.EventManagerV2.clickButton(event, 'delete-view', '" + this.uuid_parent + "')"
        } ), _tr );
    },
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewAction, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.LineCellUIViewCancelOrdersInForm           = function ( name ) {
    this.name = name;
    this.initSpecific();
};
SHINKEN_LIST.LineCellUIViewCancelOrdersInForm.prototype = {
    initSpecific: function () {
        this.init();
        this.initPhase();
    },
    doActionAfter: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "cancel_user_orders":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
        }
        this.doActionAfterCommon( event_name, param_1, param_2, param_3 );
    },
    computeLabel: function () {
        let button = new COMPONENT.ButtonFromData_V3( "cancel-orders-in-form-button", '<div class="shinken-view-cancel-button shinken-2023-back"></div>' );
        button.setTooltipHtml( _( "views.manager.service_weather.lines.cancel_orders_in_form.tooltip_cancel" ) );
        button.addParamsForEvents( this.getParamForEvents() );
        button.computeHtml();
        this.label = button.getDomElement().outerHTML;
    },
    getValueInternal      : function () {
        return "";
    },
    getValueForApplyFilter: function () {
        return this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ? SHINKEN_LIST.CONST.FILTER.EMPTY : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY;
    },
    getDataToSave   : function () {
        return null;
    },
    callbackForPhase: function () {
        this.setSortingValue( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ? 0 : 1 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewCancelOrdersInForm, SHINKEN_LIST.LineCellFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewCancelOrdersInForm, SHINKEN.OBJECT.PhaseInterface );
SHINKEN_LIST.LineCellUIViewCurrentOwner           = function ( name, user, parent ) {
    this.initSpecific( name, user, parent );
};
SHINKEN_LIST.LineCellUIViewCurrentOwner.prototype = {
    initSpecific: function ( name, user, parent ) {
    this.name = name;
    this.user = user;
    if ( !this.user ) {
        this.user = new SHINKEN.ELEMENT.UiUser();
    }
    this.original_user = this.user;
    this.parent        = parent;
    this.init();
        this.initPhase();
        this.setSortingValue( this.user.getName() || "" );
    },
    clickOnButton         : function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-open-change-view-owner-popup":
                if ( !this.popup_change_owner_container || this.popup_change_owner_container.classList.contains( "shinken-hidden" ) ) {
                    this.openChangeOwnerPopup();
                }
                else {
                    this.closeChangeOwnerPopup();
                }
                break;
            case "click-on-confirm-change-popup":
                this.changeUser();
                break;
        }
    },
    clickOnInput          : function ( event ) {
        this.component.clickOnInput( event );
    },
    askComputeAfterChange : function ( dom_element, parent ) {
        this.component.askComputeAfterChange( dom_element );
    },
    clickOnItemSelector   : function ( event ) {
        this.component.clickOnItemSelector( null, null, event );
        this.component.hidePopup();
    },
    onClick               : function ( event ) {
    },
    hidePopup             : function ( dom_element ) {
        if ( this.component ) {
            if ( this.component.askHidePopup( dom_element ) ) {
                this.closeChangeOwnerPopup();
            }
        }
        else {
            this.closeChangeOwnerPopup();
        }
    },
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "on-key-down-specific":
                var _parent_dom_element = DOM.Service.findParentElementWithDataSet( param_1.target, "name", 50 );
                if ( _parent_dom_element ) {
                    var _name = _parent_dom_element.dataset.name;
                    switch ( _name ) {
                        case "input_change_user":
                            this.component.keydown( param_1, param_1.keyCode );
                            break;
                    }
                }
                break;
            case "compute_html_done":
                this.setPhaseDomElement( this.getDomElement() );
                break;
            case "cancel_user_orders":
                this.user = this.original_user;
                this.changeDomElementContent();
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER, SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER, 0, this.parent );
                this.setSortingValue( this.user.getName() );
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
        }
        this.doActionAfterCommon( event_name, param_1, param_2, param_3 );
    },
    changeUser         : function () {
        this.closeChangeOwnerPopup();
        this.user = this.users_for_component.getUserByName( this.component.getValue() );
        this.changeDomElementContent();
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER, SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER, 1, this.parent );
        this.setSortingValue( this.user.getName() );
    },
    addExtraInformation: function ( key, value ) {
        this[ key ] = value;
    },
    computeHtml                : function () {
        this.computeContentHtml__20241107();
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-name": this.getUUID(), "data-uuid": this.getUUID() } ) );
        this.addDomElement( this.dom_element_content );
        this.doActionAfter( "compute_html_done" );
    },
    computeContentHtml__20241107         : function () {
        this.computeLabel();
        this.dom_element_content          = DOM.Service.createElement( "div", { "class": "shinken-list-cell-content", "data-filter": this.name } );
        var _table                        = DOM.Service.addElementTo( DOM.Service.createElement( "table", { "class": "shinken-view-owner-table shinken-table" } ), this.dom_element_content );
        var _tr                           = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table );
        var _td_1                         = DOM.Service.addElementTo( DOM.Service.createElement( "td", { "class": "shinken-view-owner-name-cell" } ), _tr );
        this.current_owner_name_container = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-view-owner-name" }, this.label ), _td_1 );
        if ( __current_user_has_editable_right_service_weather__ ) {
            var _td_2              = DOM.Service.addElementTo( DOM.Service.createElement( "td", { "class": "shinken-button-change-view-owner-cell" } ), _tr );
            var _onclick_attribute = "MANAGER.EventManager.clickOnButton(event, 'click-on-open-change-view-owner-popup', '" + this.parent.uuid + "')";
            DOM.Service.addElementTo( DOM.Service.createElement( "div", {
                "class": "shinken-button-change-view-owner shinken-user-select-none", "onclick": _onclick_attribute
            }, _( 'views.manager.service_weather.lines.change_owner.change_btn' ) ), _td_2 );
        }
        this.popup_change_owner_container = DOM.Service.createElement( "div", { "class": "shinken-change-owner-popup shinken-hidden" } );
        DOM.Service.addElementTo( this.popup_change_owner_container, this.dom_element_content );
    },
    computeHtmlChangeOwnerPopup: function () {
        var _table                = DOM.Service.createElement( "table", { "class": "shinken-width-100 shinken-table" } );
        var _tr1                  = DOM.Service.createElement( "tr", {} );
        var _tr2                  = DOM.Service.createElement( "tr", {} );
        var _td_label             = DOM.Service.createElement( "td", { "class": "shinken-change-owner-label-popup" }, _( 'views.manager.service_weather.lines.change_owner.label' ) + " :" );
        this.dom_component_select = DOM.Service.createElement( "td", { "class": "shinken-selector-container-popup" }, '<span class="fa-spin shinkon-refresh shinken-div-inline-block"></span>' );
        var _td_empty             = DOM.Service.createElement( "td", {} );
        var _td_buttons           = DOM.Service.createElement( "td", { "class": "shinken-change-owner-buttons-cell" } );
        
        DOM.Service.addElementTo( _td_label, _tr1 );
        DOM.Service.addElementTo( this.dom_component_select, _tr1 );
        DOM.Service.addElementTo( _tr1, _table );
        DOM.Service.addElementTo( _td_empty, _tr2 );
        DOM.Service.addElementTo( this._computeHtmlPopUpButton(), _td_buttons );
        DOM.Service.addElementTo( _td_buttons, _tr2 );
        DOM.Service.addElementTo( _tr2, _table );
        DOM.Service.addElementTo( _table, this.popup_change_owner_container );
    },
    _computeHtmlPopUpButton    : function () {
        var _table         = DOM.Service.createElement( "table", { "class": "shinken-width-100" } );
        var _tr            = DOM.Service.createElement( "tr", {} );
        var _td1           = DOM.Service.createElement( "td", {} );
        var _td2           = DOM.Service.createElement( "td", {} );
        var _button_change = DOM.Service.createElement( "div",
            {
                class  : "shinken-change-owner-popup-button shinken-change-owner-apply-button shinken-disabled",
                onclick: 'MANAGER.EventManager.clickOnButton(event, "click-on-confirm-change-popup", "' + this.parent.uuid + '")'
            },
            _( 'views.manager.service_weather.lines.change_owner.change_btn' )
        );
        var _button_cancel = DOM.Service.createElement( "div",
            {
                "class": "shinken-change-owner-popup-button shinken-change-owner-cancel-button",
                onclick: 'MANAGER.EventManager.clickOnButton(event, "click-on-open-change-view-owner-popup", "' + this.parent.uuid + '")'
            },
            _( 'views.manager.service_weather.lines.change_owner.cancel_btn' )
        );
        
        DOM.Service.addElementTo( _button_change, _td1 );
        DOM.Service.addElementTo( _button_cancel, _td2 );
        DOM.Service.addElementTo( _td1, _tr );
        DOM.Service.addElementTo( _td2, _tr );
        DOM.Service.addElementTo( _tr, _table );
        return _table;
    },
    initUsersList              : function () {
        this.users_for_component = new SHINKEN.ELEMENT.UiUsers();
        this.users_for_component.getDataFromBackend( this );
        this.component = new COMPONENT.InputWithDropDownChangeUSer( this );
        this.component.setPlaceholder( _( "views.manager.service_weather.lines.change_owner.label" ) );
    },
    closeChangeOwnerPopup      : function () {
        if ( !this.popup_change_owner_container ) {
            return;
        }
        this.popup_change_owner_container.classList.add( "shinken-hidden" );
    },
    computeLabel               : function () {
        this.label = this.user.getLabel( _( "views.manager.service_weather.lines.change_owner.no_specific_owner" ) );
    },
    changeDomElementContent    : function () {
        this.computeLabel();
        this.current_owner_name_container.innerHTML = this.getLabel();
    },
    getDataToSave           : function () {
        if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ) {
            return null;
        }
        return {
            "key"      : SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER,
            "user_name": this.user.getName(),
            "user_uuid": this.user.getUUID()
        };
    },
    updateAfterActionDoneOK : function ( action ) {
        this.setMessages();
        var old_name       = this.user.getName();
        this.user          = new SHINKEN.ELEMENT.UiUser( action[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY ] );
        this.original_user = this.user;
        if ( action.warnings[ 0 ] === SHINKEN.UI.VIEW.ACTIONS.ERRORS.USER_RENAMED ) {
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK_WITH_WARNING );
            DOM.Service.addTooltip( this.current_owner_name_container, {
                'shi-tip-html'     : SHINKEN.TOOLS.STRING.format( _( "views.manager.service_weather.lines.change_owner.user_name_changed_tooltip" ), this.user.getName(), old_name ),
                "shi-tip-placement": "top"
            } );
            this.addMessage( COMPONENT.CONST.STATUS.WARNING, SHINKEN.TOOLS.STRING.format( _( "views.manager.service_weather.lines.change_owner.user_name_changed_warning_message" ), old_name, this.user.getName() ) );
        }
        else {
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        }
        this.changeDomElementContent();
        this.parent.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER, SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER, 0, this.parent );
    },
    updateAfterActionDoneNOK: function ( action ) {
        this.setMessages();
        if ( action.critical[ 0 ] === SHINKEN.UI.VIEW.ACTIONS.ERRORS.WEATHER_NOT_FOUND ) {
            this.addMessage( COMPONENT.CONST.STATUS.WARNING, _( "views.manager.service_weather.lines.change_owner.weather_not_found_message" ) );
            this.parent.setPhase( SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED );
        }
        else if ( action.critical[ 0 ] === SHINKEN.UI.VIEW.ACTIONS.ERRORS.USER_NOT_FOUND ) {
            DOM.Service.addTooltip( this.current_owner_name_container, {
                'shi-tip-html'     : _( "views.manager.service_weather.lines.change_owner.user_not_found_tooltip" ),
                "shi-tip-placement": "top"
            } );
            this.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "views.manager.service_weather.lines.change_owner.user_not_found_message" ), this.user.getName() ) );
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK );
        }
    },
    getValueForApplyFilter: function () {
        return this.user.getName();
    },
    doActionAfterCall   : function ( call_name ) {
        switch ( call_name ) {
            case "SHINKEN.ELEMENT.UiUsers.getDataFromBackend":
                if ( this[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY ] &&
                     this[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY ][ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ] &&
                     this[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY ][ SHINKEN.ELEMENT.USER.PARAM.EXISTS ] ) {
                    var previous_owner_name = this[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY ][ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ];
                    this.component.addOption( {
                        name            : previous_owner_name,
                        label           : SHINKEN.TOOLS.STRING.format( _( "views.manager.service_weather.lines.change_owner.change_option_dropdown_previous_owner" ), SHINKEN.TOOLS.STRING.cleanXss( previous_owner_name ) ),
                        filtering_option: OBJECT.CONST.ELEMENT_LIST.FILTER_OPTION.IGNORED
                    } );
                }
                if ( this[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CREATOR._KEY ] &&
                     this[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CREATOR._KEY ][ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ] &&
                     this[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CREATOR._KEY ][ SHINKEN.ELEMENT.USER.PARAM.EXISTS ] ) {
                    var creator_name = this[ SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CREATOR._KEY ][ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ];
                    this.component.addOption( {
                        name            : creator_name,
                        label           : SHINKEN.TOOLS.STRING.format( _( "views.manager.service_weather.lines.change_owner.change_option_dropdown_creator" ), SHINKEN.TOOLS.STRING.cleanXss( creator_name ) ),
                        filtering_option: OBJECT.CONST.ELEMENT_LIST.FILTER_OPTION.IGNORED
                    } );
                }
                this.component.setOptionsFromArray( this.users_for_component.getDataForSelector() );
                this.component.computeHtml();
                DOM.Service.addElementToAfterEmpty( this.component.dom_element, this.dom_component_select );
                break;
        }
    },
    openChangeOwnerPopup: function () {
        DOM.Service.empty( this.popup_change_owner_container );
        this.computeHtmlChangeOwnerPopup();
        this.popup_change_owner_container.classList.remove( "shinken-hidden" );
        this.initUsersList();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewCurrentOwner, SHINKEN_LIST.LineCellFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewCurrentOwner, SHINKEN.OBJECT.PhaseInterface );
COMPONENT.InputWithDropDownChangeUSer           = function ( parent_object ) {
    this.init( parent_object );
};
COMPONENT.InputWithDropDownChangeUSer.prototype = {
    init: function ( parent_object ) {
        this.uuid      = SHINKEN.TOOLS.STRING.buildUUID();
        this.input     = new COMPONENT.InputChangeUSer( parent_object );
        this.select    = new COMPONENT.SelectFromData( COMPONENT.CONST.TYPE.SINGLE_SELECT );
        this.data_name = "input_change_user";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputWithDropDownChangeUSer, COMPONENT.InputWithDropDownFomData );
COMPONENT.InputChangeUSer           = function ( parent_object ) {
    this.__class_name__      = 'COMPONENT.InputChangeUSer';
    this.users_for_component = parent_object.users_for_component;
    this.init();
    this.initEnd( parent_object );
};
COMPONENT.InputChangeUSer.prototype = {
    initEnd                 : function ( parent_object ) {
        this.initCounters();
        this.getCounterUserSet().addTargetsDomElement( parent_object.dom_element );
    },
    validateValueInput      : function () {
        if ( this.need_validation ) {
            var _validator = new SHINKEN.OBJECT.Messages();
            if ( !this.users_for_component.existsPartially( this.getValue() ) ) {
                _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( "common.unknown_user", [DICTIONARY_COMMON_UI] ), SHINKEN.TOOLS.STRING.cleanXss( this.getValue() ) ) );
                this.setUserSet( "COMPONENT.InputChangeUSer", 0 );
            }
            else {
                this.setUserSet( "COMPONENT.InputChangeUSer", 1 );
            }
            this.setMessage( _validator );
            this.need_validation = false;
            return true;
        }
        return false;
    },
    __buildMessageForTooltip: function ( message ) {
        if ( message.hasError() ) {
            return message.messages_error[ 0 ]._text;
        }
        return "";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputChangeUSer, COMPONENT.InputFromData );
SHINKEN_LIST.LineCellUIViewViewDeletingTime           = function ( name, timestamp, uuid_parent ) {
    this.name        = name;
    this.value       = DATE_TIME.getDateToHtml( timestamp );
    this.uuid_parent = uuid_parent;
    this.initSpecific();
};
SHINKEN_LIST.LineCellUIViewViewDeletingTime.prototype = {
    initSpecific: function () {
        this.init();
        this.setSortingValue( this.value );
        this.button_delete_for_ever = new COMPONENT.ButtonFromData_V3( "delete-view-forever", "<span class='shinken-ui-panel-icon shinken-bin-icon shinken-2023-bin'></span>" );
    },
    getValueForApplyFilter: function () {
        return this.value;
    },
    getDataToSave: function () {
        return null;
    },
    computeHtml: function () {
        this.button_delete_for_ever.addParamsForEvents( this.getParamForEvents() );
        this.computeLabel();
        this.computeFilterValue();
        this.button_delete_for_ever.computeHtml();
        
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-name": this.name } ) );
        var _content = this.addDomElement( DOM.Service.createElement( "div", { "class": "shinken-list-cell-content", "data-filter": this.name } ) );
        var _table   = DOM.Service.addElementTo( DOM.Service.createElement( "table", { "class": "shinken-view-deleting-time-table shinken-table" } ), _content );
        var _tr      = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table );
        DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-list-cell-content", "data-filter": this.name }, this.label ), _tr );
        let button_container = DOM.Service.addElementTo( DOM.Service.createElement( "td" ), _tr );
        DOM.Service.addElementTo( this.button_delete_for_ever.getDomElement(), button_container );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewViewDeletingTime, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.LineCellUIEmpty           = function ( name ) {
    this.name = name;
    this.initSpecific();
};
SHINKEN_LIST.LineCellUIEmpty.prototype = {
    initSpecific: function () {
    this.init();
        this.setSortingValue( "" );
    },
    clickOnButton: function ( event, event_name, param ) {
    },
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "td",
            {
                class: "shinken-list-cell", "data-name": this.name,
                "shi-tip-placement"                    : "top"
            } ) );
        this.name_container = this.addDomElement( DOM.Service.createElement( "div", { "class": "shinken-list-cell-content", "data-filter": this.name } ) );
    },
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIEmpty, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.LineCellUIViewExternalLinks           = function ( name, value, uuid_parent ) {
    this.name        = name;
    this.value       = value;
    this.uuid_parent = uuid_parent;
    this.initSpecific();
};
SHINKEN_LIST.LineCellUIViewExternalLinks.prototype = {
    initSpecific: function () {
        this.init();
        if ( this.value ) {
            this.setSortingValue( this.value.getSize() );
        }
    },
    hasValue: function () {
        return this.value && this.value.getSize();
    },
    onClick      : function ( event ) {
        this.closeExternalUrlPopupByEvent( event );
    },
    clickOnButton: function ( event, event_name, param ) {
        var _link_uuid,
            _link;
        switch ( event_name ) {
            case "click-on-open-view-external-urls-popup":
                if ( !this.external_link_popup || this.external_link_popup.classList.contains( "shinken-hidden" ) ) {
                    this.openExternalUrlPopup( param );
                }
                else {
                    this.closeExternalUrlPopup();
                }
                break;
            case "open_external_link":
                _link_uuid = DOM.Service.findParentElementWithDataSet( event.target, "linkUuid", 10 ).dataset[ "linkUuid" ];
                _link      = this.value.getLinkByUuid( _link_uuid );
                _link.openLinkInNewTab();
                break;
            case "copy_external_link":
                _link_uuid = DOM.Service.findParentElementWithDataSet( event.target, "linkUuid", 10 ).dataset[ "linkUuid" ];
                _link      = this.value.getLinkByUuid( _link_uuid );
                _link.copyLinkToClipboard( event.target );
                break;
        }
    },
    hidePopup    : function () {
        this.closeExternalUrlPopup();
    },
    computeHtml                 : function () {
        this.computeHtmlExternalUrlButton();
        this.dom_element = DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-name": this.name } );
        if ( this.hasValue() ) {
            this.addDomElement( this.external_link_container );
        }
    },
    computeHtmlExternalUrlButton: function () {
        if ( !this.hasValue() ) {
            return;
        }
        var _onclick_attribute       = 'MANAGER.EventManager.clickOnButton(event, "click-on-open-view-external-urls-popup", "' + this.uuid_parent + '")';
        var links_number             = this.value ? this.value.getSize() : 0;
        var _plural                  = links_number > 1 ? "s" : "";
        var _label                   = links_number + " " + _( "views.manager.service_weather.lines.external_links.label_btn" ) + _plural;
        this.external_link_container = DOM.Service.createElement( "div", { "class": "shinken-list-cell-content", "data-filter": this.name } );
        this.external_link_button    = DOM.Service.createElement( "div", { "class": "shinken-view-external-url-button shinken-user-select-none", "onclick": _onclick_attribute } );
        var _table                   = DOM.Service.createElement( "table", { "class": "shinken-view-external-url-button-table shinken-table" } );
        var _tr                      = DOM.Service.createElement( "tr" );
        
        DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-view-external-url-icon-cell" }, "<span class='shinken-2023-external-link'></span>" ), _tr );
        DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-view-external-url-nb-urls-cell" }, _label ), _tr );
        DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-view-external-url-dropdown-icon-cell" }, "<span class='shinken-2023-arrow-down'></span>" ), _tr );
        
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, this.external_link_button );
        DOM.Service.addElementTo( this.external_link_button, this.external_link_container );
    },
    buildHtmlExternalUrlPopup   : function ( weather_uuid ) {
        this.external_link_popup = DOM.Service.createElement( "div", { "class": "shinken-weather-external-links-container" } );
        var _table               = DOM.Service.createElement( "table", { "class": "shinken-external-links-table" }, this.value.buildHtml( weather_uuid ) );
        DOM.Service.addElementTo( _table, this.external_link_popup );
    },
    openExternalUrlPopup        : function ( weather_uuid ) {
        if ( !this.external_link_popup ) {
            this.buildHtmlExternalUrlPopup( weather_uuid );
            DOM.Service.addElementTo( this.external_link_popup, this.external_link_container );
        }
        this.external_link_popup.classList.remove( "shinken-hidden" );
    },
    closeExternalUrlPopupByEvent: function ( event ) {
        var _container = DOM.Service.findParentElementWithClass( event.target, "shinken-weather-external-links-container", 20 );
        var _button    = DOM.Service.findParentElementWithClass( event.target, "shinken-view-external-url-button", 20 );
        if ( !_container && !_button ) {
            this.closeExternalUrlPopup();
        }
        else if ( this.external_link_popup !== _container && this.external_link_button !== _button ) {
            this.closeExternalUrlPopup();
        }
    },
    closeExternalUrlPopup       : function () {
        if ( !this.external_link_popup ) {
            return;
        }
        this.external_link_popup.classList.add( "shinken-hidden" );
    },
    getValueForApplyFilter      : function () {
        return this.value.getSize() ? SHINKEN_LIST.CONST.FILTER.NOT_EMPTY : SHINKEN_LIST.CONST.FILTER.EMPTY;
    },
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewExternalLinks, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.LineCellUIViewName           = function ( name, screen_name, screen_uuid, screen_type ) {
    this.name        = name;
    this.value       = screen_name;
    this.screen_uuid = screen_uuid;
    this.screen_type = screen_type;
    this.initSpecific();
};
SHINKEN_LIST.LineCellUIViewName.prototype = {
    initSpecific: function () {
        this.init();
        this.setSortingValue( this.value );
    },
    computeLabel           : function () {
        this.label = '<div class="shinken-view-name shinken-link" onMouseUp="CONTROLLER.UiViewWeatherManager.navigateTo(event, \'' + this.screen_uuid + '\',\'' + this.screen_type + '\' )">' + SHINKEN.TOOLS.STRING.cleanXss( this.value ) + '</div>';
    },
    computeLabelWithoutLink: function () {
        this.label = '<div class="shinken-view-name shinken-link">' + SHINKEN.TOOLS.STRING.cleanXss( this.value ) + '</div>';
    },
    getViewName            : function () {
        return this.value;
    },
    getCloneName           : SHINKEN.OBJECT.View.prototype.getCloneName,
    computeHtml: function () {
        this.computeLabel();
        this.computeFilterValue();
        this.setDomElement( DOM.Service.createElement( "td",
            {
                class: "shinken-list-cell", "data-name": this.name,
                "shi-tip-placement"                    : "top"
            } ) );
        this.name_container = this.addDomElement( DOM.Service.createElement( "div", { "class": "shinken-list-cell-content", "data-filter": this.name } ) );
        var _table          = DOM.Service.addElementTo( DOM.Service.createElement( "table", { "class": "shinken-table" } ), this.name_container );
        var _tr             = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table );
        DOM.Service.addElementTo( DOM.Service.createElement( "td", {}, this.label ), _tr );
        if ( __current_user_has_editable_right_service_weather__ ) {
            let button_history = new COMPONENT.ButtonFromData_V2( "show-history", "<span class='shinkon-clock'></span>" );
            button_history.setOnClickEvent( "MANAGER.EventManagerV2.clickButtonV2(event, 'show-history', '" + this.screen_uuid + "')" );
            button_history.computeHtml();
            let td = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-ui-panel-icon" } ), _tr );
            DOM.Service.addElementTo( button_history.getDomElement(), td );
        }
    },
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewName, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.LineCellUIViewNameInput           = function ( name, screen_name, parent_uuid ) {
    this.initSpecific__20240903( name, screen_name, parent_uuid );
};
SHINKEN_LIST.LineCellUIViewNameInput.prototype = {
    initSpecific__20240903: function ( name, screen_name, parent_uuid ) {
        this.name  = name;
        this.value = screen_name || _( 'screens.new-service-weather' );
        this.initSpecific();
        this.addParamForEvents( SHINKEN_LIST.CONST.PARAM.LINE_UUID, parent_uuid );
        this.addParamForEvents( SHINKEN_LIST.CONST.PARAM.CELL_UUID, this.name );
        this.component_input = new COMPONENT.InputFromData_V3( PROPERTY.COMMON.INPUT.MAIN_INPUT, this.value, this.getParamForEvents() );
        this.component_input.setPlaceholder( _( "views.manager.service_weather.filter.placeholder." + this.name ) );
    },
    computeLabel: function () {
        this.label = this.value;
    },
    doActionAfter        : function ( event_name, param ) {
        switch ( event_name ) {
            case "click_on_button_V3":
            case "onchange_in_input_V3":
                this.component_input.doActionAfter( event_name, param );
                return;
        }
        this.doActionAfterCommon( event_name, param );
    },
    clickOnInput         : function ( event ) {
        this.component_input.clickOnInput( event );
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        this.component_input.askComputeAfterChange();
    },
    setValueFromJs       : function ( to_set ) {
        this.component_input.setValueFromJs( to_set );
    },
    doActionAfterChange  : function () {
        this.setSortingValue( this.component_input.getValue() );
        this.setValue( this.component_input.getValue() );
    },
    computeHtml: function () {
        this.component_input.computeHtml();
        this.computeLabel();
        this.computeFilterValue();
        this.setDomElement( DOM.Service.createElement( "td",
            {
                class: "shinken-list-cell", "data-name": this.getUUID(), "data-uuid": this.getUUID(), "shi-tip-placement": "top"
            } ) );
        this.name_container = this.addDomElement( DOM.Service.createElement( "div", { "class": "shinken-list-cell-content", "data-filter": this.name } ) );
        var _div            = DOM.Service.addElementTo( DOM.Service.createElement( "div" ), this.name_container );
        DOM.Service.addElementTo( this.component_input.getDomElement(), _div );
    },
    getDataToSave: function () {
        return this.component_input.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewNameInput, SHINKEN_LIST.LineCellUIViewName );
SHINKEN_LIST.LineCellUIViewNotifications           = function ( name, notifications ) {
    this.name          = name;
    this.notifications = notifications;
    this.value         = null;
    this.initSpecific();
};
SHINKEN_LIST.LineCellUIViewNotifications.prototype = {
    initSpecific: function () {
    this.init();
        this.computeSortingValue();
    },
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-name": this.name } ) );
        this.label   = DOM.Service.createElement( "div", { "class": "shinken-list-cell-content", "data-filter": this.name } );
        var div      = DOM.Service.createElement( "div", { class: "shinken-list-cell-notifications-icons-container" } );
        var _keys    = Object.keys( this.notifications );
        var _current_key;
        var _has_any = false;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            var div_to_add;
            var _class   = "shinken-list-cell-notifications-content " + _current_key;
            var to_add;
            switch ( _current_key ) {
                case "notifications_visual":
                    if ( this.notifications.notifications_visual.blink.enabled ) {
                        div_to_add = DOM.Service.createElement( "div", { class: "shinken-list-cell-notifications-icon-container" } );
                        to_add     = DOM.Service.createElement( "img", { class: _class, src: "/static/" + __SHINKEN_HTTP_START_TIME__ + "/images/form/blink_icon.svg" } );
                    }
                    break;
                case "notifications_sound" :
                    if ( this.notifications.notifications_sound.enabled ) {
                        div_to_add = DOM.Service.createElement( "div", { class: "shinken-list-cell-notifications-icon-container" } );
                        to_add     = DOM.Service.createElement( "img", { class: _class, src: "/static/" + __SHINKEN_HTTP_START_TIME__ + "/images/form/enabled_sound_icon.svg" } );
                    }
                    break;
            }
            if ( to_add ) {
                _has_any = true;
                DOM.Service.addElementTo( to_add, div_to_add );
                DOM.Service.addElementTo( div_to_add, div );
            }
        }
        if ( _has_any ) {
            DOM.Service.addElementTo( div, this.label );
        }
        this.addDomElement( this.label );
        
    },
    
    getValueForApplyFilter: function () {
        var values = [];
        if ( this.notifications.notifications_sound.enabled ) {
            values.push( "AUDIO" );
        }
        if ( this.notifications.notifications_visual.blink.enabled ) {
            values.push( "VISUAL" );
        }
        if ( values.length !== 0 ) {
            return values;
        }
        return SHINKEN_LIST.CONST.FILTER.EMPTY;
    },
    computeSortingValue: function () {
        this.sorting_value = 0;
        if ( this.notifications.notifications_visual.blink.enabled ) {
            this.sorting_value = 1;
        }
        if ( this.notifications.notifications_sound.enabled ) {
            this.sorting_value = 2;
        }
        if ( this.notifications.notifications_sound.enabled && this.notifications.notifications_visual.blink.enabled ) {
            this.sorting_value = 3;
        }
    }
    
    
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewNotifications, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.LineCellUIViewProblems           = function ( name, value, parent, header ) {
    this.name  = name;
    this.value = {};
    this.init( value, parent, header );
};
SHINKEN_LIST.LineCellUIViewProblems.prototype = {
    init             : function ( value, parent, header ) {
        this.initCommon( header );
        this.setValue( value );
    },
    initCounterCommon: function ( header ) {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        MANAGER.__instance_counter_distributorV2.setParentCounter( "counter_total__list_ui_view__header_problem", this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ) );
    },
    doActionAfter: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "do_action_after_filter_change":
                this.countersShowForParent( !param_1 );
                break;
            
        }
        this.doActionAfterCommon( event_name, param_1, param_2, param_3 );
    },
    getValueForApplyFilter: function () {
        return this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ] + this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] ? SHINKEN_LIST.CONST.FILTER.NOT_EMPTY : SHINKEN_LIST.CONST.FILTER.EMPTY;
    },
    computeHtmlTooltip: function () {
        var _table              = DOM.Service.createElement( "table", { "class": "shinken-view-problems-tooltip" } );
        var _tr_error           = DOM.Service.createElement( "tr", {} );
        var _tr_warning         = DOM.Service.createElement( "tr", {} );
        var _td_error_label     = DOM.Service.createElement( "td", { "class": "shinken-tooltip-problems-error-label" }, _( "views.manager.service_weather.lines.weather_problems.error_label" ) );
        var _td_error_counter   = DOM.Service.createElement( "td", {} );
        var _td_warning_label   = DOM.Service.createElement( "td", { "class": "shinken-tooltip-problems-warning-label" }, _( "views.manager.service_weather.lines.weather_problems.warning_label" ) );
        var _td_warning_counter = DOM.Service.createElement( "td", {} );
        var _counter_error      = DOM.Service.createElement( "span", { "class": "shinken-error-counter shinken-counter" }, "<span class='shinken-counter-label'>" + this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ] + "</span>" );
        var _counter_warning    = DOM.Service.createElement( "span", { "class": "shinken-warning-counter shinken-counter" }, "<span class='shinken-counter-label'>" + this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] + "</span>" );
        
        if ( this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ] ) {
            DOM.Service.addElementTo( _counter_error, _td_error_counter );
            DOM.Service.addElementTo( _td_error_label, _tr_error );
            DOM.Service.addElementTo( _td_error_counter, _tr_error );
            DOM.Service.addElementTo( _tr_error, _table );
        }
        
        if ( this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] ) {
            DOM.Service.addElementTo( _counter_warning, _td_warning_counter );
            DOM.Service.addElementTo( _td_warning_label, _tr_warning );
            DOM.Service.addElementTo( _td_warning_counter, _tr_warning );
            DOM.Service.addElementTo( _tr_warning, _table );
        }
        
        return _table.outerHTML;
    },
    computeLabel      : function () {
        if ( !this._hasProblem() ) {
            this.label = "";
            return;
        }
        var _label = DOM.Service.createElement( "div", {
            "class"       : "shinken-view-problems",
            "onmouseenter": "SHINKEN_TOOLTIP.showTooltip(this)",
            "onmouseleave": "SHINKEN_TOOLTIP.hideTooltip()",
            "shi-tip-type": SHINKEN_TOOLTIP.TYPE.OFF_WHITE_ON_BLACK
        }, '<span class="shinken-problems-icon shinkon shinkon-warning-circle-lite"></span><span class="shinken-label">' + _( "views.manager.service_weather.lines.weather_problems.label" ) + '</span>' );
        DOM.Service.addAttribute( _label, "shi-tip-html", this.computeHtmlTooltip() );
        this.label = _label.outerHTML;
    },
    _hasProblem       : function () {
        return !!(this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ] + this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ]);
    },
    setValue          : function ( data ) {
        this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ]   = data[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ];
        this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] = data[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ];
        this.setSortingValue( this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ] * 1000 + this.value[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, "view_problems_error", this._hasProblem() ? 1 : 0 );
    },
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewProblems, SHINKEN_LIST.LineCellFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewProblems, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN_LIST.LineCellUIViewShares           = function ( name, value ) {
    this.name  = name;
    this.value = value;
    this.initSpecific();
};
SHINKEN_LIST.LineCellUIViewShares.prototype = {
    initSpecific           : function () {
    this.init();
        this.setSortingValue( this.value );
    },
    computeLabel: function () {
        this.label = this.getValueInternal() ? "<div class='shinken-number-share'>" + this.value + "<span class='shinkon shinkon-url-links'></span></div>" : "";
    },
    getValueInternal      : function () {
        return this.value;
    },
    getValueForApplyFilter: function () {
        return this.getValueInternal() || SHINKEN_LIST.CONST.FILTER.EMPTY;
    },
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewShares, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.LineCellUIViewUser           = function ( name, user ) {
    this.initSpecific( name, user );
};
SHINKEN_LIST.LineCellUIViewUser.prototype = {
    initSpecific: function ( name, user ) {
        this.name = name;
        this.user = user;
        if ( !this.user ) {
            this.user = new SHINKEN.ELEMENT.UiUser();
        }
        this.original_user = this.user;
        this.init();
        this.initPhase();
        this.setSortingValue( this.user.getName() || "" );
    },
    doActionAfter: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "compute_html_done":
                this.setPhaseDomElement( this.getDomElement() );
                break;
            case "cancel_user_orders":
                this.user = this.original_user;
                this.changeDomElementContent();
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
        }
        this.doActionAfterCommon( event_name, param_1, param_2, param_3 );
    },
    clickOnButton: function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-confirm-change-popup":
                this.user = param.original_user;
                this.changeDomElementContent();
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                break;
        }
    },
    getDataToSave          : function () {
        return null;
    },
    updateAfterActionDoneOK: function ( action ) {
        this.setMessages();
        switch ( action.key ) {
            case SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER :
                this.user                                                                    = new SHINKEN.ELEMENT.UiUser( action[ this.name ] );
                this.original_user                                                           = this.user;
                this.label                                                                   = this.user.getLabel();
                this.getDomElement().querySelector( ".shinken-list-cell-content" ).innerHTML = this.label;
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
        }
    },
    getValueForApplyFilter: function () {
        return this.user.getName();
    },
    computeLabel: function () {
        this.label = this.user.getLabel();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewUser, SHINKEN_LIST.LineCellFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewUser, SHINKEN.OBJECT.PhaseInterface );
SHINKEN_LIST.LineCellUIViewViewBehaviourPhase           = function ( name, view_behaviour_phase ) {
    this.name  = name;
    this.view_behaviour_phase = view_behaviour_phase; //SEEMS USELESS
    this.value = view_behaviour_phase.getCurrentPhase();
    this.initSpecific();
};
SHINKEN_LIST.LineCellUIViewViewBehaviourPhase.prototype = {
    initSpecific           : function () {
    this.init( );
        this.setSortingValue( this.value );
    },
    computeLabel           : function () {
        this.label = _( 'views.view_behaviour.' + this.getValue() );
    },
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellUIViewViewBehaviourPhase, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.HeaderProblemsUIView           = function ( name, label ) {
    this.initSpecific( name, label );
};
SHINKEN_LIST.HeaderProblemsUIView.prototype = {
    initSpecific     : SHINKEN_LIST.HeaderUIView.prototype.initSpecific,
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL, "counter_total__list_ui_view__header_problem" );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).setShowIfNull( true );
    },
    addHtmlCounters: function ( dom_element_parent ) {
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).computeHtml();
        this.dom_counter_cell = DOM.Service.createElement( "td", { class: "shinken-list-header-counters-cell" } );
        DOM.Service.addElementTo( this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).getDomElement(), this.dom_counter_cell );
        DOM.Service.addElementTo( this.dom_counter_cell, dom_element_parent );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderProblemsUIView, SHINKEN_LIST.HeaderUIView );
SHINKEN_LIST.FilterUIView           = function ( type, name ) {
    this.type = type;
    this.name = name;
    this.init();
};
SHINKEN_LIST.FilterUIView.prototype = {
    init          : function () {
        this.initComponents();
    },
    initComponents: function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component = new COMPONENT.SelectFromData( this.type );
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT:
                this.component = new COMPONENT.InputFromData();
                this.component.setPlaceholder( _( "views.manager.service_weather.filter.placeholder." + this.name ) );
                break;
            case COMPONENT.CONST.TYPE.INPUT_STRING_ARRAY:
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FilterUIView, SHINKEN_LIST.FilterFromData );
SHINKEN_LIST.FiltersUIView           = function ( headers_array, trad_key ) {
    this.trad_key = trad_key;
    this.init( headers_array );
};
SHINKEN_LIST.FiltersUIView.prototype = {
    init                : function ( headers_array ) {
        this.initContents();
        var _keys = Object.keys( headers_array );
        var _current_value;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_value = headers_array[ _keys[ i ] ];
            var _to_add    = new SHINKEN_LIST.FilterUIView( _current_value.FILTER_TYPE, _current_value._KEY );
            if ( _current_value.FILTER_TYPE === COMPONENT.CONST.TYPE.SINGLE_SELECT ) {
                _to_add.getComponent().setOptionsFromArray( this.computeFilterOptions( _current_value ) );
            }
            this.add( _to_add );
        }
    },
    computeFilterOptions: function ( header_info ) {
        var _to_return = [];
        var _keys      = Object.keys( header_info.FILTER_OPTIONS );
        var _current_key;
        var _to_add;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key       = _keys[ i ];
            _to_add            = { "name": header_info.FILTER_OPTIONS[ _current_key ] };
            _to_add[ 'label' ] = _( this.trad_key + ".filter.options." + header_info._KEY + "." + header_info.FILTER_OPTIONS[ _current_key ] );
            if ( !i ) {
                _to_add[ 'is_selected' ] = true;
            }
            _to_return.push( _to_add );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FiltersUIView, SHINKEN_LIST.FiltersFromData );
SHINKEN_LIST.HeadersUIView           = function ( headers_array, trad_key ) {
    this.trad_key = trad_key;
    this.init(headers_array);
};
SHINKEN_LIST.HeadersUIView.prototype = {
    init         : function (headers_array) {
        this.initContents();
        let _keys = Object.keys( headers_array );
        let _current_value;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_value = headers_array[ _keys[ i ] ];
            switch ( _current_value._KEY ) {
                case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PROBLEMS._KEY:
                    this.add( new SHINKEN_LIST.HeaderProblemsUIView( _current_value._KEY, _( this.trad_key + ".headers." + _current_value._KEY ) ) );
                    break;
                case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.ACTION._KEY:
                    this.add( new SHINKEN_LIST.HeaderUIView( _current_value._KEY, _( this.trad_key  + ".headers." + _current_value._KEY ) ) );
                    break;
                default:
                    this.add( new SHINKEN_LIST.HeaderUIView( _current_value._KEY, _( this.trad_key  + ".headers." + _current_value._KEY ) ) );
                    break;
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeadersUIView, SHINKEN_LIST.HeadersWithSortFromData );
SHINKEN_LIST.LineUIView           = function ( view_object, headers ) {
    this.__class_name__ = "SHINKEN_LIST.LineUIView";
    this.initSpecific( view_object, headers );
};
SHINKEN_LIST.LineUIView.prototype = {
    initSpecific             : function ( view_object, headers ) {
        this.unused_data = {};
        this.initCommon();
        this.setUUID( view_object.getUUID() );
        this.initLineCountersValue();
        this.initCellsValue( view_object, headers );
        this.initInformationForEdition( headers );
    },
    initCounterCommon        : function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
        MANAGER.__instance_counter_distributorV2.setParentCounter( "counter_user_save_ui_panels", this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER ) );
    },
    initInformationForEdition: function ( headers ) {
        var cell_current_owner = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY );
        if ( cell_current_owner ) {
            var cell_previous_owner = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY );
            if ( cell_previous_owner ) {
                cell_current_owner.addExtraInformation( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY, cell_previous_owner.user );
            }
            var cell_creator = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CREATOR._KEY );
            if ( cell_creator ) {
                cell_current_owner.addExtraInformation( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CREATOR._KEY, cell_creator.user );
            }
        }
    },
    initCellsValue           : function ( view_object, headers ) {
        for ( var i = 0, _size_i = headers.contents.length; i < _size_i; i++ ) {
            this.addWithFactory( headers.contents[ i ], view_object );
        }
    },
    addWithFactory           : function ( current_header, view_object ) {
        let current_key = current_header.name;
        switch ( current_key ) {
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CANCEL_ORDERS_IN_FORM._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewCancelOrdersInForm( current_key ) );
                break;
            case  SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.SHARES._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewShares( current_key, view_object.getShareNumber() ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NAME._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewName( current_key, view_object.getName(), view_object.getUUID(), view_object.getType() ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PROBLEMS._KEY :
                this.addSpecific( new SHINKEN_LIST.LineCellUIViewProblems( current_key, view_object.getProblems(), this, current_header ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewCurrentOwner( current_key, view_object.getOwner(), this ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewUser( current_key, view_object.getPreviousOwner() ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CREATOR._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewUser( current_key, view_object.getCreator() ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.EXTERNAL_LINKS._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewExternalLinks( current_key, view_object.external_links, this.uuid ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NOTIFICATIONS._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewNotifications( current_key, view_object.notifications ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.ACTION._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewAction( current_key, "", this.uuid ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.VIEW_BEHAVIOUR._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewViewBehaviourPhase( current_key, view_object.getViewBehaviourPhase() ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.DELETING.HEADERS.DELETING_TIME._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewViewDeletingTime( current_key, view_object.getViewDeletionTime(), this.uuid ) );
                break;
            default :
                break;
        }
    },
    clickOnButton                  : function ( event, event_name, param ) {
        if ( this.clickOnButton_lvl_1( event, event_name, param ) ) {
            return;
        }
        switch ( event_name ) {
            case "click-on-open-view-external-urls-popup":
                this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.EXTERNAL_LINKS._KEY ).clickOnButton( event, event_name, this.uuid );
                break;
            case "click_on_pagination_btn":
                this.current_history_view.doActionAfter( event_name, param );
                break;
            case "click-on-confirm-change-popup":
                var previous_owner = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY );
                var current_owner  = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY );
                previous_owner.clickOnButton( event, event_name, current_owner );
                current_owner.clickOnButton( event, event_name, param );
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                break;
            case "click-on-open-change-view-owner-popup":
                this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY ).clickOnButton( event, event_name, param );
                break;
            case "open_external_link":
            case "copy_external_link":
                this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.EXTERNAL_LINKS._KEY ).clickOnButton( event, event_name, param );
                break;
        }
    },
    clickOnButton_lvl_1            : function ( event, event_name, param ) {
        return false;
    },
    doActionAfter                  : function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_selector_V3":
            case "click_on_item_selector_V3":
                if ( param[ SHINKEN.OBJECT.VIEW_HISTORY.PARAM.NAME ] === this.getUUID() ) {
                    this.current_history_view.doActionAfter( event_name, param );
                    return;
                }
                break;
            case "click_on_button_V3":
                if ( param[ SHINKEN.OBJECT.VIEW_HISTORY.PARAM.NAME ] === this.getUUID() ) {
                    this.current_history_view.doActionAfter( event_name, param );
                    return;
                }
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "delete-view-forever":
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED_FOREVER );
                        return;
                    case "cancel-orders-in-form-button":
                        this.doActionAfter( "cancel_user_orders", param );
                        break;
                }
                break;
            case "on-key-down-specific":
                this.getContentByEvent( param ).doActionAfter( event_name, param );
                break;
            case "history_backend_loaded_done":
                this.current_history_view.computeHtml();
                DOM.Service.addElementToAfterEmpty( this.current_history_view.getDomElement(), this.dom_element_bind_container );
                this.dom_element_bind.classList.remove( "shinken-hidden" );
                break;
            case "click_on_selector":
            case "click_on_item_selector":
                this.current_history_view.doActionAfter( event_name, param, param_2, param_3 );
                break;
            case "click_on_button":
                switch ( param ) {
                    case "delete-view":
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED );
                        break;
                    case "cancel-orders-in-form-button":
                        this.doActionAfter( "cancel_user_orders" );
                        this.doActionAfterSpecific__20240909( "cancel_user_orders_specific", param );
                        break;
                    case "show-history":
                        this.displayHistoryData( param_2 );
                        break;
                }
                break;
            case "current_screen_has_changed":
                DOM.Service.addOrRemoveClasses(this.dom_element,  param === this.uuid ,"shinken-view-is_current_view");
                break;
            case "onchange_in_input":
                const line_cell = this.getContentByUUID( param );
                line_cell.askComputeAfterChange();
                break;
            case "clean_input_value":
                const line_cell_to_update = this.getContentByUUID( param );
                line_cell_to_update.setValueFromJs( "" );
                break;
            
        }
        this.doActionAfterCommon( event_name, param, param_2, param_3 );
    },
    getDomElementBind: function () {
        return this.dom_element_bind;
    },
    computeHtml: function () {
        let _selector_css_for_tooltip = '.shinken-list-cell[data-name="name"]';
        this.dom_element              = DOM.Service.createElement( "tr", {
            class              : "shinken-list-line",
            "data-uuid"        : this.uuid,
            onmouseenter       : "SHINKEN_TOOLTIP.showTooltipChildren(this, '" + _selector_css_for_tooltip + "')",
            onmouseleave       : "SHINKEN_TOOLTIP.hideTooltip()",
            "shi-tip-placement": "top"
        } );
        if ( this.uuid === CONTROLLER.UiPanels.current_view.uuid ) {
            this.dom_element.classList.add( "shinken-view-is_current_view" );
        }
        this.setPhaseDomElement( this.dom_element );
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
        this.dom_element_bind                 = DOM.Service.createElement( "tr", {
            class      : "shinken-list-line shinken-bind-tr shinken-view-history-container shinken-hidden",
            "data-uuid": this.uuid
        } );
        let _td_bind                          = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-bind-cell", colspan: 99 } ), this.dom_element_bind );
        this.dom_element_bind_container       = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-bind-container" } ), _td_bind );
        this.dom_element_close_history_button = DOM.Service.addElementTo( DOM.Service.createElement( "span", {
            class: "shinken-close-history shinkon-times-bold", "onclick": "MANAGER.EventManagerV2.clickButtonV2(event, 'show-history', '" + this.uuid + "')"
        } ), _td_bind );
        this.doActionAfter( "compute_html_done" );
    },
    getDataToSave               : function () {
        const _to_return    = {
            "type"   : SHINKEN.UI.VIEW.TYPE.WEATHER,
            "uuid"   : this.uuid,
            "actions": []
        };
        const current_phase = this.getCurrentPhase();
        switch ( current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED:
                _to_return.actions.push( { "key": SHINKEN.UI.VIEW.ACTIONS.REMOVE } );
                if ( this.uuid === CONTROLLER.UiPanels.current_view.uuid ) {
                    SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "current_view_has_been_deleted" );
                }
                return _to_return;
            case SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED_FOREVER:
                _to_return.actions.push( { "key": SHINKEN.UI.VIEW.ACTIONS.REMOVE_FORCED } );
                return _to_return;
            case SHINKEN.OBJECT.CONST.PHASE.TO_BE_RESTORED:
                _to_return.actions.push( { "key": SHINKEN.UI.VIEW.ACTIONS.RESTORED } );
                return _to_return;
            case SHINKEN.OBJECT.CONST.PHASE.CLONING:
                const view_name = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NAME._KEY ).getDataToSave();
                if ( view_name === "" ) {
                    _to_return.setError( "name", 1 );
                }
                const _to_add     = {
                    "key"      : SHINKEN.UI.VIEW.ACTIONS.CLONE_VIEW,
                    "view_name": this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NAME._KEY ).getDataToSave()
                };
                const _owner_user = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY ).user;
                if ( _owner_user ) {
                    _to_add[ "user_name" ] = _owner_user.getName();
                    _to_add[ "user_uuid" ] = _owner_user.getUUID();
                }
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.CLONING ) ) {
                    _to_add[ "view_cloned_uuid" ] = this.uuid_line_cloned;
                }
                _to_return.actions.push( _to_add );
                return _to_return;
        }
        
        var _data;
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _data = this.getContent( i ).getDataToSave();
            if ( _data ) {
                _to_return.actions.push( _data );
            }
        }
        if ( !_to_return.actions.length ) {
            return null;
        }
        return _to_return;
    },
    parseToFindCellUuid         : function ( key ) {
        switch ( key ) {
            case SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER :
                return SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY;
            case SHINKEN.UI.VIEW.ACTIONS.REMOVE :
                return SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.ACTION._KEY;
        }
        return key;
    },
    extraActionAfterActionDoneOK: function ( action ) {
        switch ( action.key ) {
            case SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER:
                var _previous_owner_cell = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY );
                if ( _previous_owner_cell ) {
                    _previous_owner_cell.updateAfterActionDoneOK( action );
                }
                var _current_owner_cell = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY );
                if ( _current_owner_cell && _previous_owner_cell ) {
                    _current_owner_cell.addExtraInformation(
                        SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY,
                        this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY ).user );
                }
                break;
        }
    },
    callbackForPhase  : function () {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED:
            case SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED_FOREVER:
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER, "ask_for_delete_view", 1 );
                this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NAME._KEY ).setTooltipHtml( _( "views.manager.service_weather.lines.tooltip_remove" ) );
                this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CANCEL_ORDERS_IN_FORM._KEY ).setPhase( _current_phase === SHINKEN.OBJECT.CONST.PHASE.EDITING );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.resetCounterByType( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER );
                this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NAME._KEY ).setTooltipHtml( "" );
                this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CANCEL_ORDERS_IN_FORM._KEY ).setPhase( _current_phase === SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.TO_BE_RESTORED:
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER, "restore_view", 1 );
                this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NAME._KEY ).setTooltipHtml( _( "views.manager.service_weather.lines.tooltip_restore" ) );
                this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CANCEL_ORDERS_IN_FORM._KEY ).setPhase( _current_phase === SHINKEN.OBJECT.CONST.PHASE.EDITING );
                break;
        }
    },
    removeDomElement  : function () {
        if ( this.dom_element ) {
            DOM.Service.removeElement( this.dom_element );
            DOM.Service.removeElement( this.dom_element_bind );
        }
    },
    displayHistoryData: function ( uuid ) {
        if ( this.current_history_view ) {
            this.current_history_view.reset();
            this.current_history_view = null;
            this.dom_element_bind.classList.add( "shinken-hidden" );
        }
        else {
            this.current_history_view = new WEATHER.ViewHistory( this.getUUID(), 10 );
            this.current_history_view.initSpecific( this, this.dom_element_bind_container );
        }
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineUIView, SHINKEN_LIST.LineFromData );
SHINKEN_LIST.LinesUIView           = function ( parent ) {
    this.__class_name__ = "SHINKEN_LIST.LinesUIView";
    this.init( parent );
};
SHINKEN_LIST.LinesUIView.prototype = {
    init               : SHINKEN_LIST.LinesFromData.prototype.init,
    getChildConstructor: function ( view, headers ) {
        return new SHINKEN_LIST.LineUIView( view, headers );
    },
    clickOnButton: function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-open-view-external-urls-popup":
            case "click-on-open-change-view-owner-popup":
            case "click-on-confirm-change-popup":
                this.getContentByUUID( param ).clickOnButton( event, event_name );
                break;
            case "click_on_pagination_btn":
                this.getContentByEvent( event ).clickOnButton( event, event_name, param );
                break;
            case "open_external_link":
            case "copy_external_link":
                this.getContentByEvent( event ).clickOnButton( event, event_name );
                break;
        }
    },
    doActionAfter  : function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "current_screen_has_changed":
                for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
                    this.getContent( i ).doActionAfter( event_name, param );
                }
                break;
            case "click_on_selector_V3":
            case "click_on_item_selector_V3":
            case "click_on_button_V3":
                if ( param[ SHINKEN.OBJECT.VIEW_HISTORY.PARAM.NAME ] ) {
                    this.getContentByUUID( param[ SHINKEN.OBJECT.VIEW_HISTORY.PARAM.NAME ] ).doActionAfter( event_name, param, param_2, param_3 );
                    return;
                }
                break;
        }
        this.doActionAfterCommon(event_name, param, param_2, param_3);
    },
    linkHeaderWithData: function ( headers ) {
        if ( __current_user_has_editable_right_service_weather__ ) {
            var _header_problem = headers.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PROBLEMS._KEY );
            if ( _header_problem ) {
                for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
                    this.getContent( i ).getContentByUUID( _header_problem.name ).computeCounters( _header_problem );
                }
            }
        }
    },
    displayDomByOrder : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            DOM.Service.addElementWithIndex( this.contents[ i ].getDomElement(), this.getDomElement(), i * 2 );
            DOM.Service.addElementWithIndex( this.contents[ i ].getDomElementBind(), this.getDomElement(), i * 2 + 1 );
        }
    },
    getDataToSave: function () {
        var _to_return = [];
        var _data;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _data = this.getContent( i ).getDataToSave();
            if ( _data ) {
                _to_return.push( _data );
            }
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesUIView, SHINKEN_LIST.LinesFromData );
SHINKEN.UI.VIEW.SetUIViewAbstract           = function ( type ) {
};
SHINKEN.UI.VIEW.SetUIViewAbstract.prototype = {
    init            : SHINKEN_LIST.SetFromDataWithFixHeaderFilter.prototype.init,
    initLinesObjects: function () {
        return new SHINKEN_LIST.LinesUIView();
    },
    clickOnButton        : function ( event, event_name, param ) {
        if ( this.clickOnButton_lvl_1( event, event_name, param ) ) {
            return;
        }
        switch ( event_name ) {
            case "click_on_pagination_btn":
                this.onClick();
                this.lines.clickOnButton( event, event_name, param );
                break;
        }
    },
    clickOnButton_lvl_1  : function ( event, event_name, param ) {
        return false;
    },
    doActionAfterSpecific: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "on-key-down-specific":
            case "click_on_selector":
            case "current_screen_has_changed":
            case "click_on_item_selector":
                this.lines.doActionAfter( event_name, param_1, param_2, param_3 );
                break;
            case "click_on_button":
                this.onClick( param_3 );
                switch ( param_1 ) {
                    case "click-on-option-header-popup":
                    case "click-on-header":
                        this.headers.doActionAfter( event_name, param_1, param_2, param_3 );
                        this.doActionAfterChange( { "type": "shinken-list-sorting" } );
                        break;
                    case "click-on-header-popup":
                        this.headers.doActionAfter( event_name, param_1, param_2, param_3 );
                        break;
                    case "show-history":
                    case "delete-view-forever":
                    case "delete-view":
                        this.lines.doActionAfter( event_name, param_1, param_2, param_3 );
                        break;
                }
                break;
        }
    },
    getUUID              : function () {
        return this.uuid || this.name;
    },
    computeLinesSpecific: function ( views ) {
        let valid_view = [];
        for ( var i = 0, _size_i = views.getSize(); i < _size_i; i++ ) {
            if ( this.isValidView( views.getContent( i ) ) ) {
                valid_view.push( views.getContent( i ) );
            }
        }
        this.computeLines( valid_view );
        this.lines.computeHtml();
        var _content_list = this.getDomElement().querySelector( ".shinken-list-tbody" );
        if ( _content_list ) {
            DOM.Service.replaceChild( _content_list, this.lines.getDomElement() );
        }
    },
    isValidView         : function ( view_content ) {
        return true;
    },
    doActionAfterSetDomElement: function () {
        this.lines.linkHeaderWithData( this.headers );
    },
    computeSpecificHtml       : function () {
        DOM.Service.setDataSet( this.getDomElement(), "userHasEditableRightServiceWeather", __current_user_has_editable_right_service_weather__ );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.VIEW.SetUIViewAbstract, SHINKEN_LIST.SetFromDataWithFixHeaderFilter );
SHINKEN.UI.VIEW.NewLineUIViewWeather           = function ( parent, headers ) {
    this.__class_name__ = "SHINKEN.UI.VIEW.NewLineUIViewWeather";
    this.initSpecific( parent, headers );
};
SHINKEN.UI.VIEW.NewLineUIViewWeather.prototype = {
    init                           : SHINKEN_LIST.Line.prototype.init,
    initSpecific                   : function ( parent, headers ) {
        this.init();
        this.setUUID( SHINKEN.TOOLS.STRING.buildUUID() );
        this.view_behaviour = new SHINKEN.OBJECT.ViewBehaviour();
        this.view_behaviour.changePhaseAction( SHINKEN.OBJECT.VIEW.BEHAVIOUR.PHASE.CREATE );
        this.initCellsValue( null, headers );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER, "ask_creating_view", 1 );
        this.initLineCountersValue();
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.CREATING );
    },
    addWithFactory                 : function ( current_header ) {
        let current_key = current_header.name;
        switch ( current_key ) {
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CANCEL_ORDERS_IN_FORM._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewCancelOrdersInForm( current_key ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NAME._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewNameInput( current_key, null, this.getUUID() ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewCurrentOwner( current_key, CONTROLLER.UiPanels.current_user, this ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CREATOR._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewUser( current_key, CONTROLLER.UiPanels.current_user ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.SHARES._KEY :
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PROBLEMS._KEY :
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY :
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.EXTERNAL_LINKS._KEY :
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NOTIFICATIONS._KEY :
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.ACTION._KEY :
                this.add( new SHINKEN_LIST.LineCellUIEmpty( current_key ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.VIEW_BEHAVIOUR._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewViewBehaviourPhase( current_key, this.view_behaviour ) );
                break;
        }
    },
    doActionAfterSpecific__20240909: function ( event_name, param ) {
        switch ( event_name ) {
            case "cancel_user_orders_specific" :
                param[ SHINKEN_LIST.CONST.PARAM.LINES_OBJECT ].removeContent( this.getUUID() );
                break;
        }
    },
    clickOnButton_lvl_1   : function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-confirm-change-popup":
                var previous_owner = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY );
                var current_owner  = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY );
                previous_owner.clickOnButton( event, event_name, current_owner );
                current_owner.clickOnButton( event, event_name, param );
                break;
            default:
                return false;
        }
        return true;
    },
    cancelUserModification: function ( parent ) {
        let _index_original = this.getIndexOriginal();
        parent.removeContent( this.getUUID() );
        CONTROLLER.UiViewWeatherManager.doActionAfter( "decrement_original_index_from", _index_original );
    },
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "tr", {
            class              : "shinken-list-line shinken-created-view",
            "data-uuid"        : this.uuid,
            onmouseenter       : "SHINKEN_TOOLTIP.showTooltip(this)",
            onmouseleave       : "SHINKEN_TOOLTIP.hideTooltip()",
            "shi-tip-html"     : _( 'views.view_behaviour.' + this.view_behaviour.getCurrentPhase() ),
            "shi-tip-placement": "top"
        } );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
        this.dom_element_bind = DOM.Service.createElement( "tr", {
            class      : "shinken-list-line shinken-bind-tr shinken-view-history-container",
            "data-uuid": this.uuid
        } );
        this.doActionAfter( "compute_html_done" );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.VIEW.NewLineUIViewWeather, SHINKEN_LIST.LineUIView );
SHINKEN.UI.VIEW.CloneLineUIViewWeather           = function ( line_cloned, parent, headers ) {
    this.__class_name__ = "SHINKEN.UI.VIEW.CloneLineUIViewWeather";
    this.initSpecific( line_cloned, parent, headers );
};
SHINKEN.UI.VIEW.CloneLineUIViewWeather.prototype = {
    initSpecific  : function ( line_cloned, parent, headers ) {
        this.unused_data      = {};
        this.uuid_line_cloned = line_cloned.getUUID();
        this.view_behaviour   = new SHINKEN.OBJECT.ViewBehaviour();
        this.view_behaviour.changePhaseAction( SHINKEN.OBJECT.VIEW.BEHAVIOUR.PHASE.CREATE );
        this.initCommon();
        this.setUUID( SHINKEN.TOOLS.STRING.buildUUID() );
        this.initLineCountersValue();
        this.initCellsValue( line_cloned, headers );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER, "ask_creating_view", 1, parent );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.CLONING );
    },
    addWithFactory: function ( current_header, line_cloned ) {
        let current_key = current_header.name;
        switch ( current_key ) {
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CANCEL_ORDERS_IN_FORM._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewCancelOrdersInForm( current_key ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NAME._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewNameInput( current_key, line_cloned.getContentByUUID( current_key ).getCloneName(), this.getUUID() ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewCurrentOwner( current_key, CONTROLLER.UiPanels.current_user, this ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CREATOR._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewUser( current_key, CONTROLLER.UiPanels.current_user ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.NOTIFICATIONS._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewNotifications( current_key, line_cloned.getContentByUUID( current_key ).notifications ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.SHARES._KEY :
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PROBLEMS._KEY :
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY :
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.EXTERNAL_LINKS._KEY :
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.ACTION._KEY :
                this.add( new SHINKEN_LIST.LineCellUIEmpty( current_key ) );
                break;
            case SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.VIEW_BEHAVIOUR._KEY :
                this.add( new SHINKEN_LIST.LineCellUIViewViewBehaviourPhase( current_key, this.view_behaviour ) );
                break;
        }
    },
    doActionAfterSpecific__20240909: function ( event_name, param ) {
        switch ( event_name ) {
            case "cancel_user_orders_specific" :
                param[ SHINKEN_LIST.CONST.PARAM.LINES_OBJECT ].removeContent( this.getUUID() );
                break;
        }
    },
    clickOnButton_lvl_1            : function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-confirm-change-popup":
                var previous_owner = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.PREVIOUS_OWNER._KEY );
                var current_owner  = this.getContentByUUID( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION.HEADERS.CURRENT_OWNER._KEY );
                previous_owner.clickOnButton( event, event_name, current_owner );
                current_owner.clickOnButton( event, event_name, param );
                break;
            default:
                return false;
        }
        return true;
    },
    cancelUserModification         : function ( parent ) {
        let _index_original = this.getIndexOriginal();
        parent.removeContent( this.getUUID() );
        CONTROLLER.UiViewWeatherManager.doActionAfter( "decrement_original_index_from", _index_original );
    },
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "tr", {
            class              : "shinken-list-line shinken-created-view",
            "data-uuid"        : this.getUUID(),
            onmouseenter       : "SHINKEN_TOOLTIP.showTooltip(this)",
            onmouseleave       : "SHINKEN_TOOLTIP.hideTooltip()",
            "shi-tip-html"     : _( 'views.view_behaviour.' + this.view_behaviour.getCurrentPhase() ),
            "shi-tip-placement": "top"
        } );
        this.setPhaseDomElement( this.dom_element );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
        this.dom_element_bind = DOM.Service.createElement( "tr", {
            class      : "shinken-list-line shinken-bind-tr shinken-view-history-container",
            "data-uuid": this.uuid
        } );
        this.doActionAfter( "compute_html_done" );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.VIEW.CloneLineUIViewWeather, SHINKEN_LIST.LineUIView );
SHINKEN.UI.VIEW.SetUIViewWeatherAbstract           = function () {
};
SHINKEN.UI.VIEW.SetUIViewWeatherAbstract.prototype = {
    initSpecific: function ( name ) {
        this.init( name );
        this.computeHasScrollVertical();
    },
    clickOnButton_lvl_1     : function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-open-view-external-urls-popup":
            case "click-on-open-change-view-owner-popup":
                this.onClick( event );
                this.lines.clickOnButton( event, event_name, param );
                
                break;
            case "copy_external_link":
            case "open_external_link":
            case "click-on-confirm-change-popup":
                this.lines.clickOnButton( event, event_name, param );
                break;
            default:
                return false;
        }
        return true;
    },
    computeHasScrollVertical: function () {
        if ( this.getDomElement() ) {
            DOM.Service.computeHasScrollVertical( this.getDomElement().querySelector( ".shinken-list-container-with-scroll" ) );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.VIEW.SetUIViewWeatherAbstract, SHINKEN.UI.VIEW.SetUIViewAbstract );
SHINKEN.UI.VIEW.SetUIViewWeatherAdministration           = function ( name ) {
    this.__class_name__ = "SHINKEN.UI.VIEW.SetUIViewWeatherAdministration";
    this.initSpecific( name );
};
SHINKEN.UI.VIEW.SetUIViewWeatherAdministration.prototype = {
    initSpecific: SHINKEN.UI.VIEW.SetUIViewWeatherAbstract.prototype.initSpecific,
    doActionAfter: function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "create-view-clone-in-administration":
                this.computeClonedWeather( param, param_2 );
                return true;
            case "compute_html_done":
                this.computeHtml_20240429();
                break;
            case "click_on_button":
                let param_event = typeof param === 'string' ? param : param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ];
                switch ( param_event ) {
                    case "clone-existing-view":
                        let _cloned_line = this.lines.getContentByUUID( param_2 );
                        CONTROLLER.UiViewWeatherManager.doActionAfter( "create-view-clone-in-administration", _cloned_line, _cloned_line.getIndexOriginal() );
                        break;
                    case "clean_input_value":
                        const line_to_update = this.lines.getContentByUUID( param_3 );
                        line_to_update.doActionAfter( param, param_2, param_3 );
                        break;
                    case "show-history":
                        this.lines.doActionAfter( event_name, param_event, param[ "item_uuid" ] );
                        break;
                    case "increment_original_index_from":
                        this.lines.changeOriginalIndexFrom( param, 1 );
                        return true;
                    case "decrement_original_index_from":
                        this.lines.changeOriginalIndexFrom( param, -1 );
                        return true;
                }
                break;
            case "onchange_in_input":
                const line_to_update = this.lines.getContentByUUID( param_2 );
                line_to_update.doActionAfter( event_name, param );
                break;
        }
        this.doActionAfterCommon( event_name, param, param_2, param_3 );
    },
    createNewWeather    : function () {
        let _new_line = new SHINKEN.UI.VIEW.NewLineUIViewWeather( this.lines, this.headers );
        _new_line.setIndexOriginal( -1 ); //HACK TO MAKE IT = 0 when Increment (see next step)
        this.lines.insertAtIndex( _new_line, 0 );
        this.lines.changeOriginalIndexFrom( 0, 1 );
        _new_line.computeHtml();
        DOM.Service.addElementWithIndex( _new_line.getDomElement(), this.lines.getDomElement(), 0 );
    },
    computeClonedWeather: function ( cloned_line, weather_index_original_cloned_line ) {
        let current_index_original = weather_index_original_cloned_line === undefined ? 0 : weather_index_original_cloned_line + 1;
        let current_index          = this.lines.getMappingIndex( cloned_line.getUUID() ) + 1;
        
        let _new_weather = new SHINKEN.UI.VIEW.CloneLineUIViewWeather( cloned_line, this.lines, this.headers );
        _new_weather.setIndexOriginal( current_index_original );
        _new_weather.computeHtml();
        
        CONTROLLER.UiViewWeatherManager.doActionAfter( "increment_original_index_from", current_index_original );
        this.lines.insertAtIndex( _new_weather, current_index );
        
        let views      = document.querySelector( ".shinken-list-container-with-scroll" );
        let views_rect = DOM.Service.getBoundingClientRect( views );
        
        DOM.Service.addElementWithIndex( _new_weather.getDomElementBind(), this.lines.getDomElement(), 2 * current_index );
        DOM.Service.addElementWithIndex( _new_weather.getDomElement(), this.lines.getDomElement(), 2 * current_index );
        
        let weather    = document.querySelector( `.shinken-created-view[data-uuid="${_new_weather.uuid}"]` );
        let dom_rect_2 = DOM.Service.getBoundingClientRect( weather );
        if ( !DOM.Service.isPartiallyVisibleIntoScrollingVerticalParent_Box( dom_rect_2, views_rect ) ) {
            weather.scrollIntoView( { behavior: "smooth", block: "end", inline: "nearest" } );
        }
    },
    computeHtml_20240429: function () {
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).setShowIfNull( true );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).setShowIfNull( true );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).setAnimation( true );
        
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).computeHtml();
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).computeHtml();
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).getDomElement().classList.add( "shinken-pulsate-parent" );
        var _to_add = DOM.Service.addElementAtIndex( DOM.Service.createElement( "div", { class: "shinken-filtering-information-container" } ), this.getDomElement(), 0 );
        var _1      = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-filtering-information" }, _( "views.manager.service_weather.window.after_filer_label" ) + " : " ), _to_add );
        DOM.Service.addElementTo( this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).getDomElement(), _1 );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-filtering-information-separator" }, "/" ), _1 );
        DOM.Service.addElementTo( this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).getDomElement(), _1 );
        
    },
    isValidView                  : function ( view ) {
        var _current_phase = view.getViewBehaviourPhase().getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.VIEW.BEHAVIOUR.PHASE.DELETED:
                return false;
            default:
                return true;
        }
    },
    updateAfterActionDoneOK_lvl_1: function ( action, data ) {
        switch ( action.key ) {
            case SHINKEN.UI.VIEW.ACTIONS.CLONE_VIEW:
                SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "add_favorite_for_created_weather", data[ "uuid" ] );
                this.removeContent( data[ "uuid" ] );
                return true;
        }
        return false;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.VIEW.SetUIViewWeatherAdministration, SHINKEN.UI.VIEW.SetUIViewWeatherAbstract );
SHINKEN.UI.VIEW.SetUIViewWeatherRunning           = function ( name ) {
    this.__class_name__ = "SHINKEN.UI.VIEW.SetUIViewWeatherRunning";
    this.initSpecific( name );
};
SHINKEN.UI.VIEW.SetUIViewWeatherRunning.prototype = {
    initSpecific: SHINKEN.UI.VIEW.SetUIViewWeatherAbstract.prototype.initSpecific,
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.VIEW.SetUIViewWeatherRunning, SHINKEN.UI.VIEW.SetUIViewWeatherAbstract );
SHINKEN.UI.VIEW.SetUIViewWeatherDeleting           = function ( name ) {
    this.__class_name__ = "SHINKEN.UI.VIEW.SetUIViewWeatherDeleting";
    this.initSpecific( name );
};
SHINKEN.UI.VIEW.SetUIViewWeatherDeleting.prototype = {
    initSpecific: SHINKEN.UI.VIEW.SetUIViewWeatherAbstract.prototype.initSpecific,
    doActionAfter: function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "clone-existing-view":
                let _cloned_line = this.lines.getContentByUUID( param_2 );
                CONTROLLER.UiViewWeatherManager.doActionAfter( "create-view-clone-in-administration", _cloned_line, 0 );
                return true;
            case "compute_html_done":
                this.computeHtml_20240429();
                break;
            case "click_on_button":
                let param_event = typeof param === 'string' ? param : param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ];
                switch ( param_event ) {
                    case "clone-existing-view":
                        let _cloned_line = this.lines.getContentByUUID( param_2 );
                        CONTROLLER.UiViewWeatherManager.doActionAfter( "create-view-clone-in-administration", _cloned_line, _cloned_line.getIndexOriginal() + 1 );
                        break;
                    case "show-history":
                        this.lines.doActionAfter( event_name, param_event, param[ "item_uuid" ] );
                        break;
                    case "restore-deleting-view":
                        this.lines.doActionAfter( event_name, param_event, param_2 );
                        break;
                }
                break;
        }
        this.doActionAfterCommon( event_name, param, param_2, param_3 );
    },
    isValidView: function ( view ) {
        return view.getViewBehaviourPhase().isPhase( SHINKEN.OBJECT.VIEW.BEHAVIOUR.PHASE.DELETED );
    },
    computeHtml_20240429: function () {
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).computeHtml();
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).computeHtml();
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).setShowIfNull( true );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).setAnimation( true );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).getDomElement().classList.add( "shinken-pulsate-parent" );
        var _to_add = DOM.Service.addElementAtIndex( DOM.Service.createElement( "div", { class: "shinken-filtering-information-container" } ), this.getDomElement(), 0 );
        var _1      = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-filtering-information" }, _( "views.manager.service_weather.window.after_filer_label" ) + " : " ), _to_add );
        DOM.Service.addElementTo( this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).getDomElement(), _1 );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-filtering-information-separator" }, "/" ), _1 );
        DOM.Service.addElementTo( this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).getDomElement(), _1 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UI.VIEW.SetUIViewWeatherDeleting, SHINKEN.UI.VIEW.SetUIViewWeatherAbstract );
