"use strict";
SHINKEN_PAGE.VISUALFORM.WIDGET = {
    COLLAPSE_FOLDER: {
        ELEMENT       : {
            _KEY: "cf_weather_edit_widget_element_part"
        },
        DISPLAY       : {
            _KEY: "cf_weather_edit_widget_display_part"
        },
        AREAS         : {
            _KEY: "cf_weather_edit_widget_areas_part"
        },
        LEFT_AREA     : {
            _KEY: "cf_weather_edit_widget_left_area_part"
        },
        TOP_RIGHT_AREA: {
            _KEY: "cf_weather_edit_widget_top_right_area_part"
        },
        SLA_AREA      : {
            _KEY: "cf_weather_edit_widget_sla_area_part"
        },
        NAME_AREA     : {
            _KEY: "cf_weather_edit_widget_name_area_part"
        },
        RIGHT_AREA    : {
            _KEY: "cf_weather_edit_widget_right_area_part"
        },
        TITLE_AREA    : {
            _KEY: "cf_weather_edit_widget_title_area_part"
        }
    }
};
SHINKEN.WidgetFormFactory = function ( data ) {
    let to_return;
    switch ( data[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ].getWidgetType() ) {
        case WIDGET.CONST.TYPE.WEATHER:
            to_return = new SHINKEN.OBJECT.WeatherWidgetForm( data[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ], data[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ] );
            break;
        case WIDGET.CONST.TYPE.SEPARATOR:
            to_return = new SHINKEN.OBJECT.SeparatorWidgetForm( data[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ], data[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ] );
            break;
        case WIDGET.CONST.TYPE.TITLE:
            to_return = new SHINKEN.OBJECT.TitleWidgetForm( data[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ], data[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ] );
            break;
    }
    return to_return;
};
SHINKEN.OBJECT.InterfaceWidgetForm = function ( grid_object, grid_cell ) {
    this.init( "widget-visual-form", grid_object, grid_cell );
};
SHINKEN.OBJECT.InterfaceWidgetForm.prototype = {
    init                : function ( name, grid_object, grid_cell ) {
        this.initCommon( name );
        this.grid_object  = grid_object;
        this.grid_cell    = grid_cell;
        this.initialValue = grid_cell.content.getDataToSave();
        this.initAllContent();
        this.initPropertiesValues();
        this.properties_modified = [];
    },
    initPropertiesValues: function () {
        let current_property;
        let current_value;
        for ( let i = 0, _size_i = this.property_set.getSize(); i < _size_i; i++ ) {
            current_property = this.property_set.getContent( i );
            current_value    = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.initialValue, current_property.getName() );
            current_value    = current_value !== undefined ? current_value : "";
            current_property.doActionAfter( "property_value__set__by_data", { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: current_value + "" } );
        }
    },
    doActionAfter                      : function ( event_name, param ) {
        switch ( event_name ) {
            case "on_key_down":
                if ( param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].ctrlKey && param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].keyCode === SHINKEN.CONST.KEY_CODE.Z ) {
                    param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].preventDefault();
                }
                break;
            case "on_key_up":
                switch ( param[ SHINKEN.CONST.PARAM.KEY_CODE ] ) {
                    case SHINKEN.CONST.KEY_CODE.ESCAPE:
                        CONTROLLER.PageController.doActionAfter( "close_form_for_widget_configuration" );
                        return;
                }
                break;
            case "change_radio_mode_done":
                this.askValidateForm( param );
                break;
            case "load_data_from_back_end":
                this.getBackendData( param );
                return;
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "validated_form":
                        this.askValidateForm( param );
                        return;
                    case"cancel_form":
                        CONTROLLER.PageController.current_page.visual_form.doActionAfter( "ask_close_form_for_widget_configuration__if_needed" );
                        return;
                    case"change__widget_preview_zone__activity":
                        this.doActionAfter( "change__widget_preview_zone__activity", param );
                        return;
                    case "clean_input_value":
                        if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY ) {
                            this.doActionAfter( "property_value__set__by_js", { [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY, [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: "" } );
                            this.doActionAfter( "property_value__set__by_js", { [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY, [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: "" } );
                            this.doActionAfter( "property_value__set__by_js", { [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY, [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: "" } );
                        }
                        break;
                }
                break;
            case "reset_all_html":
                DOM.Service.removeElement( this.getDomElement() );
                break;
            case "click_on_item_selector_done":
                this.doActionAfter( "synchronize_property_value", param );
                this.askValidateForm( param );
                return;
            case "onchange_in_input_V3_done":
                if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ].getName() === WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY ) {
                    let shinken_element = CONTROLLER.PageController.list_element_from_webui.getContentByUUID( param[ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ].getValue() );
                    this.setPropertyValue( WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY, shinken_element ? shinken_element[ WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY ] : "" );
                    this.setPropertyValue( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY, shinken_element ? shinken_element[ WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ] : "" );
                    this.setPropertyValue( WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY, shinken_element ? shinken_element[ WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY ] : "" );
                }
                this.askValidateForm( param );
                return;
            case "ask_close_form_for_widget_configuration__if_needed":
                if ( !param ) {
                    CONTROLLER.PageController.doActionAfter( "close_form_for_widget_configuration" );
                }
                else if ( param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_UUID ] ) {
                    if ( !SHINKEN.TOOLS.ARRAY.contains( param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_UUID ], this.grid_cell.getUUID() ) ) {
                        CONTROLLER.PageController.doActionAfter( "close_form_for_widget_configuration" );
                    }
                }
                else if ( param[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ] ) {
                    if ( param[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ].getUUID() !== this.grid_cell.getUUID() ) {
                        CONTROLLER.PageController.doActionAfter( "close_form_for_widget_configuration" );
                    }
                }
                break;
            case "widget_preview__compute_html_done":
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                if ( !param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ].IsTypeOfModification( [SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE, SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.EDIT] ) ) {
                    return CONTROLLER.PageController.doActionAfter( "close_form_for_widget_configuration" );
                }
                for ( let i = 0, _size_i = param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ].contents.length; i < _size_i; i++ ) {
                    if ( param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ].contents[ i ].getModifiedObjectParam( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ) === this.grid_cell.getUUID() ) {
                        this.property_set.doActionAfter( event_name, {
                            [ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_ELEMENT ]: param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ].contents[ i ],
                            [ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_TYPE ]   : param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ][ "type_modification" ]
                        } );
                    }
                }
                this.doActionAfter( "ask_close_form_for_widget_configuration__if_needed", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_UUID ]: param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ].getAllUuidOfImpactedElement() } );
                break;
            case "show_form_for_widget_configuration":
                CONTROLLER.Form.isValid();
                break;
            default:
                break;
        }
        this.doActionAfterCommon( event_name, param );
        this.doActionAfterShinkenElementSpecific( event_name, param );
        this.doActionAfterSpecific( event_name, param );
    },
    doActionAfterShinkenElementSpecific: function ( event_name, param ) {
    },
    doActionAfterSpecific              : function ( event_name, param ) {
    },
    setPropertyValue   : function ( property_name, value ) {
        this.doActionAfter( "property_value__set__by_js", {
            [ SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME ]: this.getName(), [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: property_name, [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: value
        } );
    },
    getChildConstructor: function () {
        return new SHINKEN.OBJECT.PropertiesSetWidgetForm();
    },
    askValidateForm            : function ( param ) {
        this.properties_modified.push( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] );
        if ( this.timeout__compute_validate_form ) {
            clearTimeout( this.timeout__compute_validate_form );
        }
        this.timeout__compute_validate_form = setTimeout( () => {
            this.validateForm( param );
            this.timeout__compute_validate_form = null;
            this.properties_modified            = [];
        }, 200 );
    },
    validateForm               : function ( param ) {
        if ( !CONTROLLER.Form.isValid( param ) ) {
        }
        if ( this.doValidateFormSpecific() ) {
            return;
        }
        
        let data                                                                = this.getDataToSave__20241114( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID, this.properties_modified );
        param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT_LIST ]           = [this.grid_cell];
        param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_DATA ]                  = this.parseDataForSpecialCase( data, param );
        param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_TYPE ] = SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.EDIT;
        this.grid_object.doActionAfter( "widgets__have_been_configured__from_form", param );
        if ( this.grid_cell_for_preview ) {
            this.grid_cell_for_preview.doActionAfter( "widgets__have_been_configured__from_form__update_object", param );
        }
        CONTROLLER.PageController.doActionAfter( "remove_error_of_widget__from_form_widget", {
            [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]               : this.grid_cell.getUUID(),
            [ SHINKEN.OBJECT.FORMSET.PARAM.FORM_ANIMATION_STOP_PROPAGATION ]: true
        } );
        return true;
    },
    doValidateFormSpecific     : function () {
        return false;
    },
    parseDataForSpecialCase    : function ( data ) {
        return data;
    },
    computeValidation__20241125: function ( param ) {
        this.status_validation      = COMPONENT.CONST.STATUS.VALID;
        let current_property;
        const validate_all_property = !param;
        for ( let i = 0, _size_i = this.property_set.getSize(); i < _size_i; i++ ) {
            current_property = this.property_set.getContent( i );
            if ( !validate_all_property && !this.properties_modified.includes( current_property.getName() ) ) {
                continue;
            }
            PROPERTY_V2.VALIDATOR.validWithParameter( current_property, this.grid_cell.getParameterToValidateProperty( current_property ), '"' );
            if ( validate_all_property ) {
                switch ( current_property.getName() ) {
                    case WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY:
                    case WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY:
                    case WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY:
                        if ( !this.grid_cell.getShinkenElement().isExisting() ) {
                            let messages = new SHINKEN.OBJECT.Messages();
                            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( "widget.weather.shinken_element_not_found" ) );
                            CONTROLLER.Form.doActionAfter( "add_message_validation", {
                                [ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ]  : current_property,
                                [ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ]: messages
                            } );
                        }
                        break;
                }
            }
        }
        
    },
    parseConfigurationToArray: function ( enum_tab, dict_key, property_structure ) {
        let composed_key  = property_structure.COMPOSED_KEY ? SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT + "." + property_structure.COMPOSED_KEY : SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT;
        let default_value = this.grid_object.getDefaultValueFor( this.grid_cell.content.getTypeValue(), composed_key );
        let to_return     = [];
        const _keys       = Object.keys( enum_tab );
        let value;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            value = enum_tab[ _keys[ i ] ];
            to_return.push( { name: value, label: _( dict_key + "." + value, [DICTIONARY_COMMON_UI] ) } );
        }
        let default_label = dict_key ? _( dict_key + "." + default_value, [DICTIONARY_COMMON_UI] ) : default_value;
        default_label     = SHINKEN.TOOLS.STRING.format( _( "property.default_label", [DICTIONARY_COMMON_UI] ), default_label );
        to_return.push( { name: WEATHER.CONST.DEFAULT_VALUE, label: default_label, [ PROPERTY_V2.COMMON.PARAM.IS_DEFAULT ]: true, [ PROPERTY_V2.COMMON.PARAM.DEFAULT_VALUE ]: default_value } );
        return to_return;
    },
    computeHtmlTitle          : function () {
        let title_container = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-form-title-container shinken-layout-center-h-v" } ) );
        DOM.Service.addElementTo( DOM.Service.createElement( 'div', {
            class              : "shinken-tag-help shinken-layout-center-h-v",
            "shi-tip-placement": "bottom-left",
            "shi-tip-html"     : this.getHelpHtml( this.grid_cell.getWidgetType() ),
            "onClick"          : "event.stopPropagation();",
            "onmouseenter"     : "SHINKEN_TOOLTIP.showTooltip(this)",
            "onmouseleave"     : "SHINKEN_TOOLTIP.hideTooltip()"
        }, "?" ), title_container );
        DOM.Service.addElementTo( this.getSpecificDomElementTitle(), title_container );
    },
    getSpecificDomElementTitle: function () {
        return DOM.Service.createElement( 'span', { class: "shinken-form-title" }, _( "grid.mode_edition.form_widget." + this.grid_cell.getWidgetType() + ".title", [DICTIONARY_COMMON_UI] ) );
    },
    computeHtmlActions        : function () {
        let _div_action         = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-form-action shinken-parent-event-listener shinken-layout-order-first", "data-controller": CONTROLLER.CONST.FORM_CONTROLLER.NAME } ) );
        let _div_action_content = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-table-form-container" } ), _div_action );
        let _div                = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-width-100 shinken-table-form-content shinken-layout-in-end-position" } ), _div_action_content );
        
        let _td_2          = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-form-action-cell" } ), _div );
        let _button_cancel = new COMPONENT.ButtonFromData_V3( "cancel_form" );
        _button_cancel.addClass( "shinken-cancel-form shinkon-times-bold" );
        _button_cancel.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME, this.name );
        _button_cancel.computeHtml();
        DOM.Service.addElementTo( _button_cancel.getDomElement(), _td_2 );
    },
    getHelpHtml              : function ( weather_type ) {
        let contents = this.getHelpContents( weather_type );
        if ( !contents.length ) {
            return "";
        }
        return this.getHelpHtmlFromContents( contents );
    },
    getHelpHtmlFromContents  : function ( contents ) {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-container", "data-help-parent-name": this.getName() } );
        contents.forEach( content => {
            DOM.Service.addElementTo( this.getHelpHtmlLineContent( content ), to_return );
        } );
        return to_return.outerHTML;
    },
    getHelpHtmlLineContent   : function ( content ) {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-content shinken-tooltip-edit-widget" } );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-tooltip-help-action-title" }, content.label ), to_return );
        let element_content = this.getHelpHtmlElementContent( content );
        if ( element_content ) {
            DOM.Service.addElementTo( element_content, to_return );
        }
        return to_return;
    },
    getHelpHtmlElementContent: function ( content ) {
        let type_content = content.type_content;
        let to_return;
        switch ( type_content ) {
            case "label_&_content":
            case "image_&_content":
                to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-action-elements" } );
                if ( content.elements ) {
                    content.elements.forEach( content_element => {
                        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: content_element.className }, content_element.content ), to_return );
                    } );
                    return to_return;
                }
                break;
        }
    },
    getHelpContents          : function ( widget_type ) {
        let data = {
            weather_widget: [
                {
                    type_content: "label_&_content",
                    elements    : [
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.cancel_and_validate_actions" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.actions_cancel" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.actions_redo" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.back_to_visual" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_clic" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_escape" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_cross" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.default_values" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.default_values_layouts" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.default_values_cfgs" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.default_values_computed" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.widget_preview" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.preview_exemple" ) }
                    ]
                }
            ],
            default       : [
                {
                    type_content: "label_&_content",
                    elements    : [
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.cancel_and_validate_actions" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.actions_cancel" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.actions_redo" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.back_to_visual" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_clic" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_escape" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_cross" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.default_values" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.default_values_layouts" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.default_values_cfgs" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.default_values_computed" ) }
                    ]
                }
            ]
        };
        return widget_type === "weather_widget" ? data[ widget_type ] : data.default;
    },
    parseTilesBackgroundValueForPreview: function ( composed_key ) {
        switch ( composed_key ) {
            case WIDGET.CONST.PARAM.LAYOUT.BACKGROUND.COMPOSED_KEY:
                switch ( __tiles_background__ ) {
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.DEFAULT:
                        return WIDGET.CONST.PARAM.LAYOUT.BACKGROUND.OPTIONS.CONTEXT_AND_STATUS;
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.CONTEXT_UP:
                        return WIDGET.CONST.PARAM.LAYOUT.BACKGROUND.OPTIONS.CONTEXT_THEN_STATUS;
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.STATUS_UP:
                        return WIDGET.CONST.PARAM.LAYOUT.BACKGROUND.OPTIONS.ONLY_STATUS;
                }
                break;
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY:
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY:
                switch ( __tiles_background__ ) {
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.DEFAULT:
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.CONTEXT_UP:
                        return WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS;
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.STATUS_UP:
                        return WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS;
                }
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceWidgetForm, SHINKEN.OBJECT.FormSetFromData );
SHINKEN.OBJECT.InterfaceWidgetFormWithShinkenElement = function () {
};
SHINKEN.OBJECT.InterfaceWidgetFormWithShinkenElement.prototype = {
    initContentShinkenElement: function () {
        let widget_type_prop = this.addSpecific( new PROPERTY.StringInputFromData_V3( WIDGET.CONST.PARAM.TYPE._KEY, this.grid_cell.content.getValue( WIDGET.CONST.PARAM.TYPE._KEY ) ), false, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        let collapse_folder  = this.addSpecific( new WEATHER.CollapseFolderShinkenElement( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.ELEMENT._KEY ), true );
        
        let prop_name = this.addSpecificToChild( new PROPERTY.SingleSelectWithResearchFromData_V3_computeOnce( WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY, _( "grid.mode_edition.form_widget.cf_shinken_element.properties.item_name", [DICTIONARY_COMMON_UI] ), [WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY] ), collapse_folder );
        let prop_visu = this.addSpecificToChild( new PROPERTY.SingleSelectWithResearchFromData_V3_computeOnce( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY, _( "grid.mode_edition.form_widget.cf_shinken_element.properties.visualisation_name", [DICTIONARY_COMMON_UI] ), [WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY] ), collapse_folder );
        prop_name.getSelector().setDefaultLabelForSelector( _( "grid.mode_edition.form_widget.cf_shinken_element.default_label_selector", [DICTIONARY_COMMON_UI] ) );
        prop_visu.getSelector().setDefaultLabelForSelector( _( "grid.mode_edition.form_widget.cf_shinken_element.default_label_selector", [DICTIONARY_COMMON_UI] ) );
        
        let prop_uuid = this.addSpecificToChild( new PROPERTY.LabelFromData_V3( WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY, _( "grid.mode_edition.form_widget.cf_shinken_element.properties.item_uuid", [DICTIONARY_COMMON_UI] ), "" ), collapse_folder, false, this.is_configured__20241216 ? SHINKEN.CONST.VISIBILITY_STATE.NORMAL : SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( new PROPERTY.StringInputFromData_V3( WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY ), collapse_folder, false, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        if ( !this.is_configured__20241216 ) {
            this.doActionAfter( "property_visibility__set", {
                [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY, [ PROPERTY.COMMON.PARAM.PROPERTY_VISIBILITY ]: SHINKEN.CONST.VISIBILITY_STATE.HIDDEN
            } );
        }
        setTimeout( () => { //TODO TO CHANGE WHEN BACKEND CALL ALWAYS DONE WHEN CONFIGURATION_UUID
            this.doActionAfter( "load_data_from_back_end", {} );
        }, 0 );
    },
    initPropertiesValues     : function () {
        let current_property;
        let current_value;
        for ( let i = 0, _size_i = this.property_set.getSize(); i < _size_i; i++ ) {
            current_property = this.property_set.getContent( i );
            current_value    = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.initialValue, current_property.getName() );
            current_value    = current_value !== undefined ? current_value : "";
            
            if ( this.is_configured__20241216 && current_property.getName() === WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ) {
                const shinken_element = this.grid_cell.getShinkenElement();
                current_value         = shinken_element.getVisualisationName();
            }
            current_property.doActionAfter( "property_value__set__by_data", { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: current_value + "" } );
        }
    },
    doActionAfterShinkenElementSpecific   : function ( event_name, param ) {
        switch ( event_name ) {
            case "synchronize_property_value":
                if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY ) {
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY, param[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY, param[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY, param[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                }
                else if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ) {
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY, param[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY, param[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY, param[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                }
                return;
            case "add_message_validation":
                switch ( param[ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ].getName() ) {
                    case WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY:
                    case WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY:
                        this.doActionAfter( "add_message_validation", {
                            [ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ]  : this.property_set.getContentByUUID( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ),
                            [ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ]: param[ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ]
                        } );
                        break;
                }
                return;
        }
    },
    doValidateFormSpecific                : function () {
        let data_widget_form = this.getDataToSave__20241114( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID );
        let is_new_widget    = !this.is_configured__20241216;
        if ( !is_new_widget && this.grid_cell.getShinkenElement().getUUID() === SHINKEN.TOOLS.DICT.getValueWithComposedKey( data_widget_form, WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY )[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] ) {
            return false;
        }
        let grid_cell_existing                                           = this.grid_cell.getObjectToJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT );
        grid_cell_existing[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ] = data_widget_form;
        
        let data_value_format = SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseDictToDict_withValueKey( grid_cell_existing );
        CONTROLLER.PageController.current_page.doActionAfter( "change__shinken_element__from_form", {
            [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]   : this.grid_object, [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT_LIST ]: [this.grid_cell], [ WIDGET.CONST.PARAM_EVENT.WIDGET_DATA_FROM_FORM ]: data_widget_form,
            [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_DATA ]: data_value_format, [ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_TYPE ]: SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE
        } );
        CONTROLLER.PageController.doActionAfter( "remove_error_of_widget__from_form_widget", {
            [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]               : this.grid_cell.getUUID(),
            [ SHINKEN.OBJECT.FORMSET.PARAM.FORM_ANIMATION_STOP_PROPAGATION ]: true
        } );
        if ( !this.is_configured__20241216 ) {
            this.doActionAfterSpecific( "widget_becomes_configured" );
        }
        return true;
    },
    synchronizeShinkenElementPropertyValue: function ( property_name, line_grid_object ) {
        this.properties_modified.push( property_name );
        let value = line_grid_object.getData__20241114( property_name );
        this.setPropertyValue( property_name, value );
    },
    getBackendData  : function ( param ) {
        this.property_set.getContentByUUID( WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY ).setPhase( SHINKEN.OBJECT.CONST.PHASE.LOADING_DATA );
        this.property_set.getContentByUUID( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ).setPhase( SHINKEN.OBJECT.CONST.PHASE.LOADING_DATA );
        let func_updateSelectorsContent = () => {
            func_createSelectors( WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY );
            func_createSelectors( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY );
            this.doActionAfter( "add_main_selector_content", {
                [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY, [ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ]: CONTROLLER.PageController.selectors_once[ WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY ]
            } );
            this.doActionAfter( "add_main_selector_content", {
                [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]  : WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY,
                [ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ]: CONTROLLER.PageController.selectors_once[ WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ]
            } );
        };
        let func_createSelectors        = ( property_name ) => {
            CONTROLLER.PageController.selectors_once = CONTROLLER.PageController.selectors_once || {};
            if ( CONTROLLER.PageController.selectors_once[ property_name ] ) {
                return;
            }
            CONTROLLER.PageController.selectors_once[ property_name ] = new COMPONENT.SingleSelectWithResearchFromData_V3( property_name, null, [WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY] );
            CONTROLLER.PageController.selectors_once[ property_name ].setDefaultLabelForSelector( _( "grid.mode_edition.form_widget.cf_shinken_element.default_label_selector", [DICTIONARY_COMMON_UI] ) );
            CONTROLLER.PageController.selectors_once[ property_name ].list_element.computeLines( CONTROLLER.PageController.list_element_from_webui.getContents() );
            CONTROLLER.PageController.selectors_once[ property_name ].list_element.computeHtml();
            CONTROLLER.PageController.selectors_once[ property_name ].computeHtml();
            CONTROLLER.PageController.selectors_once[ property_name ].addDomElement( CONTROLLER.PageController.selectors_once[ property_name ].list_element.getDomElement() );
            CONTROLLER.PageController.selectors_once[ property_name ].list_element.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
            CONTROLLER.PageController.selectors_once[ property_name ].list_element.doActionAfter( "update_counter__with_children" );
        };
        if ( CONTROLLER.PageController.list_element_from_webui ) {
            func_updateSelectorsContent();
            return;
        }
        let success = ( _status, data ) => {
            data = this.parseBackendData( data );
            switch ( _status ) {
                case COMMUNICATION.CODE.SUCCESS:
                    CONTROLLER.PageController.list_element_from_webui = new SHINKEN.OBJECT.ShinkenObjectContainer();
                    let current;
                    for ( let i = 0, _size_i = data.length; i < _size_i; i++ ) {
                        current = new SHINKEN.OBJECT.ShinkenElement();
                        current.init( data[ i ] );
                        current[ WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY ]               = current[ WIDGET.CONST.PARAM.ITEM.NAME._KEY ];
                        current[ WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ] = current[ WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME._KEY ];
                        current[ WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY ]               = current[ WIDGET.CONST.PARAM.ITEM.UUID._KEY ];
                        current[ WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY ]               = current[ WIDGET.CONST.PARAM.ITEM.TYPE._KEY ];
                        CONTROLLER.PageController.list_element_from_webui.add( current );
                    }
                    func_updateSelectorsContent();
                    break;
                case COMMUNICATION.CODE.NOT_FOUND:
                    SHINKEN.TOOLS.NOTIFICATION.addNotification( _( "communication.unknown_call", [DICTIONARY_COMMON_UI] ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
                    break;
            }
        };
        SHINKEN.COMUNICATION.requestGet_withTimeout( 10, "/service-weather/widget-configuration/list-elements", success );        //NEED TO ADD TIMEOUT IN ORDER TO SEE ( ALWAYS ) THE SPINNER...
    },
    parseBackendData: function ( data ) {
        return data; //NEEDED FOR SHINKEN DOCUMENTATION
    },
    getFakeDataShinkenElementData: function ( nb_to_generate ) {
        const to_return = [];
        for ( let i = 0; i < nb_to_generate; i++ ) {
            let str_i = +i.toString();
            to_return.push( {
                "item_name": str_i + "", "item_type": "host", "uuid": "uuid-" + str_i, "visualisation_name": "visu-" + str_i
            } );
        }
        return to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceWidgetFormWithShinkenElement, SHINKEN.OBJECT.InterfaceWidgetForm );
SHINKEN.OBJECT.PropertiesSetWidgetForm           = function () {
    this.initContentsSpecific();
};
SHINKEN.OBJECT.PropertiesSetWidgetForm.prototype = {
    initContentsSpecific: SHINKEN.OBJECT.PropertiesSet.prototype.initContentsSpecific,
    doActionAfter          : function ( event_name, param ) {
        let _current_prop;
        
        switch ( event_name ) {
            case "undo_last_modification":
            case "redo_last_modification":
                let value_from_dict;
                for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
                    _current_prop   = this.getContent( i );
                    value_from_dict = SHINKEN.TOOLS.DICT.getValueWithComposedKey_WithValue( param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION_ELEMENT ].getNextOrPrevious( event_name ), _current_prop.getName() );
                    if ( _current_prop.getName() !== WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ) { //VISUALISATION NAME DOESN'T HAVE THE STRUCTURE VALUE
                        value_from_dict = value_from_dict[ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ] + ""; //PARSED TO STRING FOR "TRUE" OR "FALSE" VALUE
                    }
                    if ( _current_prop.getValue() !== value_from_dict ) {
                        let param_action = {
                            [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: _current_prop.getName(), [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: value_from_dict
                        };
                        _current_prop.doActionAfter( "property_value__set__by_js", param_action );
                    }
                }
                CONTROLLER.Form.current_form.computeValidation__20241125();
                CONTROLLER.Form.current_form.doActionAfterSpecific( CONTROLLER.Form.current_form.grid_cell.getShinkenElement().isConfigured() ? "widget_becomes_configured" : "widget_becomes_not_configured" );
                break;
            default:
                this.doActionAfterCommon( event_name, param );
                break;
        }
    }, //********************************************  SAVE   **************************************************//
    getDataToSave__20241115: function ( type_save, property_list ) {
        const _to_return = {};
        let _current;
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( property_list && !SHINKEN.TOOLS.ARRAY.contains( property_list, _current.getUUID() ) ) {
                continue;
            }
            SHINKEN.TOOLS.DICT.parseKeyComposedToKey( _to_return, _current.getUUID(), _current.getDataToSave__20241127( type_save ) );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.PropertiesSetWidgetForm, SHINKEN.OBJECT.PropertiesSet );
PROPERTY.SingleSelectWithResearchFromData_V3_computeOnce           = function ( property_name, label, extra_columns ) {
    this.initSpecific( property_name, [], label, extra_columns );
};
PROPERTY.SingleSelectWithResearchFromData_V3_computeOnce.prototype = {
    initSpecific: PROPERTY.SingleSelectWithResearchFromData_V3.prototype.initSpecific, initMainSelector: function ( data_option_array, extra_columns ) {
        this.setComponentSelector( new COMPONENT.SingleSelectWithResearchFromData_V3( this.getName(), null, extra_columns ) );
    },
    doActionAfter                : function ( event_name, param ) {
        switch ( event_name ) {
            case "add_main_selector_content":
                param[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ].doActionAfter( "clean_filter" );
                param[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ].doActionAfter( "clean_selected_element" );
                param[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ].doActionAfter( "add_message_validation", { [ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ]: this.component_selector.getMessage__2024_12_16() } );
                
                param[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ].doActionAfter( "property_value__set__by_js", { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: this.component_selector.getValue() } );
                this.setComponentSelector( param[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ] );
                DOM.Service.addElementToAfterEmpty( this.component_selector.getDomElement(), this.dom_cell_action );
                this.setPhaseIfPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.LOADING_DATA );
                return;
        }
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterChange          : function ( validation_done ) {
        this.component_selector.doActionAfter( "ask_apply_filter" );
    }, //********************************************  HTML  *****************************************************//
    computeHtml_getClassContainer: function () {
        return "shinken-element-property-line-V3 shinken-layout-column-start-h ";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectWithResearchFromData_V3_computeOnce, PROPERTY.SingleSelectWithResearchFromData_V3 );
WEATHER.VisualForm           = function ( name ) {
    this.init( name );
};
WEATHER.VisualForm.prototype = {
    init          : function ( name ) {
        this.initCommon( name );
        this.initAllContent();
        this.setPhaseDomElement( document.querySelector( ".shinken-weather-form-container" ) );
    },
    initAllContent: function () {
        let widget_cf = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderFromData( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS._KEY, _( "form.collapse_folder.label." + SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS._KEY ) ), true );
        
        let widget_modes = this.addSpecificToChild( new SHINKEN.OBJECT.WidgetRadioModes( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES._KEY ), widget_cf );
        widget_modes.add( new SHINKEN.OBJECT.RadioWidgetModeSelect( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT ) );
        let widget_mode_add = widget_modes.add( new SHINKEN.OBJECT.RadioWidgetModeAdd( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD ) );
        widget_modes.add( new SHINKEN.OBJECT.RadioWidgetModeSpaceCreate( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE ) );
        widget_modes.add( new SHINKEN.OBJECT.RadioWidgetModeSpaceDelete( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE ) );
        
        let widget_mode_add_radios = this.addSpecificToChild( new SHINKEN.OBJECT.AddRadioModes( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.RADIOS._KEY ), widget_mode_add );
        widget_mode_add_radios.add( new WEATHER.AddRadioModeWeather( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.WEATHER_ADD ) );
        widget_mode_add_radios.add( new WEATHER.AddRadioModeSeparator( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.SEPARATOR_ADD ) );
        
        widget_modes.setPhaseDomElement( CONTROLLER.PageController.current_page.getDomElement(), SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES._KEY );
    },
    doActionAfter: function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "show_form_for_widget_configuration":
                if ( this.widget_visual_form ) {
                    if ( this.widget_visual_form.grid_cell.getUUID() === param[SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET].getUUID() ){
                        return;
                    }
                    this.widget_visual_form.getDomElement().remove();
                }
                this.widget_visual_form = SHINKEN.WidgetFormFactory( param );
                this.widget_visual_form.computeHtml();
                DOM.Service.addElementTo( this.widget_visual_form.getDomElement(), document.querySelector( ".shinken-weather-form-container .shinken-grid-cell-configuration" ) );
                CONTROLLER.Form.setCurrentForm( this.widget_visual_form );
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING_SINGLE_GRID_CELL );
                break;
            case "close_form_for_widget_configuration":
            case "cancel_form_for_widget_configuration":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                this.widget_visual_form.getDomElement().remove();
                CONTROLLER.Form.setCurrentForm( this );
                this.widget_visual_form = null;
                break;
            case "undo_last_modification":
            case "redo_last_modification":
            case "ask_close_form_for_widget_configuration__if_needed":
                if ( !this.widget_visual_form ) {
                    return;
                }
                this.widget_visual_form.doActionAfter( event_name, param );
                return;
            default:
                for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                    this.contents[ i ].doActionAfter( event_name, param, param_2, param_3 );
                }
                break;
        }
        if ( this.widget_visual_form ) {
            this.widget_visual_form.doActionAfter( event_name, param );
        }
    },
    
    computeHtmlActions: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.VisualForm, SHINKEN.OBJECT.GridPageVisualForm );
SHINKEN.OBJECT.SeparatorWidgetForm = function ( grid_object, grid_cell ) {
    this.init( "widget-visual-form", grid_object, grid_cell );
};
SHINKEN.OBJECT.SeparatorWidgetForm.prototype = {
    initAllContent : function () {
        this.initNameArea();
        this.initContentArea();
        this.initContentLeftArea();
        this.initContentRightArea();
        this.initContentTitleArea();
    },
    initContentArea: function () {
        let collapse_folder = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.AREAS._KEY, _( "grid.mode_edition.form_widget.separator_widget.cf_area.title", [DICTIONARY_COMMON_UI] ) ), true );
        this.addSpecificToChild( new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED ), _( "grid.mode_edition.form_widget.separator_widget.cf_left_area.properties.displayed._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        this.addSpecificToChild( new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.DISPLAYED.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.DISPLAYED ), _( "grid.mode_edition.form_widget.separator_widget.cf_right_area.properties.displayed._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
    },
    
    initNameArea: function () {
        let type = new PROPERTY.StringInputFromData_V3( WIDGET.CONST.PARAM.TYPE._KEY, this.grid_cell.content.getValue( WIDGET.CONST.PARAM.TYPE._KEY ) );
        this.addSpecific( type, false, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        let property = new PROPERTY.StringInputFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL.COMPOSED_KEY, "", _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.label._key", [DICTIONARY_COMMON_UI] ) );
        property.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.label.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        this.addSpecific( property );
    },
    
    initContentLeftArea : function () {
        let collapse_folder = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.cf_left_area.title", [DICTIONARY_COMMON_UI] ) ), true );
        let property        = this.addSpecificToChild( new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.WIDTH_PERCENT.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.WIDTH_PERCENT ), _( "grid.mode_edition.form_widget.separator_widget.cf_left_area.properties.width_percent._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        property.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.cf_left_area.properties.width_percent.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
    },
    initContentRightArea: function () {
        let collapse_folder = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.RIGHT_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.cf_right_area.title", [DICTIONARY_COMMON_UI] ) ), true );
        let property        = this.addSpecificToChild( new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT ), _( "grid.mode_edition.form_widget.separator_widget.cf_right_area.properties.width_percent._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        property.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.cf_right_area.properties.width_percent.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
    },
    initContentTitleArea: function () {
        let collapse_folder = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TITLE_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.title", [DICTIONARY_COMMON_UI] ) ), true );
        this.addSpecificToChild( new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN ), _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.text_align._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        let property_1 = this.addSpecificToChild( new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR ), _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.text_color._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        let property_2 = this.addSpecificToChild( new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT ), _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.font_zoom_percent._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        property_1.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.text_color.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        property_2.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.font_zoom_percent.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
    },
    
    getConfigurationForPropertiesRadioList: function ( property_structure ) {
        let to_return = [];
        let dict_key;
        switch ( property_structure._KEY ) {
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED._KEY:
                dict_key = "grid.mode_edition.form_widget.separator_widget.cf_left_area.properties.displayed.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN._KEY:
                dict_key = "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.text_align.radio";
                break;
        }
        return this.parseConfigurationToArray( property_structure.OPTIONS, dict_key, property_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SeparatorWidgetForm, SHINKEN.OBJECT.InterfaceWidgetForm );
SHINKEN.OBJECT.TitleWidgetForm = function ( grid_object, grid_cell ) {
    this.init( "widget-visual-form", grid_object, grid_cell );
};
SHINKEN.OBJECT.TitleWidgetForm.prototype = {
    
    initAllContent: function () {
        this.initContentTitleArea();
    },
    
    initContentTitleArea: function () {
        let _type = new PROPERTY.StringInputFromData_V3( WIDGET.CONST.PARAM.TYPE._KEY, this.grid_cell.content.getValue( WIDGET.CONST.PARAM.TYPE._KEY ) );
        this.addSpecific( _type, false, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        
        let _title = new PROPERTY.StringInputFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL.COMPOSED_KEY, "", _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.label._key", [DICTIONARY_COMMON_UI] ) );
        _title.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.label.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        this.addSpecific( _title );
        
        
        let _color = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR ), _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.text_color._key", [DICTIONARY_COMMON_UI] ) );
        _color.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.text_color.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        this.addSpecific( _color );
        
        this.addSpecific( new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN ), _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.text_align._key", [DICTIONARY_COMMON_UI] ) ) );
        
        
        let _font_zoom = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT ), _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.font_zoom_percent._key", [DICTIONARY_COMMON_UI] ) );
        _font_zoom.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.font_zoom_percent.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        this.addSpecific( _font_zoom );
    },
    
    getConfigurationForPropertiesRadioList: function ( property_structure ) {
        let to_return = [];
        let dict_key;
        switch ( property_structure._KEY ) {
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN._KEY:
                dict_key = "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.text_align.radio";
                break;
        }
        return this.parseConfigurationToArray( property_structure.OPTIONS, dict_key, property_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TitleWidgetForm, SHINKEN.OBJECT.InterfaceWidgetForm );
SHINKEN.OBJECT.WeatherWidgetForm = function ( grid_object, grid_cell ) {
    this.init( "widget-visual-form", grid_object, grid_cell );
};
SHINKEN.OBJECT.WeatherWidgetForm.prototype = {
    init        : SHINKEN.OBJECT.InterfaceWidgetForm.prototype.init,
    doActionAfterSpecific: function ( event_name, param ) {
        switch ( event_name ) {
            case "slide_panel__size__has_changed":
                if ( this.grid_for_preview ) {
                    this.grid_for_preview.doActionAfter( event_name, param );
                }
                break;
            case "change_radio_mode_done":
                this.synchronizationProperty( param );
                this.synchronizationPreviewWithProperty( param );
                break;
            case "widget_preview__compute_html_done":
            case "change__widget_preview_zone__activity":
                for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                    this.contents[ i ].doActionAfter( event_name, param );
                }
                break;
            case "widget_becomes_configured":
                this.is_configured__20241216 = true;
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.DISPLAY._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.AREAS._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                this.property_set.getContentByUUID( WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                this.getContentByUUID( "grid_for_preview" ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                this.getContentByUUID( "grid_for_preview" ).computeSizes();
                break;
            case "widget_becomes_not_configured":
                this.is_configured__20241216 = false;
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.DISPLAY._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.AREAS._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                this.property_set.getContentByUUID( WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                this.getContentByUUID( "grid_for_preview" ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                break;
        }
    },
    initAllContent    : function () {
        this.is_configured__20241216 = this.grid_cell.getShinkenElement().isConfigured();
        this.initContentShinkenElement();
        this.initContentDisplay();
        this.initContentArea();
        
        this.initPreviewWidget();
        
        this.initContentLeftArea();
        this.initContentTopRightArea();
        this.initContentSLAArea();
        this.initContentNameArea();
        
    },
    initContentDisplay: function () {
        let collapse_folder = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.DISPLAY._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_display.title", [DICTIONARY_COMMON_UI] ) ), true, this.is_configured__20241216 ? SHINKEN.CONST.VISIBILITY_STATE.NORMAL : SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME ), _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.property_used_as_name._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        let property = this.addSpecificToChild( new PROPERTY.CheckBoxRadioProp__WithSelector__FromData( WIDGET.CONST.PARAM.LAYOUT.BACKGROUND.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.BACKGROUND ), _( "grid.mode_edition.form_widget.weather_widget.cf_display.properties.background._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        property.doActionAfter( "change_selector_default_title", { [ COMPONENT.CONST.PARAM.TEXT_DEFAULT_SELECTOR ]: _( "grid.mode_edition.form_widget.weather_widget.cf_display.properties.background.radio.default_label_selector", [DICTIONARY_COMMON_UI] ) } );
    },
    initContentArea   : function () {
        let collapse_folder = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.AREAS._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_area.title", [DICTIONARY_COMMON_UI] ) ), true, this.is_configured__20241216 ? SHINKEN.CONST.VISIBILITY_STATE.NORMAL : SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        let property_right  = this.addSpecificToChild( new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED ), _( "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.properties.displayed._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        property_right.addParamForEvents( SHINKEN.OBJECT.COLLAPSE.PARAM.NAME_FOR_HIDDEN_PREVIEW, SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY );
        let property_sla = this.addSpecificToChild( new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED ), _( "grid.mode_edition.form_widget.weather_widget.cf_sla_area.properties.displayed._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        property_sla.addParamForEvents( SHINKEN.OBJECT.COLLAPSE.PARAM.NAME_FOR_HIDDEN_PREVIEW, SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.SLA_AREA._KEY );
    },
    
    initPreviewWidget: function () {
        this.grid_for_preview      = new SHINKEN_GRID.GridForPreview( this.getContextForPreviewWidget() );
        this.grid_cell_for_preview = this.grid_for_preview.grid_elements.getContent( 0 );
        this.addSpecific( this.grid_for_preview, true, this.is_configured__20241216 ? SHINKEN.CONST.VISIBILITY_STATE.NORMAL : SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
    },
    
    initContentLeftArea    : function () {
        let collapse_folder = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_left_area.title", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview ), true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        let property        = this.addSpecificToChild( new PROPERTY.CheckBoxRadioProp__WithSelector__FromData( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE ), _( "grid.mode_edition.form_widget.weather_widget.cf_left_area.properties.icon_type._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        property.doActionAfter( "change_selector_default_title", { [ COMPONENT.CONST.PARAM.TEXT_DEFAULT_SELECTOR ]: _( "grid.mode_edition.form_widget.weather_widget.cf_left_area.properties.icon_type.radio.default_label_selector", [DICTIONARY_COMMON_UI] ) } );
    },
    initContentTopRightArea: function () {
        let collapse_folder = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.title", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview ), true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        let property        = this.addSpecificToChild( new PROPERTY.CheckBoxRadioProp__WithSelector__FromData( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE ), _( "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.properties.icon_type._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        property.doActionAfter( "change_selector_default_title", { [ COMPONENT.CONST.PARAM.TEXT_DEFAULT_SELECTOR ]: _( "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.properties.displayed.radio.default_label_selector", [DICTIONARY_COMMON_UI] ) } );
    },
    initContentSLAArea     : function () {
        let collapse_folder = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.SLA_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_sla_area.title", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview ), true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON ), _( "grid.mode_edition.form_widget.weather_widget.cf_sla_area.properties.show_icon._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
    },
    initContentNameArea    : function () {
        let collapse_folder = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.NAME_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.title", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview ), true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN ), _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.vertical_align._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        let property_1 = this.addSpecificToChild( new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.FONT_ZOOM_PERCENT.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.FONT_ZOOM_PERCENT ), _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.font_zoom_percent._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        let property_2 = this.addSpecificToChild( new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.NB_LINES_MAX.COMPOSED_KEY, this.getConfigurationForPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.NB_LINES_MAX ), _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.nb_lines_max._key", [DICTIONARY_COMMON_UI] ) ), collapse_folder );
        property_1.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.font_zoom_percent.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        property_2.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.nb_lines_max.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
    },
    synchronizationPreviewWithProperty: function ( param ) {
        switch ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ) {
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED.COMPOSED_KEY:
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED.COMPOSED_KEY:
                let property = this.property_set.getContentByUUID( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] );
                let value    = property.getDataToSave__20241127( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID );
                if ( !value[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] || value[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === "false" ) {
                    this.getContentByUUID( param[ SHINKEN.OBJECT.COLLAPSE.PARAM.NAME_FOR_HIDDEN_PREVIEW ] ).doActionAfter( "hide_collapse_folder" );
                }
                break;
        }
        
    },
    synchronizationProperty           : function ( param ) {
        switch ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ) {
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY:
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY:
                let property_left  = this.property_set.getContentByUUID( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY );
                let property_right = this.property_set.getContentByUUID( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY );
                let value_left     = property_left.getDataToSave__20241127( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID );
                let value_tp_r     = property_right.getDataToSave__20241127( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID );
                if ( WIDGET.CONST.isSameIconType( value_left, value_tp_r ) ) {
                    if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY ) {
                        if ( value_left[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON ) {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS );
                        }
                        else {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON );
                        }
                        SHINKEN.TOOLS.NOTIFICATION.addNotification( SHINKEN.TOOLS.STRING.format( _( "validation.errors.change_auto__duplicate_value_on_property" ),
                            '<span class="shinken-data-user">' + property_right.getLabel() + '</span>&nbsp;<span "shinken-note"> (&nbsp;' + this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY )
                                                                                                                                                .getLabel() + '&nbsp;)</span>',
                            '<span class="shinken-data-user">' + property_left.getLabel() + '</span>&nbsp;<span "shinken-note"> (&nbsp;' + this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY )
                                                                                                                                               .getLabel() + '&nbsp;)</span>'
                        ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.INFO, null, 10000 );
                    }
                    if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY ) {
                        if ( value_tp_r[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON ) {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS );
                        }
                        else {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON );
                        }
                        SHINKEN.TOOLS.NOTIFICATION.addNotification( SHINKEN.TOOLS.STRING.format( _( "validation.errors.change_auto__duplicate_value_on_property" ),
                            '<span class="shinken-data-user">' + property_right.getLabel() + '</span>&nbsp;<span "shinken-note"> (&nbsp;' + this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY )
                                                                                                                                                .getLabel() + '&nbsp;)</span>',
                            '<span class="shinken-data-user">' + property_left.getLabel() + '</span>&nbsp;<span "shinken-note"> (&nbsp;' + this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY )
                                                                                                                                               .getLabel() + '&nbsp;)</span>'
                        ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.INFO, null, 10000 );
                    }
                }
                break;
        }
    },
    parseDataForSpecialCase: function ( data, param ) {
        if ( SHINKEN.TOOLS.DICT.getObjectWithComposedKey( data, param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ).value === WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.FROM_WEBUI ) {
            let webui_value = this.parseTilesBackgroundValueForPreview( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] );
            data            = SHINKEN.TOOLS.DICT.replaceValuesForGivenKeyInDict( data, "value", WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.FROM_WEBUI, webui_value );
        }
        return data;
    },
    getContextForPreviewWidget: function () {
        const layout = SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseDictToDict_withValueKey( this.grid_cell.content.layout.getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT ) );
        return {
            "width"  : {
                "value": 15
            },
            "height" : {
                "value": 4
            },
            "content": {
                "type"  : {
                    "value": "weather_widget"
                },
                "layout": {
                    "value": layout
                },
                "item"  : {
                    "value": {
                        "item_uuid": {
                            "value": "010010010"
                        },
                        "item_name": {
                            "value": "Preview_Widget"
                        },
                        "item_type": {
                            "value": "host"
                        }
                    }
                }
            }
        };
    },
    
    getSpecificDomElementTitle: function () {
        let to_return;
        if ( this.is_configured__20241216 ) {
            to_return = DOM.Service.createElement( 'div', { class: "shinken-form-title-content" } );
            DOM.Service.addElementTo( DOM.Service.createElement( 'span', { class: "shinken-form-title" }, _( "grid.mode_edition.form_widget." + this.grid_cell.getWidgetType() + ".title", [DICTIONARY_COMMON_UI] ) ), to_return );
            DOM.Service.addElementTo( DOM.Service.createElement( 'span', { class: "shinken-form-title" }, this.grid_cell.content.getNameToDisplay() ), to_return );
        }
        else {
            to_return = DOM.Service.createElement( 'span', { class: "shinken-form-title" }, _( "grid.mode_edition.form_widget." + this.grid_cell.getWidgetType() + ".title", [DICTIONARY_COMMON_UI] ) );
        }
        return to_return;
    },
    
    getConfigurationForPropertiesRadioList: function ( property_structure ) {
        let to_return = [];
        let enum_tab;
        let dict_key;
        switch ( property_structure._KEY ) {
            case WIDGET.CONST.PARAM.LAYOUT.BACKGROUND._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_display.properties.background.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.property_used_as_name.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_left_area.properties.icon_type.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.vertical_align.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.properties.displayed.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.properties.icon_type.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_sla_area.properties.displayed.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_sla_area.properties.show_icon.radio";
                break;
        }
        return this.parseConfigurationToArray( property_structure.OPTIONS, dict_key, property_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.WeatherWidgetForm, SHINKEN.OBJECT.InterfaceWidgetFormWithShinkenElement );
WEATHER.AddRadioModeWeather           = function ( name ) {
    this.initSpecific( name );
};
WEATHER.AddRadioModeWeather.prototype = {
    initSpecific: function ( name ) {
        this.init( name );
        this.setLabel( WIDGET.Weather.prototype.getTypeLabel() );
    },
    
    getIconHtml: function () {
        if ( !WEATHER.CONST.COMPONENT.SVG.RADIO_ICON ) {
            WEATHER.CONST.COMPONENT.SVG.RADIO_ICON = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-radio-button-svg" ) ).outerHTML;
        }
        return WEATHER.CONST.COMPONENT.SVG.RADIO_ICON;
    },
    getLabelDomElement: function () {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-label-container shinken-layout-center-h-v" } );
        DOM.Service.addElementTo( WIDGET.Weather.prototype.getIconTypeDom(), to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-label" }, this.label ), to_return );
        return to_return;
    },
    callbackForPhase  : function () {
         switch ( this.getCurrentPhase() ){
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING:
                CONTROLLER.PageController.doActionAfter("change_virtual_add_grid_cell", {[SHINKEN.OBJECT.RADIOMODE.PARAM.NAME] : this.name } );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.AddRadioModeWeather, SHINKEN.OBJECT.RadioMode );
WEATHER.AddRadioModeSeparator           = function ( name ) {
    this.initSpecific( name );
};
WEATHER.AddRadioModeSeparator.prototype = {
    initSpecific: function ( name, label ) {
        this.init( name );
        this.setLabel( WIDGET.Separator.prototype.getTypeLabel() );
        
    },
    
    getIconHtml: function () {
        return WEATHER.AddRadioModeWeather.prototype.getIconHtml();
    },
    
    getLabelDomElement: function () {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-label-container shinken-layout-center-h-v" } );
        DOM.Service.addElementTo( WIDGET.Separator.prototype.getIconTypeDom(), to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-label" }, this.label ), to_return );
        return to_return;
    },
    callbackForPhase  : function () {
         switch ( this.getCurrentPhase() ){
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING:
                CONTROLLER.PageController.doActionAfter("change_virtual_add_grid_cell", {[SHINKEN.OBJECT.RADIOMODE.PARAM.NAME] : this.name } );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.AddRadioModeSeparator, SHINKEN.OBJECT.RadioMode );
WEATHER.CollapseFolderShinkenElement           = function ( name, is_configured ) {
    this.initSpecific( name, _( "grid.mode_edition.form_widget.cf_shinken_element.title", [DICTIONARY_COMMON_UI] ) );
};
WEATHER.CollapseFolderShinkenElement.prototype = {
    initSpecific: SHINKEN.OBJECT.CollapseFolderFromData.prototype.initSpecific,
    computeSpecificHtml: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.CollapseFolderShinkenElement, SHINKEN.OBJECT.CollapseFolderFromData );
WEATHER.ViewHistory           = function ( name, pagination ) {
    this.init( name, pagination );
};
WEATHER.ViewHistory.prototype = {
    init        : SHINKEN.OBJECT.ViewHistory.prototype.init,
    initSpecific: function ( parent, dom_element_target, avoid_load_last_modification ) {
        this.parent = parent;
        this.initList();
        this.dom_element_parent__20240822 = dom_element_target;
        this.getDataFromBackend__20241001();
        if ( parent.last_modifications && !avoid_load_last_modification ) {
            this.addDoActionAfterCallBackPhaseIs( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING, "load_last_modifications", { modifications_objects_until_init: parent.last_modifications.contents } );
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "redo_last_modification":
            case "add_last_modification":
                this._updateLastModifications( "add", param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.MODIFICATION ] );
                break;
            case "load_last_modifications":
                for ( let i = 0, _size_i = param[ "modifications_objects_until_init" ].length; i < _size_i; i++ ) {
                    this._updateLastModifications( "add", param[ "modifications_objects_until_init" ][ i ] );
                }
                break;
            case "undo_last_modification":
                this._updateLastModifications( "remove" );
                break;
            case "clear_all_last_modifications":
                this._updateLastModifications( "clear", param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.NB_LAST_MODIFICATION ] );
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    _updateLastModifications: function ( type_action, data ) {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.INIT ) ) {
            return;
        }
        DOM.Service.removeElement( this.getList__20240822().getDomElement() );
        switch ( type_action ) {
            case "add":
                this.getList__20240822().addLineWithData( this.parseLastModificationDataLine( data ), 0 );
                break;
            case "remove":
                this.getList__20240822().getLines().removeContentByIndex( 0 );
                break;
            case "clear":
                this.getList__20240822().getLines().removeFirstXContent( data );
                break;
        }
        this.computeHtml();
        DOM.Service.addElementTo( this.getList__20240822().getDomElement(), this.dom_element_parent__20240822 );
    },
    getBackendUrl: function () {
        return SHINKEN.HIGHWAY.getOrigin() + "/service-weather/api/V1/get-history/" + this.getName();
    },
    parseLastModificationDataLine: function ( data ) {
        return this.parseLastModificationDataLineGrid( data );
    },
    parseBackendDataLine: function ( data ) {
        return this.parseBackendDataLineGrid( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ViewHistory, SHINKEN_GRID.ViewHistory );
SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION = (function ( self ) {
    "use strict";
    self.askEnterEditMode = function () {
        try {
            if ( window.parent.EXTERNAL ) {
                window.parent.EXTERNAL.IFRAME.LISTENER.listenEnterEditMode();
            }
        }
        catch ( e ) {
            console.warn( "askEnterEditMode", e );
        }
    };
    self.askLeaveEditMode = function () {
        try {
            if ( window.parent.EXTERNAL ) {
                window.parent.EXTERNAL.IFRAME.LISTENER.listenLeaveEditMode();
            }
        }
        catch ( e ) {
            console.warn( "askLeaveEditMode", e );
        }
    };
    self.askOpenHelp      = function () {
        try {
            if ( window.parent.EXTERNAL ) {
                window.parent.EXTERNAL.IFRAME.LISTENER.listenOpenHelp();
            }
        }
        catch ( e ) {
            console.warn( "askOpenHelp", e );
        }
    };
    self.listenSaveDone   = function () {
        try {
            if ( window.parent.EXTERNAL ) {
                window.parent.EXTERNAL.IFRAME.LISTENER.listenSaveDone();
            }
        }
        catch ( e ) {
            console.warn( "listenSaveDone", e );
        }
    };
    self.askSaveUserPrefs = function ( key, value ) {
        try {
            if ( window.parent.EXTERNAL ) {
                window.parent.EXTERNAL.IFRAME.LISTENER.listenSaveUserSinglePref( key, value );
            }
        }
        catch ( e ) {
            console.warn( "askSaveUserPrefs", e );
        }
    };
    self.getUserPref      = function ( pref_name ) {
        try {
            if ( window.parent.EXTERNAL ) {
                return window.parent.EXTERNAL.IFRAME.LISTENER.listenGetUserPref( pref_name );
            }
        }
        catch ( e ) {
            console.warn( "getUserPref", e );
        }
        return {};
    };
    
    return self;
})( SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION || {} );
WEATHER.ExternalLinkLayout = function ( data ) {
    this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
    this.init( data );
    _load_extra_lang_obj( "weather_lang" );
};
WEATHER.ExternalLinkLayout.prototype = {
    init                       : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.init,
    _getValidOwnProperty       : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_PROTOCOL, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( EXTERNAL_LINKS.CONST.EXTERNAL_LINK.ENUM.LINK_PROTOCOL, WEATHER.CONST.DEFAULT_VALUE )],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_BASE_URL, SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN, ["\"", "'", " "]],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_EXTERNAL_PART_URL, SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN, ["\"", "'", "/", " "]],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.AUTHENTICATION_NEEDED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    },
    _getValidOwnChildren       : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.INFO_BAR, "SHINKEN_PAGE.InfoBar"],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.NOTIFICATIONS, "WEATHER.Notifications"]
        ] );
    },
    getValueForTooltip         : function ( key ) {
        switch ( key ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAMS.AUTHENTICATION_NEEDED:
                return this.getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.INFO_BAR ).getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED:
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.INFO_BAR ).getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH )
                           .getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY :
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.NOTIFICATIONS ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY )
                           .getBooleanValue( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.NOTIFICATIONS ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL._KEY ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY )
                           .getBooleanValue( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.INFO_BAR )
                           .getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION ) === SHINKEN_PAGE.CONST.INFO_BAR.VALUES.POSITION_BOTTOM ? _( "external_link_tooltip.bottom", ["weather_lang"] ) : _( "external_link_tooltip.top", ["weather_lang"] );
            default:
                return this.getValue( key );
        }
    },
    getComputeHostUrl          : function () {
        let _host = SHINKEN.HIGHWAY.getHost();
        if ( SHINKEN.HIGHWAY.isDocumentationOn() ) {
            return "<span class='shinken-sensible'>" + _host + "</span>";
        }
        return _host;
    },
    computeUrl                 : function () {
        let _base_url     = this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_BASE_URL );
        this.computed_url = [
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_PROTOCOL ) + ":/",
            _base_url || this.getComputeHostUrl(),
            COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE,
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_EXTERNAL_PART_URL ),
            this.weather_uuid,
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_UUID )
        ].join( "/" );
    },
    getComputedUrl             : function () {
        if ( !this.computed_url ) {
            this.computeUrl();
        }
        return this.computed_url;
    },
    openLinkInNewTab           : function () {
        SHINKEN.HIGHWAY.goToBlank( this.getComputedUrl() );
    },
    copyLinkToClipboard        : function ( dom_button ) {
        CLIPBOARD_SERVICE.setContent( dom_button, this.getComputedUrl(), this.copyLinkToClipboardCallback );
    },
    copyLinkToClipboardCallback: function ( status, dom_button ) {
        let _text     = status ? _( "copy_service.copyExternalLinkSuccess", ["weather_lang"] ) : _( "copy_service.copyFail", ["weather_lang"] );
        let _state    = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED;
        let _position = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _text, _state, dom_button, _position, 2000 );
    },
    buildTooltip               : function () {
        let to_return = document.querySelector( "#id-shinken-template-view .shinken-external-link-tooltip-template" ).innerHTML;
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_auth_needed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.AUTHENTICATION_NEEDED ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_name_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_NAME ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_uuid_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_UUID ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_external_part_url_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_EXTERNAL_PART_URL ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_auth_needed_attribute_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.AUTHENTICATION_NEEDED ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_protocol_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_PROTOCOL ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_position_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_background_color_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.INFO_BAR )
                                                                                                                                                           .getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.BACKGROUND_COLOR ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_logo_displayed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_chrono_displayed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_generated_time_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_sound_notification_enable_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_blink_notification_enable_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_external_url$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getComputedUrl() ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, '"', "&quot;" );
        return to_return;
    },
    buildHtml                  : function ( weather_uuid ) {
        this.weather_uuid = weather_uuid;
        this.computeUrl();
        let to_return = document.querySelector( "#id-shinken-template-view .shinken-external-link-table-template .shinken-external-link-row" ).outerHTML;
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_uuid_$$$", this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_UUID ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_name_$$$", SHINKEN.TOOLS.STRING.cleanXss( this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_NAME ) ) );
        to_return     = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_tooltip_$$$", this.buildTooltip() );
        return to_return;
    },
    getUUID: function () {
        return this.uuid;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinkLayout, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.ExternalLink = function ( data ) {
    this.initSpecific( data );
};
WEATHER.ExternalLink.prototype = {
    initSpecific: function ( data ) {
        this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        this.init( data );
        _load_extra_lang_obj( "weather_lang" );
    },
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_NAME, SHINKEN_VALIDATION.CONST.STRING.NOT_EMPTY, undefined, true],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_UUID],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_PROTOCOL, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( EXTERNAL_LINKS.CONST.EXTERNAL_LINK.ENUM.LINK_PROTOCOL, WEATHER.CONST.DEFAULT_VALUE )],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_BASE_URL, SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN, ["\"", "'", " "]],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_EXTERNAL_PART_URL, SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN, ["\"", "'", "/", " "]],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.AUTHENTICATION_NEEDED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLink, WEATHER.ExternalLinkLayout );
WEATHER.ExternalLinks = function ( data ) {
    this.init( data );
};
WEATHER.ExternalLinks.prototype = {
    init: function ( data ) {
        this.initInternal();
        this.initCounterCommon();
        this.initContents();
        this.updateData( data );
    },
    getChildrenObject    : function () {
        return this.getContents();
    },
    getChildrenObjectDict: function () {
        return this.getContents();
    },
    hasLinks           : function () {
        return !!this.getSize();
    },
    getLinkByUuid      : function ( uuid ) {
        var _current;
        for ( var i = 0, _size = this.getSize(); i < _size; i++ ) {
            _current = this.getContent( i );
            if ( uuid === _current.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINK_UUID ) ) {
                return _current;
            }
        }
        return null;
    },
    getChildConstructor: function ( data ) {
        return new WEATHER.ExternalLink( data );
    },
    updateData: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.updateData,
    reset     : function () {
        this.initContents();
        DOM.Service.removeElement( this.getDomElement() );
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "list_content":
                for ( var i = 0, _size_i = value.length; i < _size_i; i++ ) {
                    this.add( this.getChildConstructor( value[ i ] ) );
                }
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    getDataToSave: function () {
        var _to_return = [];
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _to_return.push( this.contents[ i ].getDataToSave() );
        }
        return _to_return;
    },
    buildHtml   : function ( weather_uuid ) {
        var _to_return = '';
        for ( var i = 0, _size = this.getSize(); i < _size; i++ ) {
            _to_return += this.getContent( i ).buildHtml( weather_uuid );
        }
        return _to_return;
    },
    initMessages: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initMessages
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinks, SHINKEN.OBJECT.ShinkenObjectContainer );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinks, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.LinksConfiguration = function ( weather_uuid, data ) {
    this.weather_uuid = weather_uuid;
    this.computeHtml();
    if ( data ) {
        this.initSpecific( data );
    }
};
WEATHER.LinksConfiguration.prototype = {
    initSpecific        : function ( data ) {
        this.init( data );
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN, this.dom_element );
    },
    computeHtml         : function ( data ) {
        this.dom_element       = DOM.Service.createElement( "div", { class: "shinken-weather-external-links-container" } );
        this.dom_element_table = DOM.Service.createElement( "table", { class: "shinken-external-links-table" } );
        DOM.Service.addElementTo( this.dom_element_table, this.dom_element );
    },
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [] );
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.DEFAULT_LINK, "WEATHER.ExternalLinkLayout"],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINKS, "WEATHER.ExternalLinks"]
        ] );
    },
    doActionAfter                  : function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "on_click_2024_07_31":
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
                    if ( !DOM.Service.findParentElementWithClass( param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].target, "shinken-weather-external-links-container", 100 ) ) {
                        this._clickOnExternalLinks();
                    }
                }
                break;
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "external_links_weather":
                        this._clickOnExternalLinks();
                        break;
                }
                break;
        }
    },
    clickOnButton                  : function ( event_name, event ) {
        switch ( event_name ) {
            case "external_links_weather":
                this._clickOnExternalLinks();
                break;
            case "open_external_link":
                this.openLinkInNewTab( event );
                break;
        }
    },
    _clickOnExternalLinks          : function () {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                DOM.Service.empty( this.dom_element_table );
                this.dom_element_table.innerHTML = this.buildHtml();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
        }
        this._computePositionPopUpEditButton( this.dom_element );
    },
    _computePositionPopUpEditButton: function ( dom ) {
        DOM.Service.cleanAllStyles( dom );
        var _rect = DOM.Service.getBoundingClientRect( dom );
        if ( _rect.left < 0 ) {
            DOM.Service.removeStyle( dom, DOM.CONST.STYLE.RIGHT );
            DOM.Service.setStyle( dom, DOM.CONST.STYLE.LEFT, "0" );
        }
        else if ( _rect.left + _rect.width > window.innerWidth ) {
            DOM.Service.removeStyle( dom, DOM.CONST.STYLE.LEFT );
            DOM.Service.setStyle( dom, DOM.CONST.STYLE.RIGHT, "0" );
        }
        
        if ( _rect.bottom > window.innerHeight ) {
            DOM.Service.removeStyle( dom, DOM.CONST.STYLE.BOTTOM );
            DOM.Service.setStyle( dom, DOM.CONST.STYLE.TOP, "-" + _rect.height + "px" );
        }
        else if ( _rect.top < 0 ) {
            DOM.Service.removeStyle( dom, DOM.CONST.STYLE.TOP );
        }
    },
    openLinkInNewTab               : function ( event ) {
        var _link_uuid = DOM.Service.findParentElementWithDataSet( event.target, "linkUuid", 10 ).dataset[ "linkUuid" ];
        var _link      = this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINKS ).getLinkByUuid( _link_uuid );
        _link.openLinkInNewTab();
    },
    copyLinkToClipboard            : function ( event ) {
        var _link_uuid = DOM.Service.findParentElementWithDataSet( event.target, "linkUuid", 10 ).dataset[ "linkUuid" ];
        var _link      = this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINKS ).getLinkByUuid( _link_uuid );
        _link.copyLinkToClipboard( event.target );
    },
    closePopup                     : function () {
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
        this.closeCopyNotificationPopup();
    },
    mouseDown                      : function ( event ) {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN ) ) {
            return;
        }
        var _target             = event.target;
        var _dom_parent         = DOM.Service.findParentElementWithClass( _target, "shinken-weather-external-links-container", 20 );
        var _dom_button         = DOM.Service.findParentElementWithClass( _target, "shinken-button", 20 );
        var _drag_n_drop_zone   = DOM.Service.findParentElementWithClass( _target, "shinken-weather-edit-drag-cell", 20 );
        var _is_external_button = _dom_button && _dom_button.dataset[ "name" ] === "external_links_weather";
        if ( !_dom_parent && !_is_external_button && !_drag_n_drop_zone ) {
            this.closePopup();
        }
    },
    closeCopyNotificationPopup     : function () {
        SHINKEN.TOOLS.NOTIFICATION.cleanAllNotification();
    },
    getUUID     : function () {
        return this.weather_uuid;
    },
    setDomParent: function ( to_set ) {
        DOM.Service.addElementTo( this.dom_element, to_set );
    },
    hasLinks : function () {
        return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINKS ).hasLinks();
    },
    buildHtml: function () {
        return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAMS.LINKS ).buildHtml( this.weather_uuid );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.LinksConfiguration, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.LinksConfiguration, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.OBJECT.WeatherJsonEditor = function ( dom_element, json, default_tag ) {
    this.__class_name__ = 'SHINKEN.OBJECT.WeatherJsonEditor';
    this.dom_element    = dom_element;
    this.json           = json;
    this.content        = null;
    this.default_tag    = default_tag;
    this.init();
};
SHINKEN.OBJECT.WeatherJsonEditor.prototype = {
    init: SHINKEN.OBJECT.JsonEditor.init,
    isEditableKeyElement: function ( key ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT:
            case SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS:
            case SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y:
                return true;
        }
        return false;
    },
    isLabelOfEditableKey: function ( key ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y:
                return true;
        }
        return false;
    },
    getController       : function () {
        return CONTROLLER.PageController;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.WeatherJsonEditor, SHINKEN.OBJECT.JsonEditor );
WEATHER.PageEdit           = function ( uuid ) {
    this.__class_name__ = "WEATHER.PageEdit";
    this.init( uuid );
};
WEATHER.PageEdit.prototype = {
    init                 : function ( uuid ) {
        this.initCommon( uuid );
        this.initNotificationsOfChange();
        this.initEditMode();
    },
    reset                : WEATHER.Page.prototype.reset,
    setData              : WEATHER.Page.prototype.setData,
    getChildrenObjectDict: WEATHER.Page.prototype.getChildrenObjectDict,
    initMessages         : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initMessages,
    setIdentification    : WEATHER.Page.prototype.setIdentification,
    initButtonsEdition    : function () {
        this.button_enter_edit_mode = new COMPONENT.ButtonFromData_V3( "enter_in_edit_mode", _( 'edit_mode.buttons.edit_mode' ) );
        this.button_enter_edit_mode.computeHtml();
        DOM.Service.addElementToAfterEmpty( this.button_enter_edit_mode.getDomElement(), document.querySelector( ".shinken-weather-edit-mode-button-cell .shinken-button-container" ) );
        this.button_external_links = new COMPONENT.ButtonFromData_V3( "external_links_weather", _( 'edit_mode.buttons.external_link' ) );
        this.button_external_links.computeHtml();
        DOM.Service.addElementAtIndex( DOM.Service.createElement( "span", { class: "shinken-2023-external-link" } ), this.button_external_links.getDomElement(), 0 );
        DOM.Service.addElementToAfterEmpty( this.button_external_links.getDomElement(), document.querySelector( ".shinken-weather-external-links-button-cell .shinken-button-container" ) );
    },
    getViewHistoryInstance: function () {
        return new WEATHER.ViewHistory( this.getUUID(), 30 );
    },
    getVisualFormInstance : function () {
        return new WEATHER.VisualForm( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.VISUAL );
    },
    getJsonEditorInstance : function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.WeatherJsonEditor( dom_element, json, default_tag );
    },
    isSameViewData        : function ( data ) {
        return this.page_version === data.weather_version && this.last_modifications.getCurrentStep() === SHINKEN.OBJECT.CONST.LAST_MODIFICATION.INITIAL_STEP;
    },
    getPageEditDomElement : function ( name ) {
        if ( !this.dom_elements ) {
            this.dom_elements = [];
        }
        switch ( name ) {
            case WEATHER.CONST.DOM_ELEMENT.BTN_EXTERNAL_LINKS_CONTAINER:
                this.dom_elements[ name ] = document.querySelector( "#id-shinken-weather-edit-buttons-container .shinken-weather-external-links-button-cell .shinken-button-container" );
                break;
            case WEATHER.CONST.DOM_ELEMENT.EDIT_MODE_BTN_EXTERNAL_LINKS_CONTAINER:
                this.dom_elements[ name ] = document.querySelector( ".shinken-weather-edition-button-action .shinken-weather-external-links-button-cell .shinken-button-container" );
                break;
        }
        return this.getPageEditDomElementCommon( name );
    },
    doActionAfterSpecific : function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "on_click_2024_07_31":
                if ( this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ] ) {
                    this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].doActionAfter( event_name, param );
                }
                break;
            case "on_drag_start":
                switch ( param ) {
                    case "weather-edit-buttons-container":
                        DOM.Service.parsePositionForDragStart( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.EDIT_BUTTONS_CONTAINER ), true );
                        this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].closeCopyNotificationPopup();
                        this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].closePopup();
                        break;
                    case SHINKEN_PAGE.CONST.SLIDE_PANEL.EDITION.NAME:
                        this.slide_panel_edition.doActionAfter( event_name, { "origin_x": param_2, "origin_y": param_3 } );
                        this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].closePopup();
                        break;
                    case SHINKEN_PAGE.CONST.SLIDE_PANEL.PROBLEMS.NAME:
                        this.slide_panel_problems.doActionAfter( event_name, { "origin_x": param_2, "origin_y": param_3 } );
                        this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].closePopup();
                        break;
                    default:
                        break;
                }
                break;
            case "on_drag_move":
                switch ( param ) {
                    case "weather-edit-buttons-container":
                        this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                        break;
                }
                break;
            case "current_view_is_being_deleted":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
        }
    },
    clickOnButton: function ( event, event_name, param ) {
        switch ( event_name ) {
            case "external_links_weather":
                this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].clickOnButton( event_name );
                this.closeSavingPopUp();
                return;
            case "open_external_link":
                this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].clickOnButton( event_name, event );
                return;
            case "copy_external_link":
                this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].copyLinkToClipboard( event );
                return;
        }
        this.clickOnButtonCommon( event, event_name, param );
    },
    getController: function () {
        return CONTROLLER.PageController;
    },
    getBackendDataUrl__20241008: function ( need_user_value ) {
        let _url = SHINKEN.HIGHWAY.getOrigin() + "/" + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.GET_WEATHER + this.getUUID();
        _url += "?configuration_hash=" + __configuration_hash__ + "&validation_change_time=" + this[ SHINKEN_PAGE.CONST.PARAM.PAGE.VALIDATION_CHANGE_TIME ];
        _url += "&computed_value=true&include_validation_messages=true&source_value=true&config_value=true";
        _url += "&weather_version=";
        _url += need_user_value ? -1 : this.getPageVersion();
        return _url;
    },
    getUrlPreview: function () {
        return "/" + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.PREVIEW_WEATHER + this.getUUID();
    },
    getUrlSave   : function () {
        const _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.PUBLISHING:
                return "/" + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.PUBLISH_WEATHER + this.getUUID();
            default:
                return "/" + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.SAVE_WEATHER + this.getUUID();
        }
    },
    getDataToSaveSpecific: function ( to_return ) {
        to_return[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ] = this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].getDataToSave();
        return to_return;
    },
    
    
    updateButtonExternalLinks: function () {
        const dom_element = this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ? this.getPageEditDomElement( WEATHER.CONST.DOM_ELEMENT.BTN_EXTERNAL_LINKS_CONTAINER ) : this.getPageEditDomElement( WEATHER.CONST.DOM_ELEMENT.EDIT_MODE_BTN_EXTERNAL_LINKS_CONTAINER );
        if ( !dom_element ) {
            return;
        }
        DOM.Service.addElementToAfterEmpty( this.button_external_links.getDomElement(), dom_element );
        let _state = COMPONENT.CONST.BTN_STATE.DISABLED;
        if ( this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].hasLinks() ) {
            _state = COMPONENT.CONST.BTN_STATE.ON;
        }
        this.button_external_links.setTooltipHtml( _state === COMPONENT.CONST.BTN_STATE.DISABLED ? _( "external_link_tooltip.has_no_links" ) : "" );
        this.button_external_links.setState( _state );
    },
    callbackForPhaseSpecific : function () {
        const _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].setDomParent( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.SHINKEN_BOX_MODE_RUNNING ) );
                this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].closePopup();
                this.updateButtonExternalLinks();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.EDITING:
            case SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_EDITING:
                if ( this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ] ) {
                    this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].setDomParent( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.SHINKEN_BOX_MODE_EDITING ) );
                    this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].closePopup();
                    this.updateButtonExternalLinks();
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.SAVING:
            case SHINKEN.OBJECT.CONST.PHASE.PUBLISHING:
                this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].closePopup();
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.PageEdit, SHINKEN.OBJECT.GridPageEdit );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.PageEdit, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.PageEdit, WEATHER.Page );
WIDGET.ShinkenGridStructure           = function ( data ) {
    this.init( data );
};
WIDGET.ShinkenGridStructure.prototype = {
    
    
    __computeHtml : function () {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-widget shinken-height-100", "data-type": "shinken-grid-structure" } );
        DOM.Service.addElementToAfterEmpty( this.dom_element, this.dom_element_parent );
    },
    updateSize    : function () {
        this.computeAllStyle();
    },
    computeAllStyle: function () {
    },
    getNameToDisplay            : function () {
        if ( (__external_url_uuid__ && !__has_authentication_needed__) ) {
            return this.type.value;
        }
        return this.shinken_widget_separator_title.innerHTML;
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.ShinkenGridStructure, WIDGET.Separator );
SHINKEN_GRID.GridForPreview           = function ( data_widget ) {
    this.initSpecific( data_widget );
};
SHINKEN_GRID.GridForPreview.prototype = {
    initSpecific                  : function ( data_widget ) {
        this.uuid = "grid_for_preview";
        this.init( this.createPreviewWidgetWithContext( data_widget ) );
        this.addClass( "shinken-weather-page" );
        this.addClass( "shinken-grid-for-preview" );
    },
    getChildConstructor           : function ( data ) {
        return new SHINKEN_GRID.CellsForPreview( data );
    },
    computeTileSize               : function () {
        let new_tile_size    = DOM.Service.getBoundingClientRect( this.getDomElement(), DOM.CONST.STYLE.WIDTH ) / this.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ) - 1;
        this.tile_pixel_size = Math.min( new_tile_size, 24 );
    },
    computeFontSize               : function () {
        this.font_size = 13;
    },
    getComputedStyle              : function () {
        const _nb_tiles                         = this.max_nb_tiles;
        const _to_return                        = {};
        _to_return[ DOM.CONST.STYLE.HEIGHT ]    = this.tile_pixel_size * _nb_tiles;
        _to_return[ DOM.CONST.STYLE.FONT_SIZE ] = this.font_size;
        return _to_return;
    },
    updateContentData             : function () {
        this.grid_elements.updateContentData( {
            "host-010010010": {
                "item_uuid"                                   : "010010010",
                "item_type"                                   : "host",
                "context"                                     : "DOWNTIME",
                "item_name"                                   : _( "grid.mode_edition.form_widget.weather_widget.cf_preview_widget.item_name", [DICTIONARY_COMMON_UI] ),
                "visualisation_name"                          : _( "grid.mode_edition.form_widget.weather_widget.cf_preview_widget.visualisation_name", [DICTIONARY_COMMON_UI] ),
                "sla"                                         : {
                    "value"             : "100",
                    "warning_threshold" : 99,
                    "critical_threshold": 97,
                    "tendency"          : "arrow-up-ok"
                },
                "status"                                      : 0,
                "exists"                                      : true,
                "element_visibility_on_not_authenticated_view": false,
                "is_not_authorized_for_user"                  : false
            }
        } );
    },
    doActionAfter                 : function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "slide_panel__size__has_changed":
                this.computeSizes();
                break;
            case "compute_html_done":
                this.updateContentData();
                this.computeSizes();
                setTimeout( () => { // I DON'T KNOW WHY IS IT NECESSARY
                    this.computeSizes();
                }, 100 );
                break;
            default:
                this.grid_elements.getContent( 0 ).doActionAfter( event_name, param );
                break;
        }
    },
    createPreviewWidgetWithContext: function ( preview_context ) {
        const preview_pattern_to_change = this.getPatternForPreviewWidget();
        const pattern_value_to_change   = preview_pattern_to_change[ "grid_elements" ][ "list_content" ][ 0 ][ "value" ];
        
        pattern_value_to_change[ "content" ][ "value" ] = preview_context[ "content" ];
        pattern_value_to_change[ "height" ]             = preview_context[ "height" ];
        pattern_value_to_change[ "width" ]              = preview_context[ "width" ];
        return preview_pattern_to_change;
    },
    getPatternForPreviewWidget    : function () {
        return {
            "type"                           : {
                "value": "grid"
            },
            "nb_tiles_in_width"              : {
                "value": 15
            },
            "nb_tiles_in_height"             : {
                "value": 4
            },
            "separation_grid_element_min"    : {
                "value": 10
            },
            "separation_grid_element_max"    : {
                "value": 10
            },
            "separation_grid_element_percent": {
                "value": 0
            },
            "grid_elements"                  : {
                "list_content": [
                    {
                        "value": {
                            "width"     : {
                                "value": 0
                            },
                            "height"    : {
                                "value": 0
                            },
                            "content"   : {
                                "value": {}
                            },
                            "position_x": {
                                "value": 0
                            },
                            "position_y": {
                                "value": 0
                            }
                        }
                    }
                ]
            }
        };
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.GridForPreview, SHINKEN_GRID.Grid );
SHINKEN_GRID.CellsForPreview           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.CellsForPreview.prototype = {
    getChildConstructor: function ( data ) {
        return new SHINKEN_GRID.CellForPreview( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.CellsForPreview, SHINKEN_GRID.Cells );
SHINKEN_GRID.CellForPreview           = function ( data ) {
    this.__class_name__ = "WEATHER.CellForPreview";
    this.initSpecific( data );
};
SHINKEN_GRID.CellForPreview.prototype = {
    initSpecific       : function ( data ) {
        this.init( data );
        this.addClass( "shinken-for-preview" );
    },
    isVisible          : function () {
        return true;
    },
    doActionAfter      : function ( event_name, param ) {
        switch ( event_name ) {
            default:
                this.content.doActionAfter( event_name, param );
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    getChildConstructor: function ( data ) {
        return WIDGET.factoryPreview( data );
    },
    callbackForPhase   : function () {
        let current_phase = this.getCurrentPhase();
        this.updateSize();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.CellForPreview, SHINKEN_GRID.Cell );
WIDGET.factoryPreview = function ( data ) {
    var _to_return;
    var _type = "";
    try {
        _type = data[ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ][ WIDGET.CONST.PARAM.TYPE._KEY ].value || "";
    }
    catch ( e ) {
        try {
            _type = data[ WIDGET.CONST.PARAM.TYPE._KEY ].value || "";
        }
        catch ( e ) {
            _type = data[ "item_type" ] || "";
        }
    }
    switch ( _type ) {
        case WIDGET.CONST.TYPE.WEATHER:
            _to_return = new WIDGET.WeatherForPreview( data );
            break;
    }
    _to_return._timeout_compute_ellipsis = null;
    return _to_return;
};
WIDGET.WeatherForPreview           = function ( data ) {
    this.__class_name__ = "WIDGET.WeatherForPreview";
    this.initSpecific( data );
};
WIDGET.WeatherForPreview.prototype = {
    initSpecific    : WIDGET.Weather.prototype.initSpecific,
    computeHtml     : function () {
        if ( this.getDomElement() ) {
            return;
        }
        this.__computeHtml();
        CONTROLLER.Form.doActionAfter( "widget_preview__compute_html_done", { [ WIDGET.CONST.PARAM_EVENT.WIDGET_DOM_ELEMENT ]: this.getDomElement() } );
    },
    getDomZoneByName: function ( name ) {
        switch ( name ) {
            case  SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY:
                return this.getDomElement().querySelector( ".shinken-cell-left-area" );
            case  SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY:
                return this.getDomElement().querySelector( ".shinken-cell-top-right-area" );
            case  SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.SLA_AREA._KEY:
                return this.getDomElement().querySelector( ".shinken-cell-sla" );
            case  SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.NAME_AREA._KEY:
                return this.getDomElement().querySelector( ".shinken-cell-name" );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.WeatherForPreview, WIDGET.Weather );
WIDGET.ZoneForPreview           = function ( name ) {
    this.__class_name__ = "WIDGET.ZoneForPreview";
    this.init( name );
};
WIDGET.ZoneForPreview.prototype = {
    init             : function ( name ) {
        this.name = name;
        this.initCounterCommon();
        this.initPhase();
        this.button = new COMPONENT.ButtonFromData_V3( "change__widget_preview_zone__activity", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-cog-svg" ) ).outerHTML );
        this.addParamForEvents( SHINKEN.OBJECT.COLLAPSE.PARAM.NAME, this.name );
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    getUUID          : function ( event_name, param ) {
        return this.name;
    },
    addParamForEvents: function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        this.button.addParamForEvents( key, value );
    },
    computeHtml              : function ( dom_element_parent ) {
        if ( !this.getDomElement() ) {
            this.setDomElement( DOM.Service.createElement( "div", {
                class    : "shinken-grid-cell-mask-container-preview",
                "onclick": "MANAGER.EventManagerV2.doActionAfter(event,'change__widget_preview_zone__activity'," + this.parseParamForEventsToHtml() + ")"
            } ) );
            this.button.computeHtml();
            this.addDomElement( this.button.getDomElement() );
            this.addCountersTargetDomElement( this.getDomElement() );
            this.setPhaseDomElement( this.getDomElement() );
        }
        this.insertDomElementInPreview( dom_element_parent );
    },
    insertDomElementInPreview: function ( dom_element_parent ) {
        if ( !dom_element_parent ) {
            return;
        }
        dom_element_parent.classList.add( "shinken-relative-div" );
        DOM.Service.addElementTo( this.getDomElement(), dom_element_parent );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.ZoneForPreview, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.ZoneForPreview, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview           = function ( name, label, grid_cell_for_preview ) {
    this.initSpecific( name, label );
    this.initZonePreview();
    if ( grid_cell_for_preview ) {
        this.widget_preview = grid_cell_for_preview[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ];
    }
};
SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview.prototype = {
    initSpecific     : SHINKEN.OBJECT.CollapseFolderForProperties.prototype.initSpecific,
    setCountersParent: SHINKEN.OBJECT.CollapseFolderForProperties.prototype.setCountersParent,
    initZonePreview  : function () {
        this.zone_preview = new WIDGET.ZoneForPreview( this.getName() );
        this.setCountersParent( this.zone_preview );
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "hide_collapse_folder":
                this.zone_preview.setPhase( SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                this.setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                break;
            case "widget_preview__compute_html_done":
                this.computeSpecificHtml();
                break;
            case "change__widget_preview_zone__activity":
                let is_current_cf = param[ SHINKEN.OBJECT.COLLAPSE.PARAM.NAME ] === this.getName();
                if ( this.zone_preview.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING ) ) {
                    is_current_cf = false;
                }
                this.zone_preview.setPhaseOrPhase( is_current_cf, SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING, SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                this.setVisibilityState( is_current_cf ? SHINKEN.CONST.VISIBILITY_STATE.NORMAL : SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    
    computeSpecificHtml: function () {
        this.zone_preview.computeHtml( this.widget_preview ? this.widget_preview.getDomZoneByName( this.getName() ) : null );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview, SHINKEN.OBJECT.CollapseFolderForProperties );
