"use strict";
SHINKEN.TOOLS.TEST_AUTO_RADIO_CHECKBOX = (function ( self ) {
    self.DOM                         = {};
    self.DOM.INPUT                   = {};
    self.TEST                        = {};
    self.TEST.INPUT                  = {};
    self.ACTION                      = {};
    self.ACTION.INPUT                = {};
    self.CONST                       = {
        STATE_DISPLAY: {
            HIDDEN           : 0,
            VISIBLE_CHECKED  : 1,
            VISIBLE_UNCHECKED: 2
        },
        INPUT        : {
            STATE_DISPLAY: {
                HIDDEN                      : 0,
                VISIBLE_AND_EMPTY           : 1,
                VISIBLE_AND_SET             : 2,
                VISIBLE_AND_EMPTY_WITH_ERROR: 3,
                VISIBLE_AND_SET_WITH_ERROR  : 4
            }
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.radio                   = function ( dom_element_parent, radio_name ) {
        return dom_element_parent.querySelector( `.shinken-radio-with-checkbox[data-name="${radio_name}"]` );
    };
    self.DOM.radioSvgChecked         = function ( dom_element_parent, radio_name ) {
        return self.DOM.radio( dom_element_parent, radio_name ).querySelector( `.shinken-radio-button-svg .shinken-checked-svg` );
    };
    self.DOM.INPUT.container         = function ( dom_element_parent, radio_name ) {
        return self.DOM.radio( dom_element_parent, radio_name ).querySelector( `.shinken-input-component-container` );
    };
    self.DOM.INPUT.input             = function ( dom_element_parent, radio_name ) {
        return self.DOM.INPUT.container( dom_element_parent, radio_name ).querySelector( `.shinken-input-V3` );
    };
    self.DOM.INPUT.inputBroom        = function ( dom_element_parent, radio_name ) {
        return self.DOM.INPUT.container( dom_element_parent, radio_name ).querySelector( `.shinken-button-V3[data-name="clean_input_value"]` );
    };
    //********************************************  Test   **************************************************//
    self.TEST.displayState           = function ( timeout, dom_element_parent, radio_name, state ) {
        setTimeout( function () {
            var _dom_radio   = self.DOM.radio( dom_element_parent, radio_name );
            var _dom_checked = self.DOM.radioSvgChecked( dom_element_parent, radio_name );
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.VISIBLE_CHECKED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_radio, radio_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_checked, radio_name );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_UNCHECKED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_radio, radio_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_checked, radio_name );
                    break;
            }
        }, timeout );
        return 50;
    };
    self.TEST.INPUT.displayState     = function ( timeout, dom_element_parent, radio_name, state ) {
        setTimeout( function () {
            var _dom       = self.DOM.INPUT.input( dom_element_parent, radio_name );
            var _dom_broom = self.DOM.INPUT.inputBroom( dom_element_parent, radio_name );
            switch ( state ) {
                case self.CONST.INPUT.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, radio_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_broom, radio_name + " broom" );
                    break;
                case self.CONST.INPUT.STATE_DISPLAY.VISIBLE_AND_EMPTY:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, radio_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_broom, radio_name + " broom" );
                    break;
                case self.CONST.INPUT.STATE_DISPLAY.VISIBLE_AND_SET:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, radio_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_broom, radio_name + " broom" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "color", "rgb(85, 85, 85)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "backgroundColor", "rgba(119, 165, 255, 0.2)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom_broom, "color", "rgb(255, 0, 0)" );
                    break;
                case self.CONST.INPUT.STATE_DISPLAY.VISIBLE_WITH_ERROR:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, radio_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_broom, radio_name + " broom" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "color", "rgb(111, 85, 85)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "backgroundColor", "rgba(119, 165, 255, 0.2)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom_broom, "color", "rgb(85, 85, 85)" );
                    break;
                case self.CONST.INPUT.STATE_DISPLAY.VISIBLE_AND_EMPTY_WITH_ERROR:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, radio_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_broom, radio_name + " broom" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "color", "rgb(85, 85, 85)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "backgroundColor", "rgba(119, 165, 255, 0.2)" );
                    break;
            }
        }, timeout );
        return 50;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.focusOnCheckboxInput = function ( timeout, composed_key, key ) {
        let _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "focusOnCheckboxInput" );
        setTimeout( function () {
            const radio_element = SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL_WIDGET.DOM.PropertyRadioListInput( composed_key, key );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, radio_element );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", 500 );
        }, timeout );
        return 500;
    };
    self.ACTION.INPUT.changeValue    = function ( timeout, dom_element_parent, radio_name, to_set ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self.DOM.INPUT.input( dom_element_parent, radio_name ), to_set );
        }, timeout );
        return 500;
    };
    self.ACTION.clickRadio           = function ( timeout, dom_element_parent, radio_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.radio( dom_element_parent, radio_name ) );
        }, timeout );
        return 100;
    };
    //********************************************  TEST   **************************************************//
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_WINDOW || {} );
