"use strict";

SHINKEN.TOOLS.TEST_AUTO.SynchronizerImportConfReportList           = function ( data ) {
    this.init( data );
};
SHINKEN.TOOLS.TEST_AUTO.SynchronizerImportConfReportList.prototype = {
    //********************************************  INIT  *****************************************************//
    init     : function ( data ) {
        this.initContents();
        this.parseData( data );
    },
    parseData: function ( data ) {
        let lines = data.split( '\n' );
        for ( let i = 1, _size_i = lines.length; i < _size_i; i++ ) {
            if ( lines[ i ].length ) {
                this.add( new SHINKEN.TOOLS.TEST_AUTO.SynchronizerImportConfReportListLine( lines[ i ] ) );
            }
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getNumberOfDifferencesInHostsNumberSinceLastArbiterRestart: function () {
        if ( this.getSize() < 2 ) {
            return;
        }
        return this.contents[ this.contents.length - 1 ].getNbHosts() - this.contents[ this.contents.length - 2 ].getNbHosts();
    },
    getLastNbHostInProd                                       : function () {
        return this.contents[ this.contents.length - 1 ].getNbHosts();
    },
    getLastReportDate                                         : function () {
        return this.contents[ this.contents.length - 1 ].getDate();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.TEST_AUTO.SynchronizerImportConfReportList, SHINKEN.OBJECT.ShinkenObjectContainer );

SHINKEN.TOOLS.TEST_AUTO.SynchronizerImportConfReportListLine           = function ( data ) {
    this.init( data );
};
SHINKEN.TOOLS.TEST_AUTO.SynchronizerImportConfReportListLine.prototype = {
    //********************************************  INIT  *****************************************************//
    init: function ( line_to_parse ) {
        this.raw_line   = line_to_parse;
        let parsed_line = line_to_parse.split( ";" );
        this.date       = parsed_line[ 0 ];
        this.nb_hosts   = parseInt( parsed_line[ 1 ] );
        this.hash       = parsed_line[ 2 ];
    },
    
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID   : function () {
        return this.raw_line;
    },
    getNbHosts: function () {
        return this.nb_hosts;
    },
    getDate   : function () {
        return this.date;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.TEST_AUTO.SynchronizerImportConfReportListLine, SHINKEN.OBJECT.ShinkenObject );