"use strict";
SHINKEN.TOOLS.TEST_AUTO.Widget           = function ( index ) {
    this.init( index );
};
SHINKEN.TOOLS.TEST_AUTO.Widget.prototype = {
    //********************************************  INIT  *****************************************************//
    init: function ( index ) {
        this.dom_element = SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.DOM.getGridCellByIndex( false, index );
        this.data        = DOM.Service.getBoundingClientRect( this.dom_element );
    },
    
    //********************************************  GETTER SETTER  *****************************************************//
    getHeight               : function () {
        return this.data.height;
    },
    getWidth                : function () {
        return this.data.width;
    },
    getHeightInTiles        : function () {
        return Math.round( this.getHeight() / CONTROLLER.PageController.current_page.content.grids.contents[ 0 ].tile_pixel_size );
    },
    getWidthInTiles         : function () {
        return Math.round( this.getWidth() / CONTROLLER.PageController.current_page.content.grids.contents[ 0 ].tile_pixel_size );
    },
    getData                 : function () {
        return this.data;
    },
    getPositionInGrid       : function () {
        return {
            "x": Math.round(SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.INTERNAL.pixelToTiles( this.getData().left )) ,
            "y": Math.round(SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.INTERNAL.pixelToTiles( this.getData().top -DOM.Service.getBoundingClientRect( SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.gridContainer(), DOM.CONST.STYLE.TOP ) ) )
            
        };
    },
    getCoordonnatesForResize: function ( corner, delta_x, delta_y ) {
        switch ( corner ) {
            case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.OVERLAYED_FRAME.CORNER.TOP_LEFT:
                return {
                    "x": SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.INTERNAL.tilesToPixels( delta_x ) + this.getData().left,
                    "y": SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.INTERNAL.tilesToPixels( delta_y ) + this.getData().top
                    
                };
            case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.OVERLAYED_FRAME.CORNER.TOP_RIGHT:
                return {
                    "x": SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.INTERNAL.tilesToPixels( delta_x ) + this.getData().left + this.getWidth(),
                    "y": SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.INTERNAL.tilesToPixels( delta_y ) + this.getData().top
                };
            case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.OVERLAYED_FRAME.CORNER.BOTTOM_LEFT:
                return {
                    "x": SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.INTERNAL.tilesToPixels( delta_x ) + this.getData().left,
                    "y": SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.INTERNAL.tilesToPixels( delta_y ) + this.getData().top + this.getHeight()
                };
            case SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.CONST.OVERLAYED_FRAME.CORNER.BOTTOM_RIGHT:
                return {
                    "x": SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.INTERNAL.tilesToPixels( delta_x ) + this.getData().left + this.getWidth(),
                    "y": SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL.INTERNAL.tilesToPixels( delta_y ) + this.getData().top + this.getHeight()
                };
        }
    }
    
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.TEST_AUTO.Widget, SHINKEN.OBJECT.ShinkenObject );