'use strict';
const ____execute = function ( timeout, action_duration, caller_function_name, fn_action, action_args ) {
    action_args.shift();
    let _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, caller_function_name, action_args.join( " -> " ) );
    setTimeout( function () {
        SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN PROGRESS" );
        fn_action( ...action_args );
        SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", action_duration );
    }, timeout );
    return action_duration;
};

SHINKEN.TOOLS.TEST_AUTO       = (function ( self ) {
    self.DOM                      = {};
    self.TEST                     = {};
    self.PERF                     = {};
    self.TEST.JS                  = {};
    self.ACTION                   = {};
    var _INTERNAL                 = {};
    //********************************************  MESSAGES   ******************************************************//
    var _messages                 = {};
    self.hasMessage               = function () {
        if ( _has_script_error ) {
            return true;
        }
        return !!Object.keys( _messages ).length;
    };
    self.addError                 = function ( text_message, extra_text ) {
        text_message = text_message || "";
        console.error( "[TEST AUTO]", text_message, extra_text || " " );
        if ( !_messages[ __shinken_test_type ] ) {
            _messages[ __shinken_test_type ] = [];
        }
        _messages[ __shinken_test_type ].push( new SHINKEN.OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, "[" + __shinken_test_type + "] - " + text_message ) );
    };
    self.addWarning               = function ( text_message ) {
        if ( !_messages[ __shinken_test_type ] ) {
            _messages[ __shinken_test_type ] = [];
        }
        _messages[ __shinken_test_type ].push( new SHINKEN.OBJECT.Message( COMPONENT.CONST.STATUS.WARNING, "[" + __shinken_test_type + "] - " + text_message ) );
    };
    self.addInfo                  = function ( text_message ) {
        if ( !_messages[ __shinken_test_type ] ) {
            _messages[ __shinken_test_type ] = [];
        }
        _messages[ __shinken_test_type ].push( new SHINKEN.OBJECT.Message( COMPONENT.CONST.STATUS.INFO, "[" + __shinken_test_type + "] - " + text_message ) );
    };
    self.MakeFinalAction          = function ( timeout ) {
        setTimeout( function () {
            self.buildMessage( 0 );
            if ( !__is_single ) {
                if ( SHINKEN.TOOLS.TEST_AUTO.hasMessage() && !__test_auto_continue_if_error ) {
                    return;
                }
                SHINKEN.TOOLS.TEST_AUTO_PHASE.doNext();
            }
        }, timeout );
    };
    self.buildMessage             = function ( timeout ) {
        var phase = parseInt( SHINKEN.HIGHWAY.getParams( 'phase' ) || 0 );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.showInConsole();
            if ( _has_script_error ) {
                self.addError( _has_script_error + ' error(s) javascript detected' );
            }
            var _to_write = new SHINKEN.OBJECT.Messages();
            var _keys     = Object.keys( _messages );
            var _current_key;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                _to_write.addMessages( _messages[ _keys[ i ] ] );
            }
            var _dom_element = document.getElementById( 'saving-log-modal-body' );
            
            if ( _to_write.hasMessage() ) {
                if ( _dom_element ) {
                    _dom_element.innerHTML = _to_write.buildMessage();
                    SHINKEN.MODAL.show();
                }
                else {
                    var _dom_to_add = DOM.Service.createElement( "div", { style: "background: red;z-index:999999;position: absolute;top:10px" }, _to_write.buildMessage() );
                    DOM.Service.addElementTo( _dom_to_add, DOM.BodyService.getDomElement() );
                }
                
                switch ( _to_write.getStatus() ) {
                    case COMPONENT.CONST.STATUS.ERROR:
                        SHINKEN.TOOLS.TEST_AUTO_LOGGER.ACTION.logToServer( __shinken_test_type, phase, SHINKEN.TOOLS.TEST_AUTO.CONST.STATUS.ERROR, _to_write.buildMessage() );
                        break;
                    case COMPONENT.CONST.STATUS.WARNING:
                        SHINKEN.TOOLS.TEST_AUTO_LOGGER.ACTION.logToServer( __shinken_test_type, phase, SHINKEN.TOOLS.TEST_AUTO.CONST.STATUS.WARNING, _to_write.buildMessage() );
                        break;
                    case COMPONENT.CONST.STATUS.BEWARE:
                        SHINKEN.TOOLS.TEST_AUTO_LOGGER.ACTION.logToServer( __shinken_test_type, phase, SHINKEN.TOOLS.TEST_AUTO.CONST.STATUS.BEWARE, _to_write.buildMessage() );
                        break;
                    default:
                        SHINKEN.TOOLS.TEST_AUTO_LOGGER.ACTION.logToServer( __shinken_test_type, phase, SHINKEN.TOOLS.TEST_AUTO.CONST.STATUS.INFO, _to_write.buildMessage() );
                        break;
                }
                
            }
            else if ( !__is_single ) {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.ACTION.logToServer( __shinken_test_type, phase, SHINKEN.TOOLS.TEST_AUTO.CONST.STATUS.VALID, "" );
                console.log( "[TEST_AUTO DONE]", __shinken_test_type, SHINKEN.TOOLS.TEST_AUTO.CONST.STATUS.VALID, "__do_next = " + __do_next, "phase" + __phase );
            }
            else {
                console.log( "[TEST_AUTO DONE]" );
            }
        }, timeout );
        
    };
    //********************************************  TEST    ******************************************************//
    self.TEST.isConfigEveryone    = function ( timeout, inverted ) {
        setTimeout( function () {
            if ( PROPERTY.UserRightsBehaviour.has_everybody_default && inverted ) {
                SHINKEN.TOOLS.TEST_AUTO_DAEMON.SYNCHRONIZER.ACTION.changeViewContactDefaultValue( "nobody" );
            }
            else if ( !PROPERTY.UserRightsBehaviour.has_everybody_default && !inverted ) {
                SHINKEN.TOOLS.TEST_AUTO_DAEMON.SYNCHRONIZER.ACTION.changeViewContactDefaultValue( "everyone" );
            }
        }, timeout );
        return 10000;
    };
    self.___isVariableEqualsTo    = function ( object, key, value_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( object[ key ] !== value_expected ) {
            if ( object.name ) {
                extra_label += " <span class='shinken-data-user'>" + object.name + "</span> ";
            }
            this.addError( extra_label + " la valeur de la clé [<span class='shinken-data-user'>" + key + "</span>] n'est pas égale à [<span class='shinken-data-user'>" + value_expected + "</span>] mais à [<span class='shinken-data-user'>" + object[ key ] + "</span>]" );
        }
    };
    self.___isEqualsTo            = function ( to_test, value_expected, extra_label, reverse ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !reverse && to_test !== value_expected ) {
            this.addError( extra_label + ": la valeur n'est pas égale à  [<span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value_expected + '' ) + "</span>]  mais à [<span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( to_test + '' ) + "</span>]" );
        }
        else if ( reverse && to_test === value_expected ) {
            this.addError( extra_label + ": la valeur ne doit pas être égale à  [<span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value_expected + '' ) + "</span>]" );
        }
    };
    self.___isLesserOrEqualsTo    = function ( to_test, value_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
            if ( to_test > value_expected ) {
                this.addError( extra_label + " la valeur est inférieure à  [<span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value_expected + '' ) + "</span>] : [<span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( to_test + '' ) + "</span>]" );
            }
        }
    };
    self.___isExisting            = function ( to_test, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !to_test ) {
            this.addError( extra_label + " l'object n'existe pas" );
        }
    };
    self.___isArrayLengthEqualsTo = function ( array, value_expected, label_array, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( array.length !== value_expected ) {
            this.addError( extra_label + "la longueur du tableau <span class='shinken-data-user'>" + label_array + "</span> n'est pas égale à [<span class='shinken-data-user'>" + value_expected + "</span>] mais à [<span class='shinken-data-user'>" + array.length + "</span>]" );
        }
    };
    self.___isArrayContains       = function ( array, value_expected, text_label, reverse ) {
        let contains = SHINKEN.TOOLS.ARRAY.contains( array, value_expected );
        if ( !contains && !reverse ) {
            this.addError( text_label + ": le tableau <span class='shinken-data-user'>" + "[ " + array.join( ", " ) + " ]" + "</span> ne contient pas <span class='shinken-data-user'>" + value_expected + "</span>" );
        }
        else if ( contains && reverse ) {
            this.addError( text_label + ": le tableau <span class='shinken-data-user'>" + "[ " + array.join( ", " ) + " ]" + "</span> contient <span class='shinken-data-user'>" + value_expected + "</span>" );
        }
    };
    self.__isFlatContentEqualTo   = function ( dom_element, string_expected, in_label, extra_label ) {
        string_expected = "" + string_expected;
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            console.warn( "GREG", "[__isInnerTextEqualTo]", "[NOT DONE ON IE]", __shinken_test_type );
            return;
        }
        if ( !in_label ) {
            in_label = dom_element.innerText;
        }
        return self.__isTextEqualTo( SHINKEN.TOOLS.STRING.replaceAll( dom_element.innerText, /\s/g, "" ).trim(), string_expected, in_label, extra_label );
    };
    self.__isInnerTextEqualTo     = function ( dom_element, string_expected, in_label, extra_label ) {
        string_expected = "" + string_expected;
        if ( !in_label ) {
            in_label = dom_element.innerText;
        }
        var _to_test = dom_element ? dom_element.innerText : "";
        _to_test     = _to_test.trim();
        //var _to_test = SHINKEN.TOOLS.STRING.replaceAll( dom_element ? dom_element.innerText : "", /\s/g, "" ).trim();
        if ( dom_element && (dom_element.tagName === "INPUT" || dom_element.tagName === "TEXTAREA") ) {
            _to_test = dom_element.value;
        }
        return self.__isTextEqualTo( _to_test, string_expected, in_label, extra_label );
    };
    self.__isInnerHtmlEqualTo     = function ( dom_element, html_expected, in_label, extra_label ) {
        html_expected = "" + html_expected;
        if ( !in_label ) {
            in_label = dom_element.innerHTML;
        }
        var _to_test = dom_element ? dom_element.innerHTML : "";
        _to_test     = _to_test.trim();
        return self.__isTextEqualTo( _to_test, html_expected, in_label, extra_label );
    };
    self.__isInnerTextContains    = function ( dom_element, value_to_test, in_label, extra_label, reverse ) {
        value_to_test = "" + value_to_test;
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            console.warn( "GREG", "[__isInnerTextEqualTo]", "[NOT DONE ON IE]", __shinken_test_type );
            return;
        }
        if ( !in_label ) {
            in_label = dom_element.innerText;
        }
        return self.__containsText( SHINKEN.TOOLS.STRING.replaceAll( dom_element.innerText, /\s/g, " " ).trim(), value_to_test, in_label, extra_label, reverse );
    };
    self.__isTextEqualTo          = function ( text, string_expected, in_label, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( text !== string_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "<br>NOT EQUALS = label = " + in_label + "<br>(ok---) - <code>" + SHINKEN.TOOLS.STRING.cleanXss( string_expected ) + "</code><br>(found) - <code>" + SHINKEN.TOOLS.STRING.cleanXss( text ) + "</code>" );
        }
    };
    self.__isHtmlEqualTo          = function ( html, html_expected, in_label, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( html !== html_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "<br>NOT EQUALS = label = " + in_label + "<br>" + SHINKEN.TOOLS.STRING.cleanXss( html_expected ) + "<br>" + SHINKEN.TOOLS.STRING.cleanXss( html ) );
        }
    };
    self.__containsText           = function ( text, value_to_test, in_label, extra_label, reverse ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !reverse && !SHINKEN.TOOLS.STRING.contains( text, value_to_test ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "le text dans <b>" + in_label + "</b> ne contient pas <b>" + value_to_test + "</b> ==> [" + text + "]" );
        }
        else if ( reverse && SHINKEN.TOOLS.STRING.contains( text, value_to_test ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "le text dans <b>" + in_label + "</b> contient <b>" + value_to_test + "</b> ==> [" + text + "]" );
        }
    };
    self.__isNotEmpty             = function ( to_set, in_label, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( to_set === "" || to_set === undefined ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "le text dans <b>" + in_label + "</b> est vide" );
        }
    };
    /**
     *
     * @deprecated V02.08.01
     */
    self.__isPropErrorWarningCounter = function ( prop_name, error_expected, warning_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        var _prop = MANAGER.__instance_property_distributor.getElement( prop_name );
        if ( _prop.getCounterError().getValue() !== error_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le nombre d'erreur pour la propriété <b>" + prop_name + "</b> est différent de <b>" + error_expected + "</b> ==> [" + _prop.getCounterError().getValue() + "]" );
        }
        if ( _prop.getCounterWarning().getValue() !== warning_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le nombre de warning pour la propriété <b>" + prop_name + "</b> est différent de <b>" + warning_expected + "</b> ==> [" + _prop.getCounterWarning().getValue() + "]" );
        }
    };
    self.__hasStyle                 = function ( dom_element, key, value_expected, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = dom_element.innerText;
        }
        var _value = DOM.Service.getComputedStyle( dom_element, key );
        if ( _value !== value_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le style <b>" + key + "</b> de <b>" + text_desc + "</b> n'est pas égale à <b>" + value_expected + "</b> ==> <b>[" + _value + "]</b>" );
        }
    };
    self.__hasNotStyle              = function ( dom_element, key, value_expected, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = dom_element.innerText;
        }
        var _value = DOM.Service.getComputedStyle( dom_element, key );
        if ( _value === value_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le style <b>" + key + "</b> de <b>" + text_desc + "</b> est égale à <b>" + value_expected + "</b> ==> <b>[" + _value + "]</b>" );
        }
    };
    self.__hasClass                 = function ( dom_element, class_name, text_desc, extra_label, inverse ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !dom_element ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " DOM Missing <b>" + text_desc + "</b>" );
            return;
        }
        if ( inverse ) {
            if ( dom_element.classList.contains( class_name ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La class <b>" + class_name + "</b> existe dans <b>" + text_desc + "</b>" );
            }
        }
        else if ( !dom_element.classList.contains( class_name ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La class <b>" + class_name + "</b> n'existe pas dans <b>" + text_desc + "</b>" );
        }
        
    };
    self.__hasPulsate               = function ( dom_element, text_desc, timeout ) {
        SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-pulsate', text_desc, "pendant le clignotement" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-pulsate', text_desc, "aprés le clignotement de " + timeout + "ms", true );
        }, timeout );
    };
    self.__isVisible                = function ( dom_element, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = dom_element.innerText;
        }
        if ( !DOM.Service.isVisible( dom_element, 2 ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le dom élément <b>" + text_desc + "</b> n'est pas visible" );
        }
        
    };
    self.__isVisible_V2             = function ( dom_element, text_desc, extra_label ) {
        return DOM.Service.isVisible( dom_element, 2 );
    };
    self.__isPartiallyInScreen      = function ( dom_element, dom_parent, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = dom_element.innerText;
        }
        const dom_rect        = dom_element.getBoundingClientRect();
        const dom_parent_rect = dom_parent.getBoundingClientRect();
        if ( !DOM.Service.isPartiallyVisibleIntoScrollingVerticalParent_Box( dom_rect, dom_parent_rect ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le dom élément <b>" + text_desc + "</b> n'est pas visible" );
        }
        
    };
    self.__isVisibleAndHasInnerText = function ( dom_element, innerText, text_desc, extra_label ) {
        self.__isVisible( dom_element, text_desc, extra_label );
        self.__isInnerTextEqualTo( dom_element, innerText, text_desc, extra_label );
    };
    self.__isNotVisible             = function ( dom_element, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
        }
        if ( DOM.Service.isVisible( dom_element, 10 ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le dom élément <b>" + text_desc + "</b> est visible" );
        }
        
    };
    self.__click                    = function ( dom_element, force_click, deepness ) {
        if ( !dom_element ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( "click on impossible ==>  dom_element 'undefined'" );
        }
        else {
            var _compute = DOM.Service.getComputedStyle( dom_element );
            if ( !force_click && _compute.pointerEvents === 'none' ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible pointerEvents === 'none'" );
            }
            else if ( !force_click && !DOM.Service.isVisible( dom_element, deepness ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible non visible" );
            }
            else {
                dom_element.click();
                dom_element.focus();
            }
        }
    };
    self.__doesntExist              = function ( dom_element, text_desc, extra_label ) {
        if ( !dom_element ) {
            return;
        }
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc ) {
            text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
        }
        if ( dom_element ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le dom élément <b>" + text_desc + "</b> existe" );
        }
        
    };
    //********************************************  ARRAY   ***********************************************************//
    self.TEST.isSameArray           = function ( array_1, array_2 ) {
        if ( array_1.length !== array_2.length ) {
            this.addError( "la longueur du tableau <span class='shinken-data-user'>" + array_1 + "</span> n'est pas égale à la longueur du tableau [<span class='shinken-data-user'>" + array_2 + "</span>]" );
        }
        for ( let i = 0, _size_i = Math.min( array_1.length, array_2.length ); i < _size_i; i++ ) {
            if ( array_1[ i ] !== array_2[ i ] ) {
                this.addError( "valeur différent pour l'index <span class='shinken-data-user'>" + i + "</span> entre les deux tableaux [<span class='shinken-data-user'>" + array_1[ i ] + "</span>] VS [<span class='shinken-data-user'>" + array_2[ i ] + "</span>]" );
            }
        }
    };
    self.ACTION.ParseDomToText      = function ( array_to_parse ) {
        let to_return = [];
        for ( let i = 0, _size_i = array_to_parse.length; i < _size_i; i++ ) {
            to_return.push( array_to_parse[ i ].innerText );
        }
        return to_return;
    };
    //********************************************  ACTION    ******************************************************//
    self.changeUser                 = function ( login, password ) {
        sessionStorage.removeItem( "user_id" );
        $.post( "/user/auth", { "shinken_login": login, "password": password } ).success(
            function ( data ) {
            }
        ).error(
            function ( res ) {
            }
        );
        return 4000;
    };
    self.ACTION.do_JS_action        = function ( timeout, function_to_eval, time_to_return ) {
        setTimeout( function () {
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                eval( function_to_eval );
            }
        }, timeout );
        return time_to_return;
    };
    //var _interval_do_JS_action_when_ready;
    //self.do_JS_action_when_ready          = function ( timeout, function_to_eval, var_to_test, expected_value ) {
    //    var _to_return = 1000;
    //    _interval_do_JS_action_when_ready = setInterval( function () {
    //        if ( var_to_test === expected_value ){
    //            clearInterval( _interval_do_JS_action_when_ready );
    //        }
    //    }, 10 );
    //    return _to_return;
    //};
    //********************************************  DISPATCH    ******************************************************//
    self.dispatchMouseEvent                = function ( timeout, dom_element, type ) {
        setTimeout( function () {
            self.___dispatchMouseEvent( dom_element, type );
        }, timeout );
        return 100;
    };
    self.ACTION.dispatchMouseEventWithEval = function ( timeout, dom_element_to_eval, type ) {
        setTimeout( function () {
            self.___dispatchMouseEvent( eval( dom_element_to_eval ), type );
        }, timeout );
        return 100;
    };
    self.___dispatchMouseEvent             = function ( dom_element, type ) {
        dom_element.focus();
        var event = new MouseEvent( type, {
            'view'      : window,
            'bubbles'   : true,
            'cancelable': true
        } );
        dom_element.dispatchEvent( event );
    };
    self.___dispatchEnterKeyEvent          = function ( dom_element, type ) {
        dom_element.focus();
        var event = new KeyboardEvent( type, {
            bubbles   : true,
            cancelable: true,
            code      : 'Enter',
            key       : 'Enter',
            charCode  : 13,
            keyCode   : 13,
            view      : window,
            shiftKey  : false
        } );
        dom_element.dispatchEvent( event );
    };
    self.___dispatchKeyEvent               = function ( dom_element, type, key, key_code ) {
        dom_element.focus();
        var event = new KeyboardEvent( type, {
            bubbles   : true,
            cancelable: true,
            code      : key,
            key       : key,
            charCode  : key_code,
            keyCode   : key_code,
            view      : window,
            shiftKey  : false
        } );
        dom_element.dispatchEvent( event );
    };
    self.___dispatchOnChangeEvent          = function ( dom_element ) {
        var event = new Event( 'change' );
        dom_element.dispatchEvent( event );
    };
    self.sleep                             = function ( timeout ) {
        setTimeout( function () {
            console.log( "" );
        }, timeout );
        return 5000;
    };
    //********************************************  PERF    ******************************************************//
    self.PERF.generateStructure            = function ( method, deepness, iterations, dom_class ) {
        let _to_return = DOM.Service.createElement( 'div', { class: `méthode-${method}` }  );
        let _tmp;
        
        function createNestedDivs ( depth ) {
            let rootDiv = document.createElement( 'div' );
            rootDiv.setAttribute("class", dom_class);
            function createNestedDiv ( currentDiv, currentDepth ) {
                if ( currentDepth >= depth ) {
                    return;
                }
                
                let newDiv = document.createElement( 'div' );
                newDiv.setAttribute("class", dom_class);
                currentDiv.appendChild( newDiv );
                
                createNestedDiv( newDiv, currentDepth + 1 );
            }
            
            createNestedDiv( rootDiv, 1 );
            
            return rootDiv;
        }
        
        
        switch ( method ) {
            case "string":
                for ( let i = 0, _size_i = iterations; i < _size_i; i++ ) {
                    i === 0 ? _tmp = `<div class=${dom_class}>`.repeat( deepness ) + '</div>'.repeat( deepness ) : _tmp += `<div class=${dom_class}>`.repeat( deepness ) + '</div>'.repeat( deepness );
                }
                _to_return.insertAdjacentHTML( "beforeend", _tmp );
                break;
            case "html":
                for ( let i = 0, _size_i = iterations; i < _size_i; i++ ) {
                    _to_return.appendChild( createNestedDivs( deepness ) );
                }
                break;
        }
        
        return _to_return;
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO || {} );
SHINKEN.TOOLS.TEST_AUTO_PHASE = (function ( self ) {
    self.DOM                = {};
    self.TEST               = {};
    self.TEST.JS            = {};
    self.ACTION             = {};
    //********************************************  NEXT    ******************************************************//
    self.doNext             = function ( timeout, forced_shinken_test_type, forced_phase ) {
        timeout               = timeout || 0;
        window.onbeforeunload = function () {
        };
        if ( !SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ __shinken_test_type ] ) {
            return;
        }
        if ( SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ __shinken_test_type ].cancel_next ) {
            return;
        }
        
        
        var _timeout   = timeout + 4000;
        var _max_phase = SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ __shinken_test_type ].phases || 1;
        if ( Array.isArray( SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ __shinken_test_type ].address ) ) {
            _max_phase = SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ __shinken_test_type ].address.length;
        }
        var _has_other_phase = __phase < _max_phase;
        var _next;
        if ( _has_other_phase ) {
            __phase++;
            _next = __shinken_test_type;
        }
        else {
            __phase = 1;
            _next   = SHINKEN.TOOLS.STRING.prefix_by_zero( parseInt( __shinken_test_type ) + 1, 5 );
            if ( SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ _next ] && SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ _next ].version_minimum ) {
                if ( __version_shinken < SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ _next ].version_minimum ) {
                    __shinken_test_type = _next;
                    __phase             = 9999;
                    return self.doNext( timeout );
                }
            }
            
        }
        if ( !SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ _next ] || !SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ _next ].address ) {
            console.log( "GREG", "[FIN DES TEST AUTO]", "[1]" );
            return;
        }
        if ( Array.isArray( SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ _next ].address ) && !SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ _next ].address[ __phase - 1 ] ) {
            console.log( "GREG", "[FIN DES TEST AUTO]", "[2]" );
            return;
        }
        if ( __do_next ) {
            setTimeout( function () {
                window.location = self.getNextLink( _next, __phase );
            }, _timeout );
        }
        if ( forced_shinken_test_type && forced_phase ) {
            SHINKEN.HIGHWAY.goTo( self.getNextLink( forced_shinken_test_type, forced_phase ) );
        }
    };
    self.doNextWhen         = function ( timeout, function_to_eval ) {
        __do_next = false;
        setTimeout( function () {
            var _test = eval( function_to_eval );
            if ( _test ) {
                __do_next = true;
                self.doNext( 0, __shinken_test_type, parseInt( __phase ) ); //TEST 00142
            }
            else {
                self.doNextWhen( 1000, function_to_eval );
            }
        }, timeout );
        return 150;
    };
    self.ACTION.refreshPage = function ( timeout, go_next ) {
        setTimeout( function () {
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                if ( go_next ) {
                    SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                }
                SHINKEN.HIGHWAY.refreshCurrentPage();
            }
        }, timeout );
        return 50;
    };
    self.getNextLink        = function ( next, phase, add_existing_argument ) {
        var _params                          = SHINKEN.HIGHWAY.getParams();
        var _new_address                     = Array.isArray( SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ next ].address ) ? SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ next ].address[ phase - 1 ] : SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ next ].address;
        var _new_address_split_with_hashtag  = _new_address.split( '#' );
        _new_address_split_with_hashtag[ 0 ] = _new_address_split_with_hashtag[ 0 ] + "?shinken_test_auto=" + next + "&phase=" + phase;
        var _to_return                       = _new_address_split_with_hashtag.join( "#" );
        if ( SHINKEN.TOOLS.STRING.contains( _new_address, "?" ) ) {
            _to_return = _new_address + "&shinken_test_auto=" + next + "&phase=" + phase;
        }
        if ( add_existing_argument ) {
            var _keys = Object.keys( _params );
            var _current_key;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                switch ( _current_key ) {
                    case "shinken_test_auto":
                    case "phase":
                        break;
                    default:
                        _to_return += "&" + _current_key + "=" + _params[ _current_key ];
                        break;
                }
            }
        }
        var _port;
        if ( SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ next ][ "port" ] ) {
            _port = Array.isArray( SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ next ].port ) ? SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ next ].port[ phase - 1 ] : SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ next ].port;
        }
        else {
            _port = 7766;
        }
        
        _to_return = window.location.protocol + "//" + window.location.hostname + ":" + _port + _to_return;
        return _to_return;
    };
    self.getNextPhaseLink   = function () {
        var _params = SHINKEN.HIGHWAY.getParams();
        if ( isNaN( parseInt( _params.phase ) ) ) {
            _params.phase = 1;
        }
        _params.phase = parseInt( _params.phase ) + 1;
        return SHINKEN.HIGHWAY.buildParamsToUrl( _params );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PHASE || {} );

SHINKEN.TOOLS.TEST_AUTO_TOOLTIP = (function ( self ) {
    self.TEST              = {};
    self.hasText           = function ( timeout, value_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "shi-tip" ), value_expected, "text dans le tooltip" );
        }, timeout );
        return 50;
    };
    self.TEST.containsText = function ( timeout, value_to_test ) {
        setTimeout( function () {
            var _dom_element = DOM.Service.createElement( "div", {}, value_to_test );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( document.getElementById( "shi-tip" ), _dom_element.innerText, "text dans le tooltip" );
        }, timeout );
        return 500;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_TOOLTIP || {} );

SHINKEN.TOOLS.TEST_AUTO_DOM = (function ( self ) {
    self.TEST                = {};
    self.ACTION              = {};
    //********************************************  EVENT   **********************************************************//
    self.dispatchEvent       = function ( timeout, dom_element, event_to_dispatch, times ) {
        setTimeout( function () {
            if ( !times ) {
                times = 1;
            }
            for ( var i = 0; i < times; i++ ) {
                dom_element.dispatchEvent( event_to_dispatch );
            }
        }, timeout );
        return 300;
    };
    self.click               = function ( timeout, dom_element, force_click, deepness ) {
        setTimeout( function () {
            if ( !dom_element ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "click on impossible ==>  dom_element 'undefined'" );
            }
            else {
                var _compute = DOM.Service.getComputedStyle( dom_element );
                if ( !force_click && _compute.pointerEvents === 'none' ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible pointerEvents === 'none'" );
                }
                    //else if ( !force_click && !DOM.Service.isVisible( dom_element, deepness ) ) {
                    //    SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible non visible" );
                //}
                else {
                    dom_element.click();
                    dom_element.focus();
                }
            }
        }, timeout );
        return 500;
    };
    self.click_V2            = function ( dom_element, callback, force_click ) {
        if ( !dom_element ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( "click on impossible ==>  dom_element 'undefined'" );
        }
        else {
            let _compute = DOM.Service.getComputedStyle( dom_element );
            if ( !force_click && _compute.pointerEvents === 'none' ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible pointerEvents === 'none'" );
            }
            else {
                dom_element.click();
                dom_element.focus();
                if ( callback ) {
                    callback();
                }
            }
        }
        
    };
    self.clickAtPosition     = function ( timeout, pos_x, pos_y ) {
        setTimeout( function () {
            document.elementFromPoint( pos_x, pos_y ).click();
            document.elementFromPoint( pos_x, pos_y ).focus();
        }, timeout );
        return 500;
    };
    self.clickOnFuturElement = function ( timeout, css_selector, force_click, deepness ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__click( document.querySelector( css_selector ), deepness );
            
        }, timeout );
        return 1000;
    };
    
    self.shiftClick               = function ( timeout, dom_element ) {
        setTimeout( function () {
            if ( !dom_element ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "click on impossible ==>  dom_element 'undefined'" );
            }
            else {
                var _compute = DOM.Service.getComputedStyle( dom_element );
                if ( _compute.pointerEvents === 'none' ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible pointerEvents === 'none'" );
                }
                else if ( !DOM.Service.isVisible( dom_element ) ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible non visible" );
                }
                else {
                    var evt = new MouseEvent( 'click', {
                        bubbles   : true,
                        cancelable: true,
                        shiftKey  : true,
                        view      : window
                    } );
                    dom_element.dispatchEvent( evt );
                }
            }
        }, timeout );
        return 500;
    };
    self.mouseup                  = function ( timeout, dom_element, force_click ) {
        -
            setTimeout( function () {
                if ( !dom_element ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "mouseup impossible ==>  dom_element 'undefined'" );
                }
                else {
                    var _compute = DOM.Service.getComputedStyle( dom_element );
                    if ( !force_click && _compute.pointerEvents === 'none' ) {
                        SHINKEN.TOOLS.TEST_AUTO.addError( "mouseup on  <b>" + dom_element.innerText + "</b> impossible pointerEvents === 'none'" );
                    }
                    else if ( !force_click && !DOM.Service.isVisible( dom_element ) ) {
                        SHINKEN.TOOLS.TEST_AUTO.addError( "mouseup on  <b>" + dom_element.innerText + "</b> impossible non visible" );
                    }
                    else {
                        var evt = document.createEvent( "HTMLEvents" );
                        evt.initEvent( "mousedown", false, true );
                        dom_element.dispatchEvent( evt );
                        
                        //var evt_2 = document.createEvent( "HTMLEvents" );
                        //evt_2.initEvent( "mouseup", false, true );
                        //dom_element.dispatchEvent( evt_2 );
                        
                        //CHANGEMENT DE CODE
                        //A TESTER
                        
                        var evt_2 = new MouseEvent( "mouseup", {
                            bubbles   : true,
                            cancelable: true,
                            view      : window
                        } );
                        dom_element.dispatchEvent( evt_2 );
                        
                    }
                }
            }, timeout );
        return 500;
    };
    //********************************************  SETTER GETTER   **************************************************//
    self.setValue                 = function ( timeout, dom_element, to_set, do_simulate_enter ) {
        setTimeout( function () {
            dom_element.focus();
            if ( dom_element.classList.contains( "shinken-input" ) || dom_element.classList.contains( "shinken-input-search" ) || dom_element.tagName === 'INPUT' ) {
                dom_element.value = to_set;
                var evt           = document.createEvent( "HTMLEvents" );
                evt.initEvent( "keyup", false, true );
                dom_element.dispatchEvent( evt );
            }
            else if ( dom_element.hasAttribute( 'contenteditable' ) ) {
                dom_element.innerText = to_set;
                var evt               = document.createEvent( "HTMLEvents" );
                evt.initEvent( "focusout", false, true );
                dom_element.dispatchEvent( evt );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.addError( "setValue impossible ==>  not editable dom_element" );
            }
            if ( do_simulate_enter ) {
                SHINKEN.TOOLS.TEST_AUTO.___dispatchEnterKeyEvent( dom_element, "keyup" );
            }
        }, timeout );
        return DOM.CONST.WAITING_TIME_BEFORE_EXEC.INPUT * 3;
    };
    //********************************************  TEST   ***********************************************************//
    self.empty                    = function ( timeout, dom_element ) {
        if ( !dom_element ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( "click on impossible ==>  dom_element 'undefined'" );
        }
        setTimeout( function () {
            DOM.Service.empty( dom_element );
        }, timeout );
        return 500;
    };
    //********************************************  ACTION   ***********************************************************//
    self.ACTION.setAttribute      = function ( timeout, dom_element, key, value ) {
        setTimeout( function () {
            dom_element.setAttribute( key, value );
        }, timeout );
        return 10;
    };
    //********************************************  TEST   ***********************************************************//
    self.visibility               = function ( timeout, dom_element, text_desc, is_visible ) {
        if ( is_visible ) {
            return self.isVisible( timeout, dom_element, text_desc );
        }
        else {
            return self.isNotVisible( timeout, dom_element, text_desc );
        }
    };
    self.isVisibleWithDomInFuture = function ( timeout, css_selector, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( document.querySelector( css_selector ), text_desc );
        }, timeout );
        return 1500;
    };
    self.isVisible                = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( dom_element, text_desc );
        }, timeout );
        return 10;
    };
    self.isVisible_V2             = function ( dom_element ) {
        return SHINKEN.TOOLS.TEST_AUTO.__isVisible_V2( dom_element );
    };
    self.isPartiallyInScreen      = function ( timeout, dom_element, dom_parent, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isPartiallyInScreen( dom_element, dom_parent, text_desc );
        }, timeout );
        return 10;
    };
    self.hasNoWidth               = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            var _rect = DOM.Service.getBoundingClientRect( dom_element );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _rect[ DOM.CONST.STYLE.WIDTH ], 0, text_desc );
            
        }, timeout );
        return 10;
    };
    self.isNotVisible             = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( dom_element, text_desc );
        }, timeout );
        return 10;
    };
    self.isEmpty                  = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            if ( !text_desc && dom_element ) {
                text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
            }
            if ( dom_element.innerHTML ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le dom élément <b>" + text_desc + "</b> n'est pas vide" );
            }
        }, timeout );
        return 10;
    };
    self.doesntExist              = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__doesntExist( dom_element, text_desc );
        }, timeout );
        return 10;
    };
    self.exists                   = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            if ( !text_desc ) {
                text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
            }
            if ( !dom_element ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le dom élément <b>" + text_desc + "</b> n'existe pas" );
            }
        }, timeout );
        return 10;
    };
    self.hasFocus                 = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            if ( !text_desc && dom_element ) {
                text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
            }
            if ( !DOM.Service.hasFocus( dom_element ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le dom élément <b>" + text_desc + "</b> n'a pas le focus" );
            }
        }, timeout );
        return 10;
    };
    self.hasStyle                 = function ( timeout, dom_element, key, value_expected, description ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, key, value_expected, description );
        }, timeout );
        return 10;
    };
    self.hasNotStyle              = function ( timeout, dom_element, key, value_expected, description ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasNotStyle( dom_element, key, value_expected, description );
        }, timeout );
        return 10;
    };
    self.hasData                  = function ( timeout, dom_element, key, value_expected, description ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( dom_element.dataset, key, value_expected, description );
        }, timeout );
        return 10;
    };
    self.containsData             = function ( timeout, dom_element, key, description ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isNotEmpty( dom_element.dataset[ key ], description );
        }, timeout );
        return 10;
    };
    self.hasAttribute             = function ( timeout, dom_element, key, value_expected, description, reverse ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( dom_element.getAttribute( key ), value_expected, description, reverse );
        }, timeout );
        return 10;
    };
    self.hasAttributeContains     = function ( timeout, dom_element, key, value_expected, description ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__containsText( dom_element.getAttribute( key ), value_expected, description );
        }, timeout );
        return 10;
    };
    self.TEST.hasStyleToEval      = function ( timeout, dom_element_to_eval, key, value_expected ) {
        setTimeout( function () {
            var dom_element = eval( dom_element_to_eval );
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, key, value_expected );
        }, timeout );
        return 10;
    };
    self.TEST.isNotExistingToEval = function ( timeout, dom_element_to_eval ) {
        setTimeout( function () {
            var dom_element = eval( dom_element_to_eval );
            if ( dom_element ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "le dom_element " + dom_element_to_eval + " existe", dom_element );
            }
        }, timeout );
        return 100;
    };
    self.hasClass                 = function ( timeout, dom_element, class_expected, revert, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, class_expected, text_desc, '', revert );
        }, timeout );
        return 10;
    };
    
    self.containsText                   = function ( timeout, dom_element, text_expected, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( dom_element, text_expected, text_desc );
        }, timeout );
        return 10;
    };
    self.isText                         = function ( timeout, dom_element, text_expected, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( dom_element, text_expected, text_desc );
        }, timeout );
        return 10;
    };
    self.isTextInArray                  = function ( timeout, dom_element, text_expected_array, text_desc, reverse ) {
        setTimeout( function () {
            if ( !Array.isArray( text_expected_array ) ) {
                text_expected_array = [text_expected_array];
            }
            SHINKEN.TOOLS.TEST_AUTO.___isArrayContains( text_expected_array, dom_element.innerText, text_desc, reverse );
        }, timeout );
        return 10;
    };
    self.isTable                        = function ( timeout, dom_element, nb_rows, nb_col, inner_flat_text ) {
        setTimeout( function () {
            if ( !dom_element ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( " isTable dom_element is null" );
                return;
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( dom_element.tagName, "TABLE" );
            if ( inner_flat_text ) {
                SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( dom_element, inner_flat_text );
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( SHINKEN.TOOLS.ARRAY.getLength( dom_element.rows ), nb_rows );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( SHINKEN.TOOLS.ARRAY.getLength( dom_element.rows[ 0 ].cells ), nb_col );
        }, timeout );
        return 10;
    };
    self.TEST.validTableHeaders         = function ( timeout, table_dom_element, expected_headers ) {
        setTimeout( function () {
            var header_count = SHINKEN.TOOLS.ARRAY.getLength( expected_headers );
            var headers      = table_dom_element.querySelectorAll( "th" );
            for ( var i = 0; i < header_count; ++i ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isText( timeout, headers[ i ], expected_headers[ i ] );
            }
        }, timeout );
        
        return 300;
    };
    self.TEST.validateNumbersOfFavorite = function ( timeout, dom_element, expected_number_of_favorites ) {
        setTimeout( function () {
            let count = SHINKEN.TOOLS.ARRAY.getLength( dom_element );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( count, expected_number_of_favorites );
        }, timeout );
        return 300;
    };
    //********************************************  ACTION   ***********************************************************//
    self.ACTION.setInputValue           = function ( timeout, dom_element, to_set ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___dispatchMouseEvent( dom_element, 'keydown' );
            DOM.Service.setInputValue( dom_element, to_set );
            SHINKEN.TOOLS.TEST_AUTO.___dispatchMouseEvent( dom_element, 'keyup' );
            var evt = document.createEvent( "HTMLEvents" );
            evt.initEvent( "change", false, true );
            dom_element.dispatchEvent( evt );
            
        }, timeout );
        return 100;
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_DOM || {} );

SHINKEN.TOOLS.TEST_AUTO_IFRAME = (function ( self ) {
    self.TEST                = {};
    self.getIframeContent    = function ( id ) {
        return document.getElementById( id ).querySelector( 'iframe' ).contentWindow.document;
    };
    //********************************************  TEST   ******************************************************//
    self.TEST.typeActiveView = function ( timeout, type_expected ) {
        var _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.typeActiveView', "" );
        let url   = SHINKEN.HIGHWAY.getHash();
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( type_expected ) {
                case SHINKEN.SCREEN.TYPE.HIVE:
                    SHINKEN.TOOLS.TEST_AUTO.__containsText( url, type_expected );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.addError( "le type de vue " + type_expected + " n'est pas géré" );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", 500 );
        }, timeout );
        
        return 500;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_IFRAME || {} );

SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT = (function ( self ) {
    self.getEnterEvent  = function () {
        return new KeyboardEvent( "keydown", {
            bubbles   : true,
            cancelable: true,
            code      : 'Enter',
            key       : 'Enter',
            charCode  : 13,
            keyCode   : 13,
            view      : window,
            shiftKey  : false
        } );
    };
    self.getDownEvent   = function () {
        return new KeyboardEvent( "keydown", {
            bubbles   : true,
            cancelable: true,
            code      : 'ArrowDown',
            key       : 'ArrowDown',
            charCode  : 0,
            keyCode   : 40,
            view      : window,
            shiftKey  : false
        } );
    };
    self.getSpaceEvent  = function () {
        return new KeyboardEvent( "keydown", {
            bubbles   : true,
            cancelable: true,
            code      : 'Space',
            key       : ' ',
            charCode  : 0,
            keyCode   : 32,
            view      : window,
            shiftKey  : false
        } );
    };
    self.getEscapeEvent = function () {
        return new KeyboardEvent( "keyup", {
            bubbles   : true,
            cancelable: true,
            code      : 'Escape',
            key       : ' ',
            charCode  : 0,
            keyCode   : 27,
            view      : window,
            shiftKey  : false
        } );
    };
    self.getKeyEvent    = function ( key, shiftKey, ctrlKey ) {
        return new KeyboardEvent( "keyup", {
            bubbles   : true,
            cancelable: true,
            keyCode   : key.toUpperCase().charCodeAt( 0 ),
            code      : "Key" + key.toUpperCase(),
            key       : key,
            view      : window,
            shiftKey  : !!shiftKey,
            ctrlKey   : !!ctrlKey
        } );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT || {} );

SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT = (function ( self ) {
    self.getMouseUpEvent    = function ( pos_x, pos_y, ctrlKey ) {
        return new MouseEvent( "mouseup", {
            bubbles   : true,
            cancelable: true,
            clientX   : pos_x || 0,
            clientY   : pos_y || 0,
            view      : window,
            shiftKey  : false,
            ctrlKey   : ctrlKey || false
        } );
    };
    self.getMouseDownEvent  = function ( pos_x, pos_y, ctrlKey ) {
        return new MouseEvent( "mousedown", {
            bubbles   : true,
            cancelable: true,
            clientX   : pos_x || 0,
            clientY   : pos_y || 0,
            view      : window,
            shiftKey  : false,
            ctrlKey   : ctrlKey || false
        } );
    };
    self.getMouseMoveEvent  = function ( pos_x, pos_y, ctrlKey ) {
        return new MouseEvent( "mousemove", {
            bubbles   : true,
            cancelable: true,
            clientX   : pos_x || 0,
            clientY   : pos_y || 0,
            view      : window,
            shiftKey  : false,
            ctrlKey   : ctrlKey || false
        } );
    };
    self.getMouseEnterEvent = function ( pos_x, pos_y, ctrlKey ) {
        return new MouseEvent( "mouseenter", {
            bubbles   : true,
            cancelable: true,
            clientX   : pos_x || 0,
            clientY   : pos_y || 0,
            view      : window,
            shiftKey  : false,
            ctrlKey   : ctrlKey || false
        } );
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT || {} );

SHINKEN.TOOLS.TEST_AUTO_XSS = (function ( self ) {
    self.isFunctionExisting = function ( timeout ) {
        setTimeout( function () {
            try {
                eval( SHINKEN.TOOLS.TEST_AUTO.XSS_FUNCTION_LABEL );
                SHINKEN.TOOLS.TEST_AUTO.addError( SHINKEN.TOOLS.TEST_AUTO.XSS_FUNCTION_LABEL + " existing ==> Faille XSS" );
            }
            catch ( e ) {
            }
            
        }, timeout );
        return 50;
    };
    self.isDOMExisting      = function ( timeout ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'XSS.isDOMExisting', '' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.TEST.isNotExistingToEval( 0, 'document.querySelector(".shinken-test-auto-injection")' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_XSS || {} );

SHINKEN.TOOLS.TEST_AUTO_OPEN_WINDOW = (function ( self ) {
    self.DOM                      = {};
    self.TEST                     = {};
    self.ACTION                   = {};
    self.instance                 = false;
    //********************************************  TEST   **************************************************//
    self.TEST.pathName            = function ( timeout, path_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isTextEqualTo( path_name, self.instance.location.pathname, "URL WINDOW" );
        }, timeout );
        return 200;
    };
    self.TEST.redirect            = function ( timeout, path_name, path_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isTextEqualTo( path_name, path_expected, "URL REDIRECT" );
        }, timeout );
        return 200;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.close             = function ( timeout ) {
        setTimeout( function () {
            if ( self.instance ) {
                self.instance.close();
            }
        }, timeout );
        return 200;
    };
    self.ACTION.open              = function ( timeout, url ) {
        setTimeout( function () {
            self.instance = window.open( url, "test", "width=" + window.innerWidth / 1.2 + ",height=" + window.innerHeight / 1.2 );
        }, timeout );
        return 5000;
    };
    self.ACTION.openFull          = function ( timeout, url ) {
        setTimeout( function () {
            self.instance = window.open( url, "test", "width=1920,height=1080" );
        }, timeout );
        return 5000;
    };
    self.ACTION.openWithStructure = function ( timeout, phase_window ) {
        var url = "http://" + SHINKEN.HIGHWAY.getHostName() + ":" + SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ __shinken_test_type ].port_window[ phase_window ] +
                  SHINKEN.TOOLS.TEST_AUTO.STRUCTURE[ __shinken_test_type ].address_window[ phase_window ];
        url += "?shinken_test_auto=" + __shinken_test_type + "&window_phase=" + (phase_window + 1);
        
        return self.ACTION.open( timeout, url );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_OPEN_WINDOW || {} );