//priority 1
//__lib__ lib_common

var SHINKEN = SHINKEN || {};

SHINKEN.DOM = SHINKEN.DOM || {};

SHINKEN.MODAL            = SHINKEN.MODAL || {};
SHINKEN.NAVIGATOR        = SHINKEN.NAVIGATOR || {};
SHINKEN.PAGE             = SHINKEN.PAGE || {};
SHINKEN.CALLBACK         = SHINKEN.CALLBACK || {};
SHINKEN.TOOLS            = SHINKEN.TOOLS || {};
SHINKEN.TOOLS.ARRAY      = SHINKEN.TOOLS.ARRAY || {};
SHINKEN.TOOLS.ENCRYPTION = SHINKEN.TOOLS.ENCRYPTION || {};
SHINKEN.OBJECT           = SHINKEN.OBJECT || {};
SHINKEN.OBJECT.CONST     = SHINKEN.OBJECT.CONST || {};
SHINKEN.ELEMENT          = SHINKEN.ELEMENT || {};

var DOM   = DOM || {};
DOM.CONST = DOM.CONST || {};

SHINKEN.CONST               = {
    KEY_CODE        : {
        TAB      : 9,
        ENTER    : 13,
        SHIFT    : 16,
        CTRL     : 17,
        ALT      : 18,
        PAUSE    : 19,
        CAPS_LOCK: 20,
        ESCAPE   : 27,
        SPACE    : 32,
        PAGE_UP  : 33,
        PAGE_DOWN: 34,
        END      : 35,
        HOME     : 36,
        LEFT     : 37,
        UP       : 38,
        RIGHT    : 39,
        DOWN     : 40,
        SUPPR    : 46,
        A        : 65,
        C        : 67,
        F        : 70,
        S        : 83,
        V        : 86,
        W        : 87,
        Y        : 89,
        Z        : 90,
        F1       : 112
    },
    MOUSE           : {
        LEFT  : 0,
        MIDDLE: 1,
        RIGHT : 2
    },
    VISIBILITY_STATE: {
        TOTALLY_FORM_EXCLUDE   : "form_exclude",
        FORM_EXCLUDE__WHEN_SAVE: "form_exclude__when_save",
        HIDDEN                 : "hidden",
        DISABLED               : "disabled",
        LOCKED                 : "locked",
        NORMAL                 : ""
    },
    PARAM           : {
        CALLBACK_FUNCTION       : "callback_function",
        CALLBACK_DO_ACTION_AFTER: "callback_do_action_after",
        KEY_CODE                : "key_code"
    }
};
SHINKEN.CONST.CONFIGURATION = {
    ELEMENT_UNIQUE_ADDRESS_BEHAVIOUR: {
        DUPLICATED_ACCEPTED: "duplicated_accepted",
        WARNING_DISPLAYED  : "warning_displayed",
        ERROR_DISPLAYED    : "error_displayed",
        SAVE_FORBIDDEN     : "save_forbidden"
    }
};


SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin = function ( link, id, label, _class, tooltip ) {
    if ( MANAGER.__instance_element_distributor.current_user.is_admin && link && id ) {
        return SHINKEN.TOOLS.buildLinkDomElement( link, id, label, _class, tooltip );
    }
    if ( !_class ) {
        _class = "title shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'span', { class: _class }, label );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkDomElement              = function ( link, id, label, _class, tooltip ) {
    var _href = "/elements/" + link + '/' + id;
    if ( !_class ) {
        _class = "title shinken-link shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'a', { class: _class, href: _href, draggable: 'false', target: "_blank", onclick: "MANAGER.EventManager.mutePropagation(event)" }, '<span class="shinken-tag-label">' + label + '</span>' );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkShinkenElement          = function ( element, label, _class, tooltip ) {
    var _uuid = element.uuid;
    if ( element.isNew() ) {
        _uuid += '?new=1';
    }
    if ( !label ) {
        label = element.getName();
    }
    return SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( element.getType(), _uuid, label, _class, tooltip );
};
